/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.entity.projectile.trigger.FireRayBeamEntity;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class FireRayPieceProjectile
extends BaseProjectile {
    private static final EntityDataAccessor<Integer> INDEX = SynchedEntityData.m_135353_(FireRayPieceProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> PARENT_UUID = SynchedEntityData.m_135353_(FireRayPieceProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Float> YAW = SynchedEntityData.m_135353_(FireRayPieceProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> PITCH = SynchedEntityData.m_135353_(FireRayPieceProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final RawAnimation APPEAR = RawAnimation.begin().thenPlay("appear");
    private static final RawAnimation DISAPPEAR = RawAnimation.begin().thenPlay("disappear");

    public FireRayPieceProjectile(EntityType<? extends FireRayPieceProjectile> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(INDEX, (Object)0);
        this.f_19804_.m_135372_(PARENT_UUID, Optional.empty());
        this.f_19804_.m_135372_(YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(PITCH, (Object)Float.valueOf(0.0f));
    }

    public boolean m_142391_() {
        return false;
    }

    public boolean m_20223_(CompoundTag compound) {
        return false;
    }

    public boolean m_20086_(CompoundTag compound) {
        return false;
    }

    @Override
    protected int baseLifetime() {
        return 140;
    }

    public void initAsChild(Entity parent, int index) {
        this.f_19804_.m_135381_(INDEX, (Object)index);
        this.f_19804_.m_135381_(PARENT_UUID, Optional.of(parent.m_20148_()));
    }

    public void syncPosition(Vec3 pos) {
        this.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        Vec3 dir = pos.m_82546_(this.getOwnerOrigin()).m_82541_();
        float yaw = (float)(Mth.m_14136_((double)dir.f_82481_, (double)dir.f_82479_) * 57.2957763671875) - 90.0f;
        float pitch = (float)(-Mth.m_14136_((double)dir.f_82480_, (double)Math.sqrt(dir.f_82479_ * dir.f_82479_ + dir.f_82481_ * dir.f_82481_)) * 57.2957763671875);
        this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(yaw));
        this.f_19804_.m_135381_(PITCH, (Object)Float.valueOf(pitch));
    }

    private Vec3 getOwnerOrigin() {
        Optional ouuid = (Optional)this.f_19804_.m_135370_(PARENT_UUID);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel serverLevel = (ServerLevel)level;
            if (ouuid.isPresent() && (entity = serverLevel.m_8791_((UUID)ouuid.get())) instanceof FireRayBeamEntity) {
                FireRayBeamEntity beam = (FireRayBeamEntity)entity;
                return beam.m_20182_();
            }
        }
        return this.m_20182_();
    }

    public float getPieceYaw() {
        return ((Float)this.f_19804_.m_135370_(YAW)).floatValue();
    }

    public float getPiecePitch() {
        return ((Float)this.f_19804_.m_135370_(PITCH)).floatValue();
    }

    @Override
    public void m_8119_() {
        List entities;
        super.m_8119_();
        if (!(this.m_9236_().f_46443_ || this.m_20145_() || (entities = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(0.25), e -> !e.equals((Object)this.m_19749_()))).isEmpty())) {
            LivingEntity victim = (LivingEntity)entities.get(0);
            victim.m_6469_(this.m_269291_().m_269104_((Entity)this, this.m_19749_()), 5.0f);
            victim.m_7311_(this.m_9236_().f_46441_.m_216339_(1, 8) * 20);
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.f_19797_ >= this.baseLifetime() - 6) {
            event.getController().setAnimation(DISAPPEAR);
        } else if (this.f_19797_ <= 4) {
            event.getController().setAnimation(APPEAR);
        }
        return PlayState.CONTINUE;
    }
}

