/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HolinessNaginataProjectile
extends ThrownTrident
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Quaternionf prevRot = new Quaternionf();
    private final Quaternionf currentRot = new Quaternionf();
    protected boolean dealtDamage;
    protected int timeToDespawn;

    public HolinessNaginataProjectile(EntityType<? extends ThrownTrident> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        if (!this.m_9236_().f_46443_) {
            this.timeToDespawn = new Random().nextInt(120, 300);
        }
    }

    protected boolean m_5603_(@NotNull Entity entity) {
        if (Util.areEntitiesLinked((Entity)this, entity)) {
            return false;
        }
        return super.m_5603_(entity);
    }

    public void m_6901_() {
        if (this.f_36704_ >= this.timeToDespawn) {
            this.m_146870_();
        }
    }

    protected boolean m_142470_(@NotNull Player pPlayer) {
        return false;
    }

    @NotNull
    public AABB m_6921_() {
        return super.m_6921_().m_82400_(10.0);
    }

    public void refreshOrientation() {
        Vec3 v = this.m_20184_();
        if (v.m_82556_() < 1.0E-7) {
            return;
        }
        float yaw = (float)Math.atan2(v.f_82479_, v.f_82481_);
        float pitch = (float)Math.atan2(v.f_82480_, Math.hypot(v.f_82479_, v.f_82481_));
        this.m_146922_(yaw * 57.295776f);
        this.m_146926_(pitch * 57.295776f);
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        Quaternionf quaternionf = new Quaternionf().rotateY(yaw + (float)Math.PI).rotateX(pitch);
        this.prevRot.set((Quaternionfc)this.currentRot);
        this.currentRot.set((Quaternionfc)quaternionf);
    }

    protected void m_8060_(@NotNull BlockHitResult pResult) {
        super.m_8060_(pResult);
        this.doShake();
    }

    protected void doShake() {
        if (this.m_9236_().f_46443_) {
            for (Player player : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(30.0))) {
                Companions.PROXY.shakePlayerCamera(player, 5, 0.1f, 0.1f, 0.1f, 10);
            }
        }
    }

    public void m_8119_() {
        if (this.f_19797_ < 2) {
            this.m_6842_(true);
        } else if (this.f_19797_ < 5) {
            this.m_6842_(false);
        }
        if (this.m_20184_().m_82556_() > 1.0E-7) {
            this.refreshOrientation();
        }
        super.m_8119_();
    }

    @Nullable
    protected EntityHitResult m_6351_(@NotNull Vec3 pStartVec, @NotNull Vec3 pEndVec) {
        return this.dealtDamage ? null : super.m_6351_(pStartVec, pEndVec);
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity entity = pResult.m_82443_();
        Entity owner = this.m_19749_();
        DamageSource damageSource = this.m_269291_().m_269525_((Entity)this, (Entity)(owner == null ? this : owner));
        this.dealtDamage = true;
        entity.m_6469_(damageSource, (float)CompanionsConfig.NAGINATA_DAMAGE);
        this.m_5496_(SoundEvents.f_12514_, 5.0f, 1.0f);
    }

    public Quaternionf getPrevRotation() {
        return this.prevRot;
    }

    public Quaternionf getCurrentRotation() {
        return this.currentRot;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }
}

