/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile.trigger;

import dev.xylonity.companions.common.entity.hostile.SacredPontiffEntity;
import dev.xylonity.companions.common.entity.projectile.FireRayPieceProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtils;

public class FireRayBeamEntity
extends Entity
implements GeoAnimatable {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Float> ORIGIN_X = SynchedEntityData.m_135353_(FireRayBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ORIGIN_Y = SynchedEntityData.m_135353_(FireRayBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ORIGIN_Z = SynchedEntityData.m_135353_(FireRayBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> START_YAW = SynchedEntityData.m_135353_(FireRayBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> ROT_TICKS = SynchedEntityData.m_135353_(FireRayBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MAX_PIECES = SynchedEntityData.m_135353_(FireRayBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> SEPARATION = SynchedEntityData.m_135353_(FireRayBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> START_PITCH = SynchedEntityData.m_135353_(FireRayBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int age;
    private UUID[] pieceUUIDs;

    public FireRayBeamEntity(EntityType<? extends FireRayBeamEntity> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
        this.pieceUUIDs = new UUID[0];
    }

    public FireRayBeamEntity(ServerLevel lvl, Vec3 origin, float yaw0, float pitch0, int rotTicks, int maxPieces, float sep, SacredPontiffEntity entity) {
        this((EntityType<? extends FireRayBeamEntity>)((EntityType)CompanionsEntities.FIRE_RAY_BEAM_ENTITY.get()), (Level)lvl);
        this.m_6034_(origin.f_82479_, origin.f_82480_, origin.f_82481_);
        this.f_19804_.m_135381_(ORIGIN_X, (Object)Float.valueOf((float)origin.f_82479_));
        this.f_19804_.m_135381_(ORIGIN_Y, (Object)Float.valueOf((float)origin.f_82480_));
        this.f_19804_.m_135381_(ORIGIN_Z, (Object)Float.valueOf((float)origin.f_82481_));
        this.f_19804_.m_135381_(START_YAW, (Object)Float.valueOf(yaw0));
        this.f_19804_.m_135381_(START_PITCH, (Object)Float.valueOf(pitch0));
        this.f_19804_.m_135381_(ROT_TICKS, (Object)rotTicks);
        this.f_19804_.m_135381_(MAX_PIECES, (Object)maxPieces);
        this.f_19804_.m_135381_(SEPARATION, (Object)Float.valueOf(sep));
        this.pieceUUIDs = new UUID[maxPieces];
        this.spawnPieces(lvl, entity);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ORIGIN_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ORIGIN_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ORIGIN_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(START_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROT_TICKS, (Object)0);
        this.f_19804_.m_135372_(MAX_PIECES, (Object)0);
        this.f_19804_.m_135372_(SEPARATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(START_PITCH, (Object)Float.valueOf(0.0f));
    }

    protected void m_7378_(@NotNull CompoundTag tag) {
    }

    protected void m_7380_(@NotNull CompoundTag tag) {
    }

    private void spawnPieces(ServerLevel level, SacredPontiffEntity entity) {
        int maxPieces = (Integer)this.f_19804_.m_135370_(MAX_PIECES);
        for (int i = 0; i < maxPieces; ++i) {
            FireRayPieceProjectile piece = (FireRayPieceProjectile)((EntityType)CompanionsEntities.FIRE_RAY_PIECE_PROJECTILE.get()).m_20615_((Level)level);
            if (piece == null) continue;
            piece.initAsChild(this, i);
            piece.m_5602_((Entity)entity);
            level.m_7967_((Entity)piece);
            this.pieceUUIDs[i] = piece.m_20148_();
        }
    }

    public boolean m_142391_() {
        return false;
    }

    public boolean m_20223_(CompoundTag compound) {
        return false;
    }

    public boolean m_20086_(CompoundTag compound) {
        return false;
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.f_19797_ % 5 == 0 && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123747_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        float eased = 0.5f * (1.0f - Mth.m_14089_((float)((float)this.age / (float)((Integer)this.f_19804_.m_135370_(ROT_TICKS)).intValue() * (float)Math.PI)));
        double yaw = Math.toRadians((((Float)this.f_19804_.m_135370_(START_YAW)).floatValue() + eased * 720.0f) % 360.0f);
        double pitch = Math.toRadians(((Float)this.f_19804_.m_135370_(START_PITCH)).floatValue());
        Vec3 direction = new Vec3(Math.cos(pitch) * Math.cos(yaw), Math.sin(pitch), Math.cos(pitch) * Math.sin(yaw));
        Vec3 origin = new Vec3((double)((Float)this.f_19804_.m_135370_(ORIGIN_X)).floatValue(), (double)((Float)this.f_19804_.m_135370_(ORIGIN_Y)).floatValue(), (double)((Float)this.f_19804_.m_135370_(ORIGIN_Z)).floatValue());
        boolean blocked = false;
        for (int i = 0; i < this.pieceUUIDs.length; ++i) {
            boolean solid;
            Entity e = ((ServerLevel)this.m_9236_()).m_8791_(this.pieceUUIDs[i]);
            if (!(e instanceof FireRayPieceProjectile)) continue;
            FireRayPieceProjectile piece = (FireRayPieceProjectile)e;
            Vec3 pos = origin.m_82549_(direction.m_82490_((double)((float)i * ((Float)this.f_19804_.m_135370_(SEPARATION)).floatValue())));
            piece.syncPosition(pos);
            boolean bl = solid = !this.m_9236_().m_8055_(BlockPos.m_274446_((Position)pos)).m_60812_((BlockGetter)this.m_9236_(), BlockPos.m_274446_((Position)pos)).m_83281_();
            if (!blocked && solid) {
                blocked = true;
                piece.m_6842_(false);
            } else if (blocked) {
                piece.m_6842_(true);
            } else {
                piece.m_6842_(false);
            }
            if (i != 0) continue;
            piece.m_6842_(true);
        }
        if (++this.age >= 135) {
            this.m_146870_();
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        return RenderUtils.getCurrentTick();
    }
}

