/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.layer;

import dev.xylonity.companions.common.blockentity.AbstractTeslaBlockEntity;
import dev.xylonity.companions.common.blockentity.VoltaicPillarBlockEntity;
import dev.xylonity.companions.common.event.CompanionsEntityTracker;
import dev.xylonity.companions.common.tesla.TeslaConnectionManager;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.texture.AutoGlowingTexture;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class StaticElectricConnectionLayer<T extends AbstractTeslaBlockEntity>
extends GeoRenderLayer<T> {
    private final class_2960 texture;
    private final int totalFrames;
    private final int ticksPerFrame;

    public StaticElectricConnectionLayer(GeoRenderer<T> renderer, class_2960 texture, int totalFrames, int ticksPerFrame) {
        super(renderer);
        this.texture = texture;
        this.totalFrames = totalFrames;
        this.ticksPerFrame = ticksPerFrame;
    }

    public void render(class_4587 poseStack, T animatable, BakedGeoModel bakedModel, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
        if (!((AbstractTeslaBlockEntity)((Object)animatable)).isActive()) {
            return;
        }
        int frame = this.calculateCurrentFrame(animatable);
        for (TeslaConnectionManager.ConnectionNode node : TeslaConnectionManager.getInstance().getOutgoing(((AbstractTeslaBlockEntity)((Object)animatable)).asConnectionNode())) {
            AbstractTeslaBlockEntity be;
            if (node == null) continue;
            if (node.isEntity()) {
                class_1297 entity = CompanionsEntityTracker.getEntityByUUID(node.entityId());
                if (!(entity instanceof class_1309)) continue;
                class_1309 livingEntity = (class_1309)entity;
                class_243 offset = new class_243(0.0, 1.25, 0.0);
                class_243 dir = livingEntity.method_19538().method_1020(animatable.method_11016().method_46558()).method_1031(0.0, (double)livingEntity.method_17682() * 1.1, 0.0);
                this.renderConnection(bufferSource, poseStack, offset, dir, frame, packedLight);
                continue;
            }
            if (!node.isBlock() || !((be = TeslaConnectionManager.getInstance().getBlockEntity(node)) instanceof VoltaicPillarBlockEntity)) continue;
            class_243 offset = ((AbstractTeslaBlockEntity)((Object)animatable)).electricalChargeOriginOffset();
            class_243 blockPos = be.method_11016().method_46558();
            class_243 blockPosVec = new class_243(blockPos.field_1352, blockPos.field_1351, blockPos.field_1350);
            class_243 dir = blockPosVec.method_1020(animatable.method_11016().method_46558()).method_1019(be.electricalChargeEndOffset());
            this.renderConnection(bufferSource, poseStack, offset, dir, frame, packedLight);
        }
    }

    private int calculateCurrentFrame(T animatable) {
        if (animatable.method_10997() != null) {
            long elapsed = animatable.method_10997().method_8510() - (long)((AbstractTeslaBlockEntity)((Object)animatable)).getAnimationStartTick();
            return (int)(elapsed / (long)this.ticksPerFrame) % this.totalFrames + 1;
        }
        return 0;
    }

    private void renderConnection(class_4597 bufferSource, class_4587 poseStack, class_243 p0, class_243 p1, int frame, int light) {
        int[] indices;
        class_4588 vertexConsumer = bufferSource.getBuffer(AutoGlowingTexture.getRenderType((class_2960)this.texture));
        Matrix4f positionMatrix = poseStack.method_23760().method_23761();
        Matrix3f normalMatrix = poseStack.method_23760().method_23762();
        float x0 = (float)p0.field_1352;
        float y0 = (float)p0.field_1351;
        float z0 = (float)p0.field_1350;
        float x1 = (float)p1.field_1352;
        float y1 = (float)p1.field_1351;
        float z1 = (float)p1.field_1350;
        float dx = x1 - x0;
        float dy = y1 - y0;
        float dz = z1 - z0;
        if (dx == 0.0f) {
            dx = 0.001f;
        }
        float dHorizontal = class_3532.method_15355((float)(dx * dx + dz * dz));
        float length = class_3532.method_15355((float)(dHorizontal * dHorizontal + dy * dy));
        float offset = 0.5f;
        float yOffset = offset * (dHorizontal / length);
        float xOffset = offset * (dy / length) * (dx / dHorizontal);
        float zOffset = offset * (dy / length) * (dz / dHorizontal);
        float frameSize = 1.0f / (float)this.totalFrames;
        float v0 = (float)frame * frameSize;
        float v1 = v0 + frameSize;
        VertexCoordinates[] vertices = new VertexCoordinates[]{new VertexCoordinates(x0 + xOffset, y0 - yOffset, z0 + zOffset, 0.0f, v1), new VertexCoordinates(x1 + xOffset, y1 - yOffset, z1 + zOffset, 1.0f, v1), new VertexCoordinates(x1 - xOffset, y1 + yOffset, z1 - zOffset, 1.0f, v0), new VertexCoordinates(x0 - xOffset, y0 + yOffset, z0 - zOffset, 0.0f, v0)};
        for (int i : indices = new int[]{0, 1, 2, 3, 3, 2, 1, 0}) {
            this.produceVertex(vertexConsumer, positionMatrix, normalMatrix, light, vertices[i].x, vertices[i].y, vertices[i].z, vertices[i].u, vertices[i].v);
        }
    }

    private void produceVertex(class_4588 vertexConsumer, Matrix4f positionMatrix, Matrix3f normalMatrix, int light, float x, float y, float z, float textureU, float textureV) {
        vertexConsumer.method_22918(positionMatrix, x, y, z).method_1336(255, 255, 255, 255).method_22913(textureU, textureV).method_22922(class_4608.field_21444).method_22916(light).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
    }

    private record VertexCoordinates(float x, float y, float z, float u, float v) {
    }
}

