/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.entity.HostileEntity;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.mixin.FallingBlockEntityAccessor;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1540;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4140;
import net.minecraft.class_5819;
import net.minecraft.class_7244;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtils;

public class FrogBonanzaBlockEntity
extends class_2586
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final RawAnimation COIN = RawAnimation.begin().thenPlay("coin");
    public static final RawAnimation LEVER = RawAnimation.begin().thenPlay("lever");
    private static final int DELAY_BETWEEN_WHEELS = 4;
    private static final int GAME_TICKS = 100;
    private static final float EXTRA_SPINS = 720.0f;
    private final float[] rotation = new float[3];
    private final float[] startRot = new float[3];
    private final float[] totalRot = new float[3];
    private final int[] faceDeg = new int[3];
    private int spinStartTick = -1;
    private int tickCount = 0;
    private int spinsRemaining = 0;
    private static final String TAG_ROT = "Rot";
    private static final String TAG_FACE = "Face";
    private static final String TAG_START = "Start";
    private static final String TAG_TOTAL = "Total";

    public FrogBonanzaBlockEntity(class_2338 pos, class_2680 state) {
        super(CompanionsBlockEntities.FROG_BONANZA, pos, state);
    }

    public void startSpinning(int[] finalFacesDeg) {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            this.faceDeg[i] = finalFacesDeg[i] % 360;
            this.startRot[i] = this.rotation[i];
            float delta = (float)this.faceDeg[i] - Util.normalizeDeg(this.startRot[i]);
            if (delta < 0.0f) {
                delta += 360.0f;
            }
            this.totalRot[i] = delta + 720.0f;
        }
        this.spinStartTick = this.tickCount;
        this.sync();
    }

    public void startGame() {
        this.startSpinning(new int[]{new Random().nextInt(4) * 90, new Random().nextInt(4) * 90, new Random().nextInt(4) * 90});
    }

    public float getWheelRotation(int idx) {
        return this.rotation[idx];
    }

    public static <T extends class_2586> void tick(class_1937 lvl, class_2338 pos, class_2680 st, T be) {
        if (!(be instanceof FrogBonanzaBlockEntity)) {
            return;
        }
        FrogBonanzaBlockEntity b = (FrogBonanzaBlockEntity)be;
        if (b.spinStartTick < 0) {
            return;
        }
        boolean hasFinished = true;
        for (int i = 0; i < 3; ++i) {
            int local = b.tickCount - (b.spinStartTick + i * 4);
            if (local < 0) {
                hasFinished = false;
                continue;
            }
            if (local >= 100) {
                b.rotation[i] = b.faceDeg[i];
                continue;
            }
            hasFinished = false;
            b.rotation[i] = Util.normalizeDeg(b.startRot[i] + b.totalRot[i] * (1.0f - (float)Math.pow(1.0f - (float)local / 100.0f, 3.0)));
        }
        if (hasFinished) {
            b.spinStartTick = -1;
            b.getFroggyReward();
            b.sync();
        }
        ++b.tickCount;
    }

    private void getFroggyReward() {
        ConcurrentHashMap<Integer, Integer> counts = new ConcurrentHashMap<Integer, Integer>();
        for (int f : this.faceDeg) {
            counts.put(f, counts.getOrDefault(f, 0) + 1);
        }
        if (counts.size() == 1) {
            switch (this.faceDeg[0]) {
                case 0: {
                    this.tripleCreeper();
                    break;
                }
                case 90: {
                    this.tripleCoin();
                    break;
                }
                case 180: {
                    this.tripleTeddy();
                    break;
                }
                case 270: {
                    this.tripleSkull();
                }
            }
            return;
        }
        Object object = counts.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            if ((Integer)entry.getValue() != 2) continue;
            switch ((Integer)entry.getKey()) {
                case 0: {
                    this.doubleCreeper();
                    break;
                }
                case 90: {
                    this.doubleCoin();
                    break;
                }
                case 180: {
                    this.doubleTeddy();
                    break;
                }
                case 270: {
                    this.doubleSkull();
                }
            }
            return;
        }
    }

    private static List<TeddyDrop> parseBonanzaTeddyDrops(String config) {
        ArrayList<TeddyDrop> list = new ArrayList<TeddyDrop>();
        if (config == null || config.isBlank()) {
            return list;
        }
        for (String part : config.split(";")) {
            int max;
            int min;
            float chance;
            String[] entry = part.trim().split(",");
            if (entry.length != 3) continue;
            try {
                chance = Float.parseFloat(entry[1].trim());
            }
            catch (NumberFormatException ignore) {
                continue;
            }
            String count = entry[2].trim();
            if (count.contains("-")) {
                String[] range = count.split("-");
                try {
                    min = Integer.parseInt(range[0].trim());
                    max = Integer.parseInt(range[1].trim());
                }
                catch (NumberFormatException ignore) {
                    min = 1;
                    max = 1;
                }
            } else {
                try {
                    min = Integer.parseInt(count);
                    max = Integer.parseInt(count);
                }
                catch (NumberFormatException ignore) {
                    min = 1;
                    max = 1;
                }
            }
            list.add(new TeddyDrop(entry[0].trim(), chance, min, max));
        }
        return list;
    }

    private static List<SkullDropEntities> parseEntitySpawns(String config) {
        ArrayList<SkullDropEntities> list = new ArrayList<SkullDropEntities>();
        if (config == null || config.isBlank()) {
            return list;
        }
        for (String part : config.split(";")) {
            int amount;
            String[] entry = part.trim().split(",");
            if (entry.length != 2) continue;
            String id = entry[0].trim();
            try {
                amount = Integer.parseInt(entry[1].trim());
            }
            catch (NumberFormatException ignore) {
                continue;
            }
            list.add(new SkullDropEntities(id, amount));
        }
        return list;
    }

    private void doubleCreeper() {
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            class_2338 center = this.field_11867.method_10084();
            for (int i = 0; i < 2 + new Random().nextInt(3); ++i) {
                BonanzaTnt tnt = new BonanzaTnt((class_1937)server, (double)center.method_10263() + 0.5, center.method_10264(), (double)center.method_10260() + 0.5, null);
                double angle = this.method_10997().field_9229.method_43058() * Math.PI * 2.0;
                double speed = 0.15 + this.method_10997().field_9229.method_43058() * 0.6;
                tnt.method_18800(Math.cos(angle) * speed, 0.5 + this.method_10997().field_9229.method_43058() * 0.3, Math.sin(angle) * speed);
                tnt.method_6967(40);
                server.method_8649((class_1297)tnt);
            }
            this.method_10997().method_45447(null, this.method_11016(), CompanionsSounds.POP.get(), class_3419.field_15245);
        }
    }

    private void doubleCoin() {
        if (this.method_10997() != null) {
            FrogBonanzaBlockEntity.popResource(this.method_10997(), this.method_11016(), new class_1799((class_1935)CompanionsBlocks.COPPER_COIN.get(), new Random().nextInt(2, 10)));
            FrogBonanzaBlockEntity.popResource(this.method_10997(), this.method_11016(), new class_1799((class_1935)CompanionsBlocks.NETHER_COIN.get(), new Random().nextInt(1, 4)));
            FrogBonanzaBlockEntity.popResource(this.method_10997(), this.method_11016(), new class_1799((class_1935)CompanionsBlocks.END_COIN.get()));
            this.method_10997().method_45447(null, this.method_11016(), CompanionsSounds.POP.get(), class_3419.field_15245);
        }
    }

    private void doubleTeddy() {
        if (this.method_10997() != null) {
            FrogBonanzaBlockEntity.parseBonanzaTeddyDrops(CompanionsConfig.BONANZA_2_TEDDY_HEADS_DROPS).forEach(drop -> {
                class_1792 item;
                if (this.method_10997().method_8409().method_43057() < drop.chance && (item = (class_1792)class_7923.field_41178.method_10223(new class_2960(drop.id()))) != null) {
                    FrogBonanzaBlockEntity.popResource(this.method_10997(), this.method_11016(), new class_1799((class_1935)item, drop.min == drop.max ? drop.min : this.method_10997().method_8409().method_43051(drop.min, drop.max + 1)));
                }
            });
            this.method_10997().method_45447(null, this.method_11016(), CompanionsSounds.POP.get(), class_3419.field_15245);
        }
    }

    private void doubleSkull() {
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_243 center = class_243.method_24953((class_2382)this.method_11016());
            class_1657 player = serverLevel.method_18459(center.field_1352, center.field_1351, center.field_1350, 25.0, false);
            if (player != null) {
                class_1540 anvil = FallingBlockEntityAccessor._new((class_1937)serverLevel, player.method_23317(), player.method_23318() + 20.0, player.method_23321(), class_2246.field_10535.method_9564());
                anvil.field_7192 = 1;
                anvil.method_49181();
                anvil.method_6965(2.0f, 40);
                serverLevel.method_8649((class_1297)anvil);
            }
            this.method_10997().method_45447(null, this.method_11016(), CompanionsSounds.POP.get(), class_3419.field_15245);
        }
    }

    private void tripleCreeper() {
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            class_2338 center = this.field_11867.method_10084();
            for (int i = 0; i < 3; ++i) {
                double angle = new Random().nextDouble() * Math.PI * 2.0;
                double dist = new Random().nextDouble() * 4.0;
                double x = (double)center.method_10263() + 0.5 + Math.cos(angle) * dist;
                double y = center.method_10264();
                double z = (double)center.method_10260() + 0.5 + Math.sin(angle) * dist;
                class_1548 creeper = (class_1548)class_1299.field_6046.method_5883((class_1937)server);
                if (creeper == null) continue;
                creeper.method_5808(x, y, z, new Random().nextFloat() * 360.0f, 0.0f);
                class_1538 bolt = (class_1538)class_1299.field_6112.method_5883((class_1937)server);
                if (bolt != null) {
                    bolt.method_24203(x, y, z);
                    server.method_8649((class_1297)bolt);
                    creeper.method_5800(server, bolt);
                }
                server.method_8649((class_1297)creeper);
            }
            this.method_10997().method_45447(null, this.method_11016(), CompanionsSounds.POP.get(), class_3419.field_15245);
        }
    }

    private void tripleCoin() {
        if (this.method_10997() != null) {
            class_5819 rand = this.method_10997().method_8409();
            FrogBonanzaBlockEntity.popResource(this.method_10997(), this.method_11016(), new class_1799((class_1935)CompanionsBlocks.COPPER_COIN.get(), rand.method_43051(1, 20)));
            if (rand.method_43057() < 0.75f) {
                FrogBonanzaBlockEntity.popResource(this.method_10997(), this.method_11016(), new class_1799((class_1935)CompanionsBlocks.NETHER_COIN.get(), rand.method_43051(1, 5)));
            }
            if (rand.method_43057() < 0.45f) {
                FrogBonanzaBlockEntity.popResource(this.method_10997(), this.method_11016(), new class_1799((class_1935)CompanionsBlocks.END_COIN.get(), 1));
            }
            this.method_10997().method_45447(null, this.method_11016(), CompanionsSounds.POP.get(), class_3419.field_15245);
        }
    }

    private void tripleTeddy() {
        if (this.method_10997() != null && this.method_10997() != null) {
            FrogBonanzaBlockEntity.parseBonanzaTeddyDrops(CompanionsConfig.BONANZA_3_TEDDY_HEADS_DROPS).forEach(drop -> {
                class_1792 item;
                if (this.method_10997().method_8409().method_43057() < drop.chance && (item = (class_1792)class_7923.field_41178.method_10223(new class_2960(drop.id()))) != null) {
                    FrogBonanzaBlockEntity.popResource(this.method_10997(), this.method_11016(), new class_1799((class_1935)item, drop.min == drop.max ? drop.min : this.method_10997().method_8409().method_43051(drop.min, drop.max + 1)));
                }
            });
            this.method_10997().method_45447(null, this.method_11016(), CompanionsSounds.POP.get(), class_3419.field_15245);
        }
    }

    private void tripleSkull() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 server = (class_3218)class_19372;
        class_2338 center = this.field_11867.method_10084();
        class_1657 player = server.method_18459((double)center.method_10263(), (double)center.method_10264(), (double)center.method_10260(), 15.0, false);
        if (player == null) {
            return;
        }
        for (SkullDropEntities config : FrogBonanzaBlockEntity.parseEntitySpawns(CompanionsConfig.BONANZA_3_SKULL_DROP_ENTITIES)) {
            class_1299 raw = (class_1299)class_7923.field_41177.method_10223(new class_2960(config.id()));
            if (raw == null) continue;
            class_1299 type = raw;
            for (int i = 0; i < config.amount; ++i) {
                if (type == class_1299.field_38095) {
                    class_7244.method_42122((class_1299)type, (class_3730)class_3730.field_16461, (class_3218)server, (class_2338)center, (int)20, (int)5, (int)6, (class_7244.class_7502)class_7244.class_7502.field_39401).ifPresent(e -> {
                        e.method_5808(e.method_23317(), e.method_23318(), e.method_23321(), player.method_36454(), 0.0f);
                        e.method_5980((class_1309)player);
                        e.method_18868().method_18878(class_4140.field_22333, (Object)player.method_5667());
                    });
                    continue;
                }
                class_1309 e2 = (class_1309)type.method_47821(server, new class_2338(center.method_10263() - 3 + server.field_9229.method_43048(4), center.method_10264() - 1, center.method_10260() - 3 + server.field_9229.method_43048(4)), class_3730.field_16471);
                if (e2 == null) continue;
                e2.method_5808(e2.method_23317(), e2.method_23318(), e2.method_23321(), player.method_36454(), 0.0f);
                if (e2 instanceof HostileEntity) {
                    HostileEntity hostile = (HostileEntity)e2;
                    hostile.method_5980((class_1309)player);
                }
                server.method_8649((class_1297)e2);
            }
        }
        this.field_11863.method_8396(null, center, CompanionsSounds.POP.get(), class_3419.field_15245, 1.0f, 1.0f);
    }

    public static void popResource(class_1937 pLevel, class_2338 pPos, class_1799 pStack) {
        double d0 = class_1299.field_6052.method_17686() / 2.0f;
        double d1 = (double)pPos.method_10263() + 0.5;
        double d2 = (double)pPos.method_10264() + 1.5 + class_3532.method_15366((class_5819)pLevel.field_9229, (double)-0.25, (double)0.25) - d0;
        double d3 = (double)pPos.method_10260() + 0.5;
        FrogBonanzaBlockEntity.popResource(pLevel, () -> new class_1542(pLevel, d1, d2, d3, pStack, -0.25 + Math.random() * 0.25, -0.35 + Math.random() * (double)0.35f, -0.25 + Math.random() * 0.25), pStack);
    }

    private static void popResource(class_1937 pLevel, Supplier<class_1542> pItemEntitySupplier, class_1799 pStack) {
        if (!pLevel.field_9236 && !pStack.method_7960()) {
            class_1542 itementity = pItemEntitySupplier.get();
            itementity.method_6988();
            pLevel.method_8649((class_1297)itementity);
        }
    }

    protected void method_11007(@NotNull class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("SpinStart", this.spinStartTick);
        tag.method_10569("TickCount", this.tickCount);
        tag.method_10566(TAG_ROT, (class_2520)Util.floatsToList(this.rotation));
        tag.method_10566(TAG_START, (class_2520)Util.floatsToList(this.startRot));
        tag.method_10566(TAG_TOTAL, (class_2520)Util.floatsToList(this.totalRot));
        tag.method_10566(TAG_FACE, (class_2520)Util.intsToList(this.faceDeg));
        tag.method_10569("SpinsRemaining", this.spinsRemaining);
    }

    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);
        this.spinStartTick = tag.method_10550("SpinStart");
        this.tickCount = tag.method_10550("TickCount");
        Util.listToFloats(tag.method_10554(TAG_ROT, 5), this.rotation);
        Util.listToFloats(tag.method_10554(TAG_START, 5), this.startRot);
        Util.listToFloats(tag.method_10554(TAG_TOTAL, 5), this.totalRot);
        Util.listToInts(tag.method_10554(TAG_FACE, 3), this.faceDeg);
        this.spinsRemaining = tag.method_10550("SpinsRemaining");
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887() {
        return this.method_38244();
    }

    private void sync() {
        if (!(this.field_11863 instanceof class_3218)) {
            return;
        }
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
    }

    public class_1269 interact(class_1657 player, class_1268 hand) {
        if (this.field_11863 == null) {
            return class_1269.field_5811;
        }
        if (this.field_11863.field_9236) {
            return class_1269.field_5812;
        }
        if (this.spinStartTick >= 0) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        class_1792 item = stack.method_7909();
        if (this.spinsRemaining <= 0) {
            if (item == CompanionsBlocks.COPPER_COIN.get().method_8389()) {
                this.spinsRemaining = Integer.parseInt(CompanionsConfig.BONANZA_COIN_TRIES.split(",")[0].trim());
            } else if (item == CompanionsBlocks.NETHER_COIN.get().method_8389()) {
                this.spinsRemaining = Integer.parseInt(CompanionsConfig.BONANZA_COIN_TRIES.split(",")[1].trim());
            } else if (item == CompanionsBlocks.END_COIN.get().method_8389()) {
                this.spinsRemaining = Integer.parseInt(CompanionsConfig.BONANZA_COIN_TRIES.split(",")[2].trim());
            } else {
                return class_1269.field_5811;
            }
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            this.triggerAnim("coin_controller", "coin");
            this.sync();
            this.field_11863.method_8396(null, this.method_11016(), CompanionsSounds.COIN_CLATTER.get(), class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        --this.spinsRemaining;
        this.triggerAnim("lever_controller", "lever");
        this.startGame();
        this.sync();
        this.field_11863.method_8396(null, this.method_11016(), CompanionsSounds.BONANZA.get(), class_3419.field_15245, 0.35f, 1.0f);
        return class_1269.field_5812;
    }

    public double getTick(Object o) {
        return RenderUtils.getCurrentTick();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "coin_controller", state -> PlayState.STOP).triggerableAnim("coin", COIN)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "lever_controller", state -> PlayState.STOP).triggerableAnim("lever", LEVER)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private record TeddyDrop(String id, float chance, int min, int max) {
    }

    private record SkullDropEntities(String id, int amount) {
    }

    private static class BonanzaTnt
    extends class_1541 {
        public BonanzaTnt(class_1937 level, double x, double y, double z, class_1309 owner) {
            super(level, x, y, z, owner);
        }

        public boolean method_5853(class_1927 explosion, class_1922 level, class_2338 pos, class_2680 blockState, float explosionPower) {
            return false;
        }
    }
}

