/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.antlion.wild.goal;

import dev.xylonity.companions.common.entity.ai.antlion.wild.AbstractWildAntlionAttackGoal;
import dev.xylonity.companions.common.entity.hostile.WildAntlionEntity;
import dev.xylonity.knightlib.api.scheduler.TickScheduler;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;

public class WildAntlionBaseLongAttackGoal
extends AbstractWildAntlionAttackGoal {
    private static final double HIT_PROBABILITY = 0.85;
    private static final double MISS_OFFSET_RANGE = 2.0;
    private static final double ARC_HEIGHT_MULTIPLIER = 0.1;
    private static final int PARTICLES_PER_UNIT = 4;
    private static final int TICK_DELAY_DIVISOR = 6;

    public WildAntlionBaseLongAttackGoal(WildAntlionEntity antlion, int minCd, int maxCd) {
        super(antlion, 13, minCd, maxCd);
    }

    @Override
    public void method_6269() {
        super.method_6269();
        this.antlion.setNoMovement(true);
    }

    @Override
    public void method_6270() {
        super.method_6270();
        this.antlion.setNoMovement(false);
    }

    @Override
    public boolean method_6264() {
        class_1309 target = this.antlion.method_5968();
        if (target != null && this.antlion.method_5858((class_1297)target) > 625.0) {
            return false;
        }
        if (this.antlion.getState() == 0 && target != null) {
            this.antlion.cycleState();
            return false;
        }
        if (!this.antlion.isUnderground()) {
            return false;
        }
        return super.method_6264();
    }

    @Override
    protected void performAttack(class_1309 target) {
        this.spawnParabolicParticles(target);
    }

    @Override
    protected int attackDelay() {
        return 6;
    }

    @Override
    protected int attackType() {
        return 2;
    }

    private void spawnParabolicParticles(class_1309 target) {
        class_3218 serverLevel = (class_3218)this.antlion.method_37908();
        class_2680 blockState = serverLevel.method_8320(this.antlion.method_24515().method_10074());
        if (blockState.method_26215()) {
            return;
        }
        boolean isHit = serverLevel.field_9229.method_43058() <= 0.85;
        TrajectoryData trajectory = this.calculateTrajectory(target, isHit);
        int steps = Math.max(1, (int)(trajectory.distance * 4.0));
        for (int i = 0; i <= steps; ++i) {
            double progress = (double)i / (double)steps;
            double x = class_3532.method_16436((double)progress, (double)trajectory.startX, (double)trajectory.endX);
            double y = class_3532.method_16436((double)progress, (double)trajectory.startY, (double)trajectory.endY) + (1.0 + trajectory.distance * 0.1) * 4.0 * progress * (1.0 - progress);
            double z = class_3532.method_16436((double)progress, (double)trajectory.startZ, (double)trajectory.endZ);
            TickScheduler.scheduleServer((class_1937)serverLevel, () -> serverLevel.method_14199((class_2394)new class_2388(class_2398.field_11217, blockState), x, y, z, 1, 0.0, 0.0, 0.0, 0.01), (int)(i / 6));
        }
        if (isHit) {
            TickScheduler.scheduleServer((class_1937)serverLevel, () -> this.antlion.method_6121((class_1297)target), (int)(steps / 6));
            if (this.antlion.method_37908().field_9229.method_43057() < 0.35f) {
                TickScheduler.scheduleServer((class_1937)serverLevel, () -> target.method_5639(new Random().nextInt(1, 3)), (int)(steps / 6));
            }
        }
    }

    private TrajectoryData calculateTrajectory(class_1309 target, boolean isHit) {
        double endZ;
        double endY;
        double endX;
        double startX = this.antlion.method_23317();
        double startY = this.antlion.method_23318() - 0.5;
        double startZ = this.antlion.method_23321();
        if (isHit) {
            endX = target.method_23317();
            endY = target.method_23318() + (double)target.method_5751();
            endZ = target.method_23321();
        } else {
            endX = target.method_23317() + (this.antlion.method_37908().field_9229.method_43058() - 0.5) * 2.0;
            endY = target.method_23318();
            endZ = target.method_23321() + (this.antlion.method_37908().field_9229.method_43058() - 0.5) * 2.0;
        }
        double dX = endX - startX;
        double dY = endY - startY;
        double dZ = endZ - startZ;
        double distance = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        return new TrajectoryData(startX, startY, startZ, endX, endY, endZ, distance);
    }

    private record TrajectoryData(double startX, double startY, double startZ, double endX, double endY, double endZ, double distance) {
    }
}

