/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionRandomStrollGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.tesla.TeslaConnectionManager;
import dev.xylonity.companions.common.tesla.behaviour.dinamo.DinamoAttackBehaviour;
import dev.xylonity.companions.common.tesla.behaviour.dinamo.DinamoPulseBehaviour;
import dev.xylonity.companions.common.util.interfaces.ITeslaGeneratorBehaviour;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1386;
import net.minecraft.class_1403;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3763;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class DinamoEntity
extends CompanionEntity
implements GeoEntity {
    private final TeslaConnectionManager connectionManager;
    public List<class_1309> entitiesToAttack = new ArrayList<class_1309>();
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("roll");
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private static final class_2940<Boolean> ACTIVE = class_2945.method_12791(DinamoEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> CYCLE_COUNTER = class_2945.method_12791(DinamoEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> ANIMATION_START_TICK = class_2945.method_12791(DinamoEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> ATTACK_ACTIVE = class_2945.method_12791(DinamoEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> ATTACK_CYCLE_COUNTER = class_2945.method_12791(DinamoEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<String> TARGET_IDS = class_2945.method_12791(DinamoEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Boolean> SHOULD_ATTACK = class_2945.method_12791(DinamoEntity.class, (class_2941)class_2943.field_13323);
    private final ITeslaGeneratorBehaviour pulseBehavior;
    private final ITeslaGeneratorBehaviour attackBehavior;

    public DinamoEntity(class_1299<? extends class_1321> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
        this.connectionManager = TeslaConnectionManager.getInstance();
        this.pulseBehavior = new DinamoPulseBehaviour();
        this.attackBehavior = new DinamoAttackBehaviour();
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 pLevel) {
        return new GroundNavigator((class_1308)this, pLevel);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(2, (class_1352)new CompanionFollowOwnerGoal(this, 0.6, 6.0f, 2.0f, false));
        this.field_6201.method_6277(2, (class_1352)new CompanionRandomStrollGoal(this, 0.43));
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new CompanionsHurtTargetGoal(this){

            @Override
            public void method_6269() {
                super.method_6269();
                DinamoEntity.this.setTargetIds(DinamoEntity.this.getTargetIds() + this.getOwnerLastHurt().method_5628() + ";");
            }
        });
    }

    public TeslaConnectionManager.ConnectionNode asConnectionNode() {
        return TeslaConnectionManager.ConnectionNode.forEntity(this.method_5667(), this.method_37908().method_27983().method_29177());
    }

    @Override
    public void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        class_2499 outgoing = new class_2499();
        for (TeslaConnectionManager.ConnectionNode node : TeslaConnectionManager.getInstance().getOutgoing(this.asConnectionNode())) {
            outgoing.add((Object)node.serialize());
        }
        tag.method_10566("OutgoingConnections", (class_2520)outgoing);
        tag.method_10569("AnimationStartTick", this.getAnimationStartTick());
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 1;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.DINAMO_KEEP_CHUNK_LOADED;
    }

    @Override
    public void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        TeslaConnectionManager.ConnectionNode me = this.asConnectionNode();
        this.connectionManager.getOutgoing(me).clear();
        this.connectionManager.getIncoming(me).clear();
        if (tag.method_10545("OutgoingConnections")) {
            class_2499 outgoingList = tag.method_10554("OutgoingConnections", 10);
            for (class_2520 t : outgoingList) {
                TeslaConnectionManager.ConnectionNode node = TeslaConnectionManager.ConnectionNode.deserialize((class_2487)t);
                this.connectionManager.addConnection(me, node, true);
            }
        }
        this.connectionManager.recalculateDistances();
    }

    public void method_6078(@NotNull class_1282 pCause) {
        super.method_6078(pCause);
        HashSet<TeslaConnectionManager.ConnectionNode> outNodes = new HashSet<TeslaConnectionManager.ConnectionNode>(this.connectionManager.getOutgoing(this.asConnectionNode()));
        for (TeslaConnectionManager.ConnectionNode target : outNodes) {
            this.connectionManager.removeConnection(this.asConnectionNode(), target);
        }
        HashSet<TeslaConnectionManager.ConnectionNode> inNodes = new HashSet<TeslaConnectionManager.ConnectionNode>(this.connectionManager.getIncoming(this.asConnectionNode()));
        for (TeslaConnectionManager.ConnectionNode source : inNodes) {
            this.connectionManager.removeConnection(source, this.asConnectionNode());
        }
        this.connectionManager.removeConnectionNode(this.asConnectionNode());
        this.connectionManager.recalculateDistances();
    }

    public static class_5132.class_5133 setAttributes() {
        return class_3763.method_26828().method_26868(class_5134.field_23716, CompanionsConfig.DINAMO_MAX_LIFE).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23723, 1.0).method_26868(class_5134.field_23719, (double)0.55f).method_26868(class_5134.field_23717, 35.0);
    }

    @NotNull
    public class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        if (this.method_6181() && !this.method_37908().field_9236 && hand == class_1268.field_5808 && this.method_35057() == player && player.method_6047().method_7909() != CompanionsItems.WRENCH.get()) {
            if (player.method_5715() && this.getMainAction() != 0) {
                this.setShouldAttack(!this.shouldAttack());
                if (this.shouldAttack()) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"dinamo.companions.client_message.attack").method_27692(class_124.field_1060), true);
                } else {
                    player.method_7353((class_2561)class_2561.method_43471((String)"dinamo.companions.client_message.no_attack").method_27692(class_124.field_1060), true);
                }
            } else {
                if (this.method_37908().field_9236) {
                    return class_1269.field_5812;
                }
                this.handleDefaultMainActionAndHeal(player, hand);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_5805()) {
            this.setActive(false);
        }
        if (this.method_37908().field_9236 && this.getAttackCycleCounter() >= 60) {
            this.entitiesToAttack.clear();
        }
        if (this.getMainAction() == 0) {
            this.pulseBehavior.tick(this);
        } else {
            this.attackBehavior.tick(this);
        }
        if (this.method_37908().field_9236 && !this.getTargetIds().isEmpty() && !this.getTargetIds().isBlank()) {
            for (String s : this.getTargetIds().split(";")) {
                class_1297 class_12972 = this.method_37908().method_8469(Integer.parseInt(s));
                if (!(class_12972 instanceof class_1309)) continue;
                class_1309 e = (class_1309)class_12972;
                this.entitiesToAttack.add(e);
            }
        }
    }

    @Override
    public boolean method_5947() {
        return true;
    }

    public void setActive(boolean active) {
        this.field_6011.method_12778(ACTIVE, (Object)active);
    }

    public String getTargetIds() {
        return (String)this.field_6011.method_12789(TARGET_IDS);
    }

    public void setTargetIds(String uuid) {
        this.field_6011.method_12778(TARGET_IDS, (Object)uuid);
    }

    public boolean isActiveForAttack() {
        return (Boolean)this.field_6011.method_12789(ATTACK_ACTIVE);
    }

    public void setActiveForAttack(boolean active) {
        this.field_6011.method_12778(ATTACK_ACTIVE, (Object)active);
    }

    @NotNull
    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this);
    }

    public int getAnimationStartTick() {
        return (Integer)this.field_6011.method_12789(ANIMATION_START_TICK);
    }

    public void setAnimationStartTick(int tick) {
        this.field_6011.method_12778(ANIMATION_START_TICK, (Object)tick);
    }

    public int getCycleCounter() {
        return (Integer)this.field_6011.method_12789(CYCLE_COUNTER);
    }

    public void setCycleCounter(int tick) {
        this.field_6011.method_12778(CYCLE_COUNTER, (Object)tick);
    }

    public int getAttackCycleCounter() {
        return (Integer)this.field_6011.method_12789(ATTACK_CYCLE_COUNTER);
    }

    public void setAttackCycleCounter(int tick) {
        this.field_6011.method_12778(ATTACK_CYCLE_COUNTER, (Object)tick);
    }

    public boolean isActive() {
        return (Boolean)this.field_6011.method_12789(ACTIVE);
    }

    public boolean shouldAttack() {
        return (Boolean)this.field_6011.method_12789(SHOULD_ATTACK);
    }

    public void setShouldAttack(boolean shouldAttack) {
        this.field_6011.method_12778(SHOULD_ATTACK, (Object)shouldAttack);
    }

    public void handleNodeSelection(TeslaConnectionManager.ConnectionNode thisNode, TeslaConnectionManager.ConnectionNode nodeToConnect) {
        this.connectionManager.addConnection(thisNode, nodeToConnect);
    }

    protected void method_5712(@NotNull class_2338 pPos, @NotNull class_2680 pState) {
        super.method_5712(pPos, pState);
        this.method_5783(CompanionsSounds.DINAMO_STEP.get(), 0.07875f, 1.0f);
    }

    @Nullable
    protected class_3414 method_5994() {
        return CompanionsSounds.DINAMO_IDLE.get();
    }

    protected void method_6013(@NotNull class_1282 pSource) {
        this.method_5783(CompanionsSounds.DINAMO_HURT.get(), 0.25f, 1.0f);
    }

    @Nullable
    protected class_3414 method_6002() {
        return CompanionsSounds.DINAMO_DEATH.get();
    }

    public int method_5970() {
        return 400;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ACTIVE, (Object)false);
        this.field_6011.method_12784(CYCLE_COUNTER, (Object)0);
        this.field_6011.method_12784(ANIMATION_START_TICK, (Object)0);
        this.field_6011.method_12784(ATTACK_ACTIVE, (Object)true);
        this.field_6011.method_12784(ATTACK_CYCLE_COUNTER, (Object)0);
        this.field_6011.method_12784(SHOULD_ATTACK, (Object)true);
        this.field_6011.method_12784(TARGET_IDS, (Object)"");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackcontroller", 1, this::attackPredicate)});
    }

    private <T extends GeoAnimatable> PlayState attackPredicate(AnimationState<T> event) {
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getMainAction() == 0) {
            event.getController().setAnimation(this.SIT);
        } else if (event.isMoving()) {
            event.getController().setAnimation(this.WALK);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

