/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionRandomStrollGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.entity.ai.puppet.glove.goal.PuppetGloveAttackGoal;
import dev.xylonity.companions.common.entity.companion.PuppetEntity;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1403;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class PuppetGloveEntity
extends CompanionEntity {
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation ATTACK = RawAnimation.begin().thenPlay("attack");
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation RECEIVE_PUPPET = RawAnimation.begin().thenPlay("recieve_puppet");
    private static final class_2940<Boolean> IS_ATTACKING = class_2945.method_12791(PuppetGloveEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> TRANSFORMING = class_2945.method_12791(PuppetGloveEntity.class, (class_2941)class_2943.field_13323);
    private static final int TRANSFORMATION_TICKS = 25;
    private int transformationCounter = -1;

    public PuppetGloveEntity(class_1299<? extends class_1321> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            if (this.transformationCounter != -1) {
                ++this.transformationCounter;
            }
            if (this.transformationCounter == 25) {
                this.tameGlove(this.method_35057());
            }
        }
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 1;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.PUPPET_GLOVE_KEEP_CHUNK_LOADED;
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 pLevel) {
        return new GroundNavigator((class_1308)this, pLevel);
    }

    protected void method_5712(@NotNull class_2338 pPos, @NotNull class_2680 pState) {
        this.method_43077(CompanionsSounds.PUPPET_GLOVE_STEP.get());
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1321.method_26828().method_26868(class_5134.field_23716, CompanionsConfig.PUPPET_GLOVE_MAX_LIFE).method_26868(class_5134.field_23721, CompanionsConfig.PUPPET_GLOVE_DAMAGE).method_26868(class_5134.field_23723, 1.0).method_26868(class_5134.field_23719, (double)0.55f).method_26868(class_5134.field_23717, 35.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new PuppetGloveAttackGoal(this, 10, 40));
        this.field_6201.method_6277(3, (class_1352)new CompanionFollowOwnerGoal(this, 0.6, 6.0f, 2.0f, false));
        this.field_6201.method_6277(3, (class_1352)new CompanionRandomStrollGoal(this, 0.43));
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new CompanionsHurtTargetGoal(this));
    }

    @NotNull
    public class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        if (this.isTransforming()) {
            return class_1269.field_5811;
        }
        class_1792 item = player.method_5998(hand).method_7909();
        if (item == CompanionsBlocks.EMPTY_PUPPET.get().method_8389() && this.method_6181() && this.method_35057() != null && this.method_35057() == player) {
            if (this.method_37908().field_9236) {
                return class_1269.field_5812;
            }
            this.method_6174(player.method_5667());
            this.setTransforming(true);
            ++this.transformationCounter;
            return class_1269.field_5812;
        }
        if (this.method_37908().field_9236) {
            return class_1269.field_5812;
        }
        if (this.handleDefaultMainActionAndHeal(player, hand)) {
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    private void tameGlove(class_1309 player) {
        PuppetEntity puppet = (PuppetEntity)CompanionsEntities.PUPPET.method_5883(this.method_37908());
        if (puppet != null) {
            puppet.method_29495(this.method_19538());
            if (player instanceof class_1657) {
                class_1657 p = (class_1657)player;
                puppet.tameInteraction(p);
            } else if (this.method_35057() == null && this.method_6139() != null) {
                puppet.method_6174(this.method_6139());
            }
            this.method_37908().method_8649((class_1297)puppet);
        }
        this.generatePoofParticles();
        this.method_31472();
    }

    private void generatePoofParticles() {
        for (int i = 0; i < 30; ++i) {
            double dx = (this.field_5974.method_43058() - 0.5) * 1.25;
            double dy = (this.field_5974.method_43058() - 0.5) * 1.25;
            double dz = (this.field_5974.method_43058() - 0.5) * 1.25;
            class_1937 class_19372 = this.method_37908();
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 level = (class_3218)class_19372;
            level.method_14199((class_2394)class_2398.field_11203, this.method_19538().field_1352, this.method_23318() + (double)this.method_17682() * Math.random(), this.method_19538().field_1350, 1, dx, dy, dz, 0.1);
        }
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(IS_ATTACKING, (Object)false);
        this.field_6011.method_12784(TRANSFORMING, (Object)false);
    }

    public boolean isAttacking() {
        return (Boolean)this.field_6011.method_12789(IS_ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.field_6011.method_12778(IS_ATTACKING, (Object)attacking);
    }

    public boolean isTransforming() {
        return (Boolean)this.field_6011.method_12789(TRANSFORMING);
    }

    public void setTransforming(boolean transforming) {
        this.field_6011.method_12778(TRANSFORMING, (Object)transforming);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.isTransforming()) {
            event.getController().setAnimation(this.RECEIVE_PUPPET);
        } else if (this.isAttacking()) {
            event.getController().setAnimation(this.ATTACK);
        } else if (this.getMainAction() == 0) {
            event.getController().setAnimation(this.SIT);
        } else if (event.isMoving()) {
            event.getController().setAnimation(this.WALK);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

