/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item.book.books;

import dev.xylonity.companions.common.entity.projectile.MagicRayCircleProjectile;
import dev.xylonity.companions.common.entity.projectile.MagicRayPieceProjectile;
import dev.xylonity.companions.common.item.book.AbstractMagicBook;
import dev.xylonity.companions.common.material.ArmorMaterials;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.scheduler.TickScheduler;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class MagicRayBook
extends AbstractMagicBook {
    public MagicRayBook(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    protected String tooltipName() {
        return "magic_ray_book";
    }

    @Override
    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 pLevel, @NotNull class_1657 pPlayer, @NotNull class_1268 pUsedHand) {
        if (!pLevel.field_9236) {
            class_243 dir = pPlayer.method_5720();
            double traveled = 0.0;
            for (int i = 0; i < 30; ++i) {
                class_243 piecePos = pPlayer.method_5836(1.0f).method_1019(dir).method_1019(dir.method_1021(traveled));
                traveled += 1.0;
                class_2338 blockPos = class_2338.method_49638((class_2374)piecePos);
                if (!this.isPassableBlock(pLevel, blockPos)) {
                    this.spawnRayPiece(pLevel, pPlayer, piecePos, dir, i == 0);
                    break;
                }
                this.spawnRayPiece(pLevel, pPlayer, piecePos, dir, i == 0);
            }
            pPlayer.method_7357().method_7906((class_1792)this, (int)((double)CompanionsConfig.MAGIC_RAY_COOLDOWN * (1.0 - (double)Util.hasFullSetOn(pPlayer, ArmorMaterials.MAGE) * CompanionsConfig.MAGE_SET_COOLDOWN_REDUCTION)));
        }
        return super.method_7836(pLevel, pPlayer, pUsedHand);
    }

    @Override
    protected void playSound(class_1657 player) {
        player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), CompanionsSounds.SPELL_RELEASE_BEAM.get(), player.method_5634(), 1.2f, 1.0f);
    }

    private boolean isPassableBlock(class_1937 level, class_2338 pos) {
        return level.method_8320(pos).method_26220((class_1922)level, pos).method_1110();
    }

    private void spawnRayPiece(class_1937 pLevel, class_1657 pPlayer, class_243 piecePos, class_243 lookVec, boolean isFirstPiece) {
        if (isFirstPiece) {
            MagicRayCircleProjectile circle = (MagicRayCircleProjectile)CompanionsEntities.MAGIC_RAY_PIECE_CIRCLE_PROJECTILE.method_5883(pLevel);
            if (circle != null) {
                circle.method_5814(piecePos.field_1352, piecePos.field_1351, piecePos.field_1350);
                circle.method_7432((class_1297)pPlayer);
                this.rotateProjectile(circle, lookVec);
                pLevel.method_8649((class_1297)circle);
            }
        } else {
            MagicRayPieceProjectile ray = (MagicRayPieceProjectile)CompanionsEntities.MAGIC_RAY_PIECE_PROJECTILE.method_5883(pLevel);
            if (ray != null) {
                ray.method_5814(piecePos.field_1352, piecePos.field_1351, piecePos.field_1350);
                this.rotateProjectile(ray, lookVec);
                ray.method_7432((class_1297)pPlayer);
                if (pLevel instanceof class_3218) {
                    class_3218 level = (class_3218)pLevel;
                    TickScheduler.scheduleServer((class_1937)level, () -> pLevel.method_8649((class_1297)ray), (int)3);
                }
            }
        }
    }

    private void rotateProjectile(MagicRayPieceProjectile projectile, class_243 direction) {
        projectile.setPitch((float)(-Math.atan2(direction.field_1351, Math.sqrt(direction.field_1352 * direction.field_1352 + direction.field_1350 * direction.field_1350)) * 57.29577951308232));
        projectile.setYaw((float)(Math.atan2(direction.field_1350, direction.field_1352) * 57.29577951308232) - 90.0f);
    }
}

