/*
 * Decompiled with CFR 0.152.
 */
package hal.studios.hpm.entity;

import hal.studios.hpm.init.HpmModEntities;
import hal.studios.hpm.init.HpmModItems;
import hal.studios.hpm.procedures.HandCannonProjectileHitsBlockProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class HandCannonProjectileEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)HpmModItems.CANNONBALL.get());

    public HandCannonProjectileEntity(EntityType<? extends HandCannonProjectileEntity> type, Level world) {
        super(type, world, PROJECTILE_ITEM);
    }

    public HandCannonProjectileEntity(EntityType<? extends HandCannonProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world, PROJECTILE_ITEM);
    }

    public HandCannonProjectileEntity(EntityType<? extends HandCannonProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world, PROJECTILE_ITEM);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        HandCannonProjectileHitsBlockProcedure.execute((LevelAccessor)this.level(), blockHitResult.getBlockPos().getX(), blockHitResult.getBlockPos().getY(), blockHitResult.getBlockPos().getZ());
    }

    public void tick() {
        super.tick();
        if (this.inGround) {
            this.discard();
        }
    }

    public static HandCannonProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return HandCannonProjectileEntity.shoot(world, entity, source, 2.0f, 4.0, 0);
    }

    public static HandCannonProjectileEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        HandCannonProjectileEntity entityarrow = new HandCannonProjectileEntity((EntityType<? extends HandCannonProjectileEntity>)((EntityType)HpmModEntities.HAND_CANNON_PROJECTILE.get()), entity, world);
        entityarrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        entityarrow.setSilent(true);
        entityarrow.setCritArrow(true);
        entityarrow.setBaseDamage(damage);
        entityarrow.setKnockback(knockback);
        entityarrow.setSecondsOnFire(100);
        world.addFreshEntity((Entity)entityarrow);
        world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.generic.explode")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static HandCannonProjectileEntity shoot(LivingEntity entity, LivingEntity target) {
        HandCannonProjectileEntity entityarrow = new HandCannonProjectileEntity((EntityType<? extends HandCannonProjectileEntity>)((EntityType)HpmModEntities.HAND_CANNON_PROJECTILE.get()), entity, entity.level());
        double dx = target.getX() - entity.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        double dz = target.getZ() - entity.getZ();
        entityarrow.shoot(dx, dy - entityarrow.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 4.0f, 12.0f);
        entityarrow.setSilent(true);
        entityarrow.setBaseDamage(4.0);
        entityarrow.setKnockback(0);
        entityarrow.setCritArrow(true);
        entityarrow.setSecondsOnFire(100);
        entity.level().addFreshEntity((Entity)entityarrow);
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.generic.explode")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.create().nextFloat() * 0.5f + 1.0f));
        return entityarrow;
    }
}

