/*
 * Decompiled with CFR 0.152.
 */
package hal.studios.hpm.network;

import hal.studios.hpm.HpmMod;
import hal.studios.hpm.procedures.SailspeedupOnKeyPressedProcedure;
import hal.studios.hpm.procedures.SailspeedupOnKeyReleasedProcedure;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public record SailspeedupMessage(int type, int pressedms) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("hpm", "key_sailspeedup");

    public SailspeedupMessage(FriendlyByteBuf buffer) {
        this(buffer.readInt(), buffer.readInt());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.type);
        buffer.writeInt(this.pressedms);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handleData(SailspeedupMessage message, PlayPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.workHandler().submitAsync(() -> SailspeedupMessage.pressAction((Player)context.player().get(), message.type, message.pressedms)).exceptionally(e -> {
                context.packetHandler().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        if (!world.hasChunkAt(entity.blockPosition())) {
            return;
        }
        if (type == 0) {
            SailspeedupOnKeyPressedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (type == 1) {
            SailspeedupOnKeyReleasedProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        HpmMod.addNetworkMessage(ID, SailspeedupMessage::new, SailspeedupMessage::handleData);
    }
}

