/*
 * Decompiled with CFR 0.152.
 */
package hal.studios.hpm.world.inventory;

import hal.studios.hpm.init.HpmModMenus;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class RaftinventoryMenu
extends AbstractContainerMenu
implements Supplier<Map<Integer, Slot>> {
    public static final HashMap<String, Object> guistate = new HashMap();
    public final Level world;
    public final Player entity;
    public int x;
    public int y;
    public int z;
    private ContainerLevelAccess access = ContainerLevelAccess.NULL;
    private IItemHandler internal;
    private final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    private boolean bound = false;
    private Supplier<Boolean> boundItemMatcher = null;
    private Entity boundEntity = null;
    private BlockEntity boundBlockEntity = null;

    public RaftinventoryMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        super((MenuType)HpmModMenus.RAFTINVENTORY.get(), id);
        int si;
        this.entity = inv.player;
        this.world = inv.player.level();
        this.internal = new ItemStackHandler(97);
        BlockPos pos = null;
        if (extraData != null) {
            pos = extraData.readBlockPos();
            this.x = pos.getX();
            this.y = pos.getY();
            this.z = pos.getZ();
            this.access = ContainerLevelAccess.create((Level)this.world, (BlockPos)pos);
        }
        if (pos != null) {
            if (extraData.readableBytes() == 1) {
                byte hand = extraData.readByte();
                ItemStack itemstack = hand == 0 ? this.entity.getMainHandItem() : this.entity.getOffhandItem();
                this.boundItemMatcher = () -> itemstack == (hand == 0 ? this.entity.getMainHandItem() : this.entity.getOffhandItem());
                IItemHandler cap = (IItemHandler)itemstack.getCapability(Capabilities.ItemHandler.ITEM);
                if (cap != null) {
                    this.internal = cap;
                    this.bound = true;
                }
            } else if (extraData.readableBytes() > 1) {
                IItemHandler cap;
                extraData.readByte();
                this.boundEntity = this.world.getEntity(extraData.readVarInt());
                if (this.boundEntity != null && (cap = (IItemHandler)this.boundEntity.getCapability(Capabilities.ItemHandler.ENTITY)) != null) {
                    this.internal = cap;
                    this.bound = true;
                }
            } else {
                IItemHandler cap;
                this.boundBlockEntity = this.world.getBlockEntity(pos);
                if (this.boundBlockEntity != null && (cap = (IItemHandler)this.world.getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) != null) {
                    this.internal = cap;
                    this.bound = true;
                }
            }
        }
        this.customSlots.put(0, this.addSlot((Slot)new SlotItemHandler(this.internal, 0, 105, 16){
            private final int slot = 0;
            {
                this.slot = 0;
            }
        }));
        this.customSlots.put(1, this.addSlot((Slot)new SlotItemHandler(this.internal, 1, 123, 16){
            private final int slot = 1;
            {
                this.slot = 1;
            }
        }));
        this.customSlots.put(2, this.addSlot((Slot)new SlotItemHandler(this.internal, 2, 141, 16){
            private final int slot = 2;
            {
                this.slot = 2;
            }
        }));
        this.customSlots.put(3, this.addSlot((Slot)new SlotItemHandler(this.internal, 3, 159, 16){
            private final int slot = 3;
            {
                this.slot = 3;
            }
        }));
        this.customSlots.put(4, this.addSlot((Slot)new SlotItemHandler(this.internal, 4, 177, 16){
            private final int slot = 4;
            {
                this.slot = 4;
            }
        }));
        this.customSlots.put(5, this.addSlot((Slot)new SlotItemHandler(this.internal, 5, 195, 16){
            private final int slot = 5;
            {
                this.slot = 5;
            }
        }));
        this.customSlots.put(6, this.addSlot((Slot)new SlotItemHandler(this.internal, 6, 213, 16){
            private final int slot = 6;
            {
                this.slot = 6;
            }
        }));
        this.customSlots.put(7, this.addSlot((Slot)new SlotItemHandler(this.internal, 7, 231, 16){
            private final int slot = 7;
            {
                this.slot = 7;
            }
        }));
        this.customSlots.put(8, this.addSlot((Slot)new SlotItemHandler(this.internal, 8, 249, 16){
            private final int slot = 8;
            {
                this.slot = 8;
            }
        }));
        this.customSlots.put(9, this.addSlot((Slot)new SlotItemHandler(this.internal, 9, 105, 34){
            private final int slot = 9;
            {
                this.slot = 9;
            }
        }));
        this.customSlots.put(10, this.addSlot((Slot)new SlotItemHandler(this.internal, 10, 123, 34){
            private final int slot = 10;
            {
                this.slot = 10;
            }
        }));
        this.customSlots.put(11, this.addSlot((Slot)new SlotItemHandler(this.internal, 11, 141, 34){
            private final int slot = 11;
            {
                this.slot = 11;
            }
        }));
        this.customSlots.put(12, this.addSlot((Slot)new SlotItemHandler(this.internal, 12, 159, 34){
            private final int slot = 12;
            {
                this.slot = 12;
            }
        }));
        this.customSlots.put(13, this.addSlot((Slot)new SlotItemHandler(this.internal, 13, 177, 34){
            private final int slot = 13;
            {
                this.slot = 13;
            }
        }));
        this.customSlots.put(14, this.addSlot((Slot)new SlotItemHandler(this.internal, 14, 195, 34){
            private final int slot = 14;
            {
                this.slot = 14;
            }
        }));
        this.customSlots.put(15, this.addSlot((Slot)new SlotItemHandler(this.internal, 15, 213, 34){
            private final int slot = 15;
            {
                this.slot = 15;
            }
        }));
        this.customSlots.put(16, this.addSlot((Slot)new SlotItemHandler(this.internal, 16, 231, 34){
            private final int slot = 16;
            {
                this.slot = 16;
            }
        }));
        this.customSlots.put(17, this.addSlot((Slot)new SlotItemHandler(this.internal, 17, 249, 34){
            private final int slot = 17;
            {
                this.slot = 17;
            }
        }));
        this.customSlots.put(18, this.addSlot((Slot)new SlotItemHandler(this.internal, 18, 105, 52){
            private final int slot = 18;
            {
                this.slot = 18;
            }
        }));
        this.customSlots.put(19, this.addSlot((Slot)new SlotItemHandler(this.internal, 19, 123, 52){
            private final int slot = 19;
            {
                this.slot = 19;
            }
        }));
        this.customSlots.put(20, this.addSlot((Slot)new SlotItemHandler(this.internal, 20, 141, 52){
            private final int slot = 20;
            {
                this.slot = 20;
            }
        }));
        this.customSlots.put(21, this.addSlot((Slot)new SlotItemHandler(this.internal, 21, 159, 52){
            private final int slot = 21;
            {
                this.slot = 21;
            }
        }));
        this.customSlots.put(22, this.addSlot((Slot)new SlotItemHandler(this.internal, 22, 177, 52){
            private final int slot = 22;
            {
                this.slot = 22;
            }
        }));
        this.customSlots.put(23, this.addSlot((Slot)new SlotItemHandler(this.internal, 23, 195, 52){
            private final int slot = 23;
            {
                this.slot = 23;
            }
        }));
        this.customSlots.put(24, this.addSlot((Slot)new SlotItemHandler(this.internal, 24, 213, 52){
            private final int slot = 24;
            {
                this.slot = 24;
            }
        }));
        this.customSlots.put(25, this.addSlot((Slot)new SlotItemHandler(this.internal, 25, 231, 52){
            private final int slot = 25;
            {
                this.slot = 25;
            }
        }));
        this.customSlots.put(26, this.addSlot((Slot)new SlotItemHandler(this.internal, 26, 249, 52){
            private final int slot = 26;
            {
                this.slot = 26;
            }
        }));
        this.customSlots.put(27, this.addSlot((Slot)new SlotItemHandler(this.internal, 27, 105, 70){
            private final int slot = 27;
            {
                this.slot = 27;
            }
        }));
        this.customSlots.put(28, this.addSlot((Slot)new SlotItemHandler(this.internal, 28, 123, 70){
            private final int slot = 28;
            {
                this.slot = 28;
            }
        }));
        this.customSlots.put(29, this.addSlot((Slot)new SlotItemHandler(this.internal, 29, 141, 70){
            private final int slot = 29;
            {
                this.slot = 29;
            }
        }));
        this.customSlots.put(30, this.addSlot((Slot)new SlotItemHandler(this.internal, 30, 159, 70){
            private final int slot = 30;
            {
                this.slot = 30;
            }
        }));
        this.customSlots.put(31, this.addSlot((Slot)new SlotItemHandler(this.internal, 31, 177, 70){
            private final int slot = 31;
            {
                this.slot = 31;
            }
        }));
        this.customSlots.put(32, this.addSlot((Slot)new SlotItemHandler(this.internal, 32, 195, 70){
            private final int slot = 32;
            {
                this.slot = 32;
            }
        }));
        this.customSlots.put(33, this.addSlot((Slot)new SlotItemHandler(this.internal, 33, 213, 70){
            private final int slot = 33;
            {
                this.slot = 33;
            }
        }));
        this.customSlots.put(34, this.addSlot((Slot)new SlotItemHandler(this.internal, 34, 231, 70){
            private final int slot = 34;
            {
                this.slot = 34;
            }
        }));
        this.customSlots.put(35, this.addSlot((Slot)new SlotItemHandler(this.internal, 35, 249, 70){
            private final int slot = 35;
            {
                this.slot = 35;
            }
        }));
        this.customSlots.put(36, this.addSlot((Slot)new SlotItemHandler(this.internal, 36, 267, 16){
            private final int slot = 36;
            {
                this.slot = 36;
            }
        }));
        this.customSlots.put(37, this.addSlot((Slot)new SlotItemHandler(this.internal, 37, 285, 16){
            private final int slot = 37;
            {
                this.slot = 37;
            }
        }));
        this.customSlots.put(38, this.addSlot((Slot)new SlotItemHandler(this.internal, 38, 303, 16){
            private final int slot = 38;
            {
                this.slot = 38;
            }
        }));
        this.customSlots.put(39, this.addSlot((Slot)new SlotItemHandler(this.internal, 39, 321, 16){
            private final int slot = 39;
            {
                this.slot = 39;
            }
        }));
        this.customSlots.put(40, this.addSlot((Slot)new SlotItemHandler(this.internal, 40, 339, 16){
            private final int slot = 40;
            {
                this.slot = 40;
            }
        }));
        this.customSlots.put(49, this.addSlot((Slot)new SlotItemHandler(this.internal, 49, 285, 52){
            private final int slot = 49;
            {
                this.slot = 49;
            }
        }));
        this.customSlots.put(50, this.addSlot((Slot)new SlotItemHandler(this.internal, 50, 303, 52){
            private final int slot = 50;
            {
                this.slot = 50;
            }
        }));
        this.customSlots.put(51, this.addSlot((Slot)new SlotItemHandler(this.internal, 51, 321, 52){
            private final int slot = 51;
            {
                this.slot = 51;
            }
        }));
        this.customSlots.put(52, this.addSlot((Slot)new SlotItemHandler(this.internal, 52, 339, 52){
            private final int slot = 52;
            {
                this.slot = 52;
            }
        }));
        this.customSlots.put(64, this.addSlot((Slot)new SlotItemHandler(this.internal, 64, 15, 16){
            private final int slot = 64;
            {
                this.slot = 64;
            }
        }));
        this.customSlots.put(66, this.addSlot((Slot)new SlotItemHandler(this.internal, 66, 87, 34){
            private final int slot = 66;
            {
                this.slot = 66;
            }
        }));
        this.customSlots.put(67, this.addSlot((Slot)new SlotItemHandler(this.internal, 67, 69, 34){
            private final int slot = 67;
            {
                this.slot = 67;
            }
        }));
        this.customSlots.put(68, this.addSlot((Slot)new SlotItemHandler(this.internal, 68, 51, 34){
            private final int slot = 68;
            {
                this.slot = 68;
            }
        }));
        this.customSlots.put(69, this.addSlot((Slot)new SlotItemHandler(this.internal, 69, 33, 16){
            private final int slot = 69;
            {
                this.slot = 69;
            }
        }));
        this.customSlots.put(70, this.addSlot((Slot)new SlotItemHandler(this.internal, 70, 33, 34){
            private final int slot = 70;
            {
                this.slot = 70;
            }
        }));
        this.customSlots.put(71, this.addSlot((Slot)new SlotItemHandler(this.internal, 71, 15, 34){
            private final int slot = 71;
            {
                this.slot = 71;
            }
        }));
        this.customSlots.put(74, this.addSlot((Slot)new SlotItemHandler(this.internal, 74, 15, 52){
            private final int slot = 74;
            {
                this.slot = 74;
            }
        }));
        this.customSlots.put(75, this.addSlot((Slot)new SlotItemHandler(this.internal, 75, 33, 52){
            private final int slot = 75;
            {
                this.slot = 75;
            }
        }));
        this.customSlots.put(76, this.addSlot((Slot)new SlotItemHandler(this.internal, 76, 51, 52){
            private final int slot = 76;
            {
                this.slot = 76;
            }
        }));
        this.customSlots.put(77, this.addSlot((Slot)new SlotItemHandler(this.internal, 77, 69, 52){
            private final int slot = 77;
            {
                this.slot = 77;
            }
        }));
        this.customSlots.put(78, this.addSlot((Slot)new SlotItemHandler(this.internal, 78, 87, 52){
            private final int slot = 78;
            {
                this.slot = 78;
            }
        }));
        this.customSlots.put(80, this.addSlot((Slot)new SlotItemHandler(this.internal, 80, 15, 70){
            private final int slot = 80;
            {
                this.slot = 80;
            }
        }));
        this.customSlots.put(81, this.addSlot((Slot)new SlotItemHandler(this.internal, 81, 33, 70){
            private final int slot = 81;
            {
                this.slot = 81;
            }
        }));
        this.customSlots.put(82, this.addSlot((Slot)new SlotItemHandler(this.internal, 82, 51, 70){
            private final int slot = 82;
            {
                this.slot = 82;
            }
        }));
        this.customSlots.put(83, this.addSlot((Slot)new SlotItemHandler(this.internal, 83, 69, 70){
            private final int slot = 83;
            {
                this.slot = 83;
            }
        }));
        this.customSlots.put(84, this.addSlot((Slot)new SlotItemHandler(this.internal, 84, 87, 70){
            private final int slot = 84;
            {
                this.slot = 84;
            }
        }));
        this.customSlots.put(62, this.addSlot((Slot)new SlotItemHandler(this.internal, 62, 51, 16){
            private final int slot = 62;
            {
                this.slot = 62;
            }
        }));
        this.customSlots.put(60, this.addSlot((Slot)new SlotItemHandler(this.internal, 60, 87, 16){
            private final int slot = 60;
            {
                this.slot = 60;
            }
        }));
        this.customSlots.put(85, this.addSlot((Slot)new SlotItemHandler(this.internal, 85, 267, 34){
            private final int slot = 85;
            {
                this.slot = 85;
            }
        }));
        this.customSlots.put(86, this.addSlot((Slot)new SlotItemHandler(this.internal, 86, 285, 34){
            private final int slot = 86;
            {
                this.slot = 86;
            }
        }));
        this.customSlots.put(87, this.addSlot((Slot)new SlotItemHandler(this.internal, 87, 303, 34){
            private final int slot = 87;
            {
                this.slot = 87;
            }
        }));
        this.customSlots.put(88, this.addSlot((Slot)new SlotItemHandler(this.internal, 88, 321, 34){
            private final int slot = 88;
            {
                this.slot = 88;
            }
        }));
        this.customSlots.put(89, this.addSlot((Slot)new SlotItemHandler(this.internal, 89, 339, 34){
            private final int slot = 89;
            {
                this.slot = 89;
            }
        }));
        this.customSlots.put(90, this.addSlot((Slot)new SlotItemHandler(this.internal, 90, 267, 52){
            private final int slot = 90;
            {
                this.slot = 90;
            }
        }));
        this.customSlots.put(91, this.addSlot((Slot)new SlotItemHandler(this.internal, 91, 267, 70){
            private final int slot = 91;
            {
                this.slot = 91;
            }
        }));
        this.customSlots.put(92, this.addSlot((Slot)new SlotItemHandler(this.internal, 92, 285, 70){
            private final int slot = 92;
            {
                this.slot = 92;
            }
        }));
        this.customSlots.put(93, this.addSlot((Slot)new SlotItemHandler(this.internal, 93, 303, 70){
            private final int slot = 93;
            {
                this.slot = 93;
            }
        }));
        this.customSlots.put(94, this.addSlot((Slot)new SlotItemHandler(this.internal, 94, 321, 70){
            private final int slot = 94;
            {
                this.slot = 94;
            }
        }));
        this.customSlots.put(95, this.addSlot((Slot)new SlotItemHandler(this.internal, 95, 69, 16){
            private final int slot = 95;
            {
                this.slot = 95;
            }
        }));
        this.customSlots.put(96, this.addSlot((Slot)new SlotItemHandler(this.internal, 96, 339, 70){
            private final int slot = 96;
            {
                this.slot = 96;
            }
        }));
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.addSlot(new Slot((Container)inv, sj + (si + 1) * 9, 106 + sj * 18, 101 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.addSlot(new Slot((Container)inv, si, 106 + si * 18, 159));
        }
    }

    public boolean stillValid(Player player) {
        if (this.bound) {
            if (this.boundItemMatcher != null) {
                return this.boundItemMatcher.get();
            }
            if (this.boundBlockEntity != null) {
                return AbstractContainerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)this.boundBlockEntity.getBlockState().getBlock());
            }
            if (this.boundEntity != null) {
                return this.boundEntity.isAlive();
            }
        }
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 76) {
                if (!this.moveItemStackTo(itemstack1, 76, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (!this.moveItemStackTo(itemstack1, 0, 76, false)) {
                if (index < 103 ? !this.moveItemStackTo(itemstack1, 103, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 76, 103, false)) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected boolean moveItemStackTo(ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        boolean flag = false;
        int i = p_38905_;
        if (p_38907_) {
            i = p_38906_ - 1;
        }
        if (p_38904_.isStackable()) {
            while (!p_38904_.isEmpty() && (p_38907_ ? i >= p_38905_ : i < p_38906_)) {
                ItemStack itemstack;
                Slot slot = (Slot)this.slots.get(i);
                if (slot.mayPlace(itemstack = slot.getItem()) && !itemstack.isEmpty() && ItemStack.isSameItemSameTags((ItemStack)p_38904_, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.getCount() + p_38904_.getCount();
                    if (j <= (maxSize = Math.min(slot.getMaxStackSize(), p_38904_.getMaxStackSize()))) {
                        p_38904_.setCount(0);
                        itemstack.setCount(j);
                        slot.set(itemstack);
                        flag = true;
                    } else if (itemstack.getCount() < maxSize) {
                        p_38904_.shrink(maxSize - itemstack.getCount());
                        itemstack.setCount(maxSize);
                        slot.set(itemstack);
                        flag = true;
                    }
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!p_38904_.isEmpty()) {
            i = p_38907_ ? p_38906_ - 1 : p_38905_;
            while (p_38907_ ? i >= p_38905_ : i < p_38906_) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(p_38904_)) {
                    if (p_38904_.getCount() > slot1.getMaxStackSize()) {
                        slot1.setByPlayer(p_38904_.split(slot1.getMaxStackSize()));
                    } else {
                        slot1.setByPlayer(p_38904_.split(p_38904_.getCount()));
                    }
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void removed(Player playerIn) {
        block4: {
            super.removed(playerIn);
            if (this.bound || !(playerIn instanceof ServerPlayer)) break block4;
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            if (!serverPlayer.isAlive() || serverPlayer.hasDisconnected()) {
                for (int j = 0; j < this.internal.getSlots(); ++j) {
                    playerIn.drop(this.internal.extractItem(j, this.internal.getStackInSlot(j).getCount(), false), false);
                }
            } else {
                for (int i = 0; i < this.internal.getSlots(); ++i) {
                    playerIn.getInventory().placeItemBackInInventory(this.internal.extractItem(i, this.internal.getStackInSlot(i).getCount(), false));
                }
            }
        }
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }
}

