/*
 * Decompiled with CFR 0.152.
 */
package hal.studios.hpm.world.inventory;

import hal.studios.hpm.init.HpmModMenus;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class SwashbucklerinventoryMenu
extends AbstractContainerMenu
implements Supplier<Map<Integer, Slot>> {
    public static final HashMap<String, Object> guistate = new HashMap();
    public final Level world;
    public final Player entity;
    public int x;
    public int y;
    public int z;
    private ContainerLevelAccess access = ContainerLevelAccess.NULL;
    private IItemHandler internal;
    private final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    private boolean bound = false;
    private Supplier<Boolean> boundItemMatcher = null;
    private Entity boundEntity = null;
    private BlockEntity boundBlockEntity = null;

    public SwashbucklerinventoryMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        super((MenuType)HpmModMenus.SWASHBUCKLERINVENTORY.get(), id);
        int si;
        this.entity = inv.player;
        this.world = inv.player.level();
        this.internal = new ItemStackHandler(36);
        BlockPos pos = null;
        if (extraData != null) {
            pos = extraData.readBlockPos();
            this.x = pos.getX();
            this.y = pos.getY();
            this.z = pos.getZ();
            this.access = ContainerLevelAccess.create((Level)this.world, (BlockPos)pos);
        }
        if (pos != null) {
            if (extraData.readableBytes() == 1) {
                byte hand = extraData.readByte();
                ItemStack itemstack = hand == 0 ? this.entity.getMainHandItem() : this.entity.getOffhandItem();
                this.boundItemMatcher = () -> itemstack == (hand == 0 ? this.entity.getMainHandItem() : this.entity.getOffhandItem());
                IItemHandler cap = (IItemHandler)itemstack.getCapability(Capabilities.ItemHandler.ITEM);
                if (cap != null) {
                    this.internal = cap;
                    this.bound = true;
                }
            } else if (extraData.readableBytes() > 1) {
                IItemHandler cap;
                extraData.readByte();
                this.boundEntity = this.world.getEntity(extraData.readVarInt());
                if (this.boundEntity != null && (cap = (IItemHandler)this.boundEntity.getCapability(Capabilities.ItemHandler.ENTITY)) != null) {
                    this.internal = cap;
                    this.bound = true;
                }
            } else {
                IItemHandler cap;
                this.boundBlockEntity = this.world.getBlockEntity(pos);
                if (this.boundBlockEntity != null && (cap = (IItemHandler)this.world.getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) != null) {
                    this.internal = cap;
                    this.bound = true;
                }
            }
        }
        this.customSlots.put(0, this.addSlot((Slot)new SlotItemHandler(this.internal, 0, 7, 12){
            private final int slot = 0;
            {
                this.slot = 0;
            }
        }));
        this.customSlots.put(1, this.addSlot((Slot)new SlotItemHandler(this.internal, 1, 25, 12){
            private final int slot = 1;
            {
                this.slot = 1;
            }
        }));
        this.customSlots.put(2, this.addSlot((Slot)new SlotItemHandler(this.internal, 2, 43, 12){
            private final int slot = 2;
            {
                this.slot = 2;
            }
        }));
        this.customSlots.put(3, this.addSlot((Slot)new SlotItemHandler(this.internal, 3, 61, 12){
            private final int slot = 3;
            {
                this.slot = 3;
            }
        }));
        this.customSlots.put(4, this.addSlot((Slot)new SlotItemHandler(this.internal, 4, 79, 12){
            private final int slot = 4;
            {
                this.slot = 4;
            }
        }));
        this.customSlots.put(5, this.addSlot((Slot)new SlotItemHandler(this.internal, 5, 97, 12){
            private final int slot = 5;
            {
                this.slot = 5;
            }
        }));
        this.customSlots.put(6, this.addSlot((Slot)new SlotItemHandler(this.internal, 6, 115, 12){
            private final int slot = 6;
            {
                this.slot = 6;
            }
        }));
        this.customSlots.put(7, this.addSlot((Slot)new SlotItemHandler(this.internal, 7, 133, 12){
            private final int slot = 7;
            {
                this.slot = 7;
            }
        }));
        this.customSlots.put(8, this.addSlot((Slot)new SlotItemHandler(this.internal, 8, 151, 12){
            private final int slot = 8;
            {
                this.slot = 8;
            }
        }));
        this.customSlots.put(9, this.addSlot((Slot)new SlotItemHandler(this.internal, 9, 7, 30){
            private final int slot = 9;
            {
                this.slot = 9;
            }
        }));
        this.customSlots.put(10, this.addSlot((Slot)new SlotItemHandler(this.internal, 10, 25, 30){
            private final int slot = 10;
            {
                this.slot = 10;
            }
        }));
        this.customSlots.put(11, this.addSlot((Slot)new SlotItemHandler(this.internal, 11, 43, 30){
            private final int slot = 11;
            {
                this.slot = 11;
            }
        }));
        this.customSlots.put(12, this.addSlot((Slot)new SlotItemHandler(this.internal, 12, 61, 30){
            private final int slot = 12;
            {
                this.slot = 12;
            }
        }));
        this.customSlots.put(13, this.addSlot((Slot)new SlotItemHandler(this.internal, 13, 79, 30){
            private final int slot = 13;
            {
                this.slot = 13;
            }
        }));
        this.customSlots.put(14, this.addSlot((Slot)new SlotItemHandler(this.internal, 14, 97, 30){
            private final int slot = 14;
            {
                this.slot = 14;
            }
        }));
        this.customSlots.put(15, this.addSlot((Slot)new SlotItemHandler(this.internal, 15, 115, 30){
            private final int slot = 15;
            {
                this.slot = 15;
            }
        }));
        this.customSlots.put(16, this.addSlot((Slot)new SlotItemHandler(this.internal, 16, 133, 30){
            private final int slot = 16;
            {
                this.slot = 16;
            }
        }));
        this.customSlots.put(17, this.addSlot((Slot)new SlotItemHandler(this.internal, 17, 151, 30){
            private final int slot = 17;
            {
                this.slot = 17;
            }
        }));
        this.customSlots.put(18, this.addSlot((Slot)new SlotItemHandler(this.internal, 18, 7, 48){
            private final int slot = 18;
            {
                this.slot = 18;
            }
        }));
        this.customSlots.put(19, this.addSlot((Slot)new SlotItemHandler(this.internal, 19, 25, 48){
            private final int slot = 19;
            {
                this.slot = 19;
            }
        }));
        this.customSlots.put(20, this.addSlot((Slot)new SlotItemHandler(this.internal, 20, 43, 48){
            private final int slot = 20;
            {
                this.slot = 20;
            }
        }));
        this.customSlots.put(21, this.addSlot((Slot)new SlotItemHandler(this.internal, 21, 61, 48){
            private final int slot = 21;
            {
                this.slot = 21;
            }
        }));
        this.customSlots.put(22, this.addSlot((Slot)new SlotItemHandler(this.internal, 22, 79, 48){
            private final int slot = 22;
            {
                this.slot = 22;
            }
        }));
        this.customSlots.put(23, this.addSlot((Slot)new SlotItemHandler(this.internal, 23, 97, 48){
            private final int slot = 23;
            {
                this.slot = 23;
            }
        }));
        this.customSlots.put(24, this.addSlot((Slot)new SlotItemHandler(this.internal, 24, 115, 48){
            private final int slot = 24;
            {
                this.slot = 24;
            }
        }));
        this.customSlots.put(25, this.addSlot((Slot)new SlotItemHandler(this.internal, 25, 133, 48){
            private final int slot = 25;
            {
                this.slot = 25;
            }
        }));
        this.customSlots.put(26, this.addSlot((Slot)new SlotItemHandler(this.internal, 26, 151, 48){
            private final int slot = 26;
            {
                this.slot = 26;
            }
        }));
        this.customSlots.put(27, this.addSlot((Slot)new SlotItemHandler(this.internal, 27, 7, 66){
            private final int slot = 27;
            {
                this.slot = 27;
            }
        }));
        this.customSlots.put(28, this.addSlot((Slot)new SlotItemHandler(this.internal, 28, 25, 66){
            private final int slot = 28;
            {
                this.slot = 28;
            }
        }));
        this.customSlots.put(29, this.addSlot((Slot)new SlotItemHandler(this.internal, 29, 43, 66){
            private final int slot = 29;
            {
                this.slot = 29;
            }
        }));
        this.customSlots.put(30, this.addSlot((Slot)new SlotItemHandler(this.internal, 30, 61, 66){
            private final int slot = 30;
            {
                this.slot = 30;
            }
        }));
        this.customSlots.put(31, this.addSlot((Slot)new SlotItemHandler(this.internal, 31, 79, 66){
            private final int slot = 31;
            {
                this.slot = 31;
            }
        }));
        this.customSlots.put(32, this.addSlot((Slot)new SlotItemHandler(this.internal, 32, 97, 66){
            private final int slot = 32;
            {
                this.slot = 32;
            }
        }));
        this.customSlots.put(33, this.addSlot((Slot)new SlotItemHandler(this.internal, 33, 115, 66){
            private final int slot = 33;
            {
                this.slot = 33;
            }
        }));
        this.customSlots.put(34, this.addSlot((Slot)new SlotItemHandler(this.internal, 34, 133, 66){
            private final int slot = 34;
            {
                this.slot = 34;
            }
        }));
        this.customSlots.put(35, this.addSlot((Slot)new SlotItemHandler(this.internal, 35, 151, 66){
            private final int slot = 35;
            {
                this.slot = 35;
            }
        }));
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.addSlot(new Slot((Container)inv, sj + (si + 1) * 9, 8 + sj * 18, 95 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.addSlot(new Slot((Container)inv, si, 8 + si * 18, 153));
        }
    }

    public boolean stillValid(Player player) {
        if (this.bound) {
            if (this.boundItemMatcher != null) {
                return this.boundItemMatcher.get();
            }
            if (this.boundBlockEntity != null) {
                return AbstractContainerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)this.boundBlockEntity.getBlockState().getBlock());
            }
            if (this.boundEntity != null) {
                return this.boundEntity.isAlive();
            }
        }
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 36) {
                if (!this.moveItemStackTo(itemstack1, 36, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (!this.moveItemStackTo(itemstack1, 0, 36, false)) {
                if (index < 63 ? !this.moveItemStackTo(itemstack1, 63, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 36, 63, false)) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected boolean moveItemStackTo(ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        boolean flag = false;
        int i = p_38905_;
        if (p_38907_) {
            i = p_38906_ - 1;
        }
        if (p_38904_.isStackable()) {
            while (!p_38904_.isEmpty() && (p_38907_ ? i >= p_38905_ : i < p_38906_)) {
                ItemStack itemstack;
                Slot slot = (Slot)this.slots.get(i);
                if (slot.mayPlace(itemstack = slot.getItem()) && !itemstack.isEmpty() && ItemStack.isSameItemSameTags((ItemStack)p_38904_, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.getCount() + p_38904_.getCount();
                    if (j <= (maxSize = Math.min(slot.getMaxStackSize(), p_38904_.getMaxStackSize()))) {
                        p_38904_.setCount(0);
                        itemstack.setCount(j);
                        slot.set(itemstack);
                        flag = true;
                    } else if (itemstack.getCount() < maxSize) {
                        p_38904_.shrink(maxSize - itemstack.getCount());
                        itemstack.setCount(maxSize);
                        slot.set(itemstack);
                        flag = true;
                    }
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!p_38904_.isEmpty()) {
            i = p_38907_ ? p_38906_ - 1 : p_38905_;
            while (p_38907_ ? i >= p_38905_ : i < p_38906_) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(p_38904_)) {
                    if (p_38904_.getCount() > slot1.getMaxStackSize()) {
                        slot1.setByPlayer(p_38904_.split(slot1.getMaxStackSize()));
                    } else {
                        slot1.setByPlayer(p_38904_.split(p_38904_.getCount()));
                    }
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void removed(Player playerIn) {
        block4: {
            super.removed(playerIn);
            if (this.bound || !(playerIn instanceof ServerPlayer)) break block4;
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            if (!serverPlayer.isAlive() || serverPlayer.hasDisconnected()) {
                for (int j = 0; j < this.internal.getSlots(); ++j) {
                    playerIn.drop(this.internal.extractItem(j, this.internal.getStackInSlot(j).getCount(), false), false);
                }
            } else {
                for (int i = 0; i < this.internal.getSlots(); ++i) {
                    playerIn.getInventory().placeItemBackInInventory(this.internal.extractItem(i, this.internal.getStackInSlot(i).getCount(), false));
                }
            }
        }
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }
}

