/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.cardboardbox;

import com.mojang.logging.LogUtils;
import java.time.LocalDate;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import wallywhip.cardboardbox.compat.TOP.compatTOP;
import wallywhip.cardboardbox.init.initBlocks;
import wallywhip.cardboardbox.init.initConfigs;
import wallywhip.cardboardbox.init.initItems;
import wallywhip.cardboardbox.init.initSounds;
import wallywhip.cardboardbox.init.initTiles;

@Mod(value="cardboardbox")
public class CardboardBox {
    public static final String MOD_ID = "cardboardbox";
    public static final initConfigs CONFIGURATION = new initConfigs();
    public static final Logger LOGGER = LogUtils.getLogger();
    public static boolean isFestive = false;

    public CardboardBox() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)CardboardBox.CONFIGURATION.SERVER);
        IEventBus MOD_EVENTBUS = FMLJavaModLoadingContext.get().getModEventBus();
        MOD_EVENTBUS.addListener(this::onInterModEnqueueEvent);
        MOD_EVENTBUS.addListener(this::onCreativeModeTabEvent);
        MOD_EVENTBUS.addListener(this::onModConfigEvent);
        initItems.ITEMS.register(MOD_EVENTBUS);
        initBlocks.BLOCKS.register(MOD_EVENTBUS);
        initTiles.TILES.register(MOD_EVENTBUS);
        initSounds.SOUNDS.register(MOD_EVENTBUS);
    }

    private void onModConfigEvent(ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER && event.getConfig().getModId().equals(MOD_ID)) {
            if (((Boolean)CardboardBox.CONFIGURATION.allowFestive.get()).booleanValue()) {
                LocalDate date = LocalDate.now();
                int dd = date.getDayOfMonth();
                int mm = date.getMonthValue();
                isFestive = dd > 20 && mm == 12;
            } else {
                isFestive = false;
            }
        }
    }

    private void onCreativeModeTabEvent(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256791_) {
            event.m_246342_(new ItemStack((ItemLike)initBlocks.CRATE_BLOCK.get()));
        }
    }

    private void onInterModEnqueueEvent(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            compatTOP.register();
        }
    }
}

