/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.cardboardbox.blocks;

import io.netty.buffer.Unpooled;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.NameTagItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import wallywhip.cardboardbox.CardboardBox;
import wallywhip.cardboardbox.blocks.CrateTileEntity;
import wallywhip.cardboardbox.compat.TOP.ITOPInfoProvider;
import wallywhip.cardboardbox.init.initBlocks;
import wallywhip.cardboardbox.init.initSounds;

public class CrateBlock
extends BaseEntityBlock
implements ITOPInfoProvider {
    public static final IntegerProperty TYPE = IntegerProperty.m_61631_((String)"type", (int)0, (int)3);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final MutableComponent name = Component.m_237115_((String)"block.cardboardbox.crate");
    public static final MutableComponent festive = Component.m_237115_((String)"block.cardboardbox.festive");
    private static final int NBT_MAXIMUM = 0x100000;
    private static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), Block.m_49796_((double)1.5, (double)9.0, (double)1.5, (double)14.5, (double)13.0, (double)14.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public CrateBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_60955_().m_278166_(PushReaction.BLOCK));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TYPE, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Deprecated
    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter p_60556_, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Integer)state.m_61143_((Property)TYPE) == 0 ? Shapes.m_83144_() : SHAPE;
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, FACING});
    }

    @Deprecated
    @NotNull
    public BlockState m_6843_(BlockState state, Rotation p_48723_) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)p_48723_.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Deprecated
    @NotNull
    public BlockState m_6943_(BlockState state, Mirror p_48720_) {
        return state.m_60717_(p_48720_.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new CrateTileEntity(pos, state);
    }

    @Nonnull
    @Deprecated
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        BlockEntity tile;
        ItemStack handStack = player.m_21120_(hand);
        if (handStack.m_41720_() instanceof NameTagItem) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof CrateTileEntity) {
                CrateTileEntity crateTile = (CrateTileEntity)blockEntity;
                crateTile.setCustomName(handStack.m_41786_());
                player.m_21011_(hand, !world.f_46443_);
                if (!player.m_7500_()) {
                    handStack.m_41774_(1);
                }
            }
            return InteractionResult.PASS;
        }
        if (!player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (!CrateBlock.canReplace(world, player, pos, state)) {
            return InteractionResult.FAIL;
        }
        if (!world.f_46443_ && (tile = world.m_7702_(pos)) instanceof CrateTileEntity) {
            CrateTileEntity crateTile = (CrateTileEntity)tile;
            CompoundTag crateData = crateTile.crateData;
            if (crateData != null) {
                String ss = crateData.m_128461_("Name");
                if (ss.equals("minecraft:armor_stand")) {
                    ArmorStand stand = new ArmorStand(EntityType.f_20529_, world);
                    LocalDate date = LocalDate.now();
                    if (date.getMonthValue() == 4 && date.getDayOfMonth() == 1) {
                        crateData.m_128379_("Small", true);
                    }
                    stand.m_20258_(crateData);
                    stand.m_20035_(pos, player.m_146908_() - 180.0f, 0.0f);
                    world.m_7471_(pos, false);
                    world.m_46747_(pos);
                    world.m_7967_((Entity)stand);
                    world.m_6263_((Player)null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11684_, SoundSource.BLOCKS, 0.75f, 0.8f);
                    stand.m_146852_(GameEvent.f_157810_, (Entity)player);
                } else {
                    Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(ss));
                    if (block instanceof AirBlock) {
                        player.m_5661_((Component)Component.m_237110_((String)"tip.cardboardbox.no", (Object[])new Object[]{Component.m_237113_((String)ss).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.RED), true);
                        world.m_5594_(null, pos, SoundEvents.f_12507_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        return InteractionResult.PASS;
                    }
                    BlockState newState = NbtUtils.m_247651_((HolderGetter)world.m_246945_(Registries.f_256747_), (CompoundTag)crateData);
                    if (newState.m_61138_((Property)BlockStateProperties.f_61374_)) {
                        newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)player.m_6350_().m_122424_());
                    } else if (newState.m_61138_((Property)BlockStateProperties.f_61372_)) {
                        newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)player.m_6350_().m_122424_());
                    }
                    world.m_46597_(pos, newState);
                    tile = world.m_7702_(pos);
                    if (tile != null) {
                        crateData.m_128405_("x", pos.m_123341_());
                        crateData.m_128405_("y", pos.m_123342_());
                        crateData.m_128405_("z", pos.m_123343_());
                        tile.m_142466_(crateData);
                    }
                }
            }
            ItemStack stack = new ItemStack((ItemLike)initBlocks.CRATE_BLOCK.get());
            if (crateTile.m_8077_()) {
                stack.m_41714_(crateTile.m_7770_());
            }
            CrateBlock.m_152435_((Level)world, (BlockPos)pos, (Direction)player.m_6350_().m_122424_(), (ItemStack)stack);
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    private static boolean canReplace(Level world, Player player, BlockPos pos, BlockState state) {
        return world.m_7966_(player, pos) && !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, state, player));
    }

    public void m_6402_(Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity livingEntity, @Nonnull ItemStack itemStack) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CrateTileEntity) {
            CrateTileEntity crateTile = (CrateTileEntity)blockEntity;
            if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_("CrateData")) {
                crateTile.crateData = itemStack.m_41783_().m_128469_("CrateData");
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)TYPE, (Comparable)Integer.valueOf(itemStack.m_41783_().m_128451_("CustomModelData"))));
            }
            if (itemStack.m_41788_()) {
                crateTile.setCustomName(itemStack.m_41786_());
            }
        }
    }

    public void m_6240_(@NotNull Level world, @NotNull Player playerEntity, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable BlockEntity tileEntity, @NotNull ItemStack itemStack) {
        super.m_6240_(world, playerEntity, pos, blockState, tileEntity, itemStack);
        if (tileEntity instanceof CrateTileEntity) {
            CrateTileEntity crateTile = (CrateTileEntity)tileEntity;
            ItemStack stack = new ItemStack((ItemLike)initBlocks.CRATE_BLOCK.get());
            stack.m_41784_().m_128365_("CrateData", (Tag)crateTile.crateData);
            stack.m_41783_().m_128405_("CustomModelData", ((Integer)blockState.m_61143_((Property)TYPE)).intValue());
            if (crateTile.m_8077_()) {
                stack.m_41714_(crateTile.m_7770_());
            }
            CrateBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack);
        }
    }

    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, Player playerEntity, Level world, BlockState blockState, IProbeHitData iProbeHitData) {
        BlockEntity blockEntity = world.m_7702_(iProbeHitData.getPos());
        if (blockEntity instanceof CrateTileEntity) {
            CrateTileEntity crateTile = (CrateTileEntity)blockEntity;
            if (crateTile.crateData == null) {
                return;
            }
            if (crateTile.crateData.m_128425_("CustomName", 8)) {
                iProbeInfo.text(CompoundText.create().style(TextStyleClass.HIGHLIGHTED).text((Component)Component.Serializer.m_130701_((String)crateTile.crateData.m_128461_("CustomName"))));
            } else {
                iProbeInfo.text(CompoundText.create().style(TextStyleClass.HIGHLIGHTED).text(crateTile.crateData.m_128461_("Desc")));
            }
            String ss = crateTile.crateData.m_128461_("Name");
            if (ss.equals("minecraft:armor_stand")) {
                ItemStack stack;
                int a;
                ListTag listTag;
                if (crateTile.crateData.m_128425_("ArmorItems", 9)) {
                    listTag = crateTile.crateData.m_128437_("ArmorItems", 10);
                    for (a = 0; a < listTag.size(); ++a) {
                        stack = ItemStack.m_41712_((CompoundTag)listTag.m_128728_(a));
                        if (stack.m_41619_()) continue;
                        iProbeInfo.text((Component)stack.m_41786_().m_6881_());
                    }
                }
                if (crateTile.crateData.m_128425_("HandItems", 9)) {
                    listTag = crateTile.crateData.m_128437_("HandItems", 10);
                    for (a = 0; a < listTag.size(); ++a) {
                        stack = ItemStack.m_41712_((CompoundTag)listTag.m_128728_(a));
                        if (stack.m_41619_()) continue;
                        iProbeInfo.text((Component)stack.m_41786_().m_6881_());
                    }
                }
                return;
            }
            Block item = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(ss));
            if (item instanceof AirBlock) {
                iProbeInfo.text(CompoundText.create().style(TextStyleClass.ERROR).text((Component)Component.m_237110_((String)"tip.cardboardbox.no", (Object[])new Object[]{ss})));
                return;
            }
            if (ss.equals("minecraft:spawner")) {
                if (crateTile.crateData.m_128441_("DescM")) {
                    iProbeInfo.text(crateTile.crateData.m_128461_("DescM"));
                }
                return;
            }
            if (ss.equals("minecraft:beehive") || ss.equals("minecraft:bee_nest")) {
                ListTag listTag = crateTile.crateData.m_128437_("Bees", 10);
                iProbeInfo.text((Component)Component.m_237110_((String)"tip.bee", (Object[])new Object[]{listTag.size()}));
                iProbeInfo.text((Component)Component.m_237110_((String)"tip.bee_level", (Object[])new Object[]{crateTile.crateData.m_128469_("Properties").m_128461_("honey_level")}));
                return;
            }
            if (crateTile.crateData.m_128425_("Items", 9)) {
                if (crateTile.crateData.m_128425_("LootTable", 8)) {
                    iProbeInfo.text("???????");
                }
                ListTag listTag = crateTile.crateData.m_128437_("Items", 10);
                int count = 0;
                for (int a = 0; a < listTag.size(); ++a) {
                    ItemStack stack = ItemStack.m_41712_((CompoundTag)listTag.m_128728_(a));
                    if (stack.m_41619_() || ++count >= 6) continue;
                    MutableComponent n = stack.m_41786_().m_6881_();
                    n.m_130946_(" x").m_130946_(Integer.toString(stack.m_41613_()));
                    iProbeInfo.text((Component)n);
                }
                if (count > 5) {
                    iProbeInfo.text((Component)Component.m_237110_((String)"container.shulkerBox.more", (Object[])new Object[]{listTag.size() - count + 1}));
                }
                return;
            }
            if (ss.equals("minecraft:decorated_pot")) {
                ListTag listTag = crateTile.crateData.m_128437_("sherds", 8);
                if (!listTag.isEmpty()) {
                    listTag.forEach(t -> {
                        String id = t.m_7916_();
                        Item itm = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
                        if (itm != null) {
                            iProbeInfo.text((Component)Component.m_237115_((String)itm.m_5524_()));
                        } else {
                            iProbeInfo.text(id);
                        }
                    });
                }
                if (crateTile.crateData.m_128469_("Properties").m_128471_("cracked")) {
                    iProbeInfo.text((Component)Component.m_237115_((String)"tip.sherd_cracked"));
                }
            }
        }
    }

    public void m_5871_(@NotNull ItemStack itemStack, @Nullable BlockGetter blockReader, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        super.m_5871_(itemStack, blockReader, list, tooltipFlag);
        if (itemStack.m_41782_()) {
            CompoundTag crateData = itemStack.m_41783_().m_128469_("CrateData");
            if (crateData.m_128456_()) {
                return;
            }
            String ss = crateData.m_128461_("Name");
            if (crateData.m_128425_("CustomName", 8)) {
                list.add((Component)Component.Serializer.m_130701_((String)crateData.m_128461_("CustomName")).m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.ITALIC));
            } else {
                list.add((Component)Component.m_237113_((String)crateData.m_128461_("Desc")).m_130940_(ChatFormatting.GOLD));
            }
            if (ss.equals("minecraft:armor_stand")) {
                MutableComponent n;
                ItemStack stack;
                int a;
                ListTag listTag;
                if (crateData.m_128425_("ArmorItems", 9)) {
                    listTag = crateData.m_128437_("ArmorItems", 10);
                    for (a = 0; a < listTag.size(); ++a) {
                        stack = ItemStack.m_41712_((CompoundTag)listTag.m_128728_(a));
                        if (stack.m_41619_()) continue;
                        n = stack.m_41786_().m_6881_();
                        list.add((Component)n.m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
                    }
                }
                if (crateData.m_128425_("HandItems", 9)) {
                    listTag = crateData.m_128437_("HandItems", 10);
                    for (a = 0; a < listTag.size(); ++a) {
                        stack = ItemStack.m_41712_((CompoundTag)listTag.m_128728_(a));
                        if (stack.m_41619_()) continue;
                        n = stack.m_41786_().m_6881_();
                        list.add((Component)n.m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
                    }
                }
                return;
            }
            Block item = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(ss));
            if (item instanceof AirBlock) {
                list.add((Component)Component.m_237110_((String)"tip.cardboardbox.no", (Object[])new Object[]{Component.m_237113_((String)ss).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.RED));
                return;
            }
            if (tooltipFlag.m_7050_()) {
                int nbtLength = CrateBlock.getNBTSize(itemStack.m_41783_());
                int overflow = 0x100000 - nbtLength;
                Object extra = "";
                if (overflow != 0) {
                    extra = " (" + overflow + ")";
                }
                if (Screen.m_96638_()) {
                    list.add(1, (Component)Component.m_237110_((String)"tip.cardboardbox.nbt", (Object[])new Object[]{nbtLength + " / 1048576" + (String)extra}).m_130940_(nbtLength <= 0x100000 ? ChatFormatting.GREEN : ChatFormatting.RED));
                } else {
                    list.add(1, (Component)Component.m_237110_((String)"tip.cardboardbox.nbt", (Object[])new Object[]{nbtLength + (String)extra}).m_130940_(nbtLength <= 0x100000 ? ChatFormatting.GREEN : ChatFormatting.RED));
                }
            }
            if (ss.equals("minecraft:spawner")) {
                if (crateData.m_128441_("DescM")) {
                    list.add((Component)Component.m_237113_((String)crateData.m_128461_("DescM")).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
                }
                list.add((Component)Component.m_237110_((String)"tip.spawn_count", (Object[])new Object[]{crateData.m_128451_("SpawnCount")}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
                list.add((Component)Component.m_237110_((String)"tip.spawn_range", (Object[])new Object[]{crateData.m_128451_("SpawnRange")}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
                list.add((Component)Component.m_237110_((String)"tip.spawn_delay", (Object[])new Object[]{crateData.m_128451_("MinSpawnDelay"), crateData.m_128451_("MaxSpawnDelay")}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
                list.add((Component)Component.m_237110_((String)"tip.spawn_player", (Object[])new Object[]{crateData.m_128451_("RequiredPlayerRange")}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
                list.add((Component)Component.m_237110_((String)"tip.spawn_near", (Object[])new Object[]{crateData.m_128451_("MaxNearbyEntities")}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
                return;
            }
            if (ss.equals("minecraft:beehive") || ss.equals("minecraft:bee_nest")) {
                ListTag listTag = crateData.m_128437_("Bees", 10);
                list.add((Component)Component.m_237110_((String)"tip.bee", (Object[])new Object[]{listTag.size()}).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
                list.add((Component)Component.m_237110_((String)"tip.bee_level", (Object[])new Object[]{crateData.m_128469_("Properties").m_128461_("honey_level")}).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
                return;
            }
            if (crateData.m_128425_("Items", 9)) {
                if (crateData.m_128425_("LootTable", 8)) {
                    list.add((Component)Component.m_237113_((String)"???????"));
                }
                ListTag listTag = crateData.m_128437_("Items", 10);
                int count = 0;
                for (int a = 0; a < listTag.size(); ++a) {
                    ItemStack stack = ItemStack.m_41712_((CompoundTag)listTag.m_128728_(a));
                    if (stack.m_41619_() || ++count >= 6) continue;
                    MutableComponent n = stack.m_41786_().m_6881_();
                    n.m_130946_(" x").m_130946_(Integer.toString(stack.m_41613_()));
                    list.add((Component)n.m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
                }
                if (count > 5) {
                    list.add((Component)Component.m_237110_((String)"container.shulkerBox.more", (Object[])new Object[]{listTag.size() - count + 1}).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
                }
                return;
            }
            if (ss.equals("minecraft:decorated_pot")) {
                ListTag listTag = crateData.m_128437_("sherds", 8);
                if (!listTag.isEmpty()) {
                    listTag.forEach(t -> {
                        String id = t.m_7916_();
                        Item itm = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
                        if (itm != null) {
                            list.add((Component)Component.m_237115_((String)itm.m_5524_()).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
                        } else {
                            list.add((Component)Component.m_237113_((String)id).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
                        }
                    });
                }
                if (crateData.m_128469_("Properties").m_128471_("cracked")) {
                    list.add((Component)Component.m_237115_((String)"tip.sherd_cracked").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
                }
            }
        }
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        return (Integer)state.m_61143_((Property)TYPE) == 0 ? SoundType.f_56736_ : initSounds.SOUND_SHAKE;
    }

    @NotNull
    public MutableComponent m_49954_() {
        return CardboardBox.isFestive ? festive : name;
    }

    private static int getNBTSize(@Nullable CompoundTag nbt) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130079_(nbt);
        buffer.release();
        return buffer.writerIndex();
    }
}

