/*
 * Decompiled with CFR 0.152.
 */
package andrews.swampier_swamps.entities;

import andrews.swampier_swamps.config.SSConfigs;
import andrews.swampier_swamps.network.NetworkUtil;
import andrews.swampier_swamps.registry.SSParticles;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SwampGas
extends Entity {
    private static final EntityDataAccessor<Boolean> IS_CLOUD = SynchedEntityData.m_135353_(SwampGas.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public SwampGas(EntityType<? extends SwampGas> entityType, Level level) {
        super(entityType, level);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20069_() && !this.isCould()) {
            Vec3 vec3 = this.m_20184_();
            double deltaX = this.m_20185_() + vec3.f_82479_;
            double deltaY = this.m_20186_() + vec3.f_82480_ + 0.1;
            double deltaZ = this.m_20189_() + vec3.f_82481_;
            this.m_6034_(deltaX, deltaY, deltaZ);
            this.m_20256_(vec3);
        } else if (!this.m_20069_() && !this.isCould()) {
            this.setIsCould(true);
            this.m_6210_();
        }
        if (this.isCould()) {
            List livingEntities;
            if (this.f_19796_.m_188503_(2) == 0) {
                for (int i = 0; i < 10; ++i) {
                    double spawnX = this.m_20185_() + (double)this.f_19796_.m_188503_(7) - 3.0 + this.f_19796_.m_188500_();
                    double spawnY = this.m_20186_() + (double)this.f_19796_.m_188503_(4) + this.f_19796_.m_188500_();
                    double spawnZ = this.m_20189_() + (double)this.f_19796_.m_188503_(7) - 3.0 + this.f_19796_.m_188500_();
                    double distance = Math.sqrt((spawnY - this.m_20186_()) * (spawnY - this.m_20186_()) + (spawnX - this.m_20185_()) * (spawnX - this.m_20185_()) + (spawnZ - this.m_20189_()) * (spawnZ - this.m_20189_()));
                    if (!(distance < 3.5)) continue;
                    this.f_19853_.m_7106_((ParticleOptions)SSParticles.SWAMP_GAS.get(), spawnX, spawnY, spawnZ, 0.0, 0.0, 0.0);
                }
            }
            if (this.f_19797_ % 10 == 0 && SSConfigs.commonConfig.givesNegativeEffects.get().booleanValue() && !(livingEntities = this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_())).isEmpty()) {
                for (LivingEntity livingEntity : livingEntities) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200));
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100));
                }
            }
        }
        if (this.f_19797_ > 400) {
            this.m_146870_();
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        EntityDimensions dimensions = super.m_6972_(pose);
        return this.isCould() ? dimensions.m_20390_(20.0f, 8.0f) : dimensions;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(IS_CLOUD, (Object)false);
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128379_("IsCloud", this.isCould());
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("IsCloud")) {
            this.setIsCould(compound.m_128471_("IsCloud"));
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if ((source.m_19372_() || source.m_19360_()) && !this.m_213877_() && !this.f_19853_.f_46443_) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            NetworkUtil.createGasExplosionParticlesAtPos(this.f_19853_, new BlockPos(this.m_20182_()));
            this.f_19853_.m_46518_(null, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), (float)SSConfigs.commonConfig.explosionStrength.get().intValue(), true, Explosion.BlockInteraction.BREAK);
        }
        return super.m_6469_(source, amount);
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public boolean isCould() {
        return (Boolean)this.m_20088_().m_135370_(IS_CLOUD);
    }

    public void setIsCould(boolean value) {
        this.m_20088_().m_135381_(IS_CLOUD, (Object)value);
    }
}

