/*
 * Decompiled with CFR 0.152.
 */
package andrews.swampier_swamps.level.features;

import andrews.swampier_swamps.registry.SSBlocks;
import andrews.swampier_swamps.registry.SSTags;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DecayingKelpFeature
extends Feature<NoneFeatureConfiguration> {
    public DecayingKelpFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        boolean placed = false;
        BlockPos blockpos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        RandomSource rand = context.m_225041_();
        int featureYPos = blockpos.m_123342_();
        int placementHeight = featureYPos + 1;
        int placementDepth = featureYPos - 3;
        int radius = 4;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)blockpos.m_7918_(-radius, 0, -radius), (BlockPos)blockpos.m_7918_(radius, 0, radius))) {
            int zPos;
            int xPos = pos.m_123341_() - blockpos.m_123341_();
            int distance = xPos * xPos + (zPos = pos.m_123343_() - blockpos.m_123343_()) * zPos;
            if (distance > radius * radius) continue;
            placed |= this.placeColumn(level, rand, placementHeight, placementDepth, distance, mutablePos.m_122190_((Vec3i)pos));
        }
        return placed;
    }

    protected boolean placeColumn(WorldGenLevel level, RandomSource rand, int placementHeight, int placementDepth, int distance, BlockPos.MutableBlockPos mutableBlockPos) {
        double sqrtDist = Math.sqrt(distance);
        boolean placed = false;
        for (int height = placementHeight; height > placementDepth; --height) {
            mutableBlockPos.m_142448_(height);
            if (!level.m_7433_((BlockPos)mutableBlockPos, state -> state.m_204336_(SSTags.Blocks.DECAYING_KELP_CAN_REPLACE))) continue;
            BlockState state2 = Blocks.f_220864_.m_49966_();
            if (sqrtDist < 1.0) {
                state2 = ((Block)SSBlocks.DECAYING_KELP.get()).m_49966_();
            } else if (sqrtDist < 2.0) {
                state2 = rand.m_188503_(3) > 0 ? Blocks.f_220834_.m_49966_() : state2;
            } else if (sqrtDist < 3.1) {
                state2 = rand.m_188503_(4) == 0 ? Blocks.f_220834_.m_49966_() : state2;
            } else if (sqrtDist < 5.0) {
                for (int j = 0; j < 3; ++j) {
                    int zRimOffset;
                    int xRimOffset = rand.m_188503_(2) - rand.m_188503_(2);
                    BlockPos fadeInPos = mutableBlockPos.m_7918_(xRimOffset, 0, zRimOffset = rand.m_188503_(2) - rand.m_188503_(2));
                    BlockState stateAtRim = level.m_8055_(fadeInPos);
                    if (!stateAtRim.m_204336_(SSTags.Blocks.DECAYING_KELP_CAN_REPLACE)) continue;
                    level.m_7731_(fadeInPos, state2, 2);
                    this.m_159739_(level, fadeInPos);
                }
            }
            level.m_7731_((BlockPos)mutableBlockPos, state2, 2);
            this.m_159739_(level, (BlockPos)mutableBlockPos);
            if (level.m_8055_(mutableBlockPos.m_7494_()).m_60713_(Blocks.f_49990_) && rand.m_188503_(2) == 0) {
                int plantToPlace = rand.m_188503_(3);
                if (plantToPlace == 0) {
                    boolean bl = isTall = rand.m_188503_(3) == 0;
                    if (isTall) {
                        isTall = level.m_8055_(mutableBlockPos.m_6630_(2)).m_60713_(Blocks.f_49990_);
                    }
                    state2 = Blocks.f_50575_.m_49966_();
                    level.m_7731_(mutableBlockPos.m_7494_(), isTall ? Blocks.f_50576_.m_49966_() : state2, 2);
                    if (isTall) {
                        level.m_7731_(mutableBlockPos.m_6630_(2), state2, 2);
                    }
                    this.m_159739_(level, mutableBlockPos.m_6630_(isTall ? 2 : 1));
                } else if (plantToPlace == 1 || plantToPlace == 2) {
                    boolean bl = isTall = rand.m_188503_(3) == 0;
                    if (isTall) {
                        isTall = level.m_8055_(mutableBlockPos.m_6630_(2)).m_60713_(Blocks.f_49990_);
                    }
                    if (isTall) {
                        level.m_7731_(mutableBlockPos.m_7494_(), (BlockState)Blocks.f_50038_.m_49966_().m_61124_((Property)TallSeagrassBlock.f_154740_, (Comparable)DoubleBlockHalf.LOWER), 2);
                        level.m_7731_(mutableBlockPos.m_6630_(2), (BlockState)Blocks.f_50038_.m_49966_().m_61124_((Property)TallSeagrassBlock.f_154740_, (Comparable)DoubleBlockHalf.UPPER), 2);
                        this.m_159739_(level, mutableBlockPos.m_6630_(2));
                    } else {
                        level.m_7731_(mutableBlockPos.m_7494_(), Blocks.f_50037_.m_49966_(), 2);
                        this.m_159739_(level, mutableBlockPos.m_7494_());
                    }
                }
            }
            placed = true;
        }
        return placed;
    }
}

