/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering;

import dev.theagameplayer.puresuffering.client.sounds.InvasionMusicManager;
import dev.theagameplayer.puresuffering.config.PSConfig;
import dev.theagameplayer.puresuffering.data.InvasionTypesProvider;
import dev.theagameplayer.puresuffering.event.PSBaseEvents;
import dev.theagameplayer.puresuffering.event.PSClientEvents;
import dev.theagameplayer.puresuffering.event.PSClientSoundEvents;
import dev.theagameplayer.puresuffering.event.PSEntityEvents;
import dev.theagameplayer.puresuffering.event.PSLevelEvents;
import dev.theagameplayer.puresuffering.event.PSLivingEvents;
import dev.theagameplayer.puresuffering.event.PSPlayerEvents;
import dev.theagameplayer.puresuffering.event.PSServerEvents;
import dev.theagameplayer.puresuffering.network.PSPacketHandler;
import dev.theagameplayer.puresuffering.registries.PSActivities;
import dev.theagameplayer.puresuffering.registries.PSCommandArgumentTypes;
import dev.theagameplayer.puresuffering.registries.PSMobEffects;
import dev.theagameplayer.puresuffering.registries.PSSoundEvents;
import dev.theagameplayer.puresuffering.registries.other.PSCommands;
import dev.theagameplayer.puresuffering.registries.other.PSEntityPlacements;
import dev.theagameplayer.puresuffering.registries.other.PSGameRules;
import dev.theagameplayer.puresuffering.registries.other.PSReloadListeners;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="puresuffering")
public final class PureSufferingMod {
    public static final String MODID = "puresuffering";
    public static final String MUSICID = "puresufferingmusic";
    public static final Logger LOGGER = LogManager.getLogger((String)"puresuffering");

    public PureSufferingMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        this.registerAll(modEventBus);
        this.createRegistries(modEventBus);
        this.createConfig();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::gatherData);
        if (FMLEnvironment.dist.isClient()) {
            PureSufferingMod.attachClientEventListeners(modEventBus, MinecraftForge.EVENT_BUS);
        }
        PureSufferingMod.attachCommonEventListeners(modEventBus, MinecraftForge.EVENT_BUS);
    }

    public static final ResourceLocation namespace(String nameIn) {
        return new ResourceLocation(MODID, nameIn);
    }

    private final void createConfig() {
        PSConfig.initConfig(FMLEnvironment.dist.isClient());
        LOGGER.info("Created mod config.");
    }

    private final void createRegistries(IEventBus busIn) {
        LOGGER.info("Created custom registries.");
    }

    private final void registerAll(IEventBus busIn) {
        PSActivities.ACTIVITIES.register(busIn);
        PSCommandArgumentTypes.COMMAND_ARGUMENT_TYPES.register(busIn);
        PSMobEffects.MOB_EFFECTS.register(busIn);
        PSSoundEvents.SOUND_EVENTS.register(busIn);
        LOGGER.info("Registered all event buses.");
    }

    public static final void attachClientEventListeners(IEventBus modBusIn, IEventBus forgeBusIn) {
        modBusIn.addListener(PSClientEvents::addLayers);
        forgeBusIn.addListener(PSClientEvents::loggedIn);
        forgeBusIn.addListener(PSClientEvents::loggedOut);
        forgeBusIn.addListener(PSClientEvents::debugText);
        forgeBusIn.addListener(PSClientEvents::renderLevelStage);
        forgeBusIn.addListener(PSClientEvents::screenInitPre);
        forgeBusIn.addListener(PSClientEvents::fogColors);
        forgeBusIn.addListener(PSClientSoundEvents::playSound);
        forgeBusIn.addListener(PSClientSoundEvents::playSoundSource);
        forgeBusIn.addListener(PSClientSoundEvents::playStreamingSource);
    }

    public static final void attachCommonEventListeners(IEventBus modBusIn, IEventBus forgeBusIn) {
        modBusIn.addListener(PSEntityPlacements::registerSpawnPlacements);
        forgeBusIn.addListener(PSCommands::registerCommands);
        forgeBusIn.addListener(PSReloadListeners::addReloadListeners);
        forgeBusIn.addListener(PSBaseEvents::levelTick);
        forgeBusIn.addListener(PSEntityEvents::joinLevel);
        forgeBusIn.addListener(PSEntityEvents::mobGriefing);
        forgeBusIn.addListener(PSLivingEvents::conversionPre);
        forgeBusIn.addListener(PSLivingEvents::conversionPost);
        forgeBusIn.addListener(PSLivingEvents::livingTick);
        forgeBusIn.addListener(PSLivingEvents::experienceDrop);
        forgeBusIn.addListener(PSLivingEvents::finalizeSpawn);
        forgeBusIn.addListener(PSLivingEvents::allowDespawn);
        forgeBusIn.addListener(PSPlayerEvents::playerLoggedIn);
        forgeBusIn.addListener(PSPlayerEvents::playerRespawn);
        forgeBusIn.addListener(PSPlayerEvents::playerChangeDimension);
        forgeBusIn.addListener(PSPlayerEvents::playerSleepInBed);
        forgeBusIn.addListener(PSLevelEvents::explosionStart);
        forgeBusIn.addListener(PSServerEvents::serverStarting);
        forgeBusIn.addListener(PSServerEvents::serverStopping);
    }

    private final void commonSetup(FMLCommonSetupEvent eventIn) {
        PSPacketHandler.registerPackets();
        PSGameRules.registerGameRules();
        LOGGER.info("Finished common setup.");
    }

    private final void clientSetup(FMLClientSetupEvent eventIn) {
        InvasionMusicManager.addMusic(true);
        LOGGER.info("Finished client setup.");
    }

    private final void gatherData(GatherDataEvent eventIn) {
        DataGenerator generator = eventIn.getGenerator();
        CompletableFuture lookupProvider = eventIn.getLookupProvider();
        if (eventIn.includeServer()) {
            generator.addProvider(true, (DataProvider)new InvasionTypesProvider(generator.getPackOutput(), lookupProvider));
        }
        LOGGER.info("Generated new data.");
    }
}

