/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.client.invasion;

import dev.theagameplayer.puresuffering.client.invasion.InvasionSkyRenderInfo;
import dev.theagameplayer.puresuffering.config.PSConfigValues;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import org.apache.commons.lang3.BooleanUtils;

public final class ClientInvasion {
    private final InvasionSkyRenderInfo renderer;
    private final boolean isPrimary;
    private final int severity;
    private final int mobCap;
    private final int maxSeverity;
    private final int rarity;
    private final int tier;
    private final Component component;
    private final boolean[] ticks = new boolean[4];
    private final boolean noTick;
    private final int[] flickerDelays = new int[4];
    private final int[][] flickerCooldown = new int[4][2];
    private final float[][] flicker = new float[4][0];

    public ClientInvasion(InvasionSkyRenderInfo rendererIn, boolean isPrimaryIn, int severityIn, int mobCapIn, int maxSeverityIn, int rarityIn, int tierIn, Component componentIn) {
        this.renderer = rendererIn;
        this.isPrimary = isPrimaryIn;
        this.severity = severityIn;
        this.mobCap = mobCapIn;
        this.maxSeverity = maxSeverityIn;
        this.rarity = rarityIn;
        this.tier = tierIn;
        this.component = componentIn;
        this.ticks[0] = rendererIn.getFogRenderInfo().doesFogColorFlicker();
        this.ticks[1] = rendererIn.doesSunAndMoonVisibilityFlicker();
        this.ticks[2] = rendererIn.doesBrightnessFlicker();
        this.ticks[3] = rendererIn.doesSkyColorFlicker();
        this.noTick = !BooleanUtils.or((boolean[])this.ticks);
    }

    public final InvasionSkyRenderInfo getSkyRenderInfo() {
        return this.renderer;
    }

    public final boolean isPrimary() {
        return this.isPrimary;
    }

    public final int getSeverity() {
        return this.severity;
    }

    public final int getMobCap() {
        return this.mobCap;
    }

    public final int getMaxSeverity() {
        return this.maxSeverity;
    }

    public final int getRarity() {
        return this.rarity;
    }

    public final int getTier() {
        return this.tier;
    }

    public final Component getComponent() {
        return this.component;
    }

    public final void tick(RandomSource randomIn, long dayTimeIn) {
        if (this.noTick) {
            return;
        }
        if (PSConfigValues.client.enableSkyFlickering && dayTimeIn > 300L && dayTimeIn < 11700L) {
            float[] fRGB;
            int index;
            if (this.ticks[0] && this.flickerCooldown[3][1] < 1) {
                if (this.flickerDelays[3] < 0) {
                    index = randomIn.m_188503_(this.renderer.getFogRenderInfo().getFlickerRGBSize());
                    fRGB = this.renderer.getFogRenderInfo().getFlickerRGBOffset(index);
                    this.flickerDelays[3] = randomIn.m_216332_((int)fRGB[3], (int)fRGB[4]);
                    this.flicker[3] = new float[]{fRGB[0], fRGB[1], fRGB[2]};
                    this.flickerCooldown[3][0] = 40 + randomIn.m_188503_(61);
                    this.flickerCooldown[3][1] = this.flickerCooldown[3][0];
                } else {
                    this.flickerDelays[3] = this.flickerDelays[3] - 1;
                }
            }
            if (this.ticks[1] && this.flickerCooldown[2][1] < 1) {
                if (this.flickerDelays[2] < 0) {
                    float[] fVisibility = this.renderer.getFlickerVisibility();
                    this.flickerDelays[2] = randomIn.m_216332_((int)fVisibility[2], (int)fVisibility[3]);
                    this.flicker[2] = new float[]{fVisibility[0] + randomIn.m_188501_() * (fVisibility[1] - fVisibility[0])};
                    this.flickerCooldown[2][0] = 40 + randomIn.m_188503_(61);
                    this.flickerCooldown[2][1] = this.flickerCooldown[2][0];
                } else {
                    this.flickerDelays[2] = this.flickerDelays[2] - 1;
                }
            }
            if (this.ticks[2] && this.flickerCooldown[1][1] < 1) {
                if (this.flickerDelays[1] < 0) {
                    float[] fBrightness = this.renderer.getFlickerBrightness();
                    this.flickerDelays[1] = randomIn.m_216332_((int)fBrightness[2], (int)fBrightness[3]);
                    this.flicker[1] = new float[]{fBrightness[0] + randomIn.m_188501_() * (fBrightness[1] - fBrightness[0])};
                    this.flickerCooldown[1][0] = 40 + randomIn.m_188503_(61);
                    this.flickerCooldown[1][1] = this.flickerCooldown[1][0];
                } else {
                    this.flickerDelays[1] = this.flickerDelays[1] - 1;
                }
            }
            if (this.ticks[3] && this.flickerCooldown[0][1] < 1) {
                if (this.flickerDelays[0] < 0) {
                    index = randomIn.m_188503_(this.renderer.getFlickerRGBSize());
                    fRGB = this.renderer.getFlickerRGBOffset(index);
                    this.flickerDelays[0] = randomIn.m_216332_((int)fRGB[3], (int)fRGB[4]);
                    this.flicker[0] = new float[]{fRGB[0], fRGB[1], fRGB[2]};
                    this.flickerCooldown[0][0] = 40 + randomIn.m_188503_(61);
                    this.flickerCooldown[0][1] = this.flickerCooldown[0][0];
                } else {
                    this.flickerDelays[0] = this.flickerDelays[0] - 1;
                }
            }
        }
    }

    public final void flickerFogRGB(float[] rgbIn) {
        if (this.flicker[3].length == 0) {
            return;
        }
        rgbIn[0] = rgbIn[0] + this.flicker[3][0] / (float)this.flickerCooldown[3][0] * (float)this.flickerCooldown[3][1];
        rgbIn[1] = rgbIn[1] + this.flicker[3][1] / (float)this.flickerCooldown[3][0] * (float)this.flickerCooldown[3][1];
        rgbIn[2] = rgbIn[2] + this.flicker[3][2] / (float)this.flickerCooldown[3][0] * (float)this.flickerCooldown[3][1];
        int[] nArray = this.flickerCooldown[3];
        nArray[1] = nArray[1] - 1;
        if (this.flickerCooldown[3][1] < 1) {
            this.flicker[3] = new float[0];
        }
    }

    public final float flickerAlpha(float alphaIn) {
        if (this.flicker[2].length == 0) {
            return alphaIn;
        }
        float alpha = this.flicker[2][0] / (float)this.flickerCooldown[2][0] * (float)this.flickerCooldown[2][1];
        int[] nArray = this.flickerCooldown[2];
        nArray[1] = nArray[1] - 1;
        if (this.flickerCooldown[2][1] < 1) {
            this.flicker[2] = new float[0];
        }
        return alphaIn + alpha;
    }

    public final float flickerBrightness(float brightnessIn) {
        if (this.flicker[1].length == 0) {
            return brightnessIn;
        }
        float brightness = this.flicker[1][0] / (float)this.flickerCooldown[1][0] * (float)this.flickerCooldown[1][1];
        int[] nArray = this.flickerCooldown[1];
        nArray[1] = nArray[1] - 1;
        if (this.flickerCooldown[1][1] < 1) {
            this.flicker[1] = new float[0];
        }
        return brightnessIn - brightness;
    }

    public final void flickerSkyRGB(float[] rgbIn) {
        if (this.flicker[0].length == 0) {
            return;
        }
        rgbIn[0] = rgbIn[0] + this.flicker[0][0] / (float)this.flickerCooldown[0][0] * (float)this.flickerCooldown[0][1];
        rgbIn[1] = rgbIn[1] + this.flicker[0][1] / (float)this.flickerCooldown[0][0] * (float)this.flickerCooldown[0][1];
        rgbIn[2] = rgbIn[2] + this.flicker[0][2] / (float)this.flickerCooldown[0][0] * (float)this.flickerCooldown[0][1];
        int[] nArray = this.flickerCooldown[0];
        nArray[1] = nArray[1] - 1;
        if (this.flickerCooldown[0][1] < 1) {
            this.flicker[0] = new float[0];
        }
    }
}

