/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.client.invasion;

import dev.theagameplayer.puresuffering.client.ClientTransitionHandler;
import dev.theagameplayer.puresuffering.client.invasion.ClientInvasion;
import dev.theagameplayer.puresuffering.client.invasion.InvasionFogRenderInfo;
import dev.theagameplayer.puresuffering.client.invasion.InvasionSkyRenderInfo;
import dev.theagameplayer.puresuffering.client.renderer.ClientEffectsRenderer;
import dev.theagameplayer.puresuffering.client.renderer.InvasionSkyRenderer;
import dev.theagameplayer.puresuffering.client.sounds.InvasionMusicManager;
import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.invasion.InvasionDifficulty;
import dev.theagameplayer.puresuffering.invasion.InvasionSessionType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public final class ClientInvasionSession
implements Iterable<ClientInvasion> {
    private static final HashMap<ResourceLocation, ClientInvasionSession> CLIENT_SESSIONS = new HashMap();
    private final ArrayList<ClientInvasion> invasions = new ArrayList();
    private final InvasionSessionType sessionType;
    private final InvasionDifficulty difficulty;
    private final Style style;
    private final InvasionSkyRenderer invasionSkyRenderer;
    private final ClientEffectsRenderer clientEffectsRenderer;
    private float[][] fogRGB;
    private float[] brightness;
    private boolean brightnessUnchanged;
    private float darkness;
    private int lightLevel;
    private int startTime = 40;
    private double xpMult;

    public ClientInvasionSession(InvasionSessionType sessionTypeIn, InvasionDifficulty difficultyIn) {
        this.sessionType = sessionTypeIn;
        this.difficulty = difficultyIn;
        this.style = Style.f_131099_.m_131136_(Boolean.valueOf(difficultyIn.isHyper())).m_131155_(Boolean.valueOf(difficultyIn.isNightmare()));
        this.invasionSkyRenderer = new InvasionSkyRenderer(difficultyIn);
        this.clientEffectsRenderer = new ClientEffectsRenderer(difficultyIn);
    }

    public final ClientInvasion getPrimary() {
        return this.invasions.get(0);
    }

    public final InvasionSessionType getSessionType() {
        return this.sessionType;
    }

    public final InvasionDifficulty getDifficulty() {
        return this.difficulty;
    }

    public final Style getStyle() {
        return this.style;
    }

    public final InvasionSkyRenderer getInvasionSkyRenderer() {
        return this.invasionSkyRenderer;
    }

    public final ClientEffectsRenderer getClientEffectsRenderer() {
        return this.clientEffectsRenderer;
    }

    public final List<InvasionSkyRenderInfo> getRenderersOf(Predicate<InvasionSkyRenderInfo> ofIn) {
        return this.invasions.stream().map(ClientInvasion::getSkyRenderInfo).filter(ofIn).toList();
    }

    /*
     * WARNING - void declaration
     */
    private final void update() {
        this.invasionSkyRenderer.update(this.getPrimary().getSkyRenderInfo(), this.invasions);
        this.fogRGB = new float[2][3];
        this.brightness = new float[2];
        if (this.difficulty.isNightmare()) {
            for (int i = 0; i < 3; ++i) {
                this.fogRGB[0][i] = -1.0f;
            }
            this.brightness[0] = 1.0f;
            this.lightLevel = 15;
        } else {
            void var3_8;
            List<InvasionSkyRenderInfo> brightnessRenders;
            List<InvasionSkyRenderInfo> fogColorRenders = this.getRenderersOf(render -> render.getFogRenderInfo().isFogColorChanged());
            if (!fogColorRenders.isEmpty()) {
                for (InvasionSkyRenderInfo invasionSkyRenderInfo : fogColorRenders) {
                    InvasionFogRenderInfo fogRender = invasionSkyRenderInfo.getFogRenderInfo();
                    for (int i = 0; i < 3; ++i) {
                        float[] fArray = this.fogRGB[0];
                        int n = i;
                        fArray[n] = fArray[n] + fogRender.getRGBOffset(i) / (float)fogColorRenders.size();
                    }
                }
            }
            if (!(brightnessRenders = this.getRenderersOf(render -> render.isBrightnessChanged())).isEmpty()) {
                for (InvasionSkyRenderInfo render3 : brightnessRenders) {
                    this.brightness[0] = this.brightness[0] + render3.getBrightness() / (float)brightnessRenders.size();
                }
            }
            this.brightnessUnchanged = brightnessRenders.isEmpty();
            boolean bl = false;
            int lc = 0;
            for (ClientInvasion invasion : this.invasions) {
                int ll = invasion.getSkyRenderInfo().getLightLevel();
                if (ll < 0) continue;
                var3_8 += ll;
                ++lc;
            }
            this.lightLevel = lc > 0 ? var3_8 / lc : 0;
        }
    }

    public final void tick(ClientLevel levelIn, long dayTimeIn) {
        RandomSource random = levelIn.m_213780_();
        this.invasions.get((int)(levelIn.m_46467_() % (long)this.invasions.size())).tick(random, dayTimeIn);
        InvasionMusicManager.tickActive(this.difficulty, random, dayTimeIn);
        if (PSConfigValues.client.useSkyBoxRenderer) {
            this.invasionSkyRenderer.tick(dayTimeIn);
        }
        if (PSConfigValues.client.enableSkyEffects) {
            this.clientEffectsRenderer.tick(random, dayTimeIn, this.startTime);
        }
        this.fogRGB[1] = (float[])this.fogRGB[0].clone();
        for (ClientInvasion invasion : this.invasions) {
            invasion.flickerFogRGB(this.fogRGB[1]);
        }
        ClientTransitionHandler.getFogColor(this.fogRGB[1], dayTimeIn);
        this.brightness[1] = this.brightness[0];
        for (ClientInvasion invasion : this.invasions) {
            this.brightness[1] = invasion.flickerBrightness(this.brightness[1]);
        }
        this.brightness[1] = ClientTransitionHandler.getBrightness(this.brightness[1], dayTimeIn);
        this.darkness = ClientTransitionHandler.getLightTextureDarkness(dayTimeIn);
        if (this.startTime < 40) {
            ++this.startTime;
        }
    }

    public final float[] getFogRGB() {
        return this.fogRGB[1];
    }

    public final float getBrightness() {
        return this.brightness[1];
    }

    public final boolean isBrightnessUnchanged() {
        return this.brightnessUnchanged;
    }

    public final float getDarkness() {
        return this.darkness;
    }

    public final int getLightLevelOrDefault(int lightLevelIn) {
        return this.lightLevel > -1 ? this.lightLevel : lightLevelIn;
    }

    public final int getStartTime() {
        return this.startTime;
    }

    public final void setStartTimer() {
        this.startTime = 0;
    }

    public final double getXPMultiplier() {
        return this.xpMult;
    }

    public final void setXPMultiplier(double xpMultIn) {
        this.xpMult = xpMultIn;
    }

    public static final ClientInvasionSession get(ClientLevel levelIn) {
        return levelIn == null ? null : CLIENT_SESSIONS.get(levelIn.m_46472_().m_135782_());
    }

    public static final void add(InvasionSessionType sessionTypeIn, InvasionDifficulty difficultyIn, InvasionSkyRenderInfo rendererIn, boolean isPrimaryIn, int severityIn, int mobCapIn, int maxSeverityIn, int rarityIn, int tierIn, Component componentIn) {
        Minecraft mc = Minecraft.m_91087_();
        ResourceLocation dimId = mc.f_91073_.m_46472_().m_135782_();
        if (CLIENT_SESSIONS.containsKey(dimId) && !isPrimaryIn) {
            ClientInvasionSession session = CLIENT_SESSIONS.get(dimId);
            session.invasions.add(new ClientInvasion(rendererIn, isPrimaryIn, severityIn, mobCapIn, maxSeverityIn, rarityIn, tierIn, componentIn));
            session.update();
        } else {
            ClientInvasionSession session = new ClientInvasionSession(sessionTypeIn, difficultyIn);
            session.invasions.add(new ClientInvasion(rendererIn, isPrimaryIn, severityIn, mobCapIn, maxSeverityIn, rarityIn, tierIn, componentIn));
            session.update();
            CLIENT_SESSIONS.put(dimId, session);
        }
    }

    public static final void remove(InvasionSkyRenderInfo rendererIn) {
        Minecraft mc = Minecraft.m_91087_();
        ResourceLocation dimId = mc.f_91073_.m_46472_().m_135782_();
        ClientInvasionSession session = CLIENT_SESSIONS.get(dimId);
        if (session == null) {
            return;
        }
        session.invasions.removeIf(inv -> inv.getSkyRenderInfo().equals(rendererIn));
        if (session.invasions.isEmpty()) {
            CLIENT_SESSIONS.remove(dimId);
            return;
        }
        session.update();
    }

    public static final void clear() {
        CLIENT_SESSIONS.clear();
    }

    public final int size() {
        return this.invasions.size();
    }

    @Override
    public final Iterator<ClientInvasion> iterator() {
        return this.invasions.iterator();
    }
}

