/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.client.invasion;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public final class InvasionFogRenderInfo {
    private final ResourceLocation id;
    private final boolean[] changes;
    private final float[][] fRGB;
    private final float[] rgb;

    public InvasionFogRenderInfo(ResourceLocation idIn, boolean[] changesIn, float[][] fRGBIn, float[] rgbIn) {
        this.id = idIn;
        this.changes = changesIn;
        this.fRGB = fRGBIn;
        this.rgb = rgbIn;
    }

    public final Builder deconstruct() {
        return new Builder(this.changes, this.fRGB, this.rgb);
    }

    public final ResourceLocation getId() {
        return this.id;
    }

    public final boolean doesFogColorFlicker() {
        return this.changes[1];
    }

    public final boolean isFogColorChanged() {
        return this.changes[0];
    }

    public final float[] getFlickerRGBOffset(int indexIn) {
        return this.fRGB[indexIn];
    }

    public final int getFlickerRGBSize() {
        return this.fRGB.length;
    }

    public final float getRGBOffset(int valueIn) {
        return this.rgb[valueIn];
    }

    public final String toString() {
        return this.id.toString();
    }

    public static final class Builder {
        private boolean[] changes = new boolean[2];
        private float[][] fRGB = new float[0][5];
        private float[] rgb = new float[3];

        private Builder(boolean[] changesIn, float[][] fRGBIn, float[] rgbIn) {
            this.changes = changesIn;
            this.fRGB = fRGBIn;
            this.rgb = rgbIn;
        }

        private Builder() {
        }

        public static final Builder fogRenderer() {
            return new Builder();
        }

        public final Builder withFlickerRGB(float redIn, float greenIn, float blueIn, int minDelayIn, int maxDelayIn) {
            int l = this.fRGB.length;
            float[][] fRGB = new float[l + 1][5];
            for (int i1 = 0; i1 < l; ++i1) {
                for (int i2 = 0; i2 < 5; ++i2) {
                    fRGB[i1][i2] = this.fRGB[i1][i2];
                }
            }
            this.fRGB = fRGB;
            this.fRGB[l][0] = redIn;
            this.fRGB[l][1] = greenIn;
            this.fRGB[l][2] = blueIn;
            this.fRGB[l][3] = minDelayIn;
            this.fRGB[l][4] = maxDelayIn;
            this.changes[1] = true;
            return this;
        }

        public final Builder withRGB(float redIn, float greenIn, float blueIn) {
            this.rgb[0] = redIn;
            this.rgb[1] = greenIn;
            this.rgb[2] = blueIn;
            this.changes[0] = true;
            return this;
        }

        public final InvasionFogRenderInfo build(ResourceLocation idIn) {
            return new InvasionFogRenderInfo(idIn, this.changes, this.fRGB, this.rgb);
        }

        public final JsonObject serializeToJson() {
            JsonObject jsonObject = new JsonObject();
            if (this.changes[1]) {
                JsonArray a1 = new JsonArray();
                for (int i = 0; i < this.fRGB.length; ++i) {
                    JsonArray a2 = new JsonArray();
                    a2.add((Number)Float.valueOf(this.fRGB[i][0]));
                    a2.add((Number)Float.valueOf(this.fRGB[i][1]));
                    a2.add((Number)Float.valueOf(this.fRGB[i][2]));
                    a2.add((Number)Float.valueOf(this.fRGB[i][3]));
                    a2.add((Number)Float.valueOf(this.fRGB[i][4]));
                    a1.add((JsonElement)a2);
                }
                jsonObject.add("FlickerRGBOffset", (JsonElement)a1);
            }
            if (this.changes[0]) {
                JsonArray a = new JsonArray();
                a.add((Number)Float.valueOf(this.rgb[0]));
                a.add((Number)Float.valueOf(this.rgb[1]));
                a.add((Number)Float.valueOf(this.rgb[2]));
                jsonObject.add("RGBOffset", (JsonElement)a);
            }
            return jsonObject.entrySet().isEmpty() ? null : jsonObject;
        }

        public static final Builder fromJson(JsonObject jsonObjectIn) {
            boolean[] changes = new boolean[]{jsonObjectIn.has("RGBOffset"), jsonObjectIn.has("FlickerRGBOffset")};
            JsonElement fRGBElement = changes[1] ? jsonObjectIn.get("FlickerRGBOffset") : null;
            float[][] fRGB = new float[0][5];
            if (fRGBElement != null && fRGBElement.isJsonArray() && !fRGBElement.getAsJsonArray().isEmpty()) {
                JsonArray a1 = fRGBElement.getAsJsonArray();
                fRGB = new float[a1.size()][5];
                for (int i = 0; i < a1.size(); ++i) {
                    JsonElement e = a1.get(i);
                    if (!e.isJsonArray() || e.getAsJsonArray().isEmpty()) continue;
                    JsonArray a2 = e.getAsJsonArray();
                    fRGB[i][0] = a2.get(0).getAsFloat();
                    fRGB[i][1] = a2.get(1).getAsFloat();
                    fRGB[i][2] = a2.get(2).getAsFloat();
                    fRGB[i][3] = a2.get(3).getAsFloat();
                    fRGB[i][4] = a2.get(4).getAsFloat();
                }
            }
            JsonElement rgbElement = changes[0] ? jsonObjectIn.get("RGBOffset") : null;
            float[] rgb = new float[3];
            if (rgbElement != null && rgbElement.isJsonArray() && !rgbElement.getAsJsonArray().isEmpty()) {
                JsonArray a = rgbElement.getAsJsonArray();
                rgb[0] = a.get(0).getAsFloat();
                rgb[1] = a.get(1).getAsFloat();
                rgb[2] = a.get(2).getAsFloat();
            }
            return new Builder(changes, fRGB, rgb);
        }

        public final void serializeToNetwork(FriendlyByteBuf bufIn) {
            bufIn.writeBoolean(this.changes[0]);
            bufIn.writeBoolean(this.changes[1]);
            bufIn.writeInt(this.fRGB.length);
            for (int i = 0; i < this.fRGB.length; ++i) {
                bufIn.writeFloat(this.fRGB[i][0]);
                bufIn.writeFloat(this.fRGB[i][1]);
                bufIn.writeFloat(this.fRGB[i][2]);
                bufIn.writeFloat(this.fRGB[i][3]);
                bufIn.writeFloat(this.fRGB[i][4]);
            }
            bufIn.writeFloat(this.rgb[0]);
            bufIn.writeFloat(this.rgb[1]);
            bufIn.writeFloat(this.rgb[2]);
        }

        public static final Builder fromNetwork(FriendlyByteBuf bufIn) {
            boolean[] changes = new boolean[]{bufIn.readBoolean(), bufIn.readBoolean()};
            float[][] fRGB = new float[bufIn.readInt()][5];
            for (int i = 0; i < fRGB.length; ++i) {
                fRGB[i][0] = bufIn.readFloat();
                fRGB[i][1] = bufIn.readFloat();
                fRGB[i][2] = bufIn.readFloat();
                fRGB[i][3] = bufIn.readFloat();
                fRGB[i][4] = bufIn.readFloat();
            }
            float[] rgb = new float[]{bufIn.readFloat(), bufIn.readFloat(), bufIn.readFloat()};
            return new Builder(changes, fRGB, rgb);
        }
    }
}

