/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.client.invasion;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.theagameplayer.puresuffering.client.invasion.InvasionFogRenderInfo;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public final class InvasionSkyRenderInfo {
    private final ResourceLocation id;
    private final InvasionFogRenderInfo fogRenderer;
    private final float sunMoonAlpha;
    private final ResourceLocation sun;
    private final ResourceLocation moon;
    private final ResourceLocation fixedSky;
    private final boolean[] changes;
    private final float[] fVisibility;
    private final float[] fBrightness;
    private final float[][] fRGB;
    private final float weatherVisibility;
    private final float brightness;
    private final int lightLevel;
    private final float[] rgb;

    public InvasionSkyRenderInfo(ResourceLocation idIn, InvasionFogRenderInfo fogRendererIn, float sunMoonAlphaIn, ResourceLocation sunIn, ResourceLocation moonIn, ResourceLocation fixedSkyIn, boolean[] changesIn, float[] fVisibilityIn, float[] fBrightnessIn, float[][] fRGBIn, float weatherVisibilityIn, float brightnessIn, int lightLevelIn, float[] rgbIn) {
        this.id = idIn;
        this.fogRenderer = fogRendererIn;
        this.sunMoonAlpha = sunMoonAlphaIn;
        this.sun = sunIn;
        this.moon = moonIn;
        this.fixedSky = fixedSkyIn;
        this.changes = changesIn;
        this.fVisibility = fVisibilityIn;
        this.fBrightness = fBrightnessIn;
        this.fRGB = fRGBIn;
        this.weatherVisibility = weatherVisibilityIn;
        this.brightness = brightnessIn;
        this.lightLevel = lightLevelIn;
        this.rgb = rgbIn;
    }

    public final Builder deconstruct() {
        return new Builder(this.fogRenderer.deconstruct(), this.sunMoonAlpha, this.sun, this.moon, this.fixedSky, this.changes, this.fVisibility, this.fBrightness, this.fRGB, this.weatherVisibility, this.brightness, this.lightLevel, this.rgb);
    }

    public final ResourceLocation getId() {
        return this.id;
    }

    public final InvasionFogRenderInfo getFogRenderInfo() {
        return this.fogRenderer;
    }

    public final float getSunMoonAlpha() {
        return this.sunMoonAlpha;
    }

    public final ResourceLocation getSunTexture() {
        return this.sun;
    }

    public final ResourceLocation getMoonTexture() {
        return this.moon;
    }

    public final ResourceLocation getFixedSkyTexture() {
        return this.fixedSky;
    }

    public final boolean isSunMoonAlphaChanged() {
        return this.changes[6];
    }

    public final boolean doesSunAndMoonVisibilityFlicker() {
        return this.changes[5];
    }

    public final boolean doesBrightnessFlicker() {
        return this.changes[4];
    }

    public final boolean doesSkyColorFlicker() {
        return this.changes[3];
    }

    public final boolean isWeatherVisibilityChanged() {
        return this.changes[2];
    }

    public final boolean isBrightnessChanged() {
        return this.changes[1];
    }

    public final boolean isSkyColorChanged() {
        return this.changes[0];
    }

    public final float[] getFlickerVisibility() {
        return this.fVisibility;
    }

    public final float[] getFlickerBrightness() {
        return this.fBrightness;
    }

    public final float[] getFlickerRGBOffset(int indexIn) {
        return this.fRGB[indexIn];
    }

    public final int getFlickerRGBSize() {
        return this.fRGB.length;
    }

    public final float getWeatherVisibility() {
        return this.weatherVisibility;
    }

    public final float getBrightness() {
        return this.brightness;
    }

    public final int getLightLevel() {
        return this.lightLevel;
    }

    public final float getRGBOffset(int valueIn) {
        return this.rgb[valueIn];
    }

    public final boolean equals(Object objIn) {
        return this.id.toString().equals(objIn.toString());
    }

    public final String toString() {
        return this.id.toString();
    }

    public static final class Builder {
        private InvasionFogRenderInfo.Builder fogRenderer = InvasionFogRenderInfo.Builder.fogRenderer();
        private float sunMoonAlpha = 1.0f;
        private ResourceLocation sun;
        private ResourceLocation moon;
        private ResourceLocation fixedSky;
        private boolean[] changes = new boolean[7];
        private float[] fVisibility = new float[4];
        private float[] fBrightness = new float[4];
        private float[][] fRGB = new float[0][5];
        private float weatherVisibility = 0.0f;
        private float brightness = 1.0f;
        private int lightLevel = -1;
        private float[] rgb = new float[3];

        private Builder(InvasionFogRenderInfo.Builder fogRendererIn, float sunMoonAlphaIn, @Nullable ResourceLocation sunIn, @Nullable ResourceLocation moonIn, @Nullable ResourceLocation fixedSkyIn, boolean[] changesIn, float[] fVisibilityIn, float[] fBrightnessIn, float[][] fRGBIn, float weatherVisibilityIn, float brightnessIn, int lightLevelIn, float[] rgbIn) {
            this.fogRenderer = fogRendererIn;
            this.sunMoonAlpha = sunMoonAlphaIn;
            this.sun = sunIn;
            this.moon = moonIn;
            this.fixedSky = fixedSkyIn;
            this.changes = changesIn;
            this.fVisibility = fVisibilityIn;
            this.fBrightness = fBrightnessIn;
            this.fRGB = fRGBIn;
            this.weatherVisibility = weatherVisibilityIn;
            this.brightness = brightnessIn;
            this.lightLevel = lightLevelIn;
            this.rgb = rgbIn;
        }

        private Builder() {
        }

        public static final Builder skyRenderInfo() {
            return new Builder();
        }

        public final Builder withFog(InvasionFogRenderInfo.Builder fogRendererIn) {
            this.fogRenderer = fogRendererIn;
            return this;
        }

        public final Builder withSunMoonAlpha(float sunMoonAlphaIn) {
            this.sunMoonAlpha = sunMoonAlphaIn;
            this.changes[6] = true;
            return this;
        }

        public final Builder sunTexture(ResourceLocation sunTextureIn) {
            this.sun = sunTextureIn;
            return this;
        }

        public final Builder moonTexture(ResourceLocation moonTextureIn) {
            this.moon = moonTextureIn;
            return this;
        }

        public final Builder fixedSkyTexture(ResourceLocation fixedTextureIn) {
            this.fixedSky = fixedTextureIn;
            return this;
        }

        public final Builder withFlickerVisibility(float minVisibilityIn, float maxVisibilityIn, int minDelayIn, int maxDelayIn) {
            this.fVisibility[0] = minVisibilityIn;
            this.fVisibility[1] = maxVisibilityIn;
            this.fVisibility[2] = minDelayIn;
            this.fVisibility[3] = maxDelayIn;
            this.changes[5] = true;
            return this;
        }

        public final Builder withFlickerBrightness(float minBrightnessIn, float maxBrightnessIn, int minDelayIn, int maxDelayIn) {
            this.fBrightness[0] = minBrightnessIn;
            this.fBrightness[1] = maxBrightnessIn;
            this.fBrightness[2] = minDelayIn;
            this.fBrightness[3] = maxDelayIn;
            this.changes[4] = true;
            return this;
        }

        public final Builder withFlickerRGB(float redIn, float greenIn, float blueIn, int minDelayIn, int maxDelayIn) {
            int l = this.fRGB.length;
            float[][] fRGB = new float[l + 1][5];
            for (int i1 = 0; i1 < l; ++i1) {
                for (int i2 = 0; i2 < 5; ++i2) {
                    fRGB[i1][i2] = this.fRGB[i1][i2];
                }
            }
            this.fRGB = fRGB;
            this.fRGB[l][0] = redIn;
            this.fRGB[l][1] = greenIn;
            this.fRGB[l][2] = blueIn;
            this.fRGB[l][3] = minDelayIn;
            this.fRGB[l][4] = maxDelayIn;
            this.changes[3] = true;
            return this;
        }

        public final Builder weatherVisibility(float weatherVisibilityIn) {
            this.weatherVisibility = weatherVisibilityIn;
            this.changes[2] = true;
            return this;
        }

        public final Builder withSkyBrightness(float brightnessIn) {
            this.brightness = brightnessIn;
            this.changes[1] = true;
            return this;
        }

        public final Builder withLightLevel(int lightLevelIn) {
            this.lightLevel = lightLevelIn;
            return this;
        }

        public final Builder withRGB(float redIn, float greenIn, float blueIn) {
            this.rgb[0] = redIn;
            this.rgb[1] = greenIn;
            this.rgb[2] = blueIn;
            this.changes[0] = true;
            return this;
        }

        public final InvasionSkyRenderInfo build(ResourceLocation idIn) {
            return new InvasionSkyRenderInfo(idIn, this.fogRenderer.build(idIn), this.sunMoonAlpha, this.sun, this.moon, this.fixedSky, this.changes, this.fVisibility, this.fBrightness, this.fRGB, this.weatherVisibility, this.brightness, this.lightLevel, this.rgb);
        }

        public final JsonObject serializeToJson() {
            JsonArray a;
            JsonObject jsonObject = new JsonObject();
            JsonObject fogRendererObject = this.fogRenderer.serializeToJson();
            if (fogRendererObject != null) {
                jsonObject.add("FogRenderInfo", (JsonElement)fogRendererObject);
            }
            if (this.sunMoonAlpha < 1.0f && this.changes[6]) {
                jsonObject.addProperty("SunMoonAlpha", (Number)Float.valueOf(this.sunMoonAlpha));
            }
            if (this.sun != null && this.sunMoonAlpha > 0.0f) {
                jsonObject.addProperty("SunTexture", this.sun.toString());
            }
            if (this.moon != null && this.sunMoonAlpha > 0.0f) {
                jsonObject.addProperty("MoonTexture", this.moon.toString());
            }
            if (this.fixedSky != null) {
                jsonObject.addProperty("FixedSkyTexture", this.fixedSky.toString());
            }
            if (this.changes[5]) {
                a = new JsonArray();
                a.add((Number)Float.valueOf(this.fVisibility[0]));
                a.add((Number)Float.valueOf(this.fVisibility[1]));
                a.add((Number)Float.valueOf(this.fVisibility[2]));
                a.add((Number)Float.valueOf(this.fVisibility[3]));
                jsonObject.add("FlickerVisibility", (JsonElement)a);
            }
            if (this.changes[4]) {
                a = new JsonArray();
                a.add((Number)Float.valueOf(this.fBrightness[0]));
                a.add((Number)Float.valueOf(this.fBrightness[1]));
                a.add((Number)Float.valueOf(this.fBrightness[2]));
                a.add((Number)Float.valueOf(this.fBrightness[3]));
                jsonObject.add("FlickerBrightness", (JsonElement)a);
            }
            if (this.changes[3]) {
                JsonArray a1 = new JsonArray();
                for (int i = 0; i < this.fRGB.length; ++i) {
                    JsonArray a2 = new JsonArray();
                    a2.add((Number)Float.valueOf(this.fRGB[i][0]));
                    a2.add((Number)Float.valueOf(this.fRGB[i][1]));
                    a2.add((Number)Float.valueOf(this.fRGB[i][2]));
                    a2.add((Number)Float.valueOf(this.fRGB[i][3]));
                    a2.add((Number)Float.valueOf(this.fRGB[i][4]));
                    a1.add((JsonElement)a2);
                }
                jsonObject.add("FlickerRGBOffset", (JsonElement)a1);
            }
            if ((this.sun != null || this.moon != null || this.fixedSky != null) && this.sunMoonAlpha > 0.0f && this.changes[2]) {
                jsonObject.addProperty("WeatherVisibility", (Number)Float.valueOf(this.weatherVisibility));
            }
            if (this.changes[1]) {
                jsonObject.addProperty("Brightness", (Number)Float.valueOf(this.brightness));
            }
            if (this.lightLevel > -1) {
                jsonObject.addProperty("LightLevel", (Number)this.lightLevel);
            }
            if (this.changes[0]) {
                a = new JsonArray();
                a.add((Number)Float.valueOf(this.rgb[0]));
                a.add((Number)Float.valueOf(this.rgb[1]));
                a.add((Number)Float.valueOf(this.rgb[2]));
                jsonObject.add("RGBOffset", (JsonElement)a);
            }
            return jsonObject.entrySet().isEmpty() ? null : jsonObject;
        }

        public static final Builder fromJson(JsonObject jsonObjectIn) {
            InvasionFogRenderInfo.Builder fogRenderer = jsonObjectIn.has("FogRenderInfo") ? InvasionFogRenderInfo.Builder.fromJson(jsonObjectIn.get("FogRenderInfo").getAsJsonObject()) : InvasionFogRenderInfo.Builder.fogRenderer();
            boolean[] changes = new boolean[]{jsonObjectIn.has("RGBOffset"), jsonObjectIn.has("Brightness"), jsonObjectIn.has("WeatherVisibility"), jsonObjectIn.has("FlickerRGBOffset"), jsonObjectIn.has("FlickerBrightness"), jsonObjectIn.has("FlickerVisibility"), jsonObjectIn.has("SunMoonAlpha")};
            float sunMoonAlpha = changes[6] ? jsonObjectIn.get("SunMoonAlpha").getAsFloat() : 1.0f;
            ResourceLocation sun = sunMoonAlpha > 0.0f && jsonObjectIn.has("SunTexture") ? ResourceLocation.m_135820_((String)jsonObjectIn.get("SunTexture").getAsString()) : null;
            ResourceLocation moon = sunMoonAlpha > 0.0f && jsonObjectIn.has("MoonTexture") ? ResourceLocation.m_135820_((String)jsonObjectIn.get("MoonTexture").getAsString()) : null;
            ResourceLocation fixedSky = jsonObjectIn.has("FixedSkyTexture") ? ResourceLocation.m_135820_((String)jsonObjectIn.get("FixedSkyTexture").getAsString()) : null;
            JsonElement fVisibilityElement = changes[5] ? jsonObjectIn.get("FlickerVisibility") : null;
            float[] fVisibility = new float[4];
            if (fVisibilityElement != null && fVisibilityElement.isJsonArray() && !fVisibilityElement.getAsJsonArray().isEmpty()) {
                JsonArray a = fVisibilityElement.getAsJsonArray();
                fVisibility[0] = a.get(0).getAsFloat();
                fVisibility[1] = a.get(1).getAsFloat();
                fVisibility[2] = a.get(2).getAsFloat();
                fVisibility[3] = a.get(3).getAsFloat();
            }
            JsonElement fBrightnessElement = changes[4] ? jsonObjectIn.get("FlickerBrightness") : null;
            float[] fBrightness = new float[4];
            if (fBrightnessElement != null && fBrightnessElement.isJsonArray() && !fBrightnessElement.getAsJsonArray().isEmpty()) {
                JsonArray a = fBrightnessElement.getAsJsonArray();
                fBrightness[0] = a.get(0).getAsFloat();
                fBrightness[1] = a.get(1).getAsFloat();
                fBrightness[2] = a.get(2).getAsFloat();
                fBrightness[3] = a.get(3).getAsFloat();
            }
            JsonElement fRGBElement = changes[3] ? jsonObjectIn.get("FlickerRGBOffset") : null;
            float[][] fRGB = new float[0][5];
            if (fRGBElement != null && fRGBElement.isJsonArray() && !fRGBElement.getAsJsonArray().isEmpty()) {
                JsonArray a1 = fRGBElement.getAsJsonArray();
                fRGB = new float[a1.size()][5];
                for (int i = 0; i < a1.size(); ++i) {
                    JsonElement e = a1.get(i);
                    if (!e.isJsonArray() || e.getAsJsonArray().isEmpty()) continue;
                    JsonArray a2 = e.getAsJsonArray();
                    fRGB[i][0] = a2.get(0).getAsFloat();
                    fRGB[i][1] = a2.get(1).getAsFloat();
                    fRGB[i][2] = a2.get(2).getAsFloat();
                    fRGB[i][3] = a2.get(3).getAsFloat();
                    fRGB[i][4] = a2.get(4).getAsFloat();
                }
            }
            float weatherVisibility = changes[2] ? jsonObjectIn.get("WeatherVisibility").getAsFloat() : 0.0f;
            float brightness = changes[1] ? 1.0f - jsonObjectIn.get("Brightness").getAsFloat() : 1.0f;
            int lightLevel = jsonObjectIn.has("LightLevel") ? Mth.m_14045_((int)(15 - jsonObjectIn.get("LightLevel").getAsInt()), (int)0, (int)15) : -1;
            JsonElement rgbElement = changes[0] ? jsonObjectIn.get("RGBOffset") : null;
            float[] rgb = new float[3];
            if (rgbElement != null && rgbElement.isJsonArray() && !rgbElement.getAsJsonArray().isEmpty()) {
                JsonArray a = rgbElement.getAsJsonArray();
                rgb[0] = a.get(0).getAsFloat();
                rgb[1] = a.get(1).getAsFloat();
                rgb[2] = a.get(2).getAsFloat();
            }
            return new Builder(fogRenderer, sunMoonAlpha, sun, moon, fixedSky, changes, fVisibility, fBrightness, fRGB, weatherVisibility, brightness, lightLevel, rgb);
        }

        public final void serializeToNetwork(FriendlyByteBuf bufIn) {
            this.fogRenderer.serializeToNetwork(bufIn);
            bufIn.writeBoolean(this.changes[0]);
            bufIn.writeBoolean(this.changes[1]);
            bufIn.writeBoolean(this.changes[2]);
            bufIn.writeBoolean(this.changes[3]);
            bufIn.writeBoolean(this.changes[4]);
            bufIn.writeBoolean(this.changes[5]);
            bufIn.writeBoolean(this.changes[6]);
            bufIn.writeFloat(this.sunMoonAlpha);
            if (this.sunMoonAlpha > 0.0f) {
                bufIn.writeBoolean(this.sun != null);
                if (this.sun != null) {
                    bufIn.m_130085_(this.sun);
                }
                bufIn.writeBoolean(this.moon != null);
                if (this.moon != null) {
                    bufIn.m_130085_(this.moon);
                }
            }
            bufIn.writeBoolean(this.fixedSky != null);
            if (this.fixedSky != null) {
                bufIn.m_130085_(this.fixedSky);
            }
            bufIn.writeFloat(this.fVisibility[0]);
            bufIn.writeFloat(this.fVisibility[1]);
            bufIn.writeFloat(this.fVisibility[2]);
            bufIn.writeFloat(this.fVisibility[3]);
            bufIn.writeFloat(this.fBrightness[0]);
            bufIn.writeFloat(this.fBrightness[1]);
            bufIn.writeFloat(this.fBrightness[2]);
            bufIn.writeFloat(this.fBrightness[3]);
            bufIn.writeInt(this.fRGB.length);
            for (int i = 0; i < this.fRGB.length; ++i) {
                bufIn.writeFloat(this.fRGB[i][0]);
                bufIn.writeFloat(this.fRGB[i][1]);
                bufIn.writeFloat(this.fRGB[i][2]);
                bufIn.writeFloat(this.fRGB[i][3]);
                bufIn.writeFloat(this.fRGB[i][4]);
            }
            bufIn.writeFloat(this.weatherVisibility);
            bufIn.writeFloat(this.brightness);
            bufIn.writeInt(this.lightLevel);
            bufIn.writeFloat(this.rgb[0]);
            bufIn.writeFloat(this.rgb[1]);
            bufIn.writeFloat(this.rgb[2]);
        }

        public static final Builder fromNetwork(FriendlyByteBuf bufIn) {
            InvasionFogRenderInfo.Builder fogRenderer = InvasionFogRenderInfo.Builder.fromNetwork(bufIn);
            boolean[] changes = new boolean[]{bufIn.readBoolean(), bufIn.readBoolean(), bufIn.readBoolean(), bufIn.readBoolean(), bufIn.readBoolean(), bufIn.readBoolean(), bufIn.readBoolean()};
            float sunMoonAlpha = bufIn.readFloat();
            ResourceLocation sun = null;
            ResourceLocation moon = null;
            ResourceLocation fixedSky = null;
            if (sunMoonAlpha > 0.0f) {
                if (bufIn.readBoolean()) {
                    sun = bufIn.m_130281_();
                }
                if (bufIn.readBoolean()) {
                    moon = bufIn.m_130281_();
                }
            }
            if (bufIn.readBoolean()) {
                fixedSky = bufIn.m_130281_();
            }
            float[] fVisibility = new float[]{bufIn.readFloat(), bufIn.readFloat(), bufIn.readFloat(), bufIn.readFloat()};
            float[] fBrightness = new float[]{bufIn.readFloat(), bufIn.readFloat(), bufIn.readFloat(), bufIn.readFloat()};
            float[][] fRGB = new float[bufIn.readInt()][5];
            for (int i = 0; i < fRGB.length; ++i) {
                fRGB[i][0] = bufIn.readFloat();
                fRGB[i][1] = bufIn.readFloat();
                fRGB[i][2] = bufIn.readFloat();
                fRGB[i][3] = bufIn.readFloat();
                fRGB[i][4] = bufIn.readFloat();
            }
            float weatherVisibility = bufIn.readFloat();
            float brightness = bufIn.readFloat();
            int lightLevel = bufIn.readInt();
            float[] rgb = new float[]{bufIn.readFloat(), bufIn.readFloat(), bufIn.readFloat()};
            return new Builder(fogRenderer, sunMoonAlpha, sun, moon, fixedSky, changes, fVisibility, fBrightness, fRGB, weatherVisibility, brightness, lightLevel, rgb);
        }
    }
}

