/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.theagameplayer.puresuffering.client.ClientTransitionHandler;
import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.invasion.InvasionDifficulty;
import dev.theagameplayer.puresuffering.util.PSRGB;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.dimension.DimensionType;
import org.joml.Matrix4f;

public final class ClientEffectsRenderer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("forge", "textures/white.png");
    private final ArrayList<SoundRing> soundRings = new ArrayList();
    private final ArrayList<VortexParticle> vortexParticles = new ArrayList();
    private final InvasionDifficulty difficulty;
    private final boolean canSeeSky;
    private final int[] delays = new int[2];

    public ClientEffectsRenderer(InvasionDifficulty difficultyIn) {
        Minecraft mc = Minecraft.m_91087_();
        DimensionType dimType = mc.f_91073_.m_6042_();
        this.difficulty = difficultyIn;
        this.canSeeSky = !dimType.f_63856_();
    }

    public final void tick(RandomSource randomIn, long dayTimeIn, int startTimeIn) {
        if (startTimeIn < 40 && PSConfigValues.client.enableInvasionStartEffects) {
            if (this.delays[0] < 1) {
                if (this.canSeeSky) {
                    this.soundRings.add(new SoundRing(this.difficulty, startTimeIn));
                }
                this.delays[0] = this.difficulty.getRingDelay();
            } else {
                this.delays[0] = this.delays[0] - 1;
            }
        }
        if (this.difficulty.isHyper()) {
            if (this.delays[1] < 1) {
                this.vortexParticles.add(new VortexParticle(randomIn, this.difficulty));
                this.delays[1] = PSConfigValues.client.vortexParticleDelay;
            } else {
                this.delays[1] = this.delays[1] - 1;
            }
        }
        this.soundRings.removeIf(ring -> ring.tick());
        this.vortexParticles.removeIf(particle -> particle.tick(dayTimeIn));
    }

    public final void render(PoseStack poseStackIn, float partialTicksIn) {
        Minecraft mc = Minecraft.m_91087_();
        float weatherVisibility = mc.f_91073_.m_46722_(partialTicksIn) * 0.15f;
        long dayTime = mc.f_91073_.m_46468_() % 12000L;
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.depthMask((boolean)Minecraft.m_91085_());
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShader(GameRenderer::m_172817_);
        this.soundRings.forEach(ring -> ring.render(bufferBuilder, poseStackIn, partialTicksIn));
        if (this.difficulty.isHyper()) {
            this.vortexParticles.forEach(particle -> particle.render(bufferBuilder, poseStackIn, partialTicksIn, weatherVisibility, dayTime));
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    private static final float getAlpha(float alphaOffsetIn, long dayTimeIn) {
        float alpha = alphaOffsetIn;
        if (dayTimeIn < 600L) {
            alpha = alphaOffsetIn / 600.0f * (float)(dayTimeIn + 1L);
        } else if (dayTimeIn > 11399L) {
            alpha = alphaOffsetIn / 600.0f * (float)(12000L - dayTimeIn);
        }
        return alpha;
    }

    private static final class SoundRing {
        private final float[] rgb = new float[3];
        private final float[] dist = new float[2];
        private final float[] sizeAlpha = new float[2];
        private final float[] length = new float[4];
        private int ticksAlive;

        private SoundRing(InvasionDifficulty difficultyIn, int startTimeIn) {
            PSRGB color = difficultyIn.getInterColor(40, 40 - startTimeIn);
            this.rgb[0] = color.red();
            this.rgb[1] = color.green();
            this.rgb[2] = color.blue();
            this.ticksAlive = 300;
        }

        private final boolean tick() {
            this.dist[1] = this.dist[0];
            this.dist[0] = 300 - this.ticksAlive;
            this.sizeAlpha[1] = this.sizeAlpha[0];
            this.sizeAlpha[0] = (float)this.ticksAlive / 300.0f;
            this.length[1] = this.length[0];
            this.length[0] = this.dist[0] / this.sizeAlpha[0];
            --this.ticksAlive;
            return this.ticksAlive < 1;
        }

        private final void render(BufferBuilder bufferBuilderIn, PoseStack poseStackIn, float partialTicksIn) {
            float dist1 = this.dist[1] + (this.dist[0] - this.dist[1]) * partialTicksIn;
            float dist2 = -dist1 / 3.0f;
            float sizeAlpha = this.sizeAlpha[1] + (this.sizeAlpha[0] - this.sizeAlpha[1]) * partialTicksIn;
            float length = this.length[1] + (this.length[0] - this.length[1]) * partialTicksIn;
            RenderSystem.setShaderColor((float)this.rgb[0], (float)this.rgb[1], (float)this.rgb[2], (float)sizeAlpha);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                poseStackIn.m_85836_();
                poseStackIn.m_252781_(Axis.f_252436_.m_252977_(dir.m_122435_()));
                poseStackIn.m_252880_(dist1, dist2, sizeAlpha);
                Matrix4f matrix4f = poseStackIn.m_85850_().m_252922_();
                bufferBuilderIn.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
                bufferBuilderIn.m_252986_(matrix4f, -sizeAlpha, 100.0f, -sizeAlpha * length).m_5752_();
                bufferBuilderIn.m_252986_(matrix4f, sizeAlpha, 100.0f, -sizeAlpha * length).m_5752_();
                bufferBuilderIn.m_252986_(matrix4f, sizeAlpha, 100.0f, sizeAlpha * length).m_5752_();
                bufferBuilderIn.m_252986_(matrix4f, -sizeAlpha, 100.0f, sizeAlpha * length).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilderIn.m_231175_());
                poseStackIn.m_85849_();
            }
        }
    }

    private static final class VortexParticle {
        private final float speed;
        private final float degreesStart;
        private final float degreesFinish;
        private final float maxSize;
        private final float maxAlpha;
        private final float[] rgb = new float[3];
        private final Axis[] axis = new Axis[3];
        private final float[][] rot;
        private final float scaleFactor;
        private float size;
        private float a;
        private float alpha;
        private float ticksAlive;

        private VortexParticle(RandomSource randomIn, InvasionDifficulty difficultyIn) {
            this.speed = randomIn.m_188503_(PSConfigValues.client.maxVortexParticleLifespan - PSConfigValues.client.minVortexParticleLifespan + 1) + PSConfigValues.client.minVortexParticleLifespan;
            this.degreesStart = randomIn.m_188503_(360);
            this.degreesFinish = randomIn.m_188503_(360) + 180;
            this.maxSize = randomIn.m_188501_() + 0.75f;
            this.maxAlpha = randomIn.m_188501_() * 0.5f + 0.5f;
            PSRGB color = difficultyIn.getRandomColor(randomIn);
            this.rgb[0] = color.red();
            this.rgb[1] = color.green();
            this.rgb[2] = color.blue();
            this.axis[0] = difficultyIn.isNightmare() ? Axis.f_252392_ : Axis.f_252436_;
            this.axis[1] = randomIn.m_188499_() ? Axis.f_252529_ : Axis.f_252495_;
            this.axis[2] = randomIn.m_188499_() ? Axis.f_252403_ : Axis.f_252393_;
            this.rot = new float[PSConfigValues.client.useFastEffects ? 2 : randomIn.m_188503_(3) + 3][3];
            this.scaleFactor = 1.0f / (float)(this.rot.length - 1);
            this.ticksAlive = this.speed;
        }

        private final boolean tick(long dayTimeIn) {
            float percentAlive = this.ticksAlive / this.speed;
            this.a = this.vortexValue(this.a, this.maxAlpha, dayTimeIn);
            this.alpha = ClientEffectsRenderer.getAlpha(this.a, dayTimeIn);
            for (int i = this.rot.length - 1; i > 0; --i) {
                this.rot[i][0] = this.rot[i - 1][0];
                this.rot[i][1] = this.rot[i - 1][1];
                this.rot[i][2] = this.rot[i - 1][2];
            }
            this.rot[0][0] = this.degreesStart + percentAlive * this.degreesFinish;
            this.rot[0][1] = percentAlive > 0.5f ? percentAlive * 180.0f : 180.0f - percentAlive * 180.0f;
            this.rot[0][2] = percentAlive > 0.5f ? 180.0f + percentAlive * 180.0f : 180.0f + percentAlive * 180.0f;
            this.size = this.vortexValue(this.size, this.maxSize, dayTimeIn);
            this.ticksAlive -= 1.0f;
            return this.ticksAlive < 1.0f;
        }

        private final float vortexValue(float currentIn, float maxIn, long dayTimeIn) {
            float result;
            float f = result = this.ticksAlive > this.speed / 2.0f ? maxIn / this.speed * (this.speed - this.ticksAlive) : maxIn / this.speed * this.ticksAlive;
            if (dayTimeIn < 300L) {
                return result + currentIn / 300.0f;
            }
            if (dayTimeIn > 11699L) {
                return result - currentIn / 300.0f;
            }
            return result;
        }

        private final void render(BufferBuilder bufferBuilderIn, PoseStack poseStackIn, float partialTicksIn, float weatherVisibilityIn, long dayTimeIn) {
            float alpha = this.alpha - ClientTransitionHandler.getWeatherVisibility(weatherVisibilityIn, dayTimeIn);
            int length = Minecraft.m_91405_() ? this.rot.length : 2;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            for (int i = 1; i < length; ++i) {
                float s = this.scaleFactor * (float)(this.rot.length - i);
                float size = this.size * s;
                RenderSystem.setShaderColor((float)(this.rgb[0] * s), (float)(this.rgb[1] * s), (float)(this.rgb[2] * s), (float)(alpha * s));
                poseStackIn.m_85836_();
                poseStackIn.m_252781_(this.axis[0].m_252977_(this.rot[i][0] + (this.rot[i - 1][0] - this.rot[i][0]) * partialTicksIn));
                poseStackIn.m_252781_(this.axis[1].m_252977_(this.rot[i][1] + (this.rot[i - 1][1] - this.rot[i][1]) * partialTicksIn));
                poseStackIn.m_252781_(this.axis[2].m_252977_(this.rot[i][2] + (this.rot[i - 1][2] - this.rot[i][2]) * partialTicksIn));
                Matrix4f matrix4f = poseStackIn.m_85850_().m_252922_();
                bufferBuilderIn.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
                bufferBuilderIn.m_252986_(matrix4f, -size, 100.0f, -size).m_5752_();
                bufferBuilderIn.m_252986_(matrix4f, size, 100.0f, -size).m_5752_();
                bufferBuilderIn.m_252986_(matrix4f, size, 100.0f, size).m_5752_();
                bufferBuilderIn.m_252986_(matrix4f, -size, 100.0f, size).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilderIn.m_231175_());
                poseStackIn.m_85849_();
            }
        }
    }
}

