/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.theagameplayer.puresuffering.client.ClientTransitionHandler;
import dev.theagameplayer.puresuffering.client.invasion.ClientInvasion;
import dev.theagameplayer.puresuffering.client.invasion.InvasionSkyRenderInfo;
import dev.theagameplayer.puresuffering.invasion.InvasionDifficulty;
import java.util.ArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public final class InvasionSkyRenderer {
    private static final ResourceLocation DEFAULT_SUN = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation DEFAULT_MOON = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation DEFAULT_END_SKY = new ResourceLocation("textures/environment/end_sky.png");
    private final DimensionSpecialEffects.SkyType skyType;
    private final InvasionDifficulty difficulty;
    private final boolean noTick;
    private ArrayList<ClientInvasion> invasions;
    private ResourceLocation sun;
    private ResourceLocation moon;
    private ResourceLocation sky;
    private boolean noSunOrMoon;
    private float[][] rgb;
    private float alphaOffset;
    private float weatherVisibilityOffset;
    private float alpha;
    private float weatherVisibility;

    public InvasionSkyRenderer(InvasionDifficulty difficultyIn) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        this.skyType = level.m_104583_().m_108883_();
        this.difficulty = difficultyIn;
        this.noTick = this.skyType != DimensionSpecialEffects.SkyType.NORMAL;
    }

    public final void update(InvasionSkyRenderInfo primaryInfoIn, ArrayList<ClientInvasion> invasionsIn) {
        switch (this.skyType) {
            case NONE: {
                return;
            }
            case NORMAL: {
                ArrayList<InvasionSkyRenderInfo> skyColorList = new ArrayList<InvasionSkyRenderInfo>();
                ArrayList<InvasionSkyRenderInfo> sunMoonAlphaList = new ArrayList<InvasionSkyRenderInfo>();
                ArrayList<InvasionSkyRenderInfo> weatherVisibilityList = new ArrayList<InvasionSkyRenderInfo>();
                this.sun = primaryInfoIn.getSunTexture();
                this.moon = primaryInfoIn.getMoonTexture();
                this.noSunOrMoon = false;
                for (ClientInvasion invasion : invasionsIn) {
                    InvasionSkyRenderInfo renderInfo = invasion.getSkyRenderInfo();
                    if (!this.noSunOrMoon) {
                        boolean bl = this.noSunOrMoon = renderInfo.getSunMoonAlpha() == 0.0f;
                    }
                    if (renderInfo.getSunMoonAlpha() < 1.0f && renderInfo.isSunMoonAlphaChanged()) {
                        sunMoonAlphaList.add(renderInfo);
                    }
                    if (!this.noSunOrMoon && renderInfo.isWeatherVisibilityChanged()) {
                        weatherVisibilityList.add(renderInfo);
                    }
                    if (this.difficulty.isNightmare() || !renderInfo.isSkyColorChanged()) continue;
                    skyColorList.add(renderInfo);
                }
                this.invasions = invasionsIn;
                this.rgb = new float[2][3];
                if (this.difficulty.isNightmare()) {
                    this.rgb[0][0] = -1.0f;
                    this.rgb[0][1] = -1.0f;
                    this.rgb[0][2] = -1.0f;
                } else {
                    for (InvasionSkyRenderInfo renderInfo : skyColorList) {
                        float[] fArray = this.rgb[0];
                        fArray[0] = fArray[0] + renderInfo.getRGBOffset(0) / (float)skyColorList.size();
                        float[] fArray2 = this.rgb[0];
                        fArray2[1] = fArray2[1] + renderInfo.getRGBOffset(1) / (float)skyColorList.size();
                        float[] fArray3 = this.rgb[0];
                        fArray3[2] = fArray3[2] + renderInfo.getRGBOffset(2) / (float)skyColorList.size();
                    }
                }
                float f = this.alphaOffset = sunMoonAlphaList.isEmpty() ? 1.0f : 0.0f;
                if (!this.noSunOrMoon) {
                    for (InvasionSkyRenderInfo renderInfo : sunMoonAlphaList) {
                        this.alphaOffset += renderInfo.getSunMoonAlpha() / (float)sunMoonAlphaList.size();
                    }
                }
                this.weatherVisibilityOffset = 0.0f;
                if (!this.noSunOrMoon) {
                    for (InvasionSkyRenderInfo renderInfo : weatherVisibilityList) {
                        this.weatherVisibilityOffset += renderInfo.getWeatherVisibility() / (float)weatherVisibilityList.size();
                    }
                }
            }
            case END: {
                this.sky = primaryInfoIn.getFixedSkyTexture();
                this.invasions = invasionsIn;
            }
        }
    }

    public final void tick(long dayTimeIn) {
        if (this.noTick) {
            return;
        }
        this.rgb[1] = (float[])this.rgb[0].clone();
        for (ClientInvasion invasion : this.invasions) {
            invasion.flickerSkyRGB(this.rgb[1]);
        }
        ClientTransitionHandler.getSkyColor(this.rgb[1], dayTimeIn);
        for (ClientInvasion invasion : this.invasions) {
            this.alphaOffset = invasion.flickerAlpha(this.alphaOffset);
        }
        this.alpha = ClientTransitionHandler.getSunMoonAlpha((this.sun != null || this.moon != null) && !this.noSunOrMoon, this.alphaOffset, dayTimeIn);
        this.weatherVisibility = Mth.m_14036_((float)ClientTransitionHandler.getWeatherVisibility(this.weatherVisibilityOffset, dayTimeIn), (float)0.0f, (float)1.0f);
    }

    public final boolean hasRenderedInvasionSky(PoseStack poseStackIn, Matrix4f mat4In, float partialTicksIn, Camera camIn, boolean isFoggyIn, Runnable fogTickIn) {
        fogTickIn.run();
        if (isFoggyIn) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        FogType fogType = camIn.m_167685_();
        if (fogType == FogType.POWDER_SNOW || fogType == FogType.LAVA || mc.f_91060_.m_234310_(camIn)) {
            return false;
        }
        ClientLevel level = mc.f_91073_;
        switch (this.skyType) {
            case NORMAL: {
                this.renderInvasionSky(level.m_46468_() % 12000L, poseStackIn, mat4In, partialTicksIn, fogTickIn);
                return true;
            }
            case END: {
                this.renderEndInvasionSkybox(level.m_46468_() % 12000L, poseStackIn, partialTicksIn);
                return true;
            }
        }
        return false;
    }

    private final void renderInvasionSky(long dayTimeIn, PoseStack poseStackIn, Matrix4f mat4In, float partialTicksIn, Runnable fogTickIn) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        float timeOfDay = level.m_46942_(partialTicksIn);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        FogRenderer.m_109036_();
        RenderSystem.depthMask((boolean)false);
        Vec3 color = level.m_171660_(mc.f_91063_.m_109153_().m_90583_(), partialTicksIn);
        RenderSystem.setShaderColor((float)(this.rgb[1][0] + (float)color.f_82479_), (float)(this.rgb[1][1] + (float)color.f_82480_), (float)(this.rgb[1][2] + (float)color.f_82481_), (float)1.0f);
        ShaderInstance shaderInstance = RenderSystem.getShader();
        mc.f_91060_.f_109472_.m_85921_();
        mc.f_91060_.f_109472_.m_253207_(poseStackIn.m_85850_().m_252922_(), mat4In, shaderInstance);
        VertexBuffer.m_85931_();
        RenderSystem.enableBlend();
        float[] aRGB = level.m_104583_().m_7518_(timeOfDay, partialTicksIn);
        if (aRGB != null) {
            RenderSystem.setShader(GameRenderer::m_172811_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStackIn.m_85836_();
            poseStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            float angle = Mth.m_14031_((float)level.m_46490_(partialTicksIn)) < 0.0f ? 180.0f : 0.0f;
            poseStackIn.m_252781_(Axis.f_252403_.m_252977_(angle));
            poseStackIn.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            Matrix4f matrix4f = poseStackIn.m_85850_().m_252922_();
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            bufferBuilder.m_252986_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(aRGB[0], aRGB[1], aRGB[2], aRGB[3]).m_5752_();
            for (int j = 0; j < 17; ++j) {
                float a = (float)j * ((float)Math.PI * 2) / 16.0f;
                float x = Mth.m_14031_((float)a);
                float yz = Mth.m_14089_((float)a);
                bufferBuilder.m_252986_(matrix4f, x * 120.0f, yz * 120.0f, -yz * 40.0f * aRGB[3]).m_85950_(aRGB[0], aRGB[1], aRGB[2], 0.0f).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            poseStackIn.m_85849_();
        }
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        poseStackIn.m_85836_();
        float alpha = Mth.m_14036_((float)(this.alpha - level.m_46722_(partialTicksIn)), (float)0.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha + this.weatherVisibility));
        poseStackIn.m_252781_(Axis.f_252392_.m_252977_(90.0f));
        poseStackIn.m_252781_(Axis.f_252529_.m_252977_(timeOfDay * 360.0f));
        Matrix4f matrix4f2 = poseStackIn.m_85850_().m_252922_();
        this.renderSun(bufferBuilder, matrix4f2, 30.0f, dayTimeIn);
        this.renderMoon(bufferBuilder, matrix4f2, 20.0f, dayTimeIn);
        float f10 = level.m_104811_(partialTicksIn) * alpha;
        if (f10 > 0.0f) {
            RenderSystem.setShaderColor((float)f10, (float)f10, (float)f10, (float)f10);
            FogRenderer.m_109017_();
            mc.f_91060_.f_109471_.m_85921_();
            mc.f_91060_.f_109471_.m_253207_(poseStackIn.m_85850_().m_252922_(), mat4In, GameRenderer.m_172808_());
            VertexBuffer.m_85931_();
            fogTickIn.run();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        poseStackIn.m_85849_();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double dist = mc.f_91074_.m_20299_((float)partialTicksIn).f_82480_ - level.m_6106_().m_171687_((LevelHeightAccessor)level);
        if (dist < 0.0) {
            poseStackIn.m_85836_();
            poseStackIn.m_85837_(0.0, 12.0, 0.0);
            mc.f_91060_.f_109473_.m_85921_();
            mc.f_91060_.f_109473_.m_253207_(poseStackIn.m_85850_().m_252922_(), mat4In, shaderInstance);
            VertexBuffer.m_85931_();
            poseStackIn.m_85849_();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
    }

    private final void renderSun(BufferBuilder bufferBuilderIn, Matrix4f matrix4fIn, float sizeIn, long dayTimeIn) {
        boolean flag = dayTimeIn < 300L || dayTimeIn > 11699L;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)(this.sun == null || flag ? DEFAULT_SUN : this.sun));
        bufferBuilderIn.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilderIn.m_252986_(matrix4fIn, -sizeIn, 100.0f, -sizeIn).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilderIn.m_252986_(matrix4fIn, sizeIn, 100.0f, -sizeIn).m_7421_(1.0f, 0.0f).m_5752_();
        bufferBuilderIn.m_252986_(matrix4fIn, sizeIn, 100.0f, sizeIn).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilderIn.m_252986_(matrix4fIn, -sizeIn, 100.0f, sizeIn).m_7421_(0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilderIn.m_231175_());
    }

    private final void renderMoon(BufferBuilder bufferBuilderIn, Matrix4f matrix4fIn, float sizeIn, long dayTimeIn) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        boolean flag = dayTimeIn < 300L || dayTimeIn > 11699L;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)(this.moon == null || flag ? DEFAULT_MOON : this.moon));
        int k = level.m_46941_();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f14 = (float)(l + 0) / 4.0f;
        float f15 = (float)(i1 + 0) / 2.0f;
        float f16 = (float)(l + 1) / 4.0f;
        float f17 = (float)(i1 + 1) / 2.0f;
        bufferBuilderIn.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilderIn.m_252986_(matrix4fIn, -sizeIn, -100.0f, sizeIn).m_7421_(f16, f17).m_5752_();
        bufferBuilderIn.m_252986_(matrix4fIn, sizeIn, -100.0f, sizeIn).m_7421_(f14, f17).m_5752_();
        bufferBuilderIn.m_252986_(matrix4fIn, sizeIn, -100.0f, -sizeIn).m_7421_(f14, f15).m_5752_();
        bufferBuilderIn.m_252986_(matrix4fIn, -sizeIn, -100.0f, -sizeIn).m_7421_(f16, f15).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilderIn.m_231175_());
    }

    private final void renderEndInvasionSkybox(long dayTimeIn, PoseStack poseStackIn, float partialTicksIn) {
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)(this.sky == null ? DEFAULT_END_SKY : this.sky));
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        for (int i = 0; i < 6; ++i) {
            poseStackIn.m_85836_();
            if (this.difficulty.isNightmare()) {
                poseStackIn.m_252781_(Axis.f_252529_.m_252977_((float)dayTimeIn));
                poseStackIn.m_252781_(Axis.f_252436_.m_252977_((float)dayTimeIn));
                poseStackIn.m_252781_(Axis.f_252403_.m_252977_((float)dayTimeIn));
            }
            if (i == 1) {
                poseStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            } else if (i == 2) {
                poseStackIn.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            } else if (i == 3) {
                poseStackIn.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            } else if (i == 4) {
                poseStackIn.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            } else if (i == 5) {
                poseStackIn.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
            }
            Matrix4f matrix4f = poseStackIn.m_85850_().m_252922_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bufferBuilder.m_252986_(matrix4f, -100.0f, -100.0f, -100.0f).m_7421_(0.0f, 0.0f).m_6122_(40, 40, 40, 255).m_5752_();
            bufferBuilder.m_252986_(matrix4f, -100.0f, -100.0f, 100.0f).m_7421_(0.0f, 16.0f).m_6122_(40, 40, 40, 255).m_5752_();
            bufferBuilder.m_252986_(matrix4f, 100.0f, -100.0f, 100.0f).m_7421_(16.0f, 16.0f).m_6122_(40, 40, 40, 255).m_5752_();
            bufferBuilder.m_252986_(matrix4f, 100.0f, -100.0f, -100.0f).m_7421_(16.0f, 0.0f).m_6122_(40, 40, 40, 255).m_5752_();
            tessellator.m_85914_();
            poseStackIn.m_85849_();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }
}

