/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.theagameplayer.puresuffering.PureSufferingMod;
import dev.theagameplayer.puresuffering.world.entity.PSInvasionMob;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;

public final class HyperChargeLayer<M extends Mob, EM extends EntityModel<M>>
extends RenderLayer<M, EM> {
    private static final ResourceLocation HYPER_CHARGE_LOCATION1 = PureSufferingMod.namespace("textures/entity/charged_armor1.png");
    private static final ResourceLocation HYPER_CHARGE_LOCATION2 = PureSufferingMod.namespace("textures/entity/charged_armor2.png");
    private final EM model;

    public HyperChargeLayer(MobRenderer<M, EM> rendererIn) {
        super(rendererIn);
        this.model = rendererIn.m_7200_();
    }

    public final void render(PoseStack poseStackIn, MultiBufferSource bufferIn, int packedLightIn, M mobIn, float limbSwingIn, float limbSwingAmountIn, float partialTicksIn, float ageInTicksIn, float netHeadYawIn, float headPitchIn) {
        PSInvasionMob invasionMob;
        if (mobIn instanceof PSInvasionMob && (invasionMob = (PSInvasionMob)mobIn).psGetHyperCharge() > 0) {
            EM entityModel = this.model;
            int hyperCharge = invasionMob.psGetHyperCharge();
            float tick = (float)((Mob)mobIn).f_19797_ + partialTicksIn;
            float argb = 0.2f * (float)hyperCharge;
            entityModel.m_6839_(mobIn, limbSwingIn, limbSwingAmountIn, partialTicksIn);
            this.m_117386_().m_102624_(entityModel);
            VertexConsumer vertexConsumer = bufferIn.m_6299_(RenderType.m_110436_((ResourceLocation)(hyperCharge < 4 ? HYPER_CHARGE_LOCATION1 : HYPER_CHARGE_LOCATION2), (float)Mth.m_14031_((float)(tick * 0.007854f * (float)hyperCharge)), (float)(tick * (0.01f * (float)hyperCharge) % 1.0f)));
            entityModel.m_6973_(mobIn, limbSwingIn, limbSwingAmountIn, ageInTicksIn, netHeadYawIn, headPitchIn);
            entityModel.m_7695_(poseStackIn, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, argb, argb, argb, argb);
        }
    }
}

