/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.client.sounds;

import com.mojang.blaze3d.audio.Channel;
import dev.theagameplayer.puresuffering.PureSufferingMod;
import dev.theagameplayer.puresuffering.client.gui.components.toasts.InvasionMusicToast;
import dev.theagameplayer.puresuffering.client.resources.sounds.PSMusicSoundInstance;
import dev.theagameplayer.puresuffering.invasion.InvasionDifficulty;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.client.sounds.Weighted;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.SampledFloat;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.Logger;

public final class InvasionMusicManager {
    private static final Logger LOGGER = PureSufferingMod.LOGGER;
    private static final HashMap<InvasionDifficulty, ArrayList<PSMusicInfo>> PS_MUSIC = new HashMap();
    private static PSMusicSoundInstance music;
    private static Channel channel;
    private static int mIndex;

    public static final void addMusic(boolean logIn) {
        Minecraft mc = Minecraft.m_91087_();
        SoundManager soundManager = mc.m_91106_();
        Path gamePath = FMLPaths.GAMEDIR.get();
        Path musicPath = Paths.get(gamePath.toAbsolutePath().toString(), "puresufferingmusic");
        try {
            Files.createDirectory(musicPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException exceptionIn) {
            if (logIn) {
                LOGGER.info("Music directory for puresufferingmusic already exists!");
            }
        }
        catch (IOException exceptionIn) {
            LOGGER.error("Failed to create puresufferingmusic music directory!", (Throwable)exceptionIn);
        }
        for (InvasionDifficulty difficulty : InvasionDifficulty.values()) {
            Path hyperPath;
            block9: {
                hyperPath = Paths.get(musicPath.toAbsolutePath().toString(), difficulty.toString());
                try {
                    Files.createDirectory(hyperPath, new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException exceptionIn) {
                    if (!logIn) break block9;
                    LOGGER.info("Music directory for puresufferingmusic-" + difficulty.toString() + " already exists!");
                }
                catch (IOException exceptionIn) {
                    LOGGER.error("Failed to create puresufferingmusic-" + difficulty.toString() + " music directory!", (Throwable)exceptionIn);
                    continue;
                }
            }
            ArrayList<PSMusicInfo> hyperList = new ArrayList<PSMusicInfo>();
            for (File file : new File(hyperPath.toString()).listFiles()) {
                ResourceLocation location = new ResourceLocation("puresufferingmusic", difficulty.toString() + "/" + file.getName().toLowerCase().replaceAll("\\s+", "_").replaceAll(".ogg", ""));
                Sound sound = new Sound(location.toString(), (SampledFloat)ConstantFloat.m_146458_((float)1.0f), (SampledFloat)ConstantFloat.m_146458_((float)1.0f), 1, Sound.Type.FILE, true, false, 16);
                WeighedSoundEvents soundEvent = new WeighedSoundEvents(location, "puresuffering.subtitle.music");
                if (!InvasionMusicManager.validateSoundOgg(sound, file.getName())) continue;
                soundEvent.m_120451_((Weighted)sound);
                hyperList.add(new PSMusicInfo(location, file.toPath(), file.getName().replaceAll(".ogg", "")));
                soundManager.f_120348_.put(location, soundEvent);
            }
            if (hyperList.isEmpty()) continue;
            PS_MUSIC.put(difficulty, hyperList);
        }
    }

    private static final boolean validateSoundOgg(Sound soundIn, String nameIn) {
        ResourceLocation resourceLocation = soundIn.m_119790_();
        if (!nameIn.endsWith(".ogg")) {
            LOGGER.warn("File {} is not '.ogg', cannot add it to music {}", (Object)resourceLocation, (Object)nameIn);
            return false;
        }
        return true;
    }

    public static final void reloadMusic() {
        LOGGER.info("Reloading Invasion Music!");
        InvasionMusicManager.addMusic(false);
    }

    public static final Path getMusic(ResourceLocation locIn) {
        if (PS_MUSIC.isEmpty()) {
            return null;
        }
        for (InvasionDifficulty difficulty : InvasionDifficulty.values()) {
            if (PS_MUSIC.get((Object)difficulty) == null) continue;
            for (PSMusicInfo info : PS_MUSIC.get((Object)difficulty)) {
                if (!locIn.equals((Object)info.id)) continue;
                return info.path;
            }
        }
        return null;
    }

    public static final void tickActive(InvasionDifficulty difficultyIn, RandomSource randomIn, long dayTimeIn) {
        if (PS_MUSIC.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (PS_MUSIC.containsKey((Object)difficultyIn) && mc.f_91066_.m_92147_(SoundSource.MUSIC) > 0.0f) {
            SoundManager soundManager = mc.m_91106_();
            SoundEngine soundEngine = soundManager.f_120349_;
            for (SoundInstance sound : soundEngine.f_120227_.get((Object)SoundSource.MUSIC)) {
                if (sound.m_7904_().m_135827_().equals("puresufferingmusic")) continue;
                soundEngine.m_120274_(sound);
            }
            if (music != null && soundManager.m_120403_((SoundInstance)music)) {
                if (channel == null) {
                    return;
                }
                channel.m_83666_(Math.min((float)(12000L - dayTimeIn) / 300.0f, 1.0f));
            } else if (dayTimeIn > 300L && dayTimeIn < 11700L) {
                ArrayList<PSMusicInfo> hyperList = PS_MUSIC.get((Object)difficultyIn);
                if (mIndex == -1) {
                    mIndex = randomIn.m_188503_(hyperList.size());
                }
                PSMusicInfo info = hyperList.get(mIndex %= hyperList.size());
                music = new PSMusicSoundInstance(SoundEvent.m_262824_((ResourceLocation)info.id));
                ++mIndex;
                soundManager.m_120367_((SoundInstance)music);
                mc.m_91300_().m_94922_((Toast)new InvasionMusicToast(info.name, difficultyIn));
            }
        } else {
            InvasionMusicManager.tickInactive();
        }
    }

    public static final void tickInactive() {
        if (!InvasionMusicManager.playingMusic()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91106_().m_120399_((SoundInstance)music);
        music = null;
        channel = null;
    }

    public static final boolean playingMusic() {
        return music != null && Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)music);
    }

    public static final boolean isMusic(PSMusicSoundInstance soundIn) {
        return ((Object)((Object)soundIn)).equals((Object)music);
    }

    public static final void setChannel(Channel channelIn) {
        channel = channelIn;
    }

    static {
        mIndex = -1;
    }

    private static final class PSMusicInfo {
        private final ResourceLocation id;
        private final Path path;
        private final String name;

        private PSMusicInfo(ResourceLocation idIn, Path pathIn, String nameIn) {
            this.id = idIn;
            this.path = pathIn;
            this.name = nameIn;
        }
    }
}

