/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import dev.theagameplayer.puresuffering.PureSufferingMod;
import dev.theagameplayer.puresuffering.invasion.InvasionDifficulty;
import dev.theagameplayer.puresuffering.invasion.InvasionSessionType;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.Logger;

public final class PSConfig {
    private static final Logger LOGGER = PureSufferingMod.LOGGER;
    private static final String CONFIG = "puresuffering.config.";
    protected static final CommonConfig COMMON = new CommonConfig();
    protected static final ClientConfig CLIENT = new ClientConfig();
    protected static final HashMap<ServerLevel, LevelConfig> LEVELS = new HashMap();

    public static final void initConfig(boolean isClientIn) {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path psConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "puresuffering");
        try {
            Files.createDirectory(psConfigPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException exception) {
            LOGGER.info("Config directory for puresuffering already exists!");
        }
        catch (IOException exception) {
            LOGGER.error("Failed to create puresuffering config directory!", (Throwable)exception);
        }
        PSConfig.loadConfig(PSConfig.COMMON.builder.build(), psConfigPath.resolve("puresuffering-common.toml"));
        if (isClientIn) {
            PSConfig.loadConfig(PSConfig.CLIENT.builder.build(), psConfigPath.resolve("puresuffering-client.toml"));
        }
    }

    public static final void initLevelConfig(ServerLevel levelIn) {
        String levelFileName = levelIn.m_46472_().m_135782_().m_179910_();
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path psConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "puresuffering");
        Path psLevelConfigPath = Paths.get(psConfigPath.toAbsolutePath().toString(), "dimensions");
        try {
            Files.createDirectory(psLevelConfigPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException exception) {
            if (LEVELS.isEmpty()) {
                LOGGER.info("Config directory for puresuffering dimensions already exists!");
            }
        }
        catch (IOException exception) {
            LOGGER.error("Failed to create puresuffering dimensions config directory!", (Throwable)exception);
        }
        LevelConfig config = new LevelConfig(levelIn);
        LEVELS.put(levelIn, config);
        PSConfig.loadConfig(config.builder.build(), psLevelConfigPath.resolve(levelFileName + "-level.toml"));
    }

    private static final void loadConfig(ForgeConfigSpec specIn, Path pathIn) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)pathIn).sync().autosave().preserveInsertionOrder().writingMode(WritingMode.REPLACE).build();
        configData.load();
        specIn.setConfig((CommentedConfig)configData);
    }

    public static final class CommonConfig {
        private static final String NOTE_HN_PERFORMANCE = "NOTE: May affect performance at higher numbers!";
        private static final String NOTE_REDUCE_FOR_PERFORMANCE = "NOTE: Reduce for increased performance!";
        private final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        public final ForgeConfigSpec.BooleanValue overrideGameRules;
        public final ForgeConfigSpec.BooleanValue enableHyperInvasions;
        public final ForgeConfigSpec.BooleanValue enableNightmareInvasions;
        public final ForgeConfigSpec.BooleanValue invasionAntiGrief;
        public final ForgeConfigSpec.BooleanValue consistentInvasions;
        public final ForgeConfigSpec.BooleanValue tieredInvasions;
        public final ForgeConfigSpec.BooleanValue hyperAggression;
        public final ForgeConfigSpec.BooleanValue hyperCharge;
        public final ForgeConfigSpec.BooleanValue forceInvasionSleeplessness;
        public final ForgeConfigSpec.BooleanValue useXPMultiplier;
        public final ForgeConfigSpec.BooleanValue mobsDieAtEndOfInvasions;
        public final ForgeConfigSpec.BooleanValue weakenedInvasionVexes;
        public final ForgeConfigSpec.BooleanValue enableInvasionAmbience;
        public final ForgeConfigSpec.IntValue primaryInvasionMobCap;
        public final ForgeConfigSpec.IntValue secondaryInvasionMobCap;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> invasionBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> primaryWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> overworldLikeDimensions;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> netherLikeDimensions;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> endLikeDimensions;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> hyperAggressionBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> hyperChargeBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> modBiomeBoostedBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> mobBiomeBoostedBlacklist;
        public final ForgeConfigSpec.DoubleValue naturalSpawnChance;
        public final ForgeConfigSpec.DoubleValue hyperChargeChance;
        public final ForgeConfigSpec.IntValue blessingEffectRespawnDuration;
        public final ForgeConfigSpec.IntValue blessingEffectDimensionChangeDuration;

        private CommonConfig() {
            this.builder.push("GameRules");
            this.overrideGameRules = this.builder.translation("puresuffering.config.override_game_rules").worldRestart().comment(new String[]{"This will make these config options override their game rule values.", "NOTE: Can be used to help modpack creators enforce certain settings."}).define("overrideGameRules", false);
            this.builder.push("Boolean");
            this.enableHyperInvasions = this.builder.translation("puresuffering.config.hyper_invasions").worldRestart().comment("Should hyper invasions be able to occur?").define("enableHyperInvasions", true);
            this.enableNightmareInvasions = this.builder.translation("puresuffering.config.nightmare_invasions").worldRestart().comment(new String[]{"Should nightmare invasions be able to occur?", "NOTE: Hyper invasions must be enabled."}).define("enableNightmareInvasions", true);
            this.invasionAntiGrief = this.builder.translation("puresuffering.config.invasion_anti_grief").worldRestart().comment("Will disable explosions, fire, etc... from entities spawned by invasions.").define("invasionAntiGrief", false);
            this.consistentInvasions = this.builder.translation("puresuffering.config.consistent_invasions").worldRestart().comment("Rather than the invasion occuring once in every 'rarity' days, it will instead be set to occur every 'rarity' days.").define("consistentInvasions", false);
            this.tieredInvasions = this.builder.translation("puresuffering.config.tiered_invasions").worldRestart().comment("Tiers make certain invasions only able to occur after so many days, turning this off will make the world ignore the day count when selecting invasions.").define("tieredInvasions", true);
            this.hyperAggression = this.builder.translation("puresuffering.config.hyper_aggression").worldRestart().comment("Hyper Aggression is what invasion mobs have to target the player from across the world, turning this off will make them use default targeting.").define("hyperAggression", true);
            this.hyperCharge = this.builder.translation("puresuffering.config.hyper_charge").worldRestart().comment("Hyper Charge is what the buffed mobs spawned by invasions have, turning this off will disabled these buffed mobs from spawning (This also disables Hyper invasions).").define("hyperCharge", true);
            this.forceInvasionSleeplessness = this.builder.translation("puresuffering.config.force_invasion_sleeplessness").worldRestart().comment("This determines whether players will be unable to sleep during all invasions.").define("forceInvasionSleeplessness", false);
            this.useXPMultiplier = this.builder.translation("puresuffering.config.use_xp_multiplier").worldRestart().comment("This determines whether invasion mobs should have an xp boost per kill.").define("useXPMultiplier", true);
            this.mobsDieAtEndOfInvasions = this.builder.translation("puresuffering.config.mobs_die_at_end_of_invasions").worldRestart().comment(new String[]{"Determines if invasion mobs should die when the invasions are over.", "NOTE: Can be used to reduce server lag."}).define("mobsDieAtEndOfInvasions", false);
            this.weakenedInvasionVexes = this.builder.translation("puresuffering.config.weakened_invasion_vexes").worldRestart().comment("Determines vexes in invasions have a limited lifespan.").define("weakenedInvasionVexes", true);
            this.enableInvasionAmbience = this.builder.translation("puresuffering.config.enable_invasion_ambience").worldRestart().comment("Should invasion ambient sounds be broadcasted before invasions?").define("enableInvasionAmbience", true);
            this.builder.pop();
            this.builder.push("Integer");
            this.primaryInvasionMobCap = this.builder.translation("puresuffering.config.primary_invasion_mob_cap").worldRestart().comment(new String[]{"The max amount of mobs that can spawn from Primary Invasions at once.", NOTE_REDUCE_FOR_PERFORMANCE}).defineInRange("primaryInvasionMobCap", 100, 0, Integer.MAX_VALUE);
            this.secondaryInvasionMobCap = this.builder.translation("puresuffering.config.secondary_invasion_mob_cap").worldRestart().comment(new String[]{"The max amount of mobs that can spawn from Secondary Invasions at once.", NOTE_REDUCE_FOR_PERFORMANCE}).defineInRange("secondaryInvasionMobCap", 25, 0, Integer.MAX_VALUE);
            this.builder.pop();
            this.builder.pop();
            this.builder.push("Invasions");
            this.invasionBlacklist = this.builder.translation("puresuffering.config.invasion_blacklist").worldRestart().comment(new String[]{"List of Invasions that can't occur.", "Ex: 'puresuffering:solar_eclipse', 'puresuffering:phantom_zone' (swap '' with quotation marks)"}).defineList("invasionBlacklist", List.of(), string -> string != "");
            this.primaryWhitelist = this.builder.translation("puresuffering.config.primary_whitelist").worldRestart().comment(new String[]{"List of Invasions that can be primary invasions.", "NOTE: The Invasion's Priority cannot be labeled as Secondary Only!", "Ex: 'puresuffering:solar_eclipse', 'lostcities:lostcity' (swap '' with quotation marks)"}).defineList("primaryWhitelist", List.of(), string -> string != "");
            this.overworldLikeDimensions = this.builder.translation("puresuffering.config.overworld_like_dimensions").worldRestart().comment(new String[]{"List of Dimensions that should use Overworld Invasions.", "NOTE: May not work with randomly generated dimensions! (RFTools/Mystcraft)", "Ex: 'twilightforest:twilight_forest', 'lostcities:lostcity' (swap '' with quotation marks)"}).defineList("overworldLikeDimensions", List.of(), string -> string != "");
            this.netherLikeDimensions = this.builder.translation("puresuffering.config.nether_like_dimensions").worldRestart().comment(new String[]{"List of Dimensions that should use Nether Invasions.", "NOTE: May not work with randomly generated dimensions! (RFTools/Mystcraft)", "Ex: 'twilightforest:twilight_forest', 'lostcities:lostcity' (swap '' with quotation marks)"}).defineList("netherLikeDimensions", List.of(), string -> string != "");
            this.endLikeDimensions = this.builder.translation("puresuffering.config.end_like_dimensions").worldRestart().comment(new String[]{"List of Dimensions that should use End Invasions.", "NOTE: May not work with randomly generated dimensions! (RFTools/Mystcraft)", "Ex: 'twilightforest:twilight_forest', 'lostcities:lostcity' (swap '' with quotation marks)"}).defineList("endLikeDimensions", List.of(), string -> string != "");
            this.hyperAggressionBlacklist = this.builder.translation("puresuffering.config.hyper_aggression_blacklist").worldRestart().comment("List of mobs that won't be hyper aggressive towards the player. (If setting is turned on)").defineList("hyperAggressionBlacklist", List.of("minecraft:vex"), string -> string != "");
            this.hyperChargeBlacklist = this.builder.translation("puresuffering.config.hyper_charge_blacklist").worldRestart().comment("List of mobs that can't be hyper charged. (If setting is turned on)").defineList("hyperChargeBlacklist", List.of("minecraft:vex"), string -> string != "");
            this.modBiomeBoostedBlacklist = this.builder.translation("puresuffering.config.mod_biome_boosted_blacklist").worldRestart().comment(new String[]{"List of mods that won't be allowed to have their mobs spawn in Biome Boosted Invasions.", "Ex: 'twilightforest', 'mutantbeasts'"}).defineList("modBiomeBoostedBlacklist", List.of(), string -> string != "");
            this.mobBiomeBoostedBlacklist = this.builder.translation("puresuffering.config.mob_biome_boosted_blacklist").worldRestart().comment(new String[]{"List of mobs that won't be allowed to spawn in Biome Boosted Invasions.", "Ex: 'minecraft:enderman', 'mutantbeasts:mutant_creeper'"}).defineList("mobBiomeBoostedBlacklist", List.of(), string -> string != "");
            this.naturalSpawnChance = this.builder.translation("puresuffering.config.natural_spawn_chance").worldRestart().comment(new String[]{"The chance of a naturally spawning mob has of spawning during an invasion.", NOTE_HN_PERFORMANCE}).defineInRange("naturalSpawnChance", 5.0E-4, 0.0, 1.0);
            this.hyperChargeChance = this.builder.translation("puresuffering.config.hyper_charge_chance").worldRestart().comment("The chance of an invasion mob being hyper charged.").defineInRange("hyperChargeChance", 0.2, 0.0, 1.0);
            this.blessingEffectRespawnDuration = this.builder.translation("puresuffering.config.blessing_effect_respawn_duration").worldRestart().comment("How many ticks the Blessing Effect lasts when respawning.").defineInRange("blessingEffectRespawnDuration", 400, 0, Integer.MAX_VALUE);
            this.blessingEffectDimensionChangeDuration = this.builder.translation("puresuffering.config.blessing_effect_dimension_change_duration").worldRestart().comment("How many ticks the Blessing Effect lasts when changing dimensions.").defineInRange("blessingEffectDimensionChangeDuration", 200, 0, Integer.MAX_VALUE);
            this.builder.pop();
        }
    }

    public static final class ClientConfig {
        private static final String NOTE_INCOMPATIBLE_SHADERS = "NOTE: Set false with incompatible shaders!";
        private static final String NOTE_DISABLE_SKY_EFFECTS = "NOTE: Set to 'enableSkyEffects' to false to disable.";
        private final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        public final ForgeConfigSpec.BooleanValue useSkyBoxRenderer;
        public final ForgeConfigSpec.BooleanValue canInvasionsChangeBrightness;
        public final ForgeConfigSpec.BooleanValue enableInvasionStartEffects;
        public final ForgeConfigSpec.BooleanValue enableSkyFlickering;
        public final ForgeConfigSpec.BooleanValue enableSkyEffects;
        public final ForgeConfigSpec.BooleanValue useFastEffects;
        public final ForgeConfigSpec.IntValue minVortexParticleLifespan;
        public final ForgeConfigSpec.IntValue maxVortexParticleLifespan;
        public final ForgeConfigSpec.IntValue vortexParticleDelay;
        public final ForgeConfigSpec.BooleanValue useInvasionSoundEffects;

        private ClientConfig() {
            this.builder.push("Rendering");
            this.useSkyBoxRenderer = this.builder.translation("puresuffering.config.use_sky_box_renderer").comment(new String[]{"Can render Invasions with a custom sky box renderer?", NOTE_INCOMPATIBLE_SHADERS}).define("useSkyBoxRenderer", true);
            this.canInvasionsChangeBrightness = this.builder.translation("puresuffering.config.can_invasions_change_brightness").comment(new String[]{"Can Invasions change the brightness Values?", NOTE_INCOMPATIBLE_SHADERS}).define("canInvasionsChangeBrightness", true);
            this.enableInvasionStartEffects = this.builder.translation("puresuffering.config.enable_invasion_start_effects").comment(new String[]{"Should Invasion start effects be enabled?", NOTE_INCOMPATIBLE_SHADERS}).define("enableInvasionStartEffects", true);
            this.enableSkyFlickering = this.builder.translation("puresuffering.config.enable_sky_flickering").comment(new String[]{"Should sky flickering effects be enabled?", NOTE_INCOMPATIBLE_SHADERS}).define("enableSkyFlickering", true);
            this.enableSkyEffects = this.builder.translation("puresuffering.config.enable_sky_effects").comment(new String[]{"Should Hyper Invasion sky effects be enabled?", NOTE_INCOMPATIBLE_SHADERS, "NOTE: May effect performance in hyper invasions!"}).define("enableSkyEffects", true);
            this.useFastEffects = this.builder.translation("puresuffering.config.use_fast_effects").comment(new String[]{"Should sky effects be rendered in their fast graphics mode?", NOTE_INCOMPATIBLE_SHADERS, "NOTE: This can improve performance, even when fast graphics are on."}).define("useFastEffects", false);
            this.minVortexParticleLifespan = this.builder.translation("puresuffering.config.min_vortex_particle_lifespan").comment(new String[]{"Minimum lifespan for vortex particles in Hyper Invasions.", NOTE_DISABLE_SKY_EFFECTS}).defineInRange("minVortexParticleLifespan", 30, 1, Integer.MAX_VALUE);
            this.maxVortexParticleLifespan = this.builder.translation("puresuffering.config.max_vortex_particles_lifespan").comment(new String[]{"Maximum lifespan for vortex particles in Hyper Invasions.", NOTE_DISABLE_SKY_EFFECTS}).defineInRange("maxVortexParticleLifespan", 630, 1, Integer.MAX_VALUE);
            this.vortexParticleDelay = this.builder.translation("puresuffering.config.vortex_particle_delay").comment(new String[]{"Delay value for spawning vortex particles.", "NOTE: Increasing the delay will result in less particles, increasing performance.", "NOTE: total particle = particles * 1/(value + 1)"}).defineInRange("vortexParticleDelay", 1, 0, Integer.MAX_VALUE);
            this.builder.pop();
            this.builder.push("Sound");
            this.useInvasionSoundEffects = this.builder.translation("puresuffering.config.use_invasion_sound_effects").comment("Should the sound effects signaling invasion be used?").define("useInvasionSoundEffects", true);
            this.builder.pop();
        }
    }

    public static final class LevelConfig {
        private static final int[][] DEFAULT_FIXED_RARITY = new int[][]{{12}, {12, 5}, {40}};
        private static final int[][] OVERWORLD_RARITY = new int[][]{{21, 3}, {12, 5}, {50, 30}};
        private static final int[][] NETHER_RARITY = new int[][]{{8}, {12, 5}, {40}};
        private static final int[][] END_RARITY = new int[][]{{8}, {10, 4}, {40}};
        private final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        public final ForgeConfigSpec.IntValue[] invasionSessionTypeRarity;
        public final ForgeConfigSpec.IntValue[] invasionDifficultyRarity;
        public final ForgeConfigSpec.BooleanValue[] cancelableInvasions;
        public final ForgeConfigSpec.IntValue[] cancelInvasionRarity;
        public final ForgeConfigSpec.IntValue[] maxInvasions;
        public final ForgeConfigSpec.IntValue[] tierIncreaseDelay;

        private LevelConfig(ServerLevel levelIn) {
            boolean hasFixedTime = levelIn.m_6042_().m_63967_();
            int[][] values = new int[0][0];
            values = levelIn.m_46472_().equals((Object)Level.f_46429_) ? NETHER_RARITY : (levelIn.m_46472_().equals((Object)Level.f_46430_) ? END_RARITY : (hasFixedTime ? DEFAULT_FIXED_RARITY : OVERWORLD_RARITY));
            int sessionTypeLength = hasFixedTime ? 1 : 2;
            int difficultyLength = InvasionDifficulty.values().length - 1;
            this.invasionSessionTypeRarity = new ForgeConfigSpec.IntValue[sessionTypeLength];
            this.invasionDifficultyRarity = new ForgeConfigSpec.IntValue[difficultyLength];
            this.cancelableInvasions = new ForgeConfigSpec.BooleanValue[sessionTypeLength];
            this.cancelInvasionRarity = new ForgeConfigSpec.IntValue[sessionTypeLength];
            this.maxInvasions = new ForgeConfigSpec.IntValue[sessionTypeLength];
            this.tierIncreaseDelay = new ForgeConfigSpec.IntValue[sessionTypeLength];
            for (int st = 0; st < sessionTypeLength; ++st) {
                InvasionSessionType sessionType = hasFixedTime ? InvasionSessionType.FIXED : InvasionSessionType.values()[st];
                this.invasionSessionTypeRarity[st] = this.builder.translation(PSConfig.CONFIG + sessionType + "_invasion_rarity").worldRestart().comment("How often should " + sessionType.getDefaultName() + " Invasions occur.").defineInRange(sessionType + "InvasionRarity", values[0][st], 1, Integer.MAX_VALUE);
                this.cancelableInvasions[st] = this.builder.translation("puresuffering.config.cancelable_" + sessionType + "_invasions").worldRestart().comment("Determines if " + sessionType + " invasions can be canceled.").define("cancelable" + sessionType.getDefaultName() + "Invasions", true);
                this.cancelInvasionRarity[st] = this.builder.translation(PSConfig.CONFIG + sessionType + "_cancel_invasion_rarity").worldRestart().comment(new String[]{"How often should " + sessionType + " invasions be canceled.", "NOTE: An invasion is canceled once in every 'value' fixed invasions.", "NOTE: If an invasion is set to be cancel on the same cycle as a hyper/nightmare invasion, it will not be cancled."}).defineInRange(sessionType + "CancelInvasionRarity", values[0][st] * 4, 1, Integer.MAX_VALUE);
                this.maxInvasions[st] = this.builder.translation("puresuffering.config.max_" + sessionType + "_invasions").worldRestart().comment("Max " + sessionType.getDefaultName() + " Invasions that can occur at once.").defineInRange("max" + sessionType.getDefaultName() + "Invasions", 3, 1, Integer.MAX_VALUE);
                this.tierIncreaseDelay[st] = this.builder.translation(PSConfig.CONFIG + sessionType + "_tier_increase_delay").worldRestart().comment("How many days should pass when the " + sessionType.getDefaultName() + " Invasion Tier increases.").defineInRange(sessionType + "TierIncreaseDelay", values[2][st], 1, Integer.MAX_VALUE);
            }
            for (int d = 0; d < difficultyLength; ++d) {
                InvasionDifficulty difficulty = InvasionDifficulty.values()[d + 1];
                this.invasionDifficultyRarity[d] = this.builder.translation(PSConfig.CONFIG + difficulty + "_invasion_rarity").worldRestart().comment("How often should " + difficulty.getDefaultName() + " Invasions occur.").defineInRange(difficulty + "InvasionRarity", values[1][d], 1, Integer.MAX_VALUE);
            }
        }
    }
}

