/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.config;

import dev.theagameplayer.puresuffering.config.PSConfig;
import dev.theagameplayer.puresuffering.invasion.InvasionDifficulty;
import java.util.HashMap;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.fml.loading.FMLEnvironment;

public abstract class PSConfigValues {
    public static CommonValues common;
    public static ClientValues client;
    public static final HashMap<ServerLevel, LevelValues> LEVELS;

    public static final void resyncCommon() {
        common = new CommonValues();
    }

    public static final void resyncClient() {
        if (FMLEnvironment.dist.isClient()) {
            client = new ClientValues();
        }
    }

    public static final void addLevelValues(ServerLevel levelIn) {
        LEVELS.put(levelIn, new LevelValues(levelIn));
    }

    static {
        LEVELS = new HashMap();
        common = new CommonValues();
        if (FMLEnvironment.dist.isClient()) {
            client = new ClientValues();
        }
    }

    public static final class CommonValues {
        public final boolean overrideGameRules;
        public final boolean enableHyperInvasions;
        public final boolean enableNightmareInvasions;
        public final boolean invasionAntiGrief;
        public final boolean consistentInvasions;
        public final boolean tieredInvasions;
        public final boolean hyperAggression;
        public final boolean hyperCharge;
        public final boolean forceInvasionSleeplessness;
        public final boolean useXPMultiplier;
        public final boolean mobsDieAtEndOfInvasions;
        public final boolean weakenedInvasionVexes;
        public final boolean enableInvasionAmbience;
        public final int primaryInvasionMobCap;
        public final int secondaryInvasionMobCap;
        public final List<? extends String> invasionBlacklist;
        public final List<? extends String> primaryWhitelist;
        public final List<? extends String> overworldLikeDimensions;
        public final List<? extends String> netherLikeDimensions;
        public final List<? extends String> endLikeDimensions;
        public final List<? extends String> hyperAggressionBlacklist;
        public final List<? extends String> hyperChargeBlacklist;
        public final List<? extends String> modBiomeBoostedBlacklist;
        public final List<? extends String> mobBiomeBoostedBlacklist;
        public final double naturalSpawnChance;
        public final double hyperChargeChance;
        public final int blessingEffectRespawnDuration;
        public final int blessingEffectDimensionChangeDuration;

        private CommonValues() {
            this.overrideGameRules = (Boolean)PSConfig.COMMON.overrideGameRules.get();
            this.enableHyperInvasions = (Boolean)PSConfig.COMMON.enableHyperInvasions.get();
            this.enableNightmareInvasions = (Boolean)PSConfig.COMMON.enableNightmareInvasions.get();
            this.invasionAntiGrief = (Boolean)PSConfig.COMMON.invasionAntiGrief.get();
            this.consistentInvasions = (Boolean)PSConfig.COMMON.consistentInvasions.get();
            this.tieredInvasions = (Boolean)PSConfig.COMMON.tieredInvasions.get();
            this.hyperAggression = (Boolean)PSConfig.COMMON.hyperAggression.get();
            this.hyperCharge = (Boolean)PSConfig.COMMON.hyperCharge.get();
            this.forceInvasionSleeplessness = (Boolean)PSConfig.COMMON.forceInvasionSleeplessness.get();
            this.useXPMultiplier = (Boolean)PSConfig.COMMON.useXPMultiplier.get();
            this.mobsDieAtEndOfInvasions = (Boolean)PSConfig.COMMON.mobsDieAtEndOfInvasions.get();
            this.weakenedInvasionVexes = (Boolean)PSConfig.COMMON.weakenedInvasionVexes.get();
            this.enableInvasionAmbience = (Boolean)PSConfig.COMMON.enableInvasionAmbience.get();
            this.primaryInvasionMobCap = (Integer)PSConfig.COMMON.primaryInvasionMobCap.get();
            this.secondaryInvasionMobCap = (Integer)PSConfig.COMMON.secondaryInvasionMobCap.get();
            this.invasionBlacklist = (List)PSConfig.COMMON.invasionBlacklist.get();
            this.primaryWhitelist = (List)PSConfig.COMMON.primaryWhitelist.get();
            this.overworldLikeDimensions = (List)PSConfig.COMMON.overworldLikeDimensions.get();
            this.netherLikeDimensions = (List)PSConfig.COMMON.netherLikeDimensions.get();
            this.endLikeDimensions = (List)PSConfig.COMMON.endLikeDimensions.get();
            this.hyperAggressionBlacklist = (List)PSConfig.COMMON.hyperAggressionBlacklist.get();
            this.hyperChargeBlacklist = (List)PSConfig.COMMON.hyperChargeBlacklist.get();
            this.modBiomeBoostedBlacklist = (List)PSConfig.COMMON.modBiomeBoostedBlacklist.get();
            this.mobBiomeBoostedBlacklist = (List)PSConfig.COMMON.mobBiomeBoostedBlacklist.get();
            this.naturalSpawnChance = (Double)PSConfig.COMMON.naturalSpawnChance.get();
            this.hyperChargeChance = (Double)PSConfig.COMMON.hyperChargeChance.get();
            this.blessingEffectRespawnDuration = (Integer)PSConfig.COMMON.blessingEffectRespawnDuration.get();
            this.blessingEffectDimensionChangeDuration = (Integer)PSConfig.COMMON.blessingEffectDimensionChangeDuration.get();
        }
    }

    public static final class ClientValues {
        public final boolean useSkyBoxRenderer;
        public final boolean canInvasionsChangeBrightness;
        public final boolean enableInvasionStartEffects;
        public final boolean enableSkyFlickering;
        public final boolean enableSkyEffects;
        public final boolean useFastEffects;
        public final int minVortexParticleLifespan;
        public final int maxVortexParticleLifespan;
        public final int vortexParticleDelay;
        public final boolean useInvasionSoundEffects;

        private ClientValues() {
            this.useSkyBoxRenderer = (Boolean)PSConfig.CLIENT.useSkyBoxRenderer.get();
            this.canInvasionsChangeBrightness = (Boolean)PSConfig.CLIENT.canInvasionsChangeBrightness.get();
            this.enableInvasionStartEffects = (Boolean)PSConfig.CLIENT.enableInvasionStartEffects.get();
            this.enableSkyFlickering = (Boolean)PSConfig.CLIENT.enableSkyFlickering.get();
            this.enableSkyEffects = (Boolean)PSConfig.CLIENT.enableSkyEffects.get();
            this.useFastEffects = (Boolean)PSConfig.CLIENT.useFastEffects.get();
            this.minVortexParticleLifespan = (Integer)PSConfig.CLIENT.minVortexParticleLifespan.get();
            this.maxVortexParticleLifespan = (Integer)PSConfig.CLIENT.maxVortexParticleLifespan.get();
            this.vortexParticleDelay = (Integer)PSConfig.CLIENT.vortexParticleDelay.get();
            this.useInvasionSoundEffects = (Boolean)PSConfig.CLIENT.useInvasionSoundEffects.get();
        }
    }

    public static final class LevelValues {
        public final int[] invasionSessionTypeRarity;
        public final int[] invasionDifficultyRarity;
        public final boolean[] cancelableInvasions;
        public final int[] cancelInvasionRarity;
        public final int[] maxInvasions;
        public final int[] tierIncreaseDelay;

        private LevelValues(ServerLevel levelIn) {
            PSConfig.LevelConfig config = PSConfig.LEVELS.get(levelIn);
            int sessionTypeLength = levelIn.m_6042_().m_63967_() ? 1 : 2;
            int difficultyLength = InvasionDifficulty.values().length - 1;
            this.invasionSessionTypeRarity = new int[sessionTypeLength];
            this.invasionDifficultyRarity = new int[difficultyLength];
            this.cancelableInvasions = new boolean[sessionTypeLength];
            this.cancelInvasionRarity = new int[sessionTypeLength];
            this.maxInvasions = new int[sessionTypeLength];
            this.tierIncreaseDelay = new int[sessionTypeLength];
            for (int st = 0; st < sessionTypeLength; ++st) {
                this.invasionSessionTypeRarity[st] = (Integer)config.invasionSessionTypeRarity[st].get();
                this.cancelableInvasions[st] = (Boolean)config.cancelableInvasions[st].get();
                this.cancelInvasionRarity[st] = (Integer)config.cancelInvasionRarity[st].get();
                this.maxInvasions[st] = (Integer)config.maxInvasions[st].get();
                this.tierIncreaseDelay[st] = (Integer)config.tierIncreaseDelay[st].get();
            }
            for (int d = 0; d < difficultyLength; ++d) {
                this.invasionDifficultyRarity[d] = (Integer)config.invasionDifficultyRarity[d].get();
            }
        }
    }
}

