/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.theagameplayer.puresuffering.PureSufferingMod;
import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.invasion.InvasionType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.dimension.LevelStem;
import org.apache.logging.log4j.Logger;

public final class InvasionTypeManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = PureSufferingMod.LOGGER;
    private static final Gson GSON = new GsonBuilder().create();
    private final HashMap<ResourceLocation, InvasionType> invasionTypeMap = new HashMap();
    private final Registry<LevelStem> dimensions;

    public InvasionTypeManager(Registry<LevelStem> dimensionsIn) {
        super(GSON, "invasion_types");
        this.dimensions = dimensionsIn;
    }

    protected final void apply(Map<ResourceLocation, JsonElement> objectsIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        this.invasionTypeMap.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : objectsIn.entrySet()) {
            try {
                JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"invasion_type");
                InvasionType invasionType = InvasionType.Builder.fromJson(this.dimensions, jsonObject).build(entry.getKey());
                if (invasionType == null) {
                    LOGGER.debug("Skipping loading invasion type {} as it's conditions were not met.", (Object)entry.getKey());
                    return;
                }
                if (PSConfigValues.common.invasionBlacklist.contains(entry.getKey().toString())) {
                    LOGGER.debug("Skipping loading invasion type {} as it is blacklisted.", (Object)entry.getKey());
                    return;
                }
                if (this.invasionTypeMap.containsKey(entry.getKey())) {
                    if (!invasionType.overridesExisting()) continue;
                    if (this.invasionTypeMap.get(entry.getKey()) != null && this.invasionTypeMap.get(entry.getKey()).overridesExisting()) {
                        throw new JsonParseException("Cannot have 2 invasion types of the same id override each other: " + entry.getKey());
                    }
                }
                this.invasionTypeMap.put(entry.getKey(), invasionType);
            }
            catch (JsonParseException | IllegalArgumentException exceptionIn) {
                LOGGER.error("Parsing error loading custom invasion types {}: {}", (Object)entry.getKey(), (Object)exceptionIn.getMessage());
            }
        }
        LOGGER.info("Loaded {} invasion types", (Object)this.invasionTypeMap.size());
    }

    @Nullable
    public final InvasionType getInvasionType(ResourceLocation idIn) {
        return this.invasionTypeMap.get(idIn);
    }

    public final Stream<InvasionType> getAllInvasionTypes() {
        return this.invasionTypeMap.values().stream();
    }

    public final ArrayList<InvasionType> getInvasionTypesOf(Predicate<InvasionType> ofIn) {
        ArrayList<InvasionType> invasionList = new ArrayList<InvasionType>();
        for (InvasionType invasionType : this.invasionTypeMap.values()) {
            if (!ofIn.test(invasionType)) continue;
            invasionList.add(invasionType);
        }
        return invasionList;
    }

    public final boolean verifyInvasion(String idIn) {
        for (ResourceLocation id : this.invasionTypeMap.keySet()) {
            if (!id.toString().equals(idIn)) continue;
            return true;
        }
        return false;
    }
}

