/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.event;

import dev.theagameplayer.puresuffering.PureSufferingMod;
import dev.theagameplayer.puresuffering.client.invasion.ClientInvasionSession;
import dev.theagameplayer.puresuffering.client.renderer.entity.layers.HyperChargeLayer;
import dev.theagameplayer.puresuffering.client.sounds.InvasionMusicManager;
import dev.theagameplayer.puresuffering.config.PSConfigValues;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;

public final class PSClientEvents {
    private static final Logger LOGGER = PureSufferingMod.LOGGER;

    public static final void addLayers(EntityRenderersEvent.AddLayers eventIn) {
        List entityTypes = List.copyOf(ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(et -> DefaultAttributes.m_22301_((EntityType)et) && et.m_20674_() == MobCategory.MONSTER).map(et -> et).collect(Collectors.toList()));
        entityTypes.forEach(et -> {
            MobRenderer renderer = null;
            try {
                renderer = (MobRenderer)eventIn.getRenderer(et);
            }
            catch (Exception eIn) {
                LOGGER.warn("HyperChargeLayer failed to apply to " + ForgeRegistries.ENTITY_TYPES.getKey(et) + ", perhaps renderer is not instance of MobRenderer?");
            }
            if (renderer != null) {
                renderer.m_115326_(new HyperChargeLayer(renderer));
            }
        });
    }

    public static final void loggedIn(ClientPlayerNetworkEvent.LoggingIn eventIn) {
        PSConfigValues.resyncClient();
        InvasionMusicManager.reloadMusic();
    }

    public static final void loggedOut(ClientPlayerNetworkEvent.LoggingOut eventIn) {
        PSConfigValues.resyncClient();
        ClientInvasionSession.clear();
    }

    public static final void debugText(CustomizeGuiOverlayEvent.DebugText eventIn) {
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.f_91066_.f_92063_) {
            return;
        }
        ClientInvasionSession session = ClientInvasionSession.get(mc.f_91073_);
        eventIn.getLeft().add("");
        eventIn.getLeft().add(ChatFormatting.RED + "[PureSuffering]" + ChatFormatting.RESET + " Current Invasions: " + (session == null ? 0 : session.size()));
        eventIn.getLeft().add(ChatFormatting.RED + "[PureSuffering]" + ChatFormatting.RESET + " Invasion XP Multiplier: " + (session == null ? 0.0 : session.getXPMultiplier()) + "x");
    }

    public static final void renderLevelStage(RenderLevelStageEvent eventIn) {
        if (!PSConfigValues.client.enableSkyEffects || eventIn.getStage() != RenderLevelStageEvent.Stage.AFTER_SKY) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ClientInvasionSession session = ClientInvasionSession.get(mc.f_91073_);
        if (session == null) {
            return;
        }
        session.getClientEffectsRenderer().render(eventIn.getPoseStack(), eventIn.getPartialTick());
    }

    public static final void screenInitPre(ScreenEvent.Init.Pre eventIn) {
        Screen screen = eventIn.getScreen();
        if (screen instanceof CreateWorldScreen) {
            CreateWorldScreen createWorldScreen = (CreateWorldScreen)screen;
            createWorldScreen.m_267748_().m_267754_(Difficulty.HARD);
        }
    }

    public static final void fogColors(ViewportEvent.ComputeFogColor eventIn) {
        FogType fogType = eventIn.getCamera().m_167685_();
        if (fogType != FogType.NONE && fogType != FogType.WATER) {
            return;
        }
        Entity entity = eventIn.getCamera().m_90592_();
        if (FogRenderer.m_234165_((Entity)entity, (float)((float)eventIn.getPartialTick())) != null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ClientInvasionSession session = ClientInvasionSession.get(mc.f_91073_);
        if (session == null) {
            return;
        }
        float[] rgb = session.getFogRGB();
        eventIn.setRed(eventIn.getRed() + rgb[0]);
        eventIn.setGreen(eventIn.getGreen() + rgb[1]);
        eventIn.setBlue(eventIn.getBlue() + rgb[2]);
    }
}

