/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.event;

import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.invasion.InvasionSession;
import dev.theagameplayer.puresuffering.registries.other.PSGameRules;
import dev.theagameplayer.puresuffering.world.entity.PSInvasionMob;
import dev.theagameplayer.puresuffering.world.level.saveddata.InvasionLevelData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.monster.Vex;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.eventbus.api.Event;

public final class PSEntityEvents {
    public static final void joinLevel(EntityJoinLevelEvent eventIn) {
        if (eventIn.getLevel().m_5776_()) {
            return;
        }
        Entity entity = eventIn.getEntity();
        if (entity instanceof Mob) {
            PSInvasionMob invasionMob;
            Mob mob = (Mob)entity;
            if (eventIn.loadedFromDisk()) {
                InvasionSession session;
                ServerLevel level = (ServerLevel)eventIn.getLevel();
                InvasionLevelData ilData = InvasionLevelData.get(level);
                if (ilData != null && (session = ilData.getInvasionManager().getActiveSession(level)) != null) {
                    session.loadMob(mob);
                }
            } else if (mob instanceof PSInvasionMob && (invasionMob = (PSInvasionMob)mob).psGetHyperCharge() > 0) {
                PSInvasionMob.applyHyperEffects(mob);
            }
        }
        LivingEntity owner = null;
        if (entity instanceof OwnableEntity) {
            OwnableEntity ownableEntity = (OwnableEntity)entity;
            owner = ownableEntity.m_269323_();
        }
        if (entity instanceof TraceableEntity) {
            TraceableEntity traceableEntity = (TraceableEntity)entity;
            owner = traceableEntity.m_19749_();
        }
        if (owner != null && owner.getPersistentData().m_128441_(Invasion.ANTI_GRIEF)) {
            entity.getPersistentData().m_128379_(Invasion.ANTI_GRIEF, owner.getPersistentData().m_128471_(Invasion.ANTI_GRIEF));
        }
        if (PSGameRules.WEAKENED_INVASION_VEXES.get(eventIn.getLevel()) && entity instanceof Vex) {
            Vex vex = (Vex)entity;
            if (owner != null && owner.getPersistentData().m_128441_(Invasion.INVASION_MOB)) {
                vex.m_33987_(25 + eventIn.getLevel().m_213780_().m_188503_(65));
            }
        }
    }

    public static final void mobGriefing(EntityMobGriefingEvent eventIn) {
        Entity entity = eventIn.getEntity();
        if (!PSGameRules.INVASION_ANTI_GRIEF.get(entity.m_9236_())) {
            return;
        }
        if (entity.getPersistentData().m_128441_(Invasion.ANTI_GRIEF)) {
            eventIn.setResult(Event.Result.DENY);
        }
    }
}

