/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.event;

import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.invasion.InvasionSession;
import dev.theagameplayer.puresuffering.network.PSPacketHandler;
import dev.theagameplayer.puresuffering.network.packet.UpdateXPMultPacket;
import dev.theagameplayer.puresuffering.registries.other.PSEntityPredicates;
import dev.theagameplayer.puresuffering.registries.other.PSGameRules;
import dev.theagameplayer.puresuffering.world.entity.PSInvasionMob;
import dev.theagameplayer.puresuffering.world.level.saveddata.InvasionLevelData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;

public final class PSLivingEvents {
    public static final void conversionPre(LivingConversionEvent.Pre eventIn) {
        Mob mob;
        if (eventIn.getOutcome() == null || eventIn.getOutcome().m_20674_() != MobCategory.MONSTER || !eventIn.getEntity().getPersistentData().m_128441_(Invasion.INVASION_MOB)) {
            return;
        }
        LivingEntity livingEntity = eventIn.getEntity();
        if (livingEntity instanceof Mob && (livingEntity = (mob = (Mob)livingEntity).m_9236_()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)livingEntity;
            InvasionSession session = InvasionLevelData.get(level).getInvasionManager().getActiveSession(level);
            if (session == null || !session.stopsConversions() || !session.hasMob(mob)) {
                return;
            }
            eventIn.setCanceled(true);
            eventIn.setConversionTimer(12000 - (int)(level.m_8044_() % 12000L));
        }
    }

    public static final void conversionPost(LivingConversionEvent.Post eventIn) {
        if (eventIn.getOutcome() == null || eventIn.getOutcome().getClassification(false) != MobCategory.MONSTER) {
            return;
        }
        LivingEntity livingEntity = eventIn.getOutcome();
        if (livingEntity instanceof Mob) {
            LivingEntity livingEntity2;
            Mob resultMob = (Mob)livingEntity;
            CompoundTag persistentData = eventIn.getEntity().getPersistentData();
            CompoundTag outcomeData = resultMob.getPersistentData();
            if (persistentData.m_128441_(Invasion.INVASION_MOB)) {
                outcomeData.m_128405_(Invasion.INVASION_MOB, persistentData.m_128451_(Invasion.INVASION_MOB));
            }
            if (persistentData.m_128441_(Invasion.ANTI_GRIEF)) {
                outcomeData.m_128379_(Invasion.ANTI_GRIEF, persistentData.m_128471_(Invasion.ANTI_GRIEF));
            }
            if (persistentData.m_128441_(Invasion.DESPAWN_LOGIC)) {
                outcomeData.m_128385_(Invasion.DESPAWN_LOGIC, persistentData.m_128465_(Invasion.DESPAWN_LOGIC));
            }
            if ((livingEntity2 = eventIn.getEntity()) instanceof Mob) {
                Object im2;
                Mob mob = (Mob)livingEntity2;
                LivingEntity livingEntity3 = eventIn.getEntity();
                if (livingEntity3 instanceof PSInvasionMob) {
                    PSInvasionMob im1 = (PSInvasionMob)livingEntity3;
                    if (resultMob instanceof PSInvasionMob) {
                        im2 = (PSInvasionMob)resultMob;
                        im2.psSetHyperCharge(im1.psGetHyperCharge());
                        PSInvasionMob.applyHyperEffects(mob);
                    }
                }
                if ((im2 = mob.m_9236_()) instanceof ServerLevel) {
                    ServerLevel level = (ServerLevel)im2;
                    InvasionSession session = InvasionLevelData.get(level).getInvasionManager().getActiveSession(level);
                    if (session == null || !session.hasMob(mob)) {
                        return;
                    }
                    session.replaceMob(mob, resultMob);
                }
            }
        }
    }

    public static final void livingTick(LivingEvent.LivingTickEvent eventIn) {
        Mob mob;
        LivingEntity livingEntity = eventIn.getEntity();
        if (livingEntity instanceof Mob && (livingEntity = (mob = (Mob)livingEntity).m_9236_()) instanceof ServerLevel) {
            boolean flag2;
            ServerLevel level = (ServerLevel)livingEntity;
            CompoundTag persistentData = mob.getPersistentData();
            boolean flag1 = PSGameRules.HYPER_AGGRESSION.get((Level)level) && !PSConfigValues.common.hyperAggressionBlacklist.contains(mob.m_6095_().m_20675_());
            boolean bl = flag2 = mob.m_21188_() == null || !mob.m_21188_().m_6084_();
            if (persistentData.m_128441_(Invasion.DESPAWN_LOGIC)) {
                int[] despawnLogic = persistentData.m_128465_(Invasion.DESPAWN_LOGIC);
                BlockPos pos = mob.m_20183_();
                if (pos.m_123341_() != despawnLogic[0] || pos.m_123342_() != despawnLogic[1] || pos.m_123343_() != despawnLogic[2]) {
                    despawnLogic[0] = pos.m_123341_();
                    despawnLogic[1] = pos.m_123342_();
                    despawnLogic[2] = pos.m_123343_();
                    despawnLogic[3] = 0;
                } else if (PSLivingEvents.getNearestPlayer(level, mob.m_20182_(), true) != null) {
                    despawnLogic[3] = despawnLogic[3] + 1;
                }
            }
            if (persistentData.m_128441_(Invasion.INVASION_MOB) && flag1 && flag2) {
                ServerPlayer player = PSLivingEvents.getNearestPlayer(level, mob.m_20182_(), true);
                if (player == null) {
                    mob.m_6710_(null);
                    return;
                }
                if (player.equals((Object)mob.m_5448_())) {
                    return;
                }
                if (mob instanceof AbstractPiglin) {
                    mob.m_6274_().m_21936_(MemoryModuleType.f_26326_);
                    mob.m_6274_().m_21882_(MemoryModuleType.f_26334_, (Object)player.m_20148_(), 600L);
                } else if (mob instanceof Hoglin) {
                    mob.m_6274_().m_21936_(MemoryModuleType.f_26326_);
                    mob.m_6274_().m_21936_(MemoryModuleType.f_26375_);
                    mob.m_6274_().m_21882_(MemoryModuleType.f_26372_, (Object)player, 600L);
                } else if (mob instanceof Zoglin) {
                    mob.m_6274_().m_21936_(MemoryModuleType.f_26326_);
                    mob.m_6274_().m_21882_(MemoryModuleType.f_26372_, (Object)player, 600L);
                } else if (mob instanceof Warden) {
                    Warden warden;
                    warden.m_219387_((Entity)player, 80, !player.equals((Object)(warden = (Warden)mob).m_5448_()));
                } else {
                    mob.m_6710_((LivingEntity)player);
                }
            }
        }
    }

    private static final ServerPlayer getNearestPlayer(ServerLevel levelIn, Vec3 posIn, boolean hyperAggressionIn) {
        ServerPlayer target = null;
        double dist = -1.0;
        List players = hyperAggressionIn ? levelIn.m_8795_(PSEntityPredicates.HYPER_AGGRESSION) : levelIn.m_6907_();
        for (ServerPlayer player : players) {
            double d = player.m_20238_(posIn);
            if (!(dist < 0.0) && !(d < dist)) continue;
            dist = d;
            target = player;
        }
        return target;
    }

    public static final void experienceDrop(LivingExperienceDropEvent eventIn) {
        Mob mob;
        LivingEntity livingEntity = eventIn.getEntity();
        if (livingEntity instanceof Mob && (mob = (Mob)livingEntity) instanceof PSInvasionMob) {
            PSInvasionMob invasionMob = (PSInvasionMob)mob;
            ServerLevel level = (ServerLevel)mob.m_9236_();
            InvasionLevelData ilData = InvasionLevelData.get(level);
            InvasionSession session = ilData.getInvasionManager().getActiveSession(level);
            if (session == null || !session.hasMob(mob)) {
                eventIn.setDroppedExperience(eventIn.getOriginalExperience() + eventIn.getOriginalExperience() / 3 * invasionMob.psGetHyperCharge());
            } else if (PSGameRules.USE_XP_MULTIPLIER.get((Level)level) && eventIn.getAttackingPlayer() != null) {
                ilData.setXPMultiplier(ilData.getXPMultiplier() + 1);
                double log = Math.log1p(ilData.getXPMultiplier()) / Math.E;
                eventIn.setDroppedExperience((int)((double)eventIn.getOriginalExperience() * log) + eventIn.getOriginalExperience() / 3 * invasionMob.psGetHyperCharge());
                PSPacketHandler.sendToClientsIn(new UpdateXPMultPacket(log), level);
            }
        }
    }

    public static final void finalizeSpawn(MobSpawnEvent.FinalizeSpawn eventIn) {
        Mob mob = eventIn.getEntity();
        if (eventIn.getSpawnType() != MobSpawnType.NATURAL || mob.getClassification(false) != MobCategory.MONSTER) {
            return;
        }
        ServerLevel level = (ServerLevel)eventIn.getLevel();
        if (PSConfigValues.common.naturalSpawnChance < level.f_46441_.m_188500_()) {
            return;
        }
        InvasionSession session = InvasionLevelData.get(level).getInvasionManager().getActiveSession(level);
        if (session == null) {
            return;
        }
        eventIn.setSpawnCancelled(true);
    }

    public static final void allowDespawn(MobSpawnEvent.AllowDespawn eventIn) {
        boolean flag2;
        Mob mob = eventIn.getEntity();
        CompoundTag persistentData = mob.getPersistentData();
        if (!mob.m_6084_() || !persistentData.m_128441_(Invasion.DESPAWN_LOGIC)) {
            return;
        }
        ServerLevel level = (ServerLevel)eventIn.getLevel();
        InvasionSession session = InvasionLevelData.get(level).getInvasionManager().getActiveSession(level);
        int[] despawnLogic = persistentData.m_128465_(Invasion.DESPAWN_LOGIC);
        boolean flag1 = despawnLogic[3] > 150 || mob.m_5830_();
        boolean bl = flag2 = despawnLogic.length == 6;
        if (session != null && session.hasMob(mob)) {
            if (flag1) {
                session.relocateMob(mob);
            }
            if (flag2) {
                despawnLogic[4] = 0;
            }
        }
        if (flag2) {
            if (despawnLogic[4] > despawnLogic[5]) {
                level.m_7605_((Entity)mob, (byte)60);
                eventIn.setResult(Event.Result.ALLOW);
                return;
            }
            despawnLogic[4] = despawnLogic[4] + 1;
        }
    }
}

