/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.event;

import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.invasion.InvasionSession;
import dev.theagameplayer.puresuffering.network.PSPacketHandler;
import dev.theagameplayer.puresuffering.network.packet.SendInvasionsPacket;
import dev.theagameplayer.puresuffering.network.packet.UpdateXPMultPacket;
import dev.theagameplayer.puresuffering.registries.PSMobEffects;
import dev.theagameplayer.puresuffering.registries.other.PSGameRules;
import dev.theagameplayer.puresuffering.world.level.saveddata.InvasionLevelData;
import java.util.Optional;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;

public final class PSPlayerEvents {
    public static final void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent eventIn) {
        ServerPlayer player = (ServerPlayer)eventIn.getEntity();
        PSGameRules.syncToServer(player);
        PSPlayerEvents.updatePlayer(player, true, 0);
    }

    public static final void playerRespawn(PlayerEvent.PlayerRespawnEvent eventIn) {
        ServerPlayer player = (ServerPlayer)eventIn.getEntity();
        if (eventIn.isEndConquered()) {
            PSPlayerEvents.updatePlayer(player, true, PSConfigValues.common.blessingEffectDimensionChangeDuration);
            return;
        }
        Optional deathPos = player.m_219759_();
        PSPlayerEvents.updatePlayer(player, deathPos.isPresent() && !((GlobalPos)deathPos.get()).m_122640_().equals((Object)player.m_9236_().m_46472_()), PSConfigValues.common.blessingEffectRespawnDuration);
    }

    public static final void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent eventIn) {
        if (eventIn.getTo().equals((Object)eventIn.getEntity().m_9236_().m_46472_())) {
            PSPlayerEvents.updatePlayer((ServerPlayer)eventIn.getEntity(), true, PSConfigValues.common.blessingEffectDimensionChangeDuration);
        }
    }

    private static final void updatePlayer(ServerPlayer playerIn, boolean informPlayerIn, int blessingDurationIn) {
        InvasionLevelData ilData = InvasionLevelData.get(playerIn.m_284548_());
        InvasionSession session = ilData.getInvasionManager().getActiveSession(playerIn.m_284548_());
        if (session == null) {
            return;
        }
        session.updateClient(playerIn);
        PSPacketHandler.sendToClient(new UpdateXPMultPacket(Math.log1p(ilData.getXPMultiplier()) / Math.E), playerIn);
        if (blessingDurationIn > 0) {
            playerIn.m_7292_(new MobEffectInstance((MobEffect)PSMobEffects.BLESSING.get(), blessingDurationIn, 0));
        }
        if (informPlayerIn) {
            PSPacketHandler.sendToClient(new SendInvasionsPacket(true), playerIn);
        }
    }

    public static final void playerSleepInBed(PlayerSleepInBedEvent eventIn) {
        ServerPlayer player = (ServerPlayer)eventIn.getEntity();
        InvasionSession session = InvasionLevelData.get(player.m_284548_()).getInvasionManager().getActiveSession(player.m_284548_());
        if (session == null) {
            return;
        }
        if (PSGameRules.FORCE_INVASION_SLEEPLESSNESS.get(player.m_9236_()) || session.forcesNoSleep()) {
            if (eventIn.getOptionalPos().isPresent()) {
                player.m_9158_(player.m_284548_().m_46472_(), eventIn.getPos(), player.m_146908_(), false, true);
            }
            eventIn.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
            player.m_5661_((Component)Component.m_237115_((String)"block.minecraft.bed.invasion").m_130948_(session.getStyle().m_178520_(session.getDifficulty().getColor(false))), true);
        }
    }
}

