/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.invasion;

import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.invasion.InvasionDifficulty;
import dev.theagameplayer.puresuffering.invasion.InvasionType;
import dev.theagameplayer.puresuffering.invasion.InvasionTypeHolder;
import dev.theagameplayer.puresuffering.invasion.data.AdditionalEntitySpawnData;
import dev.theagameplayer.puresuffering.invasion.data.InvasionSpawnerData;
import dev.theagameplayer.puresuffering.network.PSPacketHandler;
import dev.theagameplayer.puresuffering.network.packet.InvasionMobParticlesPacket;
import dev.theagameplayer.puresuffering.registries.other.PSGameRules;
import dev.theagameplayer.puresuffering.registries.other.PSReloadListeners;
import dev.theagameplayer.puresuffering.util.list.SpawnPosChart;
import dev.theagameplayer.puresuffering.world.entity.PSInvasionMob;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;

public final class Invasion
implements InvasionTypeHolder {
    public static final int TRANSITION_TIME = 600;
    public static final int HALF_TRANSITION = 300;
    public static final String INVASION_MOB = "puresuffering".toUpperCase() + "InvasionMob";
    public static final String ANTI_GRIEF = "puresuffering".toUpperCase() + "AntiGrief";
    public static final String DESPAWN_LOGIC = "puresuffering".toUpperCase() + "DespawnLogic";
    private final ArrayList<MobInfo> invasionMobs = new ArrayList();
    private final InvasionType invasionType;
    private final boolean isPrimary;
    private final int severity;
    private final int mobCap;
    private final boolean shouldTick;
    private final boolean isNatural;
    private final long startTime;
    private final int index;
    private final SimpleWeightedRandomList<SpawnData> spawnPotentials = SimpleWeightedRandomList.m_185864_();
    private SpawnData nextSpawnData = new SpawnData();
    private int spawnDelay;

    public Invasion(ServerLevel levelIn, InvasionType invasionTypeIn, int severityIn, boolean isPrimaryIn, boolean isNaturalIn, long startTimeIn, int indexIn) {
        InvasionType.SeverityInfo info = invasionTypeIn.getSeverityInfo().get(severityIn);
        int pMobCap = Math.max(0, isPrimaryIn ? PSGameRules.PRIMARY_INVASION_MOB_CAP.get((Level)levelIn) : PSGameRules.SECONDARY_INVASION_MOB_CAP.get((Level)levelIn));
        int mobCap = info.getFixedMobCap() > 0 ? Mth.m_14045_((int)info.getFixedMobCap(), (int)0, (int)pMobCap) : pMobCap;
        this.invasionType = invasionTypeIn;
        this.isPrimary = isPrimaryIn;
        this.severity = severityIn;
        this.mobCap = (int)((float)mobCap * info.getMobCapPercentage());
        this.shouldTick = info.getTickDelay() > -1 && (info.getMobSpawnList() != null || invasionTypeIn.getSpawningSystem() != InvasionType.SpawningSystem.DEFAULT);
        this.isNatural = isNaturalIn;
        this.startTime = startTimeIn;
        this.index = indexIn;
    }

    @Override
    public final InvasionType getType() {
        return this.invasionType;
    }

    public final boolean isPrimary() {
        return this.isPrimary;
    }

    public final int getSeverity() {
        return this.severity;
    }

    public final int getMobCap() {
        return this.mobCap;
    }

    public final InvasionType.SeverityInfo getSeverityInfo() {
        return this.invasionType.getSeverityInfo().get(this.severity);
    }

    public final void replaceMob(Mob oldMobIn, Mob mobIn) {
        UUID uuid = oldMobIn.m_20148_();
        for (int i = 0; i < this.invasionMobs.size(); ++i) {
            MobInfo info = this.invasionMobs.get(i);
            if (!uuid.equals(info.uuid)) continue;
            info.uuid = mobIn.m_20148_();
            return;
        }
    }

    public final void relocateMob(Mob mobIn) {
        UUID uuid = mobIn.m_20148_();
        for (int i = 0; i < this.invasionMobs.size(); ++i) {
            MobInfo info = this.invasionMobs.get(i);
            if (!uuid.equals(info.uuid)) continue;
            info.relocate = true;
            return;
        }
    }

    public final boolean hasMob(Mob mobIn) {
        UUID uuid = mobIn.m_20148_();
        for (int i = 0; i < this.invasionMobs.size(); ++i) {
            MobInfo info = this.invasionMobs.get(i);
            if (!uuid.equals(info.uuid)) continue;
            return true;
        }
        return false;
    }

    public final boolean loadMob(Mob mobIn) {
        CompoundTag persistentData = mobIn.getPersistentData();
        if (this.invasionMobs.size() < this.mobCap && persistentData.m_128441_(INVASION_MOB) && persistentData.m_128451_(INVASION_MOB) == this.hashCode()) {
            this.invasionMobs.add(new MobInfo(mobIn.m_20148_(), false));
            return true;
        }
        return false;
    }

    public final void tick(ServerLevel levelIn, InvasionDifficulty difficultyIn, int totalInvasionsIn) {
        List<AdditionalEntitySpawnData> additionalEntities;
        this.invasionMobs.removeIf(info -> {
            Entity mob = levelIn.m_8791_(info.uuid);
            if (info.relocate && mob != null) {
                int players = levelIn.m_6907_().size();
                if (players < 1) {
                    return mob == null || !mob.m_6084_();
                }
                ServerPlayer player = (ServerPlayer)levelIn.m_6907_().get(levelIn.f_46441_.m_188503_(players));
                ChunkPos chunkPos = this.getSpawnChunk(levelIn, player);
                BlockPos spawnPos = this.getSpawnPos(levelIn, chunkPos, player, mob.m_6095_(), false, true);
                if (mob != null && this.canSpawnMob(levelIn, mob.m_6095_(), spawnPos, mob.getPersistentData().m_128441_(ANTI_GRIEF) && mob.getPersistentData().m_128471_(ANTI_GRIEF))) {
                    PSPacketHandler.sendToClientsIn(new InvasionMobParticlesPacket(difficultyIn, mob.m_20182_(), false), levelIn);
                    mob.m_7678_((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_(), mob.m_146908_(), mob.m_146909_());
                    if (!mob.m_5830_()) {
                        PSPacketHandler.sendToClientsIn(new InvasionMobParticlesPacket(difficultyIn, mob.m_20182_(), true), levelIn);
                        mob.getPersistentData().m_128465_((String)Invasion.DESPAWN_LOGIC)[3] = 0;
                    }
                    info.relocate = false;
                }
            }
            return mob == null || !mob.m_6084_();
        });
        if (this.shouldTick && this.invasionMobs.size() < this.mobCap) {
            this.tickMobSpawn(levelIn, difficultyIn, totalInvasionsIn);
        }
        if (!(additionalEntities = this.getSeverityInfo().getClusterEntities()).isEmpty()) {
            int t;
            AdditionalEntitySpawnData spawnInfo = additionalEntities.get(levelIn.f_46441_.m_188503_(additionalEntities.size()));
            int players = levelIn.m_6907_().size();
            if (players < 1) {
                return;
            }
            int n = t = levelIn.f_46441_.m_188503_(spawnInfo.getChance()) == 0 ? levelIn.f_46441_.m_216332_(spawnInfo.getMinCount(), spawnInfo.getMaxCount()) : 0;
            if (t < 1) {
                return;
            }
            ServerPlayer player = (ServerPlayer)levelIn.m_6907_().get(levelIn.f_46441_.m_188503_(players));
            ChunkPos chunkPos = this.getSpawnChunk(levelIn, player);
            for (int c = 0; c < t; ++c) {
                this.spawnClusterEntity(this.getSpawnPos(levelIn, chunkPos, player, spawnInfo.getEntityType(), spawnInfo.isSurfaceSpawn(), false), levelIn, spawnInfo.getEntityType());
            }
        }
    }

    private final void tickMobSpawn(ServerLevel levelIn, InvasionDifficulty difficultyIn, int totalInvasionsIn) {
        if (this.spawnDelay < 0) {
            this.delay(levelIn, totalInvasionsIn);
        }
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
            return;
        }
        int players = levelIn.m_6907_().size();
        if (players < 1) {
            return;
        }
        ServerPlayer player = (ServerPlayer)levelIn.m_6907_().get(levelIn.f_46441_.m_188503_(players));
        ChunkPos chunkPos = this.getSpawnChunk(levelIn, player);
        if (chunkPos == null || !levelIn.m_46749_(chunkPos.m_45615_())) {
            return;
        }
        ArrayList<InvasionSpawnerData> mobs = this.getMobSpawnList(levelIn, chunkPos, player);
        if (mobs.isEmpty()) {
            return;
        }
        boolean flag1 = false;
        int clusterSize = levelIn.f_46441_.m_188503_(this.getSeverityInfo().getClusterSize()) + 1;
        for (int cluster = 0; cluster < clusterSize && this.invasionMobs.size() < this.mobCap; ++cluster) {
            InvasionSpawnerData spawners = (InvasionSpawnerData)((Object)mobs.get(levelIn.f_46441_.m_188503_(mobs.size())));
            int groupSize = levelIn.f_46441_.m_188503_(spawners.maxCount - spawners.minCount + 1) + spawners.minCount;
            this.nextSpawnData.m_186567_().m_128359_("id", ForgeRegistries.ENTITY_TYPES.getKey(spawners.type).toString());
            CompoundTag compoundNBT = this.nextSpawnData.m_186567_();
            Optional optional = EntityType.m_20637_((CompoundTag)compoundNBT);
            if (!optional.isPresent()) {
                this.delay(levelIn, totalInvasionsIn);
                return;
            }
            for (int count = 0; count < groupSize && this.invasionMobs.size() < this.mobCap; ++count) {
                BlockPos spawnPos = this.getSpawnPos(levelIn, chunkPos, player, spawners.type, false, false);
                if (!this.canSpawnMob(levelIn, (EntityType)optional.get(), spawnPos, spawners.ignoreSpawnRules)) continue;
                Entity entity = EntityType.m_20645_((CompoundTag)compoundNBT, (Level)levelIn, e -> {
                    e.m_7678_((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_(), e.m_146908_(), e.m_146909_());
                    return e;
                });
                if (entity == null || entity.m_5830_()) {
                    this.delay(levelIn, totalInvasionsIn);
                    return;
                }
                entity.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), levelIn.f_46441_.m_188501_() * 360.0f, 0.0f);
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    if (!ForgeEventFactory.checkSpawnPosition((Mob)mob, (ServerLevelAccessor)levelIn, (MobSpawnType)MobSpawnType.EVENT)) continue;
                    if (this.nextSpawnData.m_186567_().m_128440_() == 1 && this.nextSpawnData.m_186567_().m_128425_("id", 8)) {
                        this.spawnInvasionMob(levelIn, difficultyIn, mob, spawners.ignoreSpawnRules, spawners.forceDespawn || PSGameRules.MOBS_DIE_AT_END_OF_INVASIONS.get((Level)levelIn));
                    }
                }
                if (!levelIn.m_8860_(entity)) {
                    this.delay(levelIn, totalInvasionsIn);
                    return;
                }
                flag1 = true;
            }
        }
        if (flag1) {
            this.delay(levelIn, totalInvasionsIn);
        }
    }

    private final boolean canSpawnMob(ServerLevel levelIn, EntityType<?> entityTypeIn, BlockPos spawnPosIn, boolean ignoreSpawnRulesIn) {
        boolean flag;
        boolean bl = flag = spawnPosIn != null && entityTypeIn.m_20674_() == MobCategory.MONSTER && NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.m_21752_(entityTypeIn), (LevelReader)levelIn, (BlockPos)spawnPosIn, entityTypeIn);
        if (ignoreSpawnRulesIn) {
            return flag && Mob.m_217057_(entityTypeIn, (LevelAccessor)levelIn, (MobSpawnType)MobSpawnType.EVENT, (BlockPos)spawnPosIn, (RandomSource)levelIn.m_213780_());
        }
        return flag && SpawnPlacements.m_217074_(entityTypeIn, (ServerLevelAccessor)levelIn, (MobSpawnType)MobSpawnType.EVENT, (BlockPos)spawnPosIn, (RandomSource)levelIn.m_213780_());
    }

    private final void spawnClusterEntity(BlockPos posIn, ServerLevel levelIn, EntityType<?> entityTypeIn) {
        if (!Level.m_46741_((BlockPos)posIn)) {
            return;
        }
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128359_("id", ForgeRegistries.ENTITY_TYPES.getKey(entityTypeIn).toString());
        Entity entity = EntityType.m_20645_((CompoundTag)compoundTag, (Level)levelIn, e -> {
            e.m_7678_((double)posIn.m_123341_(), (double)posIn.m_123342_(), (double)posIn.m_123343_(), e.m_146908_(), e.m_146909_());
            return e;
        });
        if (entity == null) {
            return;
        }
        entity.getPersistentData().m_128379_(ANTI_GRIEF, false);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)levelIn, (DifficultyInstance)levelIn.m_6436_(entity.m_20183_()), (MobSpawnType)MobSpawnType.EVENT, null, null);
        }
        levelIn.m_8860_(entity);
    }

    private final void spawnInvasionMob(ServerLevel levelIn, InvasionDifficulty difficultyIn, Mob mobIn, boolean ignoresSpawnRulesIn, boolean forceDespawnIn) {
        boolean hyperCharged = PSGameRules.HYPER_CHARGE.get((Level)levelIn) && !PSConfigValues.common.hyperChargeBlacklist.contains(mobIn.m_6095_().m_20675_()) && (difficultyIn.isHyper() || levelIn.f_46441_.m_188500_() < PSConfigValues.common.hyperChargeChance * (double)(this.severity + 1) / (double)this.invasionType.getMaxSeverity());
        CompoundTag persistentData = mobIn.getPersistentData();
        persistentData.m_128405_(INVASION_MOB, this.hashCode());
        persistentData.m_128379_(ANTI_GRIEF, ignoresSpawnRulesIn);
        persistentData.m_128385_(DESPAWN_LOGIC, new int[forceDespawnIn ? 6 : 4]);
        if (forceDespawnIn) {
            persistentData.m_128465_((String)Invasion.DESPAWN_LOGIC)[5] = 100 + levelIn.f_46441_.m_188503_(101);
        }
        if (hyperCharged && mobIn instanceof PSInvasionMob) {
            PSInvasionMob invasionMob = (PSInvasionMob)mobIn;
            invasionMob.psSetHyperCharge(difficultyIn.getHyperCharge(levelIn, this.invasionType.getTier(), this.isNatural));
        }
        ForgeEventFactory.onFinalizeSpawn((Mob)mobIn, (ServerLevelAccessor)levelIn, (DifficultyInstance)levelIn.m_6436_(mobIn.m_20183_()), (MobSpawnType)MobSpawnType.EVENT, null, null);
        this.invasionMobs.add(new MobInfo(mobIn.m_20148_(), false));
        PSPacketHandler.sendToClientsIn(new InvasionMobParticlesPacket(difficultyIn, mobIn.m_20182_()), levelIn);
        mobIn.m_21373_();
    }

    private final void delay(ServerLevel levelIn, int totalInvasionsIn) {
        this.spawnDelay = this.getSeverityInfo().getTickDelay() / totalInvasionsIn;
        this.spawnPotentials.m_216829_(levelIn.f_46441_).ifPresent(entry -> {
            this.nextSpawnData = (SpawnData)entry.m_146310_();
        });
    }

    private final ArrayList<InvasionSpawnerData> getMobSpawnList(ServerLevel levelIn, ChunkPos chunkPosIn, ServerPlayer playerIn) {
        ArrayList<InvasionSpawnerData> originalList = new ArrayList<InvasionSpawnerData>(this.getSeverityInfo().getMobSpawnList());
        switch (this.invasionType.getSpawningSystem()) {
            case DEFAULT: {
                break;
            }
            case BIOME_BOOSTED: {
                BlockPos biomePos = this.getSpawnPos(levelIn, chunkPosIn, playerIn, null, false, false);
                originalList.addAll(this.getBiomeSpawnList(biomePos, levelIn.m_46865_(biomePos)));
                break;
            }
            case BIOME_MIXED: {
                originalList.addAll(this.getMixedSpawnList(levelIn));
            }
        }
        ArrayList<InvasionSpawnerData> newList = new ArrayList<InvasionSpawnerData>();
        if (!originalList.isEmpty()) {
            for (InvasionSpawnerData spawners : originalList) {
                for (int w = 0; w < spawners.m_142631_().m_146281_(); ++w) {
                    newList.add(spawners);
                }
            }
        }
        return newList;
    }

    private final ArrayList<InvasionSpawnerData> getBiomeSpawnList(BlockPos posIn, ChunkAccess chunkIn) {
        ArrayList<InvasionSpawnerData> spawners = InvasionSpawnerData.convertSpawners(((Biome)chunkIn.m_203495_(posIn.m_123341_(), posIn.m_123342_(), posIn.m_123343_()).m_203334_()).m_47518_().m_151798_(MobCategory.MONSTER).m_146338_());
        spawners.removeIf(spawner -> {
            ResourceLocation name = spawner.type.m_20677_();
            return PSConfigValues.common.modBiomeBoostedBlacklist.contains(name.m_135827_()) || PSConfigValues.common.mobBiomeBoostedBlacklist.contains(name.toString());
        });
        return spawners;
    }

    private final ArrayList<InvasionSpawnerData> getMixedSpawnList(ServerLevel levelIn) {
        Optional optional = levelIn.m_9598_().m_175515_(Registries.f_256862_).m_213642_(levelIn.f_46441_);
        if (!optional.isPresent() || optional.isEmpty()) {
            return new ArrayList<InvasionSpawnerData>();
        }
        ArrayList biomes = new ArrayList(((LevelStem)((Holder.Reference)optional.get()).get()).f_63976_().m_62218_().m_207840_());
        ArrayList<InvasionSpawnerData> spawners = biomes.size() > 0 ? InvasionSpawnerData.convertSpawners(((Biome)((Holder)biomes.get(levelIn.f_46441_.m_188503_(biomes.size()))).get()).m_47518_().m_151798_(MobCategory.MONSTER).m_146338_()) : new ArrayList<InvasionSpawnerData>();
        spawners.removeIf(spawner -> {
            ResourceLocation name = spawner.type.m_20677_();
            return PSConfigValues.common.modBiomeBoostedBlacklist.contains(name.m_135827_()) || PSConfigValues.common.mobBiomeBoostedBlacklist.contains(name.toString());
        });
        return spawners;
    }

    private final ChunkPos getSpawnChunk(ServerLevel levelIn, ServerPlayer playerIn) {
        ChunkPos chunkPos = levelIn.m_46865_(playerIn.m_20183_()).m_7697_();
        int chunkX = chunkPos.f_45578_ - 8 + levelIn.f_46441_.m_188503_(17);
        int chunkZ = chunkPos.f_45579_ - 8 + levelIn.f_46441_.m_188503_(17);
        boolean flag = chunkPos.f_45578_ == chunkX && chunkPos.f_45579_ == chunkZ;
        ChunkPos chunkPos1 = new ChunkPos(flag ? chunkX + this.getChunkOffset(levelIn) : chunkX, flag ? chunkZ + this.getChunkOffset(levelIn) : chunkZ);
        return chunkPos1;
    }

    private final int getChunkOffset(ServerLevel levelIn) {
        int offSet = levelIn.f_46441_.m_188503_(8) + 1;
        return levelIn.f_46441_.m_188499_() ? offSet : -offSet;
    }

    private final BlockPos getSpawnPos(ServerLevel levelIn, ChunkPos chunkPosIn, ServerPlayer playerIn, EntityType<?> entityTypeIn, boolean isSurfaceIn, boolean relocateIn) {
        int x = chunkPosIn.m_45604_() + levelIn.f_46441_.m_188503_(16);
        int z = chunkPosIn.m_45605_() + levelIn.f_46441_.m_188503_(16);
        int surface = levelIn.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z);
        if (isSurfaceIn) {
            return new BlockPos(x, surface, z);
        }
        ArrayList<Integer> posList = new ArrayList<Integer>();
        for (int y = levelIn.m_141937_(); y <= surface; ++y) {
            BlockPos pos = new BlockPos(x, y, z);
            if (!(entityTypeIn == null ? !levelIn.m_8055_(pos).m_60795_() && levelIn.m_8055_(pos.m_7494_()).m_60795_() : SpawnPlacements.m_21752_(entityTypeIn).canSpawnAt((LevelReader)levelIn, pos, entityTypeIn))) continue;
            posList.add(pos.m_123342_());
        }
        return new BlockPos(x, SpawnPosChart.getYInRange(posList, playerIn.m_146904_(), levelIn.f_46441_.m_188501_(), relocateIn), z);
    }

    public static final Invasion load(ServerLevel levelIn, CompoundTag nbtIn) {
        if (!PSReloadListeners.getInvasionTypeManager().verifyInvasion(nbtIn.m_128461_("InvasionType"))) {
            return null;
        }
        InvasionType invasionType = PSReloadListeners.getInvasionTypeManager().getInvasionType(ResourceLocation.m_135820_((String)nbtIn.m_128461_("InvasionType")));
        Invasion invasion = new Invasion(levelIn, invasionType, nbtIn.m_128451_("Severity"), nbtIn.m_128471_("IsPrimary"), nbtIn.m_128471_("IsNatural"), nbtIn.m_128454_("StartTime"), nbtIn.m_128451_("Index"));
        invasion.spawnDelay = nbtIn.m_128451_("SpawnDelay");
        return invasion;
    }

    public final CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("InvasionType", this.invasionType.toString());
        nbt.m_128405_("Severity", this.severity);
        nbt.m_128379_("IsPrimary", this.isPrimary);
        nbt.m_128379_("IsNatural", this.isNatural);
        nbt.m_128356_("StartTime", this.startTime);
        nbt.m_128405_("Index", this.index);
        nbt.m_128405_("SpawnDelay", this.spawnDelay);
        return nbt;
    }

    public final String toString() {
        return this.invasionType.toString();
    }

    public final boolean equals(Object objIn) {
        if (objIn instanceof Invasion) {
            Invasion inv = (Invasion)objIn;
            return this.invasionType.toString().equals(inv.invasionType.toString()) && this.severity == inv.severity && this.isPrimary == inv.isPrimary && this.isNatural == inv.isNatural && this.startTime == inv.startTime && this.index == inv.index;
        }
        return false;
    }

    private static final class MobInfo {
        private UUID uuid;
        private boolean relocate;

        private MobInfo(UUID uuidIn, Boolean relocateIn) {
            this.uuid = uuidIn;
            this.relocate = relocateIn;
        }
    }

    public static final class BuildInfo
    implements InvasionTypeHolder {
        private final InvasionType invasionType;
        private final int severity;
        private final boolean isPrimary;

        public BuildInfo(InvasionType invasionTypeIn, int severityIn, boolean isPrimaryIn) {
            this.invasionType = invasionTypeIn;
            this.severity = severityIn;
            this.isPrimary = isPrimaryIn;
        }

        @Override
        public final InvasionType getType() {
            return this.invasionType;
        }

        public final boolean isPrimary() {
            return this.isPrimary;
        }

        public static final BuildInfo load(ServerLevel levelIn, CompoundTag nbtIn) {
            InvasionType invasionType = PSReloadListeners.getInvasionTypeManager().getInvasionType(ResourceLocation.m_135820_((String)nbtIn.m_128461_("InvasionType")));
            int severity = nbtIn.m_128451_("Severity");
            boolean isPrimary = nbtIn.m_128471_("IsPrimary");
            return new BuildInfo(invasionType, severity, isPrimary);
        }

        public final CompoundTag save() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("InvasionType", this.invasionType.toString());
            nbt.m_128405_("Severity", this.severity);
            nbt.m_128379_("IsPrimary", this.isPrimary);
            return nbt;
        }

        public final Invasion build(ServerLevel levelIn, int indexIn) {
            return new Invasion(levelIn, this.invasionType, this.severity, this.isPrimary, false, levelIn.m_46468_(), indexIn);
        }
    }
}

