/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.invasion;

import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.invasion.InvasionSessionType;
import dev.theagameplayer.puresuffering.registries.PSSoundEvents;
import dev.theagameplayer.puresuffering.registries.other.PSGameRules;
import dev.theagameplayer.puresuffering.util.PSRGB;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum InvasionDifficulty {
    DEFAULT("Default", (int)ChatFormatting.RED.m_126665_(), (int)ChatFormatting.DARK_RED.m_126665_(), (RegistryObject)PSSoundEvents.DEFAULT_INVASION_START, ParticleTypes.f_123762_, ParticleTypes.f_123744_, 20, 4){

        @Override
        public final int getHyperCharge(ServerLevel levelIn, int tierIn, boolean isNaturalIn) {
            if (PSGameRules.TIERED_INVASIONS.get((Level)levelIn) && isNaturalIn) {
                int maxCharge = (int)levelIn.m_46468_() / (24000 * InvasionSessionType.getActive(levelIn).getTierIncreaseDelay(levelIn)) - tierIn;
                if (maxCharge < 1) {
                    return 0;
                }
                return levelIn.f_46441_.m_188503_(levelIn.f_46441_.m_188503_(Math.min(maxCharge, 3)) + 1) + 1;
            }
            return levelIn.f_46441_.m_188503_(levelIn.f_46441_.m_188503_(3) + 1) + 1;
        }

        @Override
        public final boolean isAllowed(Level levelIn) {
            return levelIn.m_46791_() != Difficulty.PEACEFUL && PSGameRules.ENABLE_INVASIONS.get(levelIn);
        }

        @Override
        public final int getRarity(ServerLevel levelIn, int invasionRarityIn) {
            return invasionRarityIn;
        }

        @Override
        public final int getInvasionCount(RandomSource randomIn, int maxInvasionsIn) {
            return randomIn.m_188503_(maxInvasionsIn) + 1;
        }
    }
    ,
    HYPER("Hyper", (int)ChatFormatting.RED.m_126665_(), (int)ChatFormatting.DARK_RED.m_126665_(), (RegistryObject)PSSoundEvents.HYPER_INVASION_START, ParticleTypes.f_123746_, ParticleTypes.f_123744_, 25, 2){

        @Override
        public final int getHyperCharge(ServerLevel levelIn, int tierIn, boolean isNaturalIn) {
            return Math.max(levelIn.f_46441_.m_188503_(3), levelIn.f_46441_.m_188503_(3)) + 1;
        }

        @Override
        public final boolean isAllowed(Level levelIn) {
            return DEFAULT.isAllowed(levelIn) && levelIn.m_46791_() != Difficulty.EASY && PSGameRules.HYPER_CHARGE.get(levelIn) && PSGameRules.ENABLE_HYPER_INVASIONS.get(levelIn);
        }

        @Override
        public final int getRarity(ServerLevel levelIn, int invasionRarityIn) {
            return PSConfigValues.LEVELS.get((Object)levelIn).invasionDifficultyRarity[0];
        }

        @Override
        public final int getInvasionCount(RandomSource randomIn, int maxInvasionsIn) {
            return Math.max(randomIn.m_188503_(maxInvasionsIn), randomIn.m_188503_(maxInvasionsIn)) + 1;
        }
    }
    ,
    NIGHTMARE("Nightmare", (ChatFormatting.DARK_PURPLE.m_126665_() + ChatFormatting.DARK_RED.m_126665_()) / 2, (ChatFormatting.DARK_PURPLE.m_126665_() + ChatFormatting.DARK_RED.m_126665_()) / 3, (RegistryObject)PSSoundEvents.NIGHTMARE_INVASION_START, ParticleTypes.f_235898_, ParticleTypes.f_123745_, 30, 1){

        @Override
        public final int getHyperCharge(ServerLevel levelIn, int tierIn, boolean isNaturalIn) {
            return 4;
        }

        @Override
        public final boolean isAllowed(Level levelIn) {
            return HYPER.isAllowed(levelIn) && PSGameRules.ENABLE_NIGHTMARE_INVASIONS.get(levelIn);
        }

        @Override
        public final int getRarity(ServerLevel levelIn, int invasionRarityIn) {
            return PSConfigValues.LEVELS.get((Object)levelIn).invasionDifficultyRarity[1];
        }

        @Override
        public final int getInvasionCount(RandomSource randomIn, int maxInvasionsIn) {
            return Math.max(HYPER.getInvasionCount(randomIn, maxInvasionsIn), randomIn.m_188503_(maxInvasionsIn));
        }
    };

    private final String name;
    private final MutableComponent translation;
    private final int color1;
    private final int color2;
    private final RegistryObject<SoundEvent> startSound;
    private final SimpleParticleType p1;
    private final SimpleParticleType p2;
    private final int particleCount;
    private final int ringDelay;

    private InvasionDifficulty(String nameIn, int color1n, int color2n, RegistryObject<SoundEvent> startSoundIn, SimpleParticleType p1n, SimpleParticleType p2n, int particleCountIn, int ringDelayIn) {
        this.name = nameIn;
        this.translation = Component.m_237115_((String)("puresuffering.invasionDifficulty." + this.toString()));
        this.color1 = color1n;
        this.color2 = color2n;
        this.startSound = startSoundIn;
        this.p1 = p1n;
        this.p2 = p2n;
        this.particleCount = particleCountIn;
        this.ringDelay = ringDelayIn;
    }

    public final String toString() {
        return super.toString().toLowerCase();
    }

    public final String getDefaultName() {
        return this.name;
    }

    public final String getTranslation() {
        return this.translation.m_130668_(256);
    }

    public final int getColor(boolean isFirstIn) {
        return isFirstIn ? this.color1 : this.color2;
    }

    public final PSRGB getInterColor(int divIn, int multIn) {
        return new PSRGB(this.color1, this.color2, divIn, multIn);
    }

    public final PSRGB getRandomColor(RandomSource randomIn) {
        return new PSRGB(randomIn, this.color1, this.color2);
    }

    public final SoundEvent getStartSound() {
        return (SoundEvent)this.startSound.get();
    }

    public final SimpleParticleType getSpawnParticleType(boolean isFirstIn) {
        return isFirstIn ? this.p1 : this.p2;
    }

    public final int getParticleCount() {
        return this.particleCount;
    }

    public final int getRingDelay() {
        return this.ringDelay;
    }

    public final boolean isHyper() {
        return this != DEFAULT;
    }

    public final boolean isNightmare() {
        return this.ordinal() > HYPER.ordinal();
    }

    public abstract int getHyperCharge(ServerLevel var1, int var2, boolean var3);

    public abstract boolean isAllowed(Level var1);

    public abstract int getRarity(ServerLevel var1, int var2);

    public abstract int getInvasionCount(RandomSource var1, int var2);
}

