/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.invasion;

import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.invasion.InvasionDifficulty;
import dev.theagameplayer.puresuffering.invasion.InvasionSessionType;
import dev.theagameplayer.puresuffering.invasion.InvasionType;
import dev.theagameplayer.puresuffering.network.PSPacketHandler;
import dev.theagameplayer.puresuffering.network.packet.AddInvasionPacket;
import dev.theagameplayer.puresuffering.network.packet.ClearInvasionsPacket;
import dev.theagameplayer.puresuffering.network.packet.RemoveInvasionPacket;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Mob;

public final class InvasionSession
implements Iterable<Invasion> {
    private final ArrayList<Invasion> invasions = new ArrayList();
    private final InvasionSessionType sessionType;
    private final InvasionDifficulty difficulty;
    private final Style style;
    private InvasionType.WeatherType weatherType = InvasionType.WeatherType.DEFAULT;
    private int weatherChangeDelay;
    private int lightLevel;
    private boolean stopsConversions;
    private boolean forceNoSleep;

    public InvasionSession(InvasionSessionType sessionTypeIn, InvasionDifficulty difficultyIn) {
        this.sessionType = sessionTypeIn;
        this.difficulty = difficultyIn;
        this.style = Style.f_131099_.m_131136_(Boolean.valueOf(difficultyIn.isHyper())).m_131155_(Boolean.valueOf(difficultyIn.isNightmare()));
    }

    public final Invasion getPrimary() {
        return this.invasions.get(0);
    }

    public final InvasionSessionType getSessionType() {
        return this.sessionType;
    }

    public final InvasionDifficulty getDifficulty() {
        return this.difficulty;
    }

    public final Style getStyle() {
        return this.style;
    }

    public final boolean replaceMob(Mob oldMobIn, Mob mobIn) {
        for (Invasion invasion : this.invasions) {
            if (!invasion.hasMob(oldMobIn)) continue;
            invasion.replaceMob(oldMobIn, mobIn);
            return true;
        }
        return false;
    }

    public final void relocateMob(Mob mobIn) {
        for (Invasion invasion : this.invasions) {
            if (!invasion.hasMob(mobIn)) continue;
            invasion.relocateMob(mobIn);
        }
    }

    public final boolean hasMob(Mob mobIn) {
        for (Invasion invasion : this.invasions) {
            if (!invasion.hasMob(mobIn)) continue;
            return true;
        }
        return false;
    }

    public final void loadMob(Mob mobIn) {
        for (Invasion invasion : this.invasions) {
            if (!invasion.loadMob(mobIn)) continue;
            return;
        }
    }

    private final void update() {
        this.weatherType = InvasionType.WeatherType.DEFAULT;
        this.stopsConversions = false;
        this.forceNoSleep = this.difficulty.isNightmare();
        int lightLevel = 0;
        int lc = 0;
        for (Invasion invasion : this.invasions) {
            int ll;
            if (this.weatherType == InvasionType.WeatherType.DEFAULT) {
                this.weatherType = invasion.getType().getWeatherType();
            }
            this.stopsConversions |= invasion.getType().stopsConversions();
            this.forceNoSleep |= invasion.getSeverityInfo().forcesNoSleep();
            if (this.difficulty.isNightmare() || (ll = invasion.getSeverityInfo().getSkyRenderInfo().getLightLevel()) < 0) continue;
            lightLevel += ll;
            ++lc;
        }
        this.lightLevel = this.difficulty.isNightmare() ? 15 : (lc > 0 ? lightLevel / lc : -1);
    }

    public final boolean stopOrTick(ServerLevel levelIn) {
        if (this.invasions.isEmpty()) {
            return true;
        }
        switch (this.weatherType) {
            case DEFAULT: {
                break;
            }
            case CLEAR: {
                if (!levelIn.m_46471_() && !levelIn.m_46470_()) break;
                levelIn.m_8606_(12000 - (int)(levelIn.m_8044_() % 12000L), 0, false, false);
                break;
            }
            case RAIN: {
                if (levelIn.m_46471_()) break;
                levelIn.m_8606_(0, 12000 - (int)(levelIn.m_8044_() % 12000L), true, false);
                break;
            }
            case THUNDER: {
                if (levelIn.m_46470_()) break;
                levelIn.m_8606_(0, 12000 - (int)(levelIn.m_8044_() % 12000L), true, true);
                break;
            }
            case UNSTABLE: {
                if (this.weatherChangeDelay < 0) {
                    int type = levelIn.f_46441_.m_188503_(5);
                    int time = Math.min(150 + levelIn.f_46441_.m_188503_(301), 12000 - (int)(levelIn.m_8044_() % 12000L));
                    levelIn.m_8606_(type < 2 ? time : 0, type < 2 ? 0 : time, type == 2, type > 2);
                    this.weatherChangeDelay = time;
                    break;
                }
                --this.weatherChangeDelay;
            }
        }
        this.invasions.get((int)(levelIn.m_46468_() % (long)this.invasions.size())).tick(levelIn, this.difficulty, this.invasions.size());
        return false;
    }

    public final boolean stopsConversions() {
        return this.stopsConversions;
    }

    public final boolean forcesNoSleep() {
        return this.forceNoSleep;
    }

    public final int getLightLevelOrDefault(int lightLevelIn) {
        return this.lightLevel > 0 ? this.lightLevel : lightLevelIn;
    }

    public static final InvasionSession load(ServerLevel levelIn, CompoundTag nbtIn) {
        InvasionSession session = new InvasionSession(InvasionSessionType.getActive(levelIn), InvasionDifficulty.values()[nbtIn.m_128451_("Difficulty")]);
        ListTag invasionsNBT = nbtIn.m_128437_(session.sessionType.getDefaultName() + "Invasions", 10);
        for (Tag inbt : invasionsNBT) {
            if (!(inbt instanceof CompoundTag)) continue;
            CompoundTag nbt = (CompoundTag)inbt;
            session.add(levelIn, Invasion.load(levelIn, nbt));
        }
        return session;
    }

    public final CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        ListTag invasionsNBT = new ListTag();
        nbt.m_128405_("Difficulty", this.difficulty.ordinal());
        for (Invasion invasion : this.invasions) {
            invasionsNBT.add((Object)invasion.save());
        }
        nbt.m_128365_(this.sessionType.getDefaultName() + "Invasions", (Tag)invasionsNBT);
        return nbt;
    }

    public final void add(ServerLevel levelIn, Invasion invasionIn) {
        this.invasions.add(invasionIn);
        this.update();
        PSPacketHandler.sendToClientsIn(new AddInvasionPacket(this.sessionType, this.difficulty, invasionIn), levelIn);
    }

    public final void remove(ServerLevel levelIn, Invasion invasionIn) {
        if (invasionIn.isPrimary()) {
            this.clear(levelIn);
            return;
        }
        this.invasions.remove(invasionIn);
        this.update();
        PSPacketHandler.sendToClientsIn(new RemoveInvasionPacket(invasionIn.getSeverityInfo().getSkyRenderInfo()), levelIn);
    }

    public final void clear(ServerLevel levelIn) {
        this.invasions.clear();
        PSPacketHandler.sendToClientsIn(new ClearInvasionsPacket(), levelIn);
    }

    public final void updateClient(ServerPlayer playerIn) {
        PSPacketHandler.sendToClient(new ClearInvasionsPacket(), playerIn);
        for (int index = 0; index < this.invasions.size(); ++index) {
            Invasion invasion = this.invasions.get(index);
            PSPacketHandler.sendToClient(new AddInvasionPacket(this.sessionType, this.difficulty, invasion), playerIn);
        }
    }

    public final String toString() {
        return this.invasions.toString();
    }

    @Override
    public final Iterator<Invasion> iterator() {
        return this.invasions.iterator();
    }
}

