/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.invasion;

import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.invasion.InvasionType;
import dev.theagameplayer.puresuffering.registries.other.PSGameRules;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum InvasionSessionType {
    DAY("Day", (it, modified) -> modified.booleanValue() ? it != InvasionType.InvasionTime.DAY : it != InvasionType.InvasionTime.NIGHT, tm -> tm == InvasionType.TimeModifier.DAY_TO_NIGHT, tc -> tc != InvasionType.TimeChangeability.ONLY_NIGHT){

        @Override
        public final int getMaxPossibleInvasions(ServerLevel levelIn) {
            return Mth.m_14045_((int)((int)(levelIn.m_46468_() / (24000L * (long)this.getTierIncreaseDelay(levelIn))) + 1), (int)0, (int)PSConfigValues.LEVELS.get((Object)levelIn).maxInvasions[0]);
        }

        @Override
        public final int getRarity(ServerLevel levelIn) {
            return PSConfigValues.LEVELS.get((Object)levelIn).invasionSessionTypeRarity[0];
        }

        @Override
        public final int getTierIncreaseDelay(ServerLevel levelIn) {
            return PSConfigValues.LEVELS.get((Object)levelIn).tierIncreaseDelay[0];
        }

        @Override
        public final boolean canBeCanceled(ServerLevel levelIn) {
            return PSGameRules.CANCELABLE_INVASIONS.get((Level)levelIn) && PSConfigValues.LEVELS.get((Object)levelIn).cancelableInvasions[0];
        }

        @Override
        public final int getCancelRarity(ServerLevel levelIn) {
            return PSConfigValues.LEVELS.get((Object)levelIn).cancelInvasionRarity[0];
        }
    }
    ,
    NIGHT("Night", (it, modified) -> modified.booleanValue() ? it != InvasionType.InvasionTime.NIGHT : it != InvasionType.InvasionTime.DAY, tm -> tm == InvasionType.TimeModifier.NIGHT_TO_DAY, tc -> tc != InvasionType.TimeChangeability.ONLY_DAY){

        @Override
        public final int getMaxPossibleInvasions(ServerLevel levelIn) {
            return Mth.m_14045_((int)((int)(levelIn.m_46468_() / (24000L * (long)this.getTierIncreaseDelay(levelIn))) + 1), (int)0, (int)PSConfigValues.LEVELS.get((Object)levelIn).maxInvasions[1]);
        }

        @Override
        public final int getRarity(ServerLevel levelIn) {
            return PSConfigValues.LEVELS.get((Object)levelIn).invasionSessionTypeRarity[1];
        }

        @Override
        public final int getTierIncreaseDelay(ServerLevel levelIn) {
            return PSConfigValues.LEVELS.get((Object)levelIn).tierIncreaseDelay[1];
        }

        @Override
        public final boolean canBeCanceled(ServerLevel levelIn) {
            return PSGameRules.CANCELABLE_INVASIONS.get((Level)levelIn) && PSConfigValues.LEVELS.get((Object)levelIn).cancelableInvasions[1];
        }

        @Override
        public final int getCancelRarity(ServerLevel levelIn) {
            return PSConfigValues.LEVELS.get((Object)levelIn).cancelInvasionRarity[1];
        }
    }
    ,
    FIXED("Fixed", (it, modified) -> true, tm -> false, tc -> true){

        @Override
        public final int getMaxPossibleInvasions(ServerLevel levelIn) {
            return Mth.m_14045_((int)((int)(levelIn.m_46468_() / (24000L * (long)this.getTierIncreaseDelay(levelIn))) + 1), (int)0, (int)PSConfigValues.LEVELS.get((Object)levelIn).maxInvasions[0]);
        }

        @Override
        public final int getRarity(ServerLevel levelIn) {
            return PSConfigValues.LEVELS.get((Object)levelIn).invasionSessionTypeRarity[0];
        }

        @Override
        public final int getTierIncreaseDelay(ServerLevel levelIn) {
            return PSConfigValues.LEVELS.get((Object)levelIn).tierIncreaseDelay[0];
        }

        @Override
        public final boolean canBeCanceled(ServerLevel levelIn) {
            return PSGameRules.CANCELABLE_INVASIONS.get((Level)levelIn) && PSConfigValues.LEVELS.get((Object)levelIn).cancelableInvasions[0];
        }

        @Override
        public final int getCancelRarity(ServerLevel levelIn) {
            return PSConfigValues.LEVELS.get((Object)levelIn).cancelInvasionRarity[0];
        }
    };

    private final String name;
    private final MutableComponent translation;
    private final BiPredicate<InvasionType.InvasionTime, Boolean> isAcceptableTime;
    private final Predicate<InvasionType.TimeModifier> canModifyTime;
    private final Predicate<InvasionType.TimeChangeability> canBeChanged;

    private InvasionSessionType(String nameIn, BiPredicate<InvasionType.InvasionTime, Boolean> isAcceptableTimeIn, Predicate<InvasionType.TimeModifier> canModifyTimeIn, Predicate<InvasionType.TimeChangeability> canBeChangedIn) {
        this.name = nameIn;
        this.translation = Component.m_237115_((String)("puresuffering.invasionSessionType." + this.toString()));
        this.isAcceptableTime = isAcceptableTimeIn;
        this.canModifyTime = canModifyTimeIn;
        this.canBeChanged = canBeChangedIn;
    }

    public final String toString() {
        return super.toString().toLowerCase();
    }

    public final String getDefaultName() {
        return this.name;
    }

    public final String getTranslation() {
        return this.translation.m_130668_(256);
    }

    public final boolean isAcceptableTime(InvasionType invasionTypeIn, boolean isTimeModifiedIn) {
        return this.isAcceptableTime.test(invasionTypeIn.getInvasionTime(), isTimeModifiedIn);
    }

    public final boolean canModifyTime(InvasionType invasionTypeIn) {
        return this.canModifyTime.test(invasionTypeIn.getTimeModifier());
    }

    public final boolean canBeChanged(InvasionType invasionTypeIn) {
        return this.canBeChanged.test(invasionTypeIn.getTimeChangeability());
    }

    public abstract int getMaxPossibleInvasions(ServerLevel var1);

    public abstract int getRarity(ServerLevel var1);

    public abstract int getTierIncreaseDelay(ServerLevel var1);

    public abstract boolean canBeCanceled(ServerLevel var1);

    public abstract int getCancelRarity(ServerLevel var1);

    public static final InvasionSessionType getActive(ServerLevel levelIn) {
        return levelIn.m_6042_().m_63967_() ? FIXED : (levelIn.m_46468_() % 24000L < 12000L ? DAY : NIGHT);
    }

    public static final InvasionSessionType getInactive(ServerLevel levelIn) {
        return levelIn.m_6042_().m_63967_() ? FIXED : (levelIn.m_46468_() % 24000L < 12000L ? NIGHT : DAY);
    }
}

