/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.invasion;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.theagameplayer.puresuffering.PureSufferingMod;
import dev.theagameplayer.puresuffering.client.invasion.InvasionSkyRenderInfo;
import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.invasion.data.AdditionalEntitySpawnData;
import dev.theagameplayer.puresuffering.invasion.data.InvasionSpawnerData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;

public final class InvasionType {
    private static final Logger LOGGER = PureSufferingMod.LOGGER;
    private final ResourceLocation id;
    private final boolean overridesExisting;
    private final String defaultName;
    private final int rarity;
    private final int tier;
    private final boolean stopConversions;
    private final InvasionTime invasionTime;
    private final InvasionPriority invasionPriority;
    private final SpawningSystem spawningSystem;
    private final TimeModifier timeModifier;
    private final TimeChangeability timeChangeability;
    private final WeatherType weatherType;
    private final DayNightCycleRequirement dayNightCycleRequirement;
    private final List<SeverityInfo> severityInfo;
    private final List<ResourceLocation> dimensions;
    private final Component component;

    public InvasionType(ResourceLocation idIn, boolean overridesExistingIn, String defaultNameIn, int rarityIn, int tierIn, boolean stopConversionsIn, InvasionTime invasionTimeIn, InvasionPriority invasionPriorityIn, SpawningSystem spawningSystemIn, TimeModifier timeModifierIn, TimeChangeability timeChangeabilityIn, WeatherType weatherTypeIn, DayNightCycleRequirement dayNightCycleRequirementIn, List<SeverityInfo> severityInfoIn, List<ResourceLocation> dimensionsIn) {
        this.id = idIn;
        this.overridesExisting = overridesExistingIn;
        this.defaultName = defaultNameIn;
        this.rarity = rarityIn;
        this.tier = tierIn;
        this.stopConversions = stopConversionsIn;
        this.invasionTime = invasionTimeIn;
        this.invasionPriority = invasionPriorityIn;
        this.spawningSystem = spawningSystemIn;
        this.timeModifier = timeModifierIn;
        this.timeChangeability = timeChangeabilityIn;
        this.weatherType = weatherTypeIn;
        this.dayNightCycleRequirement = dayNightCycleRequirementIn;
        this.severityInfo = severityInfoIn;
        this.dimensions = dimensionsIn;
        String text = "invasion." + idIn.m_135827_() + "." + idIn.m_135815_();
        MutableComponent component = Component.m_237115_((String)text);
        this.component = component.getString().equals(text) && defaultNameIn != null ? Component.m_237113_((String)defaultNameIn) : component;
    }

    public final Builder deconstruct() {
        ArrayList<SeverityInfo.Builder> severityInfo = new ArrayList<SeverityInfo.Builder>();
        for (SeverityInfo info : this.severityInfo) {
            severityInfo.add(info.deconstruct());
        }
        return new Builder(this.overridesExisting, this.defaultName, this.rarity, this.tier, this.stopConversions, this.invasionTime, this.invasionPriority, this.spawningSystem, this.timeModifier, this.timeChangeability, this.weatherType, this.dayNightCycleRequirement, severityInfo, this.dimensions);
    }

    public final ResourceLocation getId() {
        return this.id;
    }

    public final boolean overridesExisting() {
        return this.overridesExisting;
    }

    public final int getRarity() {
        return this.rarity;
    }

    public final int getTier() {
        return this.tier;
    }

    public final boolean stopsConversions() {
        return this.stopConversions;
    }

    public final InvasionTime getInvasionTime() {
        return this.invasionTime;
    }

    public final InvasionPriority getInvasionPriority() {
        return this.invasionPriority;
    }

    public final SpawningSystem getSpawningSystem() {
        return this.spawningSystem;
    }

    public final TimeModifier getTimeModifier() {
        return this.timeModifier;
    }

    public final TimeChangeability getTimeChangeability() {
        return this.timeChangeability;
    }

    public final WeatherType getWeatherType() {
        return this.weatherType;
    }

    public final DayNightCycleRequirement getDayNightCycleRequirement() {
        return this.dayNightCycleRequirement;
    }

    public final List<SeverityInfo> getSeverityInfo() {
        return this.severityInfo;
    }

    public final List<ResourceLocation> getDimensions() {
        return this.dimensions;
    }

    public final Component getComponent() {
        return this.component;
    }

    public final int getMaxSeverity() {
        return this.severityInfo.size();
    }

    public final String toString() {
        return this.id.toString();
    }

    public static enum InvasionTime {
        BOTH,
        NIGHT,
        DAY;

    }

    public static enum InvasionPriority {
        BOTH,
        PRIMARY_ONLY,
        SECONDARY_ONLY;

    }

    public static enum SpawningSystem {
        DEFAULT,
        BIOME_BOOSTED,
        BIOME_MIXED;

    }

    public static enum TimeModifier {
        NONE,
        DAY_TO_NIGHT,
        NIGHT_TO_DAY;

    }

    public static enum TimeChangeability {
        DEFAULT,
        ONLY_NIGHT,
        ONLY_DAY;

    }

    public static enum WeatherType {
        DEFAULT,
        CLEAR,
        RAIN,
        THUNDER,
        UNSTABLE;

    }

    public static enum DayNightCycleRequirement {
        NONE(dimType -> true),
        NEEDS_CYCLE(dimType -> !dimType.m_63967_()),
        NO_CYCLE(dimType -> dimType.m_63967_());

        private final Predicate<DimensionType> requirement;

        private DayNightCycleRequirement(Predicate<DimensionType> requirementIn) {
            this.requirement = requirementIn;
        }

        public final boolean meetsRequirement(LevelStem levelStemIn, String modDimIn) {
            if (levelStemIn == null || !levelStemIn.f_63975_().m_203633_()) {
                LOGGER.warn("Could not find dimension with id, likely typed it wrong in Config: " + modDimIn);
            }
            return this.requirement.test((DimensionType)levelStemIn.f_63975_().m_203334_());
        }
    }

    public static final class SeverityInfo {
        private final InvasionSkyRenderInfo skyRenderInfo;
        private final List<InvasionSpawnerData> mobSpawnList;
        private final List<AdditionalEntitySpawnData> additionalEntitiesList;
        private final float mobCapPercentage;
        private final int fixedMobCap;
        private final boolean forceNoSleep;
        private final int tickDelay;
        private final int clusterSize;

        private SeverityInfo(InvasionSkyRenderInfo skyRenderInfoIn, List<InvasionSpawnerData> mobSpawnListIn, List<AdditionalEntitySpawnData> additionalEntitiesListIn, float mobCapPercentageIn, int fixedMobCapIn, boolean forceNoSleepIn, int tickDelayIn, int clusterSizeIn) {
            this.skyRenderInfo = skyRenderInfoIn;
            this.mobSpawnList = mobSpawnListIn;
            this.additionalEntitiesList = additionalEntitiesListIn;
            this.mobCapPercentage = mobCapPercentageIn;
            this.fixedMobCap = fixedMobCapIn;
            this.forceNoSleep = forceNoSleepIn;
            this.tickDelay = tickDelayIn;
            this.clusterSize = clusterSizeIn;
        }

        public final Builder deconstruct() {
            return new Builder(this.skyRenderInfo == null ? null : this.skyRenderInfo.deconstruct(), this.mobSpawnList, this.additionalEntitiesList, this.mobCapPercentage, this.fixedMobCap, this.forceNoSleep, this.tickDelay, this.clusterSize);
        }

        public final InvasionSkyRenderInfo getSkyRenderInfo() {
            return this.skyRenderInfo;
        }

        public final List<InvasionSpawnerData> getMobSpawnList() {
            return this.mobSpawnList;
        }

        public final List<AdditionalEntitySpawnData> getClusterEntities() {
            return this.additionalEntitiesList;
        }

        public final float getMobCapPercentage() {
            return this.mobCapPercentage;
        }

        public final int getFixedMobCap() {
            return this.fixedMobCap;
        }

        public final boolean forcesNoSleep() {
            return this.forceNoSleep;
        }

        public final int getTickDelay() {
            return this.tickDelay;
        }

        public final int getClusterSize() {
            return this.clusterSize;
        }

        public static final class Builder {
            private InvasionSkyRenderInfo.Builder skyRenderInfo = null;
            private List<InvasionSpawnerData> mobSpawnList;
            private List<AdditionalEntitySpawnData> additionalEntitiesList;
            private float mobCapPercentage = 1.0f;
            private int fixedMobCap = 0;
            private boolean forceNoSleep = false;
            private int tickDelay = -1;
            private int clusterSize = 1;

            private Builder(InvasionSkyRenderInfo.Builder skyRenderInfoIn, List<InvasionSpawnerData> mobSpawnListIn, List<AdditionalEntitySpawnData> additionalEntitiesListIn, float mobCapPercentageIn, int fixedMobCapIn, boolean forceNoSleepIn, int tickDelayIn, int clusterSizeIn) {
                this.skyRenderInfo = skyRenderInfoIn;
                this.mobSpawnList = mobSpawnListIn;
                this.additionalEntitiesList = additionalEntitiesListIn;
                this.mobCapPercentage = mobCapPercentageIn;
                this.fixedMobCap = fixedMobCapIn;
                this.forceNoSleep = forceNoSleepIn;
                this.tickDelay = tickDelayIn;
                this.clusterSize = clusterSizeIn;
            }

            private Builder() {
            }

            public static final Builder severityInfo() {
                return new Builder();
            }

            public final Builder skyRenderInfo(InvasionSkyRenderInfo.Builder skyRenderInfoIn) {
                this.skyRenderInfo = skyRenderInfoIn;
                return this;
            }

            public final Builder mobSpawnList(InvasionSpawnerData ... mobSpawnListIn) {
                this.mobSpawnList = List.of(mobSpawnListIn);
                return this;
            }

            public final Builder additionalEntitiesList(AdditionalEntitySpawnData ... additionalEntitiesListIn) {
                this.additionalEntitiesList = List.of(additionalEntitiesListIn);
                return this;
            }

            public final Builder setMobCapMultiplier(float mobCapPercentageIn) {
                this.mobCapPercentage = mobCapPercentageIn;
                return this;
            }

            public final Builder setFixedMobCap(int fixedMobCapIn) {
                this.fixedMobCap = fixedMobCapIn;
                return this;
            }

            public final Builder setForcesNoSleep() {
                this.forceNoSleep = true;
                return this;
            }

            public final Builder withTickDelay(int tickDelayIn) {
                this.tickDelay = tickDelayIn;
                return this;
            }

            public final Builder withClusterSize(int clusterSizeIn) {
                this.clusterSize = clusterSizeIn;
                return this;
            }

            public final SeverityInfo build(ResourceLocation idIn) {
                return new SeverityInfo(this.skyRenderInfo == null ? InvasionSkyRenderInfo.Builder.skyRenderInfo().build(idIn) : this.skyRenderInfo.build(idIn), this.mobSpawnList, this.additionalEntitiesList, this.mobCapPercentage, this.fixedMobCap, this.forceNoSleep, this.tickDelay, this.clusterSize);
            }

            public final JsonObject serializeToJson() {
                JsonObject jsonObject1;
                JsonArray jsonArray;
                JsonObject jsonObject = new JsonObject();
                if (this.skyRenderInfo != null) {
                    jsonObject.add("SkyRenderInfo", (JsonElement)this.skyRenderInfo.serializeToJson());
                }
                if (this.mobSpawnList != null) {
                    jsonArray = new JsonArray();
                    for (InvasionSpawnerData invasionSpawnerData : this.mobSpawnList) {
                        jsonObject1 = new JsonObject();
                        jsonObject1.addProperty("EntityType", ForgeRegistries.ENTITY_TYPES.getKey(invasionSpawnerData.type).toString());
                        jsonObject1.addProperty("Weight", (Number)invasionSpawnerData.m_142631_().m_146281_());
                        jsonObject1.addProperty("MinCount", (Number)invasionSpawnerData.minCount);
                        jsonObject1.addProperty("MaxCount", (Number)invasionSpawnerData.maxCount);
                        if (invasionSpawnerData.ignoreSpawnRules) {
                            jsonObject1.addProperty("IgnoreSpawnRules", Boolean.valueOf(invasionSpawnerData.ignoreSpawnRules));
                        }
                        if (invasionSpawnerData.forceDespawn) {
                            jsonObject1.addProperty("ForceDespawn", Boolean.valueOf(invasionSpawnerData.forceDespawn));
                        }
                        jsonArray.add((JsonElement)jsonObject1);
                    }
                    jsonObject.add("MobSpawnList", (JsonElement)jsonArray);
                }
                if (this.additionalEntitiesList != null) {
                    jsonArray = new JsonArray();
                    for (AdditionalEntitySpawnData additionalEntitySpawnData : this.additionalEntitiesList) {
                        jsonObject1 = new JsonObject();
                        jsonObject1.addProperty("EntityType", ForgeRegistries.ENTITY_TYPES.getKey(additionalEntitySpawnData.getEntityType()).toString());
                        jsonObject1.addProperty("MinCount", (Number)additionalEntitySpawnData.getMinCount());
                        jsonObject1.addProperty("MaxCount", (Number)additionalEntitySpawnData.getMaxCount());
                        jsonObject1.addProperty("Chance", (Number)additionalEntitySpawnData.getChance());
                        if (additionalEntitySpawnData.isSurfaceSpawn()) {
                            jsonObject1.addProperty("IsSurfaceSpawn", Boolean.valueOf(true));
                        }
                        jsonArray.add((JsonElement)jsonObject1);
                    }
                    jsonObject.add("AdditionalEntitiesList", (JsonElement)jsonArray);
                }
                if (this.mobCapPercentage > 0.0f) {
                    jsonObject.addProperty("MobCapPercentage", (Number)Float.valueOf(this.mobCapPercentage));
                }
                if (this.fixedMobCap > 0) {
                    jsonObject.addProperty("FixedMobCap", (Number)this.fixedMobCap);
                }
                if (this.forceNoSleep) {
                    jsonObject.addProperty("ForceNoSleep", Boolean.valueOf(this.forceNoSleep));
                }
                jsonObject.addProperty("TickDelay", (Number)this.tickDelay);
                if (this.clusterSize > 1) {
                    jsonObject.addProperty("MobClusterSize", (Number)this.clusterSize);
                }
                return jsonObject;
            }

            public static final Builder fromJson(JsonObject jsonObjectIn) {
                int clusterSize;
                boolean errored = false;
                InvasionSkyRenderInfo.Builder skyRenderInfo = null;
                JsonObject jsonElement = jsonObjectIn.getAsJsonObject("SkyRenderInfo");
                if (jsonElement != null) {
                    if (jsonElement.isJsonObject()) {
                        skyRenderInfo = InvasionSkyRenderInfo.Builder.fromJson(jsonElement.getAsJsonObject());
                    } else {
                        errored = true;
                    }
                }
                ArrayList<InvasionSpawnerData> mobSpawnList = new ArrayList<InvasionSpawnerData>();
                JsonArray mobSpawnListElement = jsonObjectIn.getAsJsonArray("MobSpawnList");
                if (mobSpawnListElement != null) {
                    if (mobSpawnListElement.isJsonArray()) {
                        JsonArray a = mobSpawnListElement.getAsJsonArray();
                        for (JsonElement e : a) {
                            if (e.isJsonObject()) {
                                Iterator o = e.getAsJsonObject();
                                EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.m_135820_((String)o.get("EntityType").getAsString()));
                                int weight = o.get("Weight").getAsInt();
                                int minCount = o.get("MinCount").getAsInt();
                                int maxCount = o.get("MaxCount").getAsInt();
                                boolean ignoreSpawnRules = o.has("IgnoreSpawnRules") && o.get("IgnoreSpawnRules").getAsBoolean();
                                boolean forceDespawn = o.has("ForceDespawn") && o.get("ForceDespawn").getAsBoolean();
                                mobSpawnList.add(new InvasionSpawnerData(type, weight, minCount, maxCount, ignoreSpawnRules, forceDespawn));
                                continue;
                            }
                            errored = true;
                            break;
                        }
                    } else {
                        errored = true;
                    }
                }
                ArrayList<AdditionalEntitySpawnData> additionalEntitiesList = new ArrayList<AdditionalEntitySpawnData>();
                JsonArray additionalEntitiesListElement = jsonObjectIn.getAsJsonArray("AdditionalEntitiesList");
                if (additionalEntitiesListElement != null) {
                    if (additionalEntitiesListElement.isJsonArray()) {
                        JsonArray a = additionalEntitiesListElement.getAsJsonArray();
                        for (JsonElement e : a) {
                            if (e.isJsonObject()) {
                                JsonObject o = e.getAsJsonObject();
                                EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.m_135820_((String)o.get("EntityType").getAsString()));
                                int minCount = o.get("MinCount").getAsInt();
                                int maxCount = o.get("MaxCount").getAsInt();
                                int chance = o.get("Chance").getAsInt();
                                boolean isSurfaceSpawn = o.has("IsSurfaceSpawn") && o.get("IsSurfaceSpawn").getAsBoolean();
                                additionalEntitiesList.add(new AdditionalEntitySpawnData(type, minCount, maxCount, chance, isSurfaceSpawn));
                                continue;
                            }
                            errored = true;
                            break;
                        }
                    } else {
                        errored = true;
                    }
                }
                float mobCapPercentage = jsonObjectIn.has("MobCapPercentage") ? Math.max(jsonObjectIn.get("MobCapPercentage").getAsFloat(), 0.0f) : 0.0f;
                int fixedMobCap = jsonObjectIn.has("FixedMobCap") ? Math.max(jsonObjectIn.get("FixedMobCap").getAsInt(), 0) : 0;
                boolean forceNoSleep = jsonObjectIn.has("ForceNoSleep") && jsonObjectIn.get("ForceNoSleep").getAsBoolean();
                int tickDelay = jsonObjectIn.get("TickDelay").getAsInt();
                int n = clusterSize = jsonObjectIn.has("MobClusterSize") ? jsonObjectIn.get("MobClusterSize").getAsInt() : 1;
                if (errored || tickDelay < 0 || clusterSize < 1) {
                    LOGGER.error("JsonElement is incorrectly setup: " + jsonObjectIn.toString() + ". Therefore InvasionType wasn't registered! Most likely a datapack error?");
                }
                return new Builder(skyRenderInfo, mobSpawnList, additionalEntitiesList, mobCapPercentage, fixedMobCap, forceNoSleep, tickDelay, clusterSize);
            }
        }
    }

    public static final class Builder {
        private static final Logger LOGGER = PureSufferingMod.LOGGER;
        private boolean overridesExisting;
        private String defaultName;
        private int rarity;
        private int tier;
        private boolean stopConversions;
        private InvasionTime invasionTime;
        private InvasionPriority invasionPriority;
        private SpawningSystem spawningSystem;
        private TimeModifier timeModifier;
        private TimeChangeability timeChangeability;
        private WeatherType weatherType;
        private DayNightCycleRequirement dayNightCycleRequirement;
        private List<SeverityInfo.Builder> severityInfo;
        private List<ResourceLocation> dimensions;

        private Builder(boolean overridesExistingIn, String defaultNameIn, int rarityIn, int tierIn, boolean stopConversionsIn, InvasionTime invasionTimeIn, InvasionPriority invasionPriorityIn, SpawningSystem spawningSystemIn, TimeModifier timeModifierIn, TimeChangeability timeChangeabilityIn, WeatherType weatherTypeIn, DayNightCycleRequirement dayNightCycleRequirementIn, List<SeverityInfo.Builder> severityInfoIn, List<ResourceLocation> dimensionsIn) {
            this.overridesExisting = overridesExistingIn;
            this.defaultName = defaultNameIn;
            this.rarity = rarityIn;
            this.tier = tierIn;
            this.stopConversions = stopConversionsIn;
            this.invasionTime = invasionTimeIn;
            this.invasionPriority = invasionPriorityIn;
            this.spawningSystem = spawningSystemIn;
            this.timeModifier = timeModifierIn;
            this.timeChangeability = timeChangeabilityIn;
            this.weatherType = weatherTypeIn;
            this.dayNightCycleRequirement = dayNightCycleRequirementIn;
            this.severityInfo = severityInfoIn;
            this.dimensions = dimensionsIn;
        }

        private Builder() {
        }

        public static final Builder invasionType() {
            return new Builder();
        }

        public final Builder withRarity(int rarityIn) {
            this.rarity = rarityIn;
            return this;
        }

        public final Builder withTier(int tierIn) {
            this.tier = tierIn;
            return this;
        }

        public final Builder withConversionsStopped() {
            this.stopConversions = true;
            return this;
        }

        public final Builder withInvasionTime(InvasionTime invasionTimeIn) {
            this.invasionTime = invasionTimeIn;
            return this;
        }

        public final Builder withInvasionPriority(InvasionPriority invasionPriorityIn) {
            this.invasionPriority = invasionPriorityIn;
            return this;
        }

        public final Builder withSpawningSystem(SpawningSystem spawningSystemIn) {
            this.spawningSystem = spawningSystemIn;
            return this;
        }

        public final Builder withTimeModifier(TimeModifier timeModifierIn) {
            this.timeModifier = timeModifierIn;
            return this;
        }

        public final Builder withTimeChangeability(TimeChangeability timeChangeabilityIn) {
            this.timeChangeability = timeChangeabilityIn;
            return this;
        }

        public final Builder withWeatherType(WeatherType weatherTypeIn) {
            this.weatherType = weatherTypeIn;
            return this;
        }

        public final Builder withDayNightCycleRequirement(DayNightCycleRequirement dayNightCycleRequirementIn) {
            this.dayNightCycleRequirement = dayNightCycleRequirementIn;
            return this;
        }

        public final Builder severityInfo(SeverityInfo.Builder ... severityInfoIn) {
            this.severityInfo = List.of(severityInfoIn);
            return this;
        }

        public final Builder dimensions(ResourceLocation ... dimensionsIn) {
            this.dimensions = List.of(dimensionsIn);
            return this;
        }

        public final InvasionType save(Consumer<InvasionType> consumerIn, String pathIn) {
            InvasionType invasionType = this.build(PureSufferingMod.namespace(pathIn));
            consumerIn.accept(invasionType);
            return invasionType;
        }

        public final InvasionType build(ResourceLocation idIn) {
            ArrayList<SeverityInfo> severityInfo = new ArrayList<SeverityInfo>();
            if (this.severityInfo != null) {
                for (SeverityInfo.Builder builder : this.severityInfo) {
                    severityInfo.add(builder.build(idIn));
                }
            }
            return new InvasionType(idIn, this.overridesExisting, this.defaultName, this.rarity, this.tier, this.stopConversions, this.invasionTime, this.invasionPriority, this.spawningSystem, this.timeModifier, this.timeChangeability, this.weatherType, this.dayNightCycleRequirement, severityInfo, this.dimensions);
        }

        public final JsonObject serializeToJson() {
            JsonArray jsonArray;
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("Rarity", (Number)(this.rarity + 1));
            jsonObject.addProperty("Tier", (Number)(this.tier + 1));
            if (this.stopConversions) {
                jsonObject.addProperty("StopConversions", Boolean.valueOf(this.stopConversions));
            }
            if (this.invasionTime != null) {
                jsonObject.addProperty("InvasionTime", this.invasionTime.toString());
            }
            if (this.invasionPriority != null) {
                jsonObject.addProperty("InvasionPriority", this.invasionPriority.toString());
            }
            if (this.spawningSystem != null) {
                jsonObject.addProperty("SpawningSystem", this.spawningSystem.toString());
            }
            if (this.timeModifier != null && (this.invasionTime != InvasionTime.NIGHT && this.timeModifier != TimeModifier.NIGHT_TO_DAY || this.invasionTime != InvasionTime.DAY && this.timeModifier != TimeModifier.DAY_TO_NIGHT)) {
                jsonObject.addProperty("TimeModifier", this.timeModifier.toString());
            }
            if (this.timeChangeability != null && (this.invasionTime != InvasionTime.NIGHT && this.timeChangeability != TimeChangeability.ONLY_NIGHT || this.invasionTime != InvasionTime.DAY && this.timeChangeability != TimeChangeability.ONLY_DAY)) {
                jsonObject.addProperty("TimeChangeability", this.timeChangeability.toString());
            }
            if (this.weatherType != null) {
                jsonObject.addProperty("WeatherType", this.weatherType.toString());
            }
            if (this.dayNightCycleRequirement != null) {
                jsonObject.addProperty("DayNightCycleRequirement", this.dayNightCycleRequirement.toString());
            }
            if (this.severityInfo != null) {
                jsonArray = new JsonArray();
                for (SeverityInfo.Builder builder : this.severityInfo) {
                    jsonArray.add((JsonElement)builder.serializeToJson());
                }
                jsonObject.add("SeverityInfo", (JsonElement)jsonArray);
            }
            if (this.dimensions != null) {
                jsonArray = new JsonArray();
                for (ResourceLocation id : this.dimensions) {
                    jsonArray.add(id.toString());
                }
                jsonObject.add("Dimensions", (JsonElement)jsonArray);
            }
            return jsonObject;
        }

        /*
         * WARNING - void declaration
         */
        public static final Builder fromJson(Registry<LevelStem> dimensionsIn, JsonObject jsonObjectIn) {
            void var12_32;
            void var11_23;
            boolean bl;
            void var13_41;
            boolean overridesExisting = jsonObjectIn.has("OverridesExisting") && jsonObjectIn.get("OverridesExisting").getAsBoolean();
            String defaultName = jsonObjectIn.has("DefaultName") ? jsonObjectIn.get("DefaultName").getAsString() : null;
            int rarity = Math.max(jsonObjectIn.get("Rarity").getAsInt(), 1) - 1;
            int tier = Math.max(jsonObjectIn.get("Tier").getAsInt(), 1) - 1;
            boolean stopConversions = jsonObjectIn.has("StopConversions") && jsonObjectIn.get("StopConversions").getAsBoolean();
            InvasionTime invasionTime = null;
            if (jsonObjectIn.has("InvasionTime")) {
                for (InvasionTime invasionTime2 : InvasionTime.values()) {
                    if (!invasionTime2.toString().equals(jsonObjectIn.get("InvasionTime").getAsString())) continue;
                    invasionTime = invasionTime2;
                    break;
                }
            }
            InvasionPriority invasionPriority = InvasionPriority.BOTH;
            if (jsonObjectIn.has("InvasionPriority")) {
                void var11_17;
                InvasionPriority[] invasionPriorityArray = InvasionPriority.values();
                int n = invasionPriorityArray.length;
                boolean bl2 = false;
                while (var11_17 < n) {
                    InvasionPriority invasionPriority2 = invasionPriorityArray[var11_17];
                    if (invasionPriority2.toString().equals(jsonObjectIn.get("InvasionPriority").getAsString())) {
                        invasionPriority = invasionPriority2;
                        break;
                    }
                    ++var11_17;
                }
            }
            SpawningSystem spawningSystem = SpawningSystem.DEFAULT;
            if (jsonObjectIn.has("SpawningSystem")) {
                void var12_26;
                SpawningSystem[] spawningSystemArray = SpawningSystem.values();
                int n = spawningSystemArray.length;
                boolean bl3 = false;
                while (var12_26 < n) {
                    SpawningSystem spawningSystem2 = spawningSystemArray[var12_26];
                    if (spawningSystem2.toString().equals(jsonObjectIn.get("SpawningSystem").getAsString())) {
                        spawningSystem = spawningSystem2;
                        break;
                    }
                    ++var12_26;
                }
            }
            TimeModifier timeModifier = TimeModifier.NONE;
            if (jsonObjectIn.has("TimeModifier")) {
                void var13_35;
                TimeModifier[] timeModifierArray = TimeModifier.values();
                int n = timeModifierArray.length;
                boolean bl4 = false;
                while (var13_35 < n) {
                    TimeModifier timeModifier2 = timeModifierArray[var13_35];
                    if (timeModifier2.toString().equals(jsonObjectIn.get("TimeModifier").getAsString()) && (invasionTime != InvasionTime.DAY && timeModifier2 != TimeModifier.DAY_TO_NIGHT || invasionTime != InvasionTime.NIGHT && timeModifier2 != TimeModifier.NIGHT_TO_DAY || timeModifier2 == TimeModifier.NONE)) {
                        timeModifier = timeModifier2;
                        break;
                    }
                    ++var13_35;
                }
            }
            TimeChangeability timeChangeability = TimeChangeability.DEFAULT;
            if (jsonObjectIn.has("TimeChangeability")) {
                void var14_44;
                TimeChangeability[] timeChangeabilityArray = TimeChangeability.values();
                int n = timeChangeabilityArray.length;
                boolean bl5 = false;
                while (var14_44 < n) {
                    TimeChangeability changeability = timeChangeabilityArray[var14_44];
                    if (changeability.toString().equals(jsonObjectIn.get("TimeChangeability").getAsString()) && (invasionTime != InvasionTime.DAY && changeability != TimeChangeability.ONLY_DAY || invasionTime != InvasionTime.NIGHT && changeability != TimeChangeability.ONLY_NIGHT || changeability == TimeChangeability.DEFAULT)) {
                        TimeChangeability timeChangeability2 = changeability;
                        break;
                    }
                    ++var14_44;
                }
            }
            WeatherType weatherType = WeatherType.DEFAULT;
            if (jsonObjectIn.has("WeatherType")) {
                for (WeatherType weather : WeatherType.values()) {
                    if (!weather.toString().equals(jsonObjectIn.get("WeatherType").getAsString())) continue;
                    WeatherType weatherType2 = weather;
                    break;
                }
            }
            DayNightCycleRequirement dayNightCycleRequirement = DayNightCycleRequirement.NONE;
            if (jsonObjectIn.has("DayNightCycleRequirement")) {
                for (DayNightCycleRequirement requirement : DayNightCycleRequirement.values()) {
                    if (!requirement.toString().equals(jsonObjectIn.get("DayNightCycleRequirement").getAsString())) continue;
                    DayNightCycleRequirement dayNightCycleRequirement2 = requirement;
                    break;
                }
            }
            boolean bl6 = false;
            ArrayList<SeverityInfo.Builder> severityInfo = new ArrayList<SeverityInfo.Builder>();
            JsonArray severityInfoElement = jsonObjectIn.getAsJsonArray("SeverityInfo");
            if (severityInfoElement != null) {
                if (severityInfoElement.isJsonArray()) {
                    JsonArray a = severityInfoElement.getAsJsonArray();
                    for (int info = 0; info < a.size(); ++info) {
                        JsonElement e = a.get(info);
                        if (!e.isJsonObject()) {
                            boolean bl7 = true;
                            break;
                        }
                        severityInfo.add(SeverityInfo.Builder.fromJson(e.getAsJsonObject()));
                    }
                } else {
                    boolean bl8 = true;
                }
            }
            ArrayList<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
            JsonArray dimensionsElement = jsonObjectIn.getAsJsonArray("Dimensions");
            if (dimensionsElement != null) {
                if (dimensionsElement.isJsonArray()) {
                    JsonArray a = dimensionsElement.getAsJsonArray();
                    for (int dim = 0; dim < a.size(); ++dim) {
                        ResourceLocation modDimId;
                        ResourceLocation dimId = ResourceLocation.m_135820_((String)a.get(dim).getAsString());
                        dimensions.add(dimId);
                        if (dimId.equals((Object)Level.f_46428_.m_135782_()) && var13_41 != null) {
                            for (String string : PSConfigValues.common.overworldLikeDimensions) {
                                modDimId = ResourceLocation.m_135820_((String)string);
                                if (!var13_41.meetsRequirement((LevelStem)dimensionsIn.m_7745_(modDimId), string)) continue;
                                dimensions.add(modDimId);
                            }
                            continue;
                        }
                        if (dimId.equals((Object)Level.f_46429_.m_135782_())) {
                            for (String string : PSConfigValues.common.netherLikeDimensions) {
                                modDimId = ResourceLocation.m_135820_((String)string);
                                if (!var13_41.meetsRequirement((LevelStem)dimensionsIn.m_7745_(modDimId), string)) continue;
                                dimensions.add(modDimId);
                            }
                            continue;
                        }
                        if (!dimId.equals((Object)Level.f_46430_.m_135782_())) continue;
                        for (String string : PSConfigValues.common.endLikeDimensions) {
                            modDimId = ResourceLocation.m_135820_((String)string);
                            if (!var13_41.meetsRequirement((LevelStem)dimensionsIn.m_7745_(modDimId), string)) continue;
                            dimensions.add(modDimId);
                        }
                    }
                } else {
                    bl = true;
                }
            }
            if (invasionTime == null || bl) {
                LOGGER.error("JsonElement is incorrectly setup: " + jsonObjectIn.toString() + ". Therefore InvasionType wasn't registered! Most likely a datapack error?");
            }
            return new Builder(overridesExisting, defaultName, rarity, tier, stopConversions, invasionTime, invasionPriority, spawningSystem, timeModifier, (TimeChangeability)var11_23, (WeatherType)var12_32, (DayNightCycleRequirement)var13_41, severityInfo, dimensions);
        }
    }
}

