/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.network.packet;

import dev.theagameplayer.puresuffering.client.invasion.ClientInvasionSession;
import dev.theagameplayer.puresuffering.client.invasion.InvasionSkyRenderInfo;
import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.invasion.InvasionDifficulty;
import dev.theagameplayer.puresuffering.invasion.InvasionSessionType;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public final class AddInvasionPacket {
    private final InvasionSessionType sessionType;
    private final InvasionDifficulty difficulty;
    private final InvasionSkyRenderInfo renderer;
    private final boolean isPrimary;
    private final int severity;
    private final int mobCap;
    private final int maxSeverity;
    private final int rarity;
    private final int tier;
    private final Component component;

    public AddInvasionPacket(InvasionSessionType sessionTypeIn, InvasionDifficulty difficultyIn, Invasion invasionIn) {
        this(sessionTypeIn, difficultyIn, invasionIn.getSeverityInfo().getSkyRenderInfo(), invasionIn.isPrimary(), invasionIn.getSeverity(), invasionIn.getMobCap(), invasionIn.getType().getMaxSeverity(), invasionIn.getType().getRarity(), invasionIn.getType().getTier(), invasionIn.getType().getComponent());
    }

    private AddInvasionPacket(InvasionSessionType sessionTypeIn, InvasionDifficulty difficultyIn, InvasionSkyRenderInfo rendererIn, boolean isPrimaryIn, int severityIn, int mobCapIn, int maxSeverityIn, int rarityIn, int tierIn, Component componentIn) {
        this.sessionType = sessionTypeIn;
        this.difficulty = difficultyIn;
        this.renderer = rendererIn;
        this.isPrimary = isPrimaryIn;
        this.severity = severityIn;
        this.mobCap = mobCapIn;
        this.maxSeverity = maxSeverityIn;
        this.rarity = rarityIn;
        this.tier = tierIn;
        this.component = componentIn;
    }

    public static final void encode(AddInvasionPacket msgIn, FriendlyByteBuf bufIn) {
        bufIn.m_130068_((Enum)msgIn.sessionType);
        bufIn.m_130068_((Enum)msgIn.difficulty);
        msgIn.renderer.deconstruct().serializeToNetwork(bufIn);
        bufIn.m_130085_(msgIn.renderer.getId());
        bufIn.writeBoolean(msgIn.isPrimary);
        bufIn.writeInt(msgIn.severity);
        bufIn.writeInt(msgIn.mobCap);
        bufIn.writeInt(msgIn.maxSeverity);
        bufIn.writeInt(msgIn.rarity);
        bufIn.writeInt(msgIn.tier);
        bufIn.m_130083_(msgIn.component);
    }

    public static final AddInvasionPacket decode(FriendlyByteBuf bufIn) {
        InvasionSessionType sessionType = (InvasionSessionType)bufIn.m_130066_(InvasionSessionType.class);
        InvasionDifficulty difficulty = (InvasionDifficulty)bufIn.m_130066_(InvasionDifficulty.class);
        InvasionSkyRenderInfo renderer = InvasionSkyRenderInfo.Builder.fromNetwork(bufIn).build(bufIn.m_130281_());
        return new AddInvasionPacket(sessionType, difficulty, renderer, bufIn.readBoolean(), bufIn.readInt(), bufIn.readInt(), bufIn.readInt(), bufIn.readInt(), bufIn.readInt(), bufIn.m_130238_());
    }

    public static final class Handler {
        public static final boolean handle(AddInvasionPacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            ctxIn.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Handler.lambda$handle$1(msgIn, (Supplier)ctxIn)));
            return true;
        }

        private static final void handlePacket(AddInvasionPacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            ClientInvasionSession.add(msgIn.sessionType, msgIn.difficulty, msgIn.renderer, msgIn.isPrimary, msgIn.severity, msgIn.mobCap, msgIn.maxSeverity, msgIn.rarity, msgIn.tier, msgIn.component);
        }

        private static /* synthetic */ Runnable lambda$handle$1(AddInvasionPacket msgIn, Supplier ctxIn) {
            return () -> Handler.lambda$handle$0(msgIn, (Supplier)ctxIn);
        }

        private static /* synthetic */ void lambda$handle$0(AddInvasionPacket msgIn, Supplier ctxIn) {
            Handler.handlePacket(msgIn, ctxIn);
        }
    }
}

