/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.network.packet;

import dev.theagameplayer.puresuffering.invasion.InvasionDifficulty;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public final class InvasionMobParticlesPacket {
    private final InvasionDifficulty difficulty;
    private final double x;
    private final double y;
    private final double z;
    private final RelocationStatus status;

    public InvasionMobParticlesPacket(InvasionDifficulty difficultyIn, Vec3 posIn) {
        this(difficultyIn, posIn, RelocationStatus.NONE);
    }

    public InvasionMobParticlesPacket(InvasionDifficulty difficultyIn, Vec3 posIn, boolean relocateIn) {
        this(difficultyIn, posIn, relocateIn ? RelocationStatus.TO : RelocationStatus.FROM);
    }

    private InvasionMobParticlesPacket(InvasionDifficulty difficultyIn, Vec3 posIn, RelocationStatus statusIn) {
        this.difficulty = difficultyIn;
        this.x = posIn.f_82479_;
        this.y = posIn.f_82480_;
        this.z = posIn.f_82481_;
        this.status = statusIn;
    }

    public static final void encode(InvasionMobParticlesPacket msgIn, FriendlyByteBuf bufIn) {
        bufIn.m_130068_((Enum)msgIn.difficulty);
        bufIn.writeDouble(msgIn.x);
        bufIn.writeDouble(msgIn.y);
        bufIn.writeDouble(msgIn.z);
        bufIn.m_130068_((Enum)msgIn.status);
    }

    public static final InvasionMobParticlesPacket decode(FriendlyByteBuf bufIn) {
        return new InvasionMobParticlesPacket((InvasionDifficulty)bufIn.m_130066_(InvasionDifficulty.class), new Vec3(bufIn.readDouble(), bufIn.readDouble(), bufIn.readDouble()), (RelocationStatus)bufIn.m_130066_(RelocationStatus.class));
    }

    private static enum RelocationStatus {
        NONE,
        FROM,
        TO;

    }

    public static final class Handler {
        public static final boolean handle(InvasionMobParticlesPacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            ctxIn.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Handler.lambda$handle$1(msgIn, (Supplier)ctxIn)));
            return true;
        }

        private static final void handlePacket(InvasionMobParticlesPacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            Minecraft mc = Minecraft.m_91087_();
            for (int l = 0; l < msgIn.difficulty.getParticleCount(); ++l) {
                double x = msgIn.x + 0.5 + (mc.f_91073_.f_46441_.m_188500_() - 0.5) * 2.0;
                double y = msgIn.y + 0.5 + (mc.f_91073_.f_46441_.m_188500_() - 0.5) * 2.0;
                double z = msgIn.z + 0.5 + (mc.f_91073_.f_46441_.m_188500_() - 0.5) * 2.0;
                if (msgIn.status != RelocationStatus.TO) {
                    mc.f_91073_.m_7106_((ParticleOptions)msgIn.difficulty.getSpawnParticleType(true), x, y, z, 0.0, 0.0025 * (double)l, 0.0);
                }
                if (msgIn.status == RelocationStatus.FROM) continue;
                mc.f_91073_.m_7106_((ParticleOptions)msgIn.difficulty.getSpawnParticleType(false), x, y, z, 0.0, 0.0025 * (double)l, 0.0);
            }
        }

        private static /* synthetic */ Runnable lambda$handle$1(InvasionMobParticlesPacket msgIn, Supplier ctxIn) {
            return () -> Handler.lambda$handle$0(msgIn, (Supplier)ctxIn);
        }

        private static /* synthetic */ void lambda$handle$0(InvasionMobParticlesPacket msgIn, Supplier ctxIn) {
            Handler.handlePacket(msgIn, ctxIn);
        }
    }
}

