/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.network.packet;

import dev.theagameplayer.puresuffering.client.invasion.ClientInvasionSession;
import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.registries.PSSoundEvents;
import dev.theagameplayer.puresuffering.util.invasion.InvasionText;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public final class SendInvasionsPacket {
    private final boolean isNatural;

    public SendInvasionsPacket(boolean isNaturalIn) {
        this.isNatural = isNaturalIn;
    }

    public static final void encode(SendInvasionsPacket msgIn, FriendlyByteBuf bufIn) {
        bufIn.writeBoolean(msgIn.isNatural);
    }

    public static final SendInvasionsPacket decode(FriendlyByteBuf bufIn) {
        return new SendInvasionsPacket(bufIn.readBoolean());
    }

    public static final class Handler {
        public static final boolean handle(SendInvasionsPacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            ctxIn.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Handler.lambda$handle$1(msgIn, (Supplier)ctxIn)));
            return true;
        }

        private static final void handlePacket(SendInvasionsPacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            ClientInvasionSession session;
            Minecraft mc = Minecraft.m_91087_();
            if (PSConfigValues.client.useInvasionSoundEffects && msgIn.isNatural) {
                mc.f_91074_.m_216990_((SoundEvent)PSSoundEvents.INFORM_INVASION.get());
            }
            if ((session = ClientInvasionSession.get(mc.f_91073_)) != null) {
                mc.m_240442_().m_240494_((Component)InvasionText.create(msgIn.isNatural ? "invasion.puresuffering.inform" : "commands.puresuffering.query.invasions", msgIn.isNatural ? ChatFormatting.GRAY : ChatFormatting.GOLD, session).m_130948_(session.getStyle()), false);
            } else if (!msgIn.isNatural) {
                mc.m_240442_().m_240494_((Component)Component.m_237115_((String)"commands.puresuffering.query.none").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            }
        }

        private static /* synthetic */ Runnable lambda$handle$1(SendInvasionsPacket msgIn, Supplier ctxIn) {
            return () -> Handler.lambda$handle$0(msgIn, (Supplier)ctxIn);
        }

        private static /* synthetic */ void lambda$handle$0(SendInvasionsPacket msgIn, Supplier ctxIn) {
            Handler.handlePacket(msgIn, ctxIn);
        }
    }
}

