/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.network.packet;

import dev.theagameplayer.puresuffering.registries.other.PSGameRules;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public final class UpdateGameRulePacket {
    final PSGameRules.PSGameRule<?> gameRule;
    final boolean isBool;
    final boolean v1;
    final int v2;

    public UpdateGameRulePacket(PSGameRules.PSGameRule<?> gameRuleIn, boolean valueIn) {
        this.gameRule = gameRuleIn;
        this.isBool = true;
        this.v1 = valueIn;
        this.v2 = 0;
    }

    public UpdateGameRulePacket(PSGameRules.PSGameRule<?> gameRuleIn, int valueIn) {
        this.gameRule = gameRuleIn;
        this.isBool = false;
        this.v1 = false;
        this.v2 = valueIn;
    }

    public static final void encode(UpdateGameRulePacket msgIn, FriendlyByteBuf bufIn) {
        bufIn.m_130070_(msgIn.gameRule.toString());
        bufIn.writeBoolean(msgIn.isBool);
        if (msgIn.isBool) {
            bufIn.writeBoolean(msgIn.v1);
        } else {
            bufIn.writeInt(msgIn.v2);
        }
    }

    public static final UpdateGameRulePacket decode(FriendlyByteBuf bufIn) {
        PSGameRules.PSGameRule<?> gameRule = PSGameRules.fromString(bufIn.m_130277_());
        return bufIn.readBoolean() ? new UpdateGameRulePacket(gameRule, bufIn.readBoolean()) : new UpdateGameRulePacket(gameRule, bufIn.readInt());
    }

    public static final class Handler {
        public static final boolean handle(UpdateGameRulePacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            ctxIn.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Handler.lambda$handle$1(msgIn, (Supplier)ctxIn)));
            return true;
        }

        private static final void handlePacket(UpdateGameRulePacket msgIn, Supplier<NetworkEvent.Context> ctxIn) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null) {
                return;
            }
            Object value = msgIn.gameRule.getRule(mc.f_91073_.m_46469_());
            if (value instanceof GameRules.BooleanValue) {
                GameRules.BooleanValue booleanValue = (GameRules.BooleanValue)value;
                booleanValue.m_46246_(msgIn.v1, null);
            } else if (value instanceof GameRules.IntegerValue) {
                GameRules.IntegerValue integerValue = (GameRules.IntegerValue)value;
                integerValue.m_151489_(msgIn.v2, null);
            }
        }

        private static /* synthetic */ Runnable lambda$handle$1(UpdateGameRulePacket msgIn, Supplier ctxIn) {
            return () -> Handler.lambda$handle$0(msgIn, (Supplier)ctxIn);
        }

        private static /* synthetic */ void lambda$handle$0(UpdateGameRulePacket msgIn, Supplier ctxIn) {
            Handler.handlePacket(msgIn, ctxIn);
        }
    }
}

