/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.registries.other;

import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.network.PSPacketHandler;
import dev.theagameplayer.puresuffering.network.packet.UpdateGameRulePacket;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public final class PSGameRules {
    public static final ArrayList<PSGameRule<?>> GAME_RULES = new ArrayList();
    public static final BooleanRule ENABLE_INVASIONS = new BooleanRule("enableInvasions", true, true);
    public static final BooleanRule ENABLE_HYPER_INVASIONS = new BooleanRule("enableHyperInvasions", true, PSConfigValues.common.enableHyperInvasions);
    public static final BooleanRule ENABLE_NIGHTMARE_INVASIONS = new BooleanRule("enableNightmareInvasions", true, PSConfigValues.common.enableNightmareInvasions);
    public static final BooleanRule INVASION_ANTI_GRIEF = new BooleanRule("invasionAntiGrief", false, PSConfigValues.common.invasionAntiGrief);
    public static final BooleanRule CONSISTENT_INVASIONS = new BooleanRule("consistentInvasions", false, PSConfigValues.common.consistentInvasions);
    public static final BooleanRule TIERED_INVASIONS = new BooleanRule("tieredInvasions", false, PSConfigValues.common.tieredInvasions);
    public static final BooleanRule CANCELABLE_INVASIONS = new BooleanRule("cancelableInvasions", false, true);
    public static final BooleanRule HYPER_AGGRESSION = new BooleanRule("hyperAggression", false, PSConfigValues.common.hyperAggression);
    public static final BooleanRule HYPER_CHARGE = new BooleanRule("hyperCharge", true, PSConfigValues.common.hyperCharge);
    public static final BooleanRule FORCE_INVASION_SLEEPLESSNESS = new BooleanRule("forceInvasionSleeplessness", false, PSConfigValues.common.forceInvasionSleeplessness);
    public static final BooleanRule USE_XP_MULTIPLIER = new BooleanRule("useXPMultiplier", false, PSConfigValues.common.useXPMultiplier);
    public static final BooleanRule MOBS_DIE_AT_END_OF_INVASIONS = new BooleanRule("mobsDieAtEndOfInvasions", false, PSConfigValues.common.mobsDieAtEndOfInvasions);
    public static final BooleanRule WEAKENED_INVASION_VEXES = new BooleanRule("weakenedInvasionVexes", false, PSConfigValues.common.weakenedInvasionVexes);
    public static final BooleanRule ENABLE_INVASION_AMBIENCE = new BooleanRule("enableInvasionAmbience", false, PSConfigValues.common.enableInvasionAmbience);
    public static final IntegerRule PRIMARY_INVASION_MOB_CAP = new IntegerRule("primaryInvasionMobCap", false, PSConfigValues.common.primaryInvasionMobCap);
    public static final IntegerRule SECONDARY_INVASION_MOB_CAP = new IntegerRule("secondaryInvasionMobCap", false, PSConfigValues.common.secondaryInvasionMobCap);

    public static final void registerGameRules() {
        GameRules.Category category = GameRules.Category.valueOf((String)"PURE_SUFFERING");
        for (PSGameRule<?> gameRule : GAME_RULES) {
            gameRule.register(category);
        }
    }

    public static final PSGameRule<?> fromString(String nameIn) {
        for (PSGameRule<?> gameRule : GAME_RULES) {
            if (!gameRule.name.equals(nameIn)) continue;
            return gameRule;
        }
        return null;
    }

    public static final void syncToConfig(MinecraftServer serverIn) {
        for (PSGameRule<?> gameRule : GAME_RULES) {
            gameRule.syncToConfig(serverIn);
        }
    }

    public static final void syncToServer(ServerPlayer playerIn) {
        for (PSGameRule<?> gameRule : GAME_RULES) {
            gameRule.syncToServer(playerIn);
        }
    }

    public static abstract class PSGameRule<T extends GameRules.Value<T>> {
        private final String name;
        private final GameRules.Type<T> type;
        private final BiConsumer<MinecraftServer, PSGameRule<T>> resyncToConfig;
        private final BiConsumer<ServerPlayer, PSGameRule<T>> resyncToServer;
        private final boolean updatesClient;
        protected GameRules.Key<T> key;

        private PSGameRule(String nameIn, GameRules.Type<T> typeIn, BiConsumer<MinecraftServer, PSGameRule<T>> resyncToConfigIn, BiConsumer<ServerPlayer, PSGameRule<T>> resyncToServerIn, boolean updatesClientIn) {
            this.name = nameIn;
            this.type = typeIn;
            this.resyncToConfig = resyncToConfigIn;
            this.resyncToServer = resyncToServerIn;
            this.updatesClient = updatesClientIn;
            GAME_RULES.add(this);
        }

        public final T getRule(GameRules gameRulesIn) {
            return (T)gameRulesIn.m_46170_(this.key);
        }

        public final void register(GameRules.Category categoryIn) {
            this.key = GameRules.m_46189_((String)("puresuffering:" + this.name), (GameRules.Category)categoryIn, this.type);
        }

        public final void syncToConfig(MinecraftServer serverIn) {
            this.resyncToConfig.accept(serverIn, this);
        }

        public final void syncToServer(ServerPlayer playerIn) {
            if (this.updatesClient) {
                this.resyncToServer.accept(playerIn, this);
            }
        }

        public final boolean equals(Object objIn) {
            return this.name.equals(objIn);
        }

        public final String toString() {
            return this.name;
        }
    }

    public static final class BooleanRule
    extends PSGameRule<GameRules.BooleanValue> {
        private final boolean defaultValue;

        private BooleanRule(String nameIn, boolean updatesClientIn, boolean valueIn) {
            super(nameIn, updatesClientIn ? GameRules.BooleanValue.m_46252_((boolean)valueIn, (server, value) -> PSPacketHandler.sendToAllClients(new UpdateGameRulePacket(PSGameRules.fromString(nameIn), value.m_46223_()))) : GameRules.BooleanValue.m_46250_((boolean)valueIn), (server, gameRule) -> ((GameRules.BooleanValue)gameRule.getRule(server.m_129900_())).m_46246_(valueIn, server), (player, gameRule) -> PSPacketHandler.sendToClient(new UpdateGameRulePacket((PSGameRule<?>)gameRule, ((GameRules.BooleanValue)gameRule.getRule(player.f_8924_.m_129900_())).m_46223_()), player), updatesClientIn);
            this.defaultValue = valueIn;
        }

        public final boolean get(Level levelIn) {
            return PSConfigValues.common.overrideGameRules ? this.defaultValue : levelIn.m_46469_().m_46207_(this.key);
        }
    }

    public static final class IntegerRule
    extends PSGameRule<GameRules.IntegerValue> {
        private final int defaultValue;

        private IntegerRule(String nameIn, boolean updatesClientIn, int valueIn) {
            super(nameIn, updatesClientIn ? GameRules.IntegerValue.m_46294_((int)valueIn, (server, value) -> PSPacketHandler.sendToAllClients(new UpdateGameRulePacket(PSGameRules.fromString(nameIn), value.m_46288_()))) : GameRules.IntegerValue.m_46312_((int)valueIn), (server, gameRule) -> ((GameRules.IntegerValue)gameRule.getRule(server.m_129900_())).m_151489_(valueIn, server), (player, gameRule) -> PSPacketHandler.sendToClient(new UpdateGameRulePacket((PSGameRule<?>)gameRule, ((GameRules.IntegerValue)gameRule.getRule(player.f_8924_.m_129900_())).m_46288_()), player), updatesClientIn);
            this.defaultValue = valueIn;
        }

        public final int get(Level levelIn) {
            return PSConfigValues.common.overrideGameRules ? this.defaultValue : levelIn.m_46469_().m_46215_(this.key);
        }
    }
}

