/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.server.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.theagameplayer.puresuffering.commands.arguments.InvasionDifficultyArgument;
import dev.theagameplayer.puresuffering.commands.arguments.InvasionMethodArgument;
import dev.theagameplayer.puresuffering.commands.arguments.InvasionSessionTypeArgument;
import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.invasion.InvasionDifficulty;
import dev.theagameplayer.puresuffering.invasion.InvasionSessionType;
import dev.theagameplayer.puresuffering.invasion.InvasionType;
import dev.theagameplayer.puresuffering.registries.other.PSReloadListeners;
import dev.theagameplayer.puresuffering.util.list.QueuedInvasionList;
import dev.theagameplayer.puresuffering.world.level.saveddata.InvasionLevelData;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public final class AddInvasionsCommand {
    private static final SimpleCommandExceptionType ERROR_INVALID_SESSION_TYPE = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.puresuffering.session_type.invalid"));
    private static final DynamicCommandExceptionType ERROR_INVALID_DIFFICULTY = new DynamicCommandExceptionType(name -> Component.m_237110_((String)"commands.puresuffering.invasion_difficulty.invalid", (Object[])new Object[]{name}));
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_INVASION_TYPE = new DynamicCommandExceptionType(resourceLocation -> Component.m_237110_((String)"commands.puresuffering.invasion_type.invasionTypeNotFound", (Object[])new Object[]{resourceLocation}));
    private static final DynamicCommandExceptionType ERROR_INVALID_INVASION_TYPE = new DynamicCommandExceptionType(name -> Component.m_237110_((String)"commands.puresuffering.invasion_type.invalid", (Object[])new Object[]{name}));
    private static final DynamicCommandExceptionType ERROR_INVALID_METHOD_1 = new DynamicCommandExceptionType(method -> Component.m_237110_((String)"commands.puresuffering.invasion_method.invalid1", (Object[])new Object[]{method}));
    private static final SimpleCommandExceptionType ERROR_INVALID_METHOD_2 = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.puresuffering.invasion_method.invalid2"));
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_INVASION_SESSION_TYPES = (ctx, suggestionsBuilder) -> {
        boolean hasFixedTime = ((CommandSourceStack)ctx.getSource()).m_81372_().m_6042_().m_63967_();
        return SharedSuggestionProvider.m_82981_(Stream.of(InvasionSessionType.values()).filter(sessionType -> hasFixedTime ? sessionType == InvasionSessionType.FIXED : sessionType != InvasionSessionType.FIXED).map(InvasionSessionType::toString), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_INVASION_DIFFICULTIES = (ctx, suggestionsBuilder) -> {
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        return SharedSuggestionProvider.m_82981_(Stream.of(InvasionDifficulty.values()).filter(difficulty -> difficulty.isAllowed((Level)level)).map(InvasionDifficulty::toString), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_PRIMARY_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        InvasionSessionType sessionType = (InvasionSessionType)((Object)((Object)ctx.getArgument("sessionType", InvasionSessionType.class)));
        return SharedSuggestionProvider.m_82957_(AddInvasionsCommand.getPrimaryInvasionTypes(((CommandSourceStack)ctx.getSource()).m_81372_(), sessionType), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_SECONDARY_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        InvasionSessionType sessionType = (InvasionSessionType)((Object)((Object)ctx.getArgument("sessionType", InvasionSessionType.class)));
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        QueuedInvasionList queuedList = InvasionLevelData.get(level).getInvasionManager().getQueued(sessionType);
        if (queuedList == null) {
            return Suggestions.empty();
        }
        return SharedSuggestionProvider.m_82957_(AddInvasionsCommand.getSecondaryInvasionTypes(((CommandSourceStack)ctx.getSource()).m_81372_(), sessionType, queuedList), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_PRIMARY_INVASION_METHODS = (ctx, suggestionsBuilder) -> {
        InvasionDifficulty difficulty = (InvasionDifficulty)((Object)((Object)ctx.getArgument("difficulty", InvasionDifficulty.class)));
        return difficulty.isHyper() ? suggestionsBuilder.suggest(InvasionMethod.MAX.toString()).buildFuture() : SharedSuggestionProvider.m_82981_(Stream.of(InvasionMethod.values()).map(InvasionMethod::toString), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_SECONDARY_INVASION_METHODS = (ctx, suggestionsBuilder) -> {
        InvasionSessionType sessionType = (InvasionSessionType)((Object)((Object)ctx.getArgument("sessionType", InvasionSessionType.class)));
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        QueuedInvasionList queuedList = InvasionLevelData.get(level).getInvasionManager().getQueued(sessionType);
        if (queuedList == null) {
            return Suggestions.empty();
        }
        InvasionDifficulty difficulty = queuedList.getDifficulty();
        return difficulty.isHyper() ? suggestionsBuilder.suggest(InvasionMethod.MAX.toString()).buildFuture() : SharedSuggestionProvider.m_82981_(Stream.of(InvasionMethod.values()).map(InvasionMethod::toString), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_SEVERITY = (ctx, suggestionsBuilder) -> {
        InvasionMethod method = (InvasionMethod)((Object)((Object)ctx.getArgument("severityMethod", InvasionMethod.class)));
        if (method != InvasionMethod.SET) {
            return Suggestions.empty();
        }
        ResourceLocation resourceLocation = (ResourceLocation)ctx.getArgument("invasionType", ResourceLocation.class);
        InvasionType invasionType = PSReloadListeners.getInvasionTypeManager().getInvasionType(resourceLocation);
        if (invasionType == null) {
            throw ERROR_UNKNOWN_INVASION_TYPE.create((Object)resourceLocation);
        }
        String[] severities = new String[invasionType.getMaxSeverity()];
        for (int s = 0; s < severities.length; ++s) {
            severities[s] = Integer.toString(s + 1);
        }
        return SharedSuggestionProvider.m_82967_((String[])severities, (SuggestionsBuilder)suggestionsBuilder);
    };

    public static final ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"add").requires(css -> css.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"sessionType", (ArgumentType)InvasionSessionTypeArgument.sessionType()).suggests(SUGGEST_INVASION_SESSION_TYPES).then(AddInvasionsCommand.literalPrimary("primary", true))).then(AddInvasionsCommand.literalPrimary("secondary", false))).then(Commands.m_82127_((String)"random").executes(ctx -> AddInvasionsCommand.addRandomInvasion((CommandContext<CommandSourceStack>)ctx))));
    }

    private static final ArgumentBuilder<CommandSourceStack, ?> literalPrimary(String nameIn, boolean isPrimaryIn) {
        LiteralArgumentBuilder main = Commands.m_82127_((String)nameIn);
        return isPrimaryIn ? main.then(Commands.m_82129_((String)"difficulty", (ArgumentType)InvasionDifficultyArgument.difficulty()).suggests(SUGGEST_INVASION_DIFFICULTIES).then(AddInvasionsCommand.literalDifficulty(true))) : main.then(AddInvasionsCommand.literalDifficulty(false));
    }

    private static final ArgumentBuilder<CommandSourceStack, ?> literalDifficulty(boolean isPrimaryIn) {
        return Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(isPrimaryIn ? SUGGEST_PRIMARY_INVASION_TYPES : SUGGEST_SECONDARY_INVASION_TYPES).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"severityMethod", (ArgumentType)InvasionMethodArgument.method()).suggests(isPrimaryIn ? SUGGEST_PRIMARY_INVASION_METHODS : SUGGEST_SECONDARY_INVASION_METHODS).then(Commands.m_82129_((String)"severity", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests(SUGGEST_SEVERITY).executes(ctx -> AddInvasionsCommand.addInvasion((CommandContext<CommandSourceStack>)ctx, true, isPrimaryIn)))).executes(ctx -> AddInvasionsCommand.addInvasion((CommandContext<CommandSourceStack>)ctx, false, isPrimaryIn)));
    }

    private static final int addInvasion(CommandContext<CommandSourceStack> ctxIn, boolean setSeverityIn, boolean isPrimaryIn) throws CommandSyntaxException {
        QueuedInvasionList queuedList;
        ResourceLocation resourceLocation = (ResourceLocation)ctxIn.getArgument("invasionType", ResourceLocation.class);
        InvasionType invasionType = PSReloadListeners.getInvasionTypeManager().getInvasionType(resourceLocation);
        if (invasionType == null) {
            throw ERROR_UNKNOWN_INVASION_TYPE.create((Object)resourceLocation);
        }
        ServerLevel level = ((CommandSourceStack)ctxIn.getSource()).m_81372_();
        InvasionSessionType sessionType = (InvasionSessionType)((Object)ctxIn.getArgument("sessionType", InvasionSessionType.class));
        if (level.m_6042_().m_63967_() && sessionType != InvasionSessionType.FIXED || !level.m_6042_().m_63967_() && sessionType == InvasionSessionType.FIXED) {
            throw ERROR_INVALID_SESSION_TYPE.create();
        }
        InvasionMethod method = (InvasionMethod)((Object)ctxIn.getArgument("severityMethod", InvasionMethod.class));
        if (setSeverityIn && method != InvasionMethod.SET) {
            throw ERROR_INVALID_METHOD_1.create((Object)method);
        }
        if (!setSeverityIn && method == InvasionMethod.SET) {
            throw ERROR_INVALID_METHOD_2.create();
        }
        if (isPrimaryIn && !AddInvasionsCommand.getPrimaryInvasionTypes(level, sessionType).toList().contains(resourceLocation)) {
            throw ERROR_INVALID_INVASION_TYPE.create((Object)invasionType.getComponent().getString());
        }
        QueuedInvasionList queuedInvasionList = queuedList = isPrimaryIn ? InvasionLevelData.get(level).getInvasionManager().setQueued(sessionType, (InvasionDifficulty)((Object)ctxIn.getArgument("difficulty", InvasionDifficulty.class))) : InvasionLevelData.get(level).getInvasionManager().getQueued(sessionType);
        if (!isPrimaryIn && !AddInvasionsCommand.getSecondaryInvasionTypes(level, sessionType, queuedList).toList().contains(resourceLocation)) {
            throw ERROR_INVALID_INVASION_TYPE.create((Object)invasionType.getComponent().getString());
        }
        InvasionDifficulty difficulty = queuedList.getDifficulty();
        if (isPrimaryIn && !difficulty.isAllowed((Level)level)) {
            throw ERROR_INVALID_DIFFICULTY.create((Object)difficulty.getTranslation());
        }
        int severity = method == InvasionMethod.RANDOM ? level.f_46441_.m_188503_(invasionType.getMaxSeverity()) : Mth.m_14045_((int)(method == InvasionMethod.MAX ? invasionType.getMaxSeverity() : IntegerArgumentType.getInteger(ctxIn, (String)"severity")), (int)1, (int)invasionType.getMaxSeverity()) - 1;
        Invasion.BuildInfo invasion = new Invasion.BuildInfo(invasionType, difficulty.isHyper() ? invasionType.getMaxSeverity() - 1 : severity, isPrimaryIn);
        queuedList.add(invasion);
        ((CommandSourceStack)ctxIn.getSource()).m_288197_(() -> Component.m_237110_((String)("commands.puresuffering.add.success." + (isPrimaryIn ? "primary" : "secondary")), (Object[])new Object[]{difficulty.isHyper() ? difficulty.getTranslation() + " " : "", sessionType.getTranslation(), invasionType.getComponent()}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
        return 0;
    }

    private static final int addRandomInvasion(CommandContext<CommandSourceStack> ctxIn) throws CommandSyntaxException {
        InvasionSessionType sessionType = (InvasionSessionType)((Object)ctxIn.getArgument("sessionType", InvasionSessionType.class));
        ServerLevel level = ((CommandSourceStack)ctxIn.getSource()).m_81372_();
        QueuedInvasionList queuedList = InvasionLevelData.get(level).getInvasionManager().getQueued(sessionType);
        boolean isPrimary = queuedList == null || queuedList.isEmpty();
        List<InvasionType> list = PSReloadListeners.getInvasionTypeManager().getAllInvasionTypes().filter(it -> {
            boolean flag1 = isPrimary ? it.getInvasionPriority() != InvasionType.InvasionPriority.SECONDARY_ONLY : it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY;
            boolean flag2 = it.getDimensions().contains(level.m_46472_().m_135782_()) && flag1;
            switch (sessionType) {
                case DAY: {
                    return flag2 && sessionType.isAcceptableTime((InvasionType)it, !isPrimary && AddInvasionsCommand.containsDayChangingInvasion(queuedList)) && (isPrimary || !AddInvasionsCommand.containsDayChangingInvasion(queuedList) || sessionType.canBeChanged((InvasionType)it));
                }
                case NIGHT: {
                    return flag2 && sessionType.isAcceptableTime((InvasionType)it, !isPrimary && AddInvasionsCommand.containsNightChangingInvasion(queuedList)) && (isPrimary || !AddInvasionsCommand.containsNightChangingInvasion(queuedList) || sessionType.canBeChanged((InvasionType)it));
                }
            }
            return flag2;
        }).toList();
        RandomSource random = level.m_213780_();
        InvasionType invasionType = list.get(random.m_188503_(list.size()));
        InvasionDifficulty[] difficulty = new InvasionDifficulty[]{InvasionDifficulty.DEFAULT};
        if (isPrimary) {
            int total = 0;
            int[] ranges = new int[InvasionDifficulty.values().length];
            for (int i = 0; i < ranges.length; ++i) {
                ranges[i] = total += InvasionDifficulty.values().length - i;
            }
            int value = random.m_188503_(total) + 1;
            for (int i = ranges.length - 1; i > -1; --i) {
                int range = ranges[i];
                if (value < range) continue;
                difficulty[0] = InvasionDifficulty.values()[i];
                break;
            }
            int severity = difficulty[0].isHyper() ? invasionType.getMaxSeverity() - 1 : random.m_188503_(invasionType.getMaxSeverity());
            Invasion.BuildInfo invasion = new Invasion.BuildInfo(invasionType, severity, true);
            InvasionLevelData.get(level).getInvasionManager().setQueued(sessionType, difficulty[0]).add(invasion);
        } else {
            difficulty[0] = queuedList.getDifficulty();
            int severity = difficulty[0].isHyper() ? invasionType.getMaxSeverity() - 1 : random.m_188503_(invasionType.getMaxSeverity());
            Invasion.BuildInfo invasion = new Invasion.BuildInfo(invasionType, severity, false);
            queuedList.add(invasion);
        }
        ((CommandSourceStack)ctxIn.getSource()).m_288197_(() -> Component.m_237110_((String)("commands.puresuffering.add.success." + (isPrimary ? "primary" : "secondary")), (Object[])new Object[]{difficulty[0].isHyper() ? difficulty[0].getTranslation() + " " : "", sessionType.getTranslation(), invasionType.getComponent()}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
        return 0;
    }

    private static final boolean containsDayChangingInvasion(QueuedInvasionList queuedListIn) {
        for (Invasion.BuildInfo invasion : queuedListIn) {
            InvasionType it = invasion.getType();
            if (it.getInvasionTime() == InvasionType.InvasionTime.NIGHT || it.getTimeModifier() != InvasionType.TimeModifier.DAY_TO_NIGHT) continue;
            return true;
        }
        return false;
    }

    private static final boolean containsNightChangingInvasion(QueuedInvasionList queuedListIn) {
        for (Invasion.BuildInfo invasion : queuedListIn) {
            InvasionType it = invasion.getType();
            if (it.getInvasionTime() == InvasionType.InvasionTime.DAY || it.getTimeModifier() != InvasionType.TimeModifier.NIGHT_TO_DAY) continue;
            return true;
        }
        return false;
    }

    private static final Stream<ResourceLocation> getPrimaryInvasionTypes(ServerLevel levelIn, InvasionSessionType sessionTypeIn) {
        return PSReloadListeners.getInvasionTypeManager().getAllInvasionTypes().filter(it -> {
            boolean flag = it.getDimensions().contains(levelIn.m_46472_().m_135782_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.SECONDARY_ONLY;
            return sessionTypeIn.isAcceptableTime((InvasionType)it, false) && flag;
        }).map(InvasionType::getId);
    }

    private static final Stream<ResourceLocation> getSecondaryInvasionTypes(ServerLevel levelIn, InvasionSessionType sessionTypeIn, QueuedInvasionList queuedListIn) {
        return PSReloadListeners.getInvasionTypeManager().getAllInvasionTypes().filter(it -> {
            boolean flag = it.getDimensions().contains(levelIn.m_46472_().m_135782_()) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY;
            switch (sessionTypeIn) {
                case DAY: {
                    return sessionTypeIn.isAcceptableTime((InvasionType)it, AddInvasionsCommand.containsDayChangingInvasion(queuedListIn)) && flag && (!AddInvasionsCommand.containsDayChangingInvasion(queuedListIn) || sessionTypeIn.canBeChanged((InvasionType)it));
                }
                case NIGHT: {
                    return sessionTypeIn.isAcceptableTime((InvasionType)it, AddInvasionsCommand.containsNightChangingInvasion(queuedListIn)) && flag && (!AddInvasionsCommand.containsNightChangingInvasion(queuedListIn) || sessionTypeIn.canBeChanged((InvasionType)it));
                }
            }
            return flag;
        }).map(InvasionType::getId);
    }

    public static enum InvasionMethod {
        SET,
        RANDOM,
        MAX;


        public final String toString() {
            return super.toString().toLowerCase();
        }
    }
}

