/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.server.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.theagameplayer.puresuffering.commands.arguments.InvasionSessionTypeArgument;
import dev.theagameplayer.puresuffering.invasion.InvasionSession;
import dev.theagameplayer.puresuffering.invasion.InvasionSessionType;
import dev.theagameplayer.puresuffering.util.list.QueuedInvasionList;
import dev.theagameplayer.puresuffering.world.level.InvasionManager;
import dev.theagameplayer.puresuffering.world.level.saveddata.InvasionLevelData;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;

public final class ClearInvasionsCommand {
    private static final SimpleCommandExceptionType ERROR_INVALID_SESSION_TYPE = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.puresuffering.session_type.invalid"));
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_INVASION_LIST_TYPES = (ctx, suggestionsBuilder) -> SharedSuggestionProvider.m_82981_(Stream.of(InvasionSessionType.values()).filter(sessionType -> ((CommandSourceStack)ctx.getSource()).m_81372_().m_6042_().m_63967_() ? sessionType == InvasionSessionType.FIXED : sessionType != InvasionSessionType.FIXED).map(InvasionSessionType::toString), (SuggestionsBuilder)suggestionsBuilder);

    public static final ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").requires(css -> css.m_6761_(2))).then(Commands.m_82127_((String)"current").executes(ctx -> {
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
            InvasionSession session = InvasionLevelData.get(level).getInvasionManager().getActiveSession(level);
            if (session != null) {
                session.clear(level);
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.puresuffering.clear.success", (Object[])new Object[]{InvasionSessionType.getActive(level)}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            return 0;
        }))).then(Commands.m_82129_((String)"sessionType", (ArgumentType)InvasionSessionTypeArgument.sessionType()).suggests(SUGGEST_INVASION_LIST_TYPES).executes(ctx -> {
            InvasionSessionType sessionType = (InvasionSessionType)((Object)((Object)ctx.getArgument("sessionType", InvasionSessionType.class)));
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
            if (level.m_6042_().m_63967_() && sessionType != InvasionSessionType.FIXED || !level.m_6042_().m_63967_() && sessionType == InvasionSessionType.FIXED) {
                throw ERROR_INVALID_SESSION_TYPE.create();
            }
            InvasionSession session = InvasionLevelData.get(level).getInvasionManager().getSession(sessionType);
            if (session != null) {
                session.clear(level);
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.puresuffering.clear.success", (Object[])new Object[]{sessionType.getTranslation()}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            return 0;
        }))).then(Commands.m_82127_((String)"all").executes(ctx -> {
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
            InvasionManager invasionManager = InvasionLevelData.get(level).getInvasionManager();
            for (InvasionSessionType sessionType : invasionManager.getListTypes()) {
                InvasionSession session = invasionManager.getSession(sessionType);
                if (session == null) continue;
                session.clear(level);
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.puresuffering.clear.success.all").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            return 0;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"queued").then(Commands.m_82129_((String)"sessionType", (ArgumentType)InvasionSessionTypeArgument.sessionType()).suggests(SUGGEST_INVASION_LIST_TYPES).executes(ctx -> {
            InvasionSessionType sessionType = (InvasionSessionType)((Object)((Object)ctx.getArgument("sessionType", InvasionSessionType.class)));
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
            if (level.m_6042_().m_63967_() && sessionType != InvasionSessionType.FIXED || !level.m_6042_().m_63967_() && sessionType == InvasionSessionType.FIXED) {
                throw ERROR_INVALID_SESSION_TYPE.create();
            }
            InvasionManager invasionManager = InvasionLevelData.get(level).getInvasionManager();
            if (invasionManager.getQueued(sessionType) != null) {
                invasionManager.setQueued(sessionType, null);
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.puresuffering.clear.success.queued", (Object[])new Object[]{sessionType.getTranslation()}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            return 0;
        }))).then(Commands.m_82127_((String)"all").executes(ctx -> {
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
            InvasionManager invasionManager = InvasionLevelData.get(level).getInvasionManager();
            for (InvasionSessionType sessionType : invasionManager.getListTypes()) {
                QueuedInvasionList queuedList = invasionManager.getQueued(sessionType);
                if (queuedList == null) continue;
                invasionManager.setQueued(sessionType, null);
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.puresuffering.clear.success.queued.all").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            return 0;
        })));
    }
}

