/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.server.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.theagameplayer.puresuffering.commands.arguments.InvasionSessionTypeArgument;
import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.invasion.InvasionSession;
import dev.theagameplayer.puresuffering.invasion.InvasionSessionType;
import dev.theagameplayer.puresuffering.invasion.InvasionType;
import dev.theagameplayer.puresuffering.invasion.InvasionTypeHolder;
import dev.theagameplayer.puresuffering.registries.other.PSReloadListeners;
import dev.theagameplayer.puresuffering.util.list.QueuedInvasionList;
import dev.theagameplayer.puresuffering.world.level.InvasionManager;
import dev.theagameplayer.puresuffering.world.level.saveddata.InvasionLevelData;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;

public final class RemoveInvasionsCommand {
    private static final SimpleCommandExceptionType ERROR_INVALID_SESSION_TYPE = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.puresuffering.session_type.invalid"));
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_INVASION_TYPE = new DynamicCommandExceptionType(resourceLocation -> Component.m_237110_((String)"commands.puresuffering.invasion_type.invasionTypeNotFound", (Object[])new Object[]{resourceLocation}));
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_INVASION_LIST_TYPES = (ctx, suggestionsBuilder) -> SharedSuggestionProvider.m_82981_(Stream.of(InvasionSessionType.values()).filter(sessionType -> ((CommandSourceStack)ctx.getSource()).m_81372_().m_6042_().m_63967_() ? sessionType == InvasionSessionType.FIXED : sessionType != InvasionSessionType.FIXED).map(InvasionSessionType::toString), (SuggestionsBuilder)suggestionsBuilder);
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_CURRENT_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Stream<InvasionType> stream = PSReloadListeners.getInvasionTypeManager().getAllInvasionTypes();
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        InvasionSession session = InvasionLevelData.get(level).getInvasionManager().getActiveSession(level);
        if (session == null) {
            return Suggestions.empty();
        }
        return SharedSuggestionProvider.m_82957_(stream.filter(it -> RemoveInvasionsCommand.contains(session, it)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Stream<InvasionType> stream = PSReloadListeners.getInvasionTypeManager().getAllInvasionTypes();
        InvasionSessionType sessionType = (InvasionSessionType)((Object)((Object)ctx.getArgument("sessionType", InvasionSessionType.class)));
        InvasionSession session = InvasionLevelData.get(((CommandSourceStack)ctx.getSource()).m_81372_()).getInvasionManager().getSession(sessionType);
        if (session == null) {
            return Suggestions.empty();
        }
        return SharedSuggestionProvider.m_82957_(stream.filter(it -> RemoveInvasionsCommand.contains(session, it)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_ALL_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Stream<InvasionType> stream = PSReloadListeners.getInvasionTypeManager().getAllInvasionTypes();
        InvasionManager invasionManager = InvasionLevelData.get(((CommandSourceStack)ctx.getSource()).m_81372_()).getInvasionManager();
        return SharedSuggestionProvider.m_82957_(stream.filter(it -> {
            for (InvasionSessionType sessionType : invasionManager.getListTypes()) {
                if (!RemoveInvasionsCommand.contains(invasionManager.getSession(sessionType), it)) continue;
                return true;
            }
            return false;
        }).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_QUEUED_INVASION_TYPES = (ctx, suggestionsBuilder) -> {
        Stream<InvasionType> stream = PSReloadListeners.getInvasionTypeManager().getAllInvasionTypes();
        InvasionSessionType sessionType = (InvasionSessionType)((Object)((Object)ctx.getArgument("sessionType", InvasionSessionType.class)));
        InvasionManager invasionManager = InvasionLevelData.get(((CommandSourceStack)ctx.getSource()).m_81372_()).getInvasionManager();
        QueuedInvasionList queuedList = invasionManager.getQueued(sessionType);
        if (queuedList == null) {
            return Suggestions.empty();
        }
        return SharedSuggestionProvider.m_82957_(stream.filter(it -> RemoveInvasionsCommand.contains(queuedList, it)).map(InvasionType::getId), (SuggestionsBuilder)suggestionsBuilder);
    };

    public static final ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(css -> css.m_6761_(2))).then(Commands.m_82127_((String)"current").then(Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_CURRENT_INVASION_TYPES).executes(ctx -> {
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
            InvasionSession session = InvasionLevelData.get(level).getInvasionManager().getActiveSession(level);
            if (session != null) {
                Invasion invasion = RemoveInvasionsCommand.getInvasion(session, (CommandContext<CommandSourceStack>)ctx, "invasionType");
                session.remove(level, invasion);
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)("commands.puresuffering.remove.success." + (invasion.isPrimary() ? "primary" : "secondary")), (Object[])new Object[]{InvasionSessionType.getActive(level).getTranslation(), invasion.getType().getComponent()}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            }
            return 0;
        })))).then(Commands.m_82129_((String)"sessionType", (ArgumentType)InvasionSessionTypeArgument.sessionType()).suggests(SUGGEST_INVASION_LIST_TYPES).then(Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_INVASION_TYPES).executes(ctx -> {
            InvasionSessionType sessionType = (InvasionSessionType)((Object)((Object)ctx.getArgument("sessionType", InvasionSessionType.class)));
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
            if (level.m_6042_().m_63967_() && sessionType != InvasionSessionType.FIXED || !level.m_6042_().m_63967_() && sessionType == InvasionSessionType.FIXED) {
                throw ERROR_INVALID_SESSION_TYPE.create();
            }
            InvasionSession session = InvasionLevelData.get(level).getInvasionManager().getSession(sessionType);
            if (session != null) {
                Invasion invasion = RemoveInvasionsCommand.getInvasion(session, (CommandContext<CommandSourceStack>)ctx, "invasionType");
                session.remove(level, invasion);
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)("commands.puresuffering.remove.success." + (invasion.isPrimary() ? "primary" : "secondary")), (Object[])new Object[]{sessionType.getTranslation(), invasion.getType().getComponent()}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            }
            return 0;
        })))).then(Commands.m_82127_((String)"all").then(Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_ALL_INVASION_TYPES).executes(ctx -> {
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
            InvasionManager invasionManager = InvasionLevelData.get(level).getInvasionManager();
            boolean sentMessage = false;
            for (InvasionSessionType sessionType : invasionManager.getListTypes()) {
                InvasionSession session = invasionManager.getSession(sessionType);
                if (session == null) continue;
                Invasion invasion = RemoveInvasionsCommand.getInvasion(session, (CommandContext<CommandSourceStack>)ctx, "invasionType");
                if (RemoveInvasionsCommand.contains(session, invasion.getType())) {
                    session.remove(level, invasion);
                }
                if (sentMessage) continue;
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)("commands.puresuffering.remove.success.all." + (invasion.isPrimary() ? "primary" : "secondary")), (Object[])new Object[]{invasion.getType().getComponent()}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
                sentMessage = true;
            }
            return 0;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"queued").then(Commands.m_82129_((String)"sessionType", (ArgumentType)InvasionSessionTypeArgument.sessionType()).suggests(SUGGEST_INVASION_LIST_TYPES).then(Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_QUEUED_INVASION_TYPES).executes(ctx -> {
            InvasionSessionType sessionType = (InvasionSessionType)((Object)((Object)ctx.getArgument("sessionType", InvasionSessionType.class)));
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
            if (level.m_6042_().m_63967_() && sessionType != InvasionSessionType.FIXED || !level.m_6042_().m_63967_() && sessionType == InvasionSessionType.FIXED) {
                throw ERROR_INVALID_SESSION_TYPE.create();
            }
            InvasionManager invasionManager = InvasionLevelData.get(level).getInvasionManager();
            QueuedInvasionList queuedList = invasionManager.getQueued(sessionType);
            if (queuedList != null) {
                Invasion.BuildInfo invasion = RemoveInvasionsCommand.getInvasion(queuedList, (CommandContext<CommandSourceStack>)ctx, "invasionType");
                queuedList.remove(invasion);
                if (queuedList.isEmpty()) {
                    invasionManager.setQueued(sessionType, null);
                }
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)("commands.puresuffering.remove.success.queued." + (invasion.isPrimary() ? "primary" : "secondary")), (Object[])new Object[]{sessionType.getTranslation(), invasion.getType().getComponent()}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            }
            return 0;
        })))).then(Commands.m_82127_((String)"all").then(Commands.m_82129_((String)"invasionType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_ALL_INVASION_TYPES).executes(ctx -> {
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
            InvasionManager invasionManager = InvasionLevelData.get(level).getInvasionManager();
            boolean sentMessage = false;
            for (InvasionSessionType sessionType : invasionManager.getListTypes()) {
                QueuedInvasionList queuedList = invasionManager.getQueued(sessionType);
                if (queuedList == null) continue;
                Invasion.BuildInfo invasion = RemoveInvasionsCommand.getInvasion(queuedList, (CommandContext<CommandSourceStack>)ctx, "invasionType");
                queuedList.remove(invasion);
                if (queuedList.isEmpty()) {
                    invasionManager.setQueued(sessionType, null);
                }
                if (sentMessage) continue;
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)("commands.puresuffering.remove.success.queued.all." + (invasion.isPrimary() ? "primary" : "secondary")), (Object[])new Object[]{invasion.getType().getComponent()}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
                sentMessage = true;
            }
            return 0;
        }))));
    }

    private static final <ITH extends InvasionTypeHolder> boolean contains(Iterable<ITH> sessionTypeIn, InvasionType invasionTypeIn) {
        for (InvasionTypeHolder invasion : sessionTypeIn) {
            if (invasion.getType() != invasionTypeIn) continue;
            return true;
        }
        return false;
    }

    private static final <ITH extends InvasionTypeHolder> ITH getInvasion(Iterable<ITH> sessionTypeIn, CommandContext<CommandSourceStack> ctxIn, String argIn) throws CommandSyntaxException {
        ResourceLocation resourceLocation = (ResourceLocation)ctxIn.getArgument(argIn, ResourceLocation.class);
        InvasionType invasionType = PSReloadListeners.getInvasionTypeManager().getInvasionType(resourceLocation);
        if (invasionType == null) {
            throw ERROR_UNKNOWN_INVASION_TYPE.create((Object)resourceLocation);
        }
        for (InvasionTypeHolder invasion : sessionTypeIn) {
            if (invasion.getType() != invasionType) continue;
            return (ITH)invasion;
        }
        throw ERROR_UNKNOWN_INVASION_TYPE.create((Object)resourceLocation);
    }
}

