/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.util.invasion;

import dev.theagameplayer.puresuffering.client.invasion.ClientInvasion;
import dev.theagameplayer.puresuffering.client.invasion.ClientInvasionSession;
import java.awt.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;

public final class InvasionText {
    public static final MutableComponent getHoverText(ClientInvasionSession sessionIn) {
        MutableComponent sessionTypeComponent = Component.m_237110_((String)"invasion.puresuffering.sessionType", (Object[])new Object[]{sessionIn.getSessionType().getTranslation()}).m_130946_("\n");
        MutableComponent difficultyComponent = Component.m_237110_((String)"invasion.puresuffering.difficultyInfo", (Object[])new Object[]{sessionIn.getDifficulty().getTranslation()});
        return sessionTypeComponent.m_7220_((Component)difficultyComponent);
    }

    public static final MutableComponent getHoverText(ClientInvasion invasionIn) {
        MutableComponent primaryComponent = Component.m_237110_((String)"invasion.puresuffering.isPrimaryInfo", (Object[])new Object[]{invasionIn.isPrimary()}).m_130946_("\n");
        MutableComponent severityComponent = Component.m_237110_((String)"invasion.puresuffering.severityInfo", (Object[])new Object[]{invasionIn.getSeverity() + 1}).m_130946_(", ");
        MutableComponent mobCapComponent = Component.m_237110_((String)"invasion.puresuffering.mobCapInfo", (Object[])new Object[]{invasionIn.getMobCap()}).m_130946_("\n");
        MutableComponent infoComponent = Component.m_237115_((String)"invasion.puresuffering.typeInfo").m_130946_("\n");
        MutableComponent rarityComponent = Component.m_237110_((String)"invasion.puresuffering.rarityInfo", (Object[])new Object[]{invasionIn.getRarity() + 1}).m_130946_(", ");
        MutableComponent tierComponent = Component.m_237110_((String)"invasion.puresuffering.tierInfo", (Object[])new Object[]{invasionIn.getTier() + 1});
        return primaryComponent.m_7220_((Component)severityComponent).m_7220_((Component)mobCapComponent).m_7220_((Component)infoComponent).m_7220_((Component)rarityComponent).m_7220_((Component)tierComponent);
    }

    public static final MutableComponent create(String keyIn, ChatFormatting baseIn, ClientInvasionSession sessionIn) {
        return InvasionText.create(keyIn, baseIn.m_126665_(), sessionIn);
    }

    public static final MutableComponent create(String keyIn, int baseIn, ClientInvasionSession sessionIn) {
        Color color = new Color(baseIn);
        MutableComponent sessionHoverText = ComponentUtils.m_130750_((MutableComponent)Component.m_237115_((String)"invasion.puresuffering.sessionInfo"), (Style)Style.f_131099_.m_131140_(ChatFormatting.GRAY)).m_130946_("\n").m_7220_((Component)InvasionText.getHoverText(sessionIn).m_130940_(ChatFormatting.DARK_GRAY));
        MutableComponent listText = Component.m_237115_((String)"invasion.puresuffering.list").m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)sessionHoverText)).m_178520_(color.getRGB()));
        MutableComponent sessionText = (keyIn.isBlank() ? listText : Component.m_237115_((String)keyIn).m_7220_((Component)listText)).m_130948_(Style.f_131099_.m_178520_(color.getRGB()));
        for (ClientInvasion invasion : sessionIn) {
            if (!invasion.isPrimary()) {
                sessionText.m_130946_(", ").m_130948_(Style.f_131099_.m_178520_(color.getRGB()));
            }
            MutableComponent invasionHoverText = ComponentUtils.m_130750_((MutableComponent)Component.m_237113_((String)"- ").m_7220_((Component)invasion.getComponent().m_6881_()).m_130946_(" -"), (Style)Style.f_131099_.m_131140_(ChatFormatting.GRAY)).m_130946_("\n").m_7220_((Component)InvasionText.getHoverText(invasion).m_130940_(ChatFormatting.DARK_GRAY));
            MutableComponent invasionText = invasion.getComponent().m_6881_().m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)invasionHoverText)));
            sessionText.m_7220_((Component)invasionText.m_130948_(Style.f_131099_.m_178520_(InvasionText.getSeverityColor(color, invasion, false, true, !sessionIn.getDifficulty().isNightmare())).m_131162_(Boolean.valueOf(invasion.isPrimary()))));
        }
        return sessionText;
    }

    public static final int getSeverityColor(Color colorIn, ClientInvasion invasionIn, boolean rIn, boolean gIn, boolean bIn) {
        int denom = 128 / invasionIn.getMaxSeverity();
        int severity = invasionIn.getSeverity();
        int[] rgb = new int[]{rIn ? Mth.m_14045_((int)(colorIn.getRed() + invasionIn.getMaxSeverity() * denom - severity * denom), (int)0, (int)255) : colorIn.getRed(), gIn ? Mth.m_14045_((int)(colorIn.getGreen() + invasionIn.getMaxSeverity() * denom - severity * denom), (int)0, (int)255) : colorIn.getGreen(), bIn ? Mth.m_14045_((int)(colorIn.getBlue() + invasionIn.getMaxSeverity() * denom - severity * denom), (int)0, (int)255) : colorIn.getBlue()};
        return new Color(rgb[0], rgb[1], rgb[2]).getRGB();
    }
}

