/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.util.list;

import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.invasion.InvasionDifficulty;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;

public class QueuedInvasionList
implements Iterable<Invasion.BuildInfo> {
    private final ArrayList<Invasion.BuildInfo> invasions = new ArrayList();
    private final InvasionDifficulty difficulty;

    public QueuedInvasionList(InvasionDifficulty difficultyIn) {
        this.difficulty = difficultyIn;
    }

    public final Invasion.BuildInfo getPrimary() {
        return this.invasions.get(0);
    }

    public final InvasionDifficulty getDifficulty() {
        return this.difficulty;
    }

    public static final QueuedInvasionList load(ServerLevel levelIn, CompoundTag nbtIn) {
        QueuedInvasionList list = new QueuedInvasionList(InvasionDifficulty.values()[nbtIn.m_128451_("Difficulty")]);
        ListTag invasionsNBT = nbtIn.m_128437_("Invasions", 10);
        for (Tag inbt : invasionsNBT) {
            if (!(inbt instanceof CompoundTag)) continue;
            CompoundTag nbt = (CompoundTag)inbt;
            list.add(Invasion.BuildInfo.load(levelIn, nbt));
        }
        return list;
    }

    public final CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        ListTag invasionsNBT = new ListTag();
        nbt.m_128405_("Difficulty", this.difficulty.ordinal());
        for (Invasion.BuildInfo invasion : this.invasions) {
            invasionsNBT.add((Object)invasion.save());
        }
        nbt.m_128365_("Invasions", (Tag)invasionsNBT);
        return nbt;
    }

    public final void add(Invasion.BuildInfo invasionIn) {
        this.invasions.add(invasionIn);
    }

    public final void remove(Invasion.BuildInfo invasionIn) {
        this.invasions.remove(invasionIn);
    }

    public final int size() {
        return this.invasions.size();
    }

    public final boolean isEmpty() {
        return this.invasions.isEmpty();
    }

    public final Invasion.BuildInfo get(int indexIn) {
        return this.invasions.get(indexIn);
    }

    public final String toString() {
        return this.invasions.toString();
    }

    @Override
    public final Iterator<Invasion.BuildInfo> iterator() {
        return this.invasions.iterator();
    }
}

