/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.util.list;

import java.util.ArrayList;
import java.util.Iterator;

public final class SpawnPosChart {
    private final ArrayList<Integer> yList = new ArrayList();
    private final ArrayList<YRange> rangeList;
    private final int defaultY;

    private SpawnPosChart(ArrayList<Integer> posListIn, int playerPosYIn, boolean relocateIn) {
        this.yList.addAll(posListIn);
        if (relocateIn) {
            this.rangeList = null;
            int[] closestY = new int[2];
            for (int i = 0; i < this.yList.size(); ++i) {
                int y = this.yList.get(i);
                int dist = Math.abs(y - playerPosYIn);
                if (i != 0 && dist >= closestY[1]) continue;
                closestY[0] = y;
                closestY[1] = dist;
            }
            this.defaultY = closestY[0];
        } else {
            this.rangeList = new ArrayList();
            this.defaultY = playerPosYIn;
            float total = 0.0f;
            Iterator<Object> iterator = this.yList.iterator();
            while (iterator.hasNext()) {
                int y = iterator.next();
                float rangeSize = 1.0f / (float)this.yList.size() / (float)(Math.abs(y - playerPosYIn) + 1);
                this.rangeList.add(new YRange(y, total += rangeSize, total + rangeSize));
            }
            for (YRange yRange : this.rangeList) {
                yRange.min *= 1.0f / total;
                yRange.max *= 1.0f / total;
            }
        }
    }

    public static final int getYInRange(ArrayList<Integer> yListIn, int playerPosYIn, float numberIn, boolean relocateIn) {
        SpawnPosChart chart = new SpawnPosChart(yListIn, playerPosYIn, relocateIn);
        if (!relocateIn) {
            for (YRange range : chart.rangeList) {
                if (!range.inRange(numberIn)) continue;
                return range.y;
            }
        }
        return chart.defaultY;
    }

    public final String toString() {
        return this.rangeList.toString();
    }

    private static final class YRange {
        private final int y;
        private float min;
        private float max;

        private YRange(int yIn, float minIn, float maxIn) {
            this.y = yIn;
            this.min = minIn;
            this.max = maxIn;
        }

        private final boolean inRange(float numberIn) {
            return numberIn < this.max && numberIn >= this.min;
        }

        public final String toString() {
            return "[ " + this.y + " - " + (this.max - this.min) + " - " + this.min + ", " + this.max + " ]";
        }
    }
}

