/*
 * Decompiled with CFR 0.152.
 */
package dev.theagameplayer.puresuffering.world.level;

import dev.theagameplayer.puresuffering.PureSufferingMod;
import dev.theagameplayer.puresuffering.config.PSConfigValues;
import dev.theagameplayer.puresuffering.invasion.Invasion;
import dev.theagameplayer.puresuffering.invasion.InvasionDifficulty;
import dev.theagameplayer.puresuffering.invasion.InvasionSession;
import dev.theagameplayer.puresuffering.invasion.InvasionSessionType;
import dev.theagameplayer.puresuffering.invasion.InvasionType;
import dev.theagameplayer.puresuffering.network.PSPacketHandler;
import dev.theagameplayer.puresuffering.network.packet.InvasionStartPacket;
import dev.theagameplayer.puresuffering.network.packet.SendInvasionAmbiencePacket;
import dev.theagameplayer.puresuffering.registries.other.PSGameRules;
import dev.theagameplayer.puresuffering.util.list.InvasionChart;
import dev.theagameplayer.puresuffering.util.list.QueuedInvasionList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.Logger;

public final class InvasionManager {
    private static final Logger LOGGER = PureSufferingMod.LOGGER;
    private final List<InvasionSessionType> sessionTypes;
    private final InvasionSession[] sessions;
    private final QueuedInvasionList[] queuedInvasions;
    private final int[][] intervals;
    private final int[] cancelIntervals;
    private volatile int activeSession;
    private volatile int inactiveSession;
    private volatile long ambienceTime;

    public InvasionManager(boolean hasFixedTimeIn) {
        this.sessionTypes = hasFixedTimeIn ? List.of(InvasionSessionType.FIXED) : List.of(InvasionSessionType.DAY, InvasionSessionType.NIGHT);
        this.sessions = new InvasionSession[this.sessionTypes.size()];
        this.queuedInvasions = new QueuedInvasionList[this.sessionTypes.size()];
        this.intervals = new int[this.sessionTypes.size()][InvasionDifficulty.values().length];
        this.cancelIntervals = new int[this.sessionTypes.size()];
        for (int i = 0; i < this.sessionTypes.size(); ++i) {
            for (InvasionDifficulty difficulty : InvasionDifficulty.values()) {
                this.intervals[i][difficulty.ordinal()] = -1;
            }
            this.cancelIntervals[i] = -1;
        }
    }

    public final void setInvasions(ServerLevel levelIn) {
        InvasionSessionType sessionType = InvasionSessionType.getActive(levelIn);
        int index = this.sessionTypes.indexOf((Object)sessionType);
        long days = levelIn.m_46468_() / 24000L;
        int maxPossibleInvasions = sessionType.getMaxPossibleInvasions(levelIn);
        boolean isCanceled = false;
        LOGGER.info("[" + levelIn.m_46472_().m_135782_() + "] " + sessionType.getDefaultName() + ": " + days + ", Max Possible Invasions: " + maxPossibleInvasions);
        if (this.sessions[this.activeSession] != null) {
            this.sessions[this.activeSession].clear(levelIn);
            this.sessions[this.activeSession] = null;
        }
        this.activeSession = index;
        this.inactiveSession = this.sessionTypes.indexOf((Object)InvasionSessionType.getInactive(levelIn));
        if (this.queuedInvasions[index] == null) {
            if (maxPossibleInvasions > 0) {
                RandomSource random = levelIn.m_213780_();
                InvasionDifficulty difficulty = this.calcInvasionDifficulty(index, days, levelIn, sessionType);
                if (difficulty != null) {
                    int totalInvasions;
                    LOGGER.info("Setting " + difficulty.getDefaultName() + " " + sessionType.getDefaultName() + " Invasions: [");
                    if (this.cancelIntervals[index] > 0) {
                        int n = index;
                        this.cancelIntervals[n] = this.cancelIntervals[n] - 1;
                    } else {
                        int cancelRarity = sessionType.getCancelRarity(levelIn);
                        if (this.calcInvasionCanceled(index, days, maxPossibleInvasions, levelIn, sessionType, difficulty)) {
                            isCanceled = true;
                        }
                        int n = this.cancelIntervals[index] = cancelRarity > 0 ? random.m_188503_(cancelRarity) + cancelRarity - (int)(days % (long)cancelRarity) : 0;
                    }
                    if (!isCanceled && (totalInvasions = this.calcInvasionCount(difficulty, random, days, maxPossibleInvasions)) > 0) {
                        InvasionType invasionType;
                        int tierIncreaseDelay = sessionType.getTierIncreaseDelay(levelIn);
                        boolean[] isTimeModified = new boolean[1];
                        Predicate<InvasionType> potentials = it -> it.getDimensions().contains(levelIn.m_46472_().m_135782_()) && (!PSGameRules.TIERED_INVASIONS.get((Level)levelIn) || days >= (long)(it.getTier() * tierIncreaseDelay));
                        Predicate<InvasionType> potentialPrimary = it -> sessionType.isAcceptableTime((InvasionType)it, false) && potentials.test((InvasionType)it) && it.getInvasionPriority() != InvasionType.InvasionPriority.SECONDARY_ONLY && (PSConfigValues.common.primaryWhitelist.isEmpty() || PSConfigValues.common.primaryWhitelist.contains(it.getId().toString()));
                        Predicate<InvasionType> potentialSecondary = it -> potentials.test((InvasionType)it) && it.getInvasionPriority() != InvasionType.InvasionPriority.PRIMARY_ONLY;
                        for (int inv = 0; inv < totalInvasions && (invasionType = this.getInvasionType(new InvasionChart(inv == 0, inv == 0 ? potentialPrimary : it -> sessionType.isAcceptableTime((InvasionType)it, isTimeModified[0]) && potentialSecondary.test((InvasionType)it) && (!isTimeModified[0] || sessionType.canBeChanged((InvasionType)it))), random)) != null && invasionType.getMaxSeverity() >= 1; ++inv) {
                            if (inv == 0) {
                                this.sessions[index] = new InvasionSession(sessionType, difficulty);
                            }
                            int severity = difficulty.isHyper() ? invasionType.getMaxSeverity() - 1 : random.m_188503_(Mth.m_14045_((int)(PSGameRules.TIERED_INVASIONS.get((Level)levelIn) ? (int)(days / (long)tierIncreaseDelay - (long)invasionType.getTier()) + 1 : invasionType.getMaxSeverity()), (int)1, (int)(inv == 0 ? invasionType.getMaxSeverity() : this.getSecondarySeverityCap(invasionType, index))));
                            Invasion invasion = new Invasion(levelIn, invasionType, severity, inv == 0, true, levelIn.m_46468_(), inv);
                            this.sessions[index].add(levelIn, invasion);
                            LOGGER.info("Invasion " + (inv + 1) + ": " + invasionType + " - " + (severity + 1));
                            isTimeModified[0] = isTimeModified[0] | sessionType.canModifyTime(invasionType);
                        }
                    }
                    LOGGER.info("]");
                }
            }
        } else {
            this.sessions[index] = new InvasionSession(sessionType, this.queuedInvasions[index].getDifficulty());
            LOGGER.info("Setting Queued " + this.sessions[index].getDifficulty().getDefaultName() + " " + sessionType.getDefaultName() + " Invasions: [");
            for (int q = 0; q < this.queuedInvasions[index].size(); ++q) {
                Invasion invasion = this.queuedInvasions[index].get(q).build(levelIn, q);
                this.sessions[index].add(levelIn, invasion);
                LOGGER.info("Invasion " + (q + 1) + ": " + invasion.getType() + " - " + (invasion.getSeverity() + 1));
            }
            this.queuedInvasions[index] = null;
            LOGGER.info("]");
        }
        long l = this.ambienceTime = this.intervals[this.inactiveSession][0] == 0 ? 2999L + (long)levelIn.f_46441_.m_188503_(6000) : -1L;
        if (isCanceled || this.sessions[index] != null) {
            PSPacketHandler.sendToClientsIn(new InvasionStartPacket(), levelIn);
        }
    }

    private final InvasionDifficulty calcInvasionDifficulty(int indexIn, long daysIn, ServerLevel levelIn, InvasionSessionType sessionTypeIn) {
        InvasionDifficulty result = null;
        for (InvasionDifficulty difficulty : InvasionDifficulty.values()) {
            if (!difficulty.isAllowed((Level)levelIn)) break;
            int i = difficulty.ordinal();
            if (this.intervals[indexIn][i] > 0) {
                int[] nArray = this.intervals[indexIn];
                int n = i;
                nArray[n] = nArray[n] - 1;
                break;
            }
            int rarity = difficulty.getRarity(levelIn, sessionTypeIn.getRarity(levelIn));
            if (!(this.intervals[indexIn][i] <= -1 || PSGameRules.TIERED_INVASIONS.get((Level)levelIn) && daysIn <= (long)(sessionTypeIn.getTierIncreaseDelay(levelIn) * (difficulty.isHyper() ? i + 2 : i)))) {
                result = difficulty;
            }
            this.intervals[indexIn][i] = PSGameRules.CONSISTENT_INVASIONS.get((Level)levelIn) ? rarity : levelIn.f_46441_.m_188503_(rarity) + rarity - (int)(daysIn % (long)rarity) - 1;
        }
        return result;
    }

    private final boolean calcInvasionCanceled(int indexIn, long daysIn, int maxPossibleInvasionsIn, ServerLevel levelIn, InvasionSessionType sessionTypeIn, InvasionDifficulty difficultyIn) {
        return this.cancelIntervals[indexIn] > -1 && (!PSGameRules.TIERED_INVASIONS.get((Level)levelIn) || daysIn > (long)(sessionTypeIn.getTierIncreaseDelay(levelIn) * 2)) && maxPossibleInvasionsIn > 1 && sessionTypeIn.canBeCanceled(levelIn) && !difficultyIn.isHyper();
    }

    private final int calcInvasionCount(InvasionDifficulty difficultyIn, RandomSource randomIn, long daysIn, int maxInvasionsIn) {
        return daysIn > 0L && maxInvasionsIn > 0 ? difficultyIn.getInvasionCount(randomIn, maxInvasionsIn) : 0;
    }

    private final InvasionType getInvasionType(InvasionChart invasionChartIn, RandomSource randomIn) {
        return invasionChartIn.getInvasionInRange(randomIn.m_188501_());
    }

    private final int getSecondarySeverityCap(InvasionType invasionTypeIn, int indexIn) {
        Invasion primary = this.sessions[indexIn].getPrimary();
        float primaryPercent = (float)(primary.getSeverity() + 1) / (float)primary.getType().getMaxSeverity();
        for (int s = invasionTypeIn.getMaxSeverity(); s > 0; --s) {
            if (!((float)s / (float)invasionTypeIn.getMaxSeverity() <= primaryPercent)) continue;
            return s;
        }
        return 1;
    }

    public final List<InvasionSessionType> getListTypes() {
        return this.sessionTypes;
    }

    public final InvasionSession getActiveSession(ServerLevel levelIn) {
        return this.sessions[this.sessionTypes.indexOf((Object)InvasionSessionType.getActive(levelIn))];
    }

    public final InvasionSession getSession(InvasionSessionType sessionTypeIn) {
        return this.sessions[this.sessionTypes.indexOf((Object)sessionTypeIn)];
    }

    public final QueuedInvasionList setQueued(InvasionSessionType sessionTypeIn, InvasionDifficulty difficultyIn) {
        QueuedInvasionList queuedInvasionList = difficultyIn == null ? null : new QueuedInvasionList(difficultyIn);
        this.queuedInvasions[this.sessionTypes.indexOf((Object)((Object)sessionTypeIn))] = queuedInvasionList;
        return queuedInvasionList;
    }

    public final QueuedInvasionList getQueued(InvasionSessionType sessionTypeIn) {
        return this.queuedInvasions[this.sessionTypes.indexOf((Object)sessionTypeIn)];
    }

    public final void tick(boolean spawningMonstersIn, ServerLevel levelIn) {
        if (!spawningMonstersIn) {
            return;
        }
        if (PSGameRules.ENABLE_INVASION_AMBIENCE.get((Level)levelIn) && this.ambienceTime > -1L && levelIn.m_46468_() % 12000L > this.ambienceTime) {
            PSPacketHandler.sendToClientsIn(new SendInvasionAmbiencePacket(), levelIn);
            this.ambienceTime = -1L;
        }
        if (this.sessions[this.activeSession] == null) {
            return;
        }
        if (this.sessions[this.activeSession].stopOrTick(levelIn)) {
            this.sessions[this.activeSession] = null;
        }
    }

    public final void load(ServerLevel levelIn, CompoundTag nbtIn) {
        CompoundTag[] sessionsNBT = new CompoundTag[this.sessionTypes.size()];
        CompoundTag[] queuedInvasionsNBT = new CompoundTag[this.sessionTypes.size()];
        for (int i = 0; i < this.sessionTypes.size(); ++i) {
            InvasionSessionType sessionType = this.sessionTypes.get(i);
            sessionsNBT[i] = nbtIn.m_128469_(sessionType.getDefaultName() + "InvasionSessions");
            queuedInvasionsNBT[i] = nbtIn.m_128469_("Queued" + sessionType.getDefaultName() + "Invasions");
            if (!sessionsNBT[i].m_128456_()) {
                this.sessions[i] = InvasionSession.load(levelIn, sessionsNBT[i]);
            }
            if (!queuedInvasionsNBT[i].m_128456_()) {
                this.queuedInvasions[i] = QueuedInvasionList.load(levelIn, queuedInvasionsNBT[i]);
            }
            for (InvasionDifficulty difficulty : InvasionDifficulty.values()) {
                this.intervals[i][difficulty.ordinal()] = nbtIn.m_128451_(difficulty.getDefaultName() + sessionType.getDefaultName() + "Interval");
            }
            this.cancelIntervals[i] = nbtIn.m_128451_(sessionType.getDefaultName() + "CancelInterval");
        }
        this.activeSession = nbtIn.m_128451_("ActiveSession");
        this.inactiveSession = nbtIn.m_128451_("InactiveSession");
        this.ambienceTime = nbtIn.m_128454_("AmbienceTime");
    }

    public final CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        CompoundTag[] sessionsNBT = new CompoundTag[this.sessionTypes.size()];
        CompoundTag[] queuedInvasionsNBT = new CompoundTag[this.sessionTypes.size()];
        for (int i = 0; i < this.sessionTypes.size(); ++i) {
            InvasionSessionType sessionType = this.sessionTypes.get(i);
            sessionsNBT[i] = this.sessions[i] == null ? new CompoundTag() : this.sessions[i].save();
            nbt.m_128365_(sessionType.getDefaultName() + "InvasionSessions", (Tag)sessionsNBT[i]);
            queuedInvasionsNBT[i] = this.queuedInvasions[i] == null ? new CompoundTag() : this.queuedInvasions[i].save();
            nbt.m_128365_("Queued" + sessionType.getDefaultName() + "Invasions", (Tag)queuedInvasionsNBT[i]);
            for (InvasionDifficulty difficulty : InvasionDifficulty.values()) {
                nbt.m_128405_(difficulty.getDefaultName() + sessionType.getDefaultName() + "Interval", this.intervals[i][difficulty.ordinal()]);
            }
            nbt.m_128405_(sessionType.getDefaultName() + "CancelInterval", this.cancelIntervals[i]);
        }
        nbt.m_128405_("ActiveSession", this.activeSession);
        nbt.m_128405_("InactiveSession", this.inactiveSession);
        nbt.m_128356_("AmbienceTime", this.ambienceTime);
        return nbt;
    }
}

